/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BaseColorControl;
import visad.Control;
import visad.DisplayException;
import visad.VisADException;
import visad.util.ArrowSlider;
import visad.util.BaseRGBMap;
import visad.util.ColorPreview;
import visad.util.SliderLabel;

public class SimpleColorMapWidget
extends JPanel {
    BaseRGBMap baseMap;
    ColorPreview preview;
    ArrowSlider slider;
    private SliderLabel label;

    private void finishInit(String string, float f, float f2) {
        this.preview = new ColorPreview(this.baseMap);
        this.slider = new ArrowSlider(f, f2, (f + f2) / 2.0f, string);
        this.label = new SliderLabel(this.slider);
        this.setLayout(new BoxLayout(this, 1));
        this.updateSlider(f, f2);
        this.rebuildGUI();
    }

    void rebuildGUI() {
        this.removeAll();
        this.add(this.baseMap);
        this.add(this.preview);
        this.add(this.slider);
        this.add(this.label);
    }

    void updateSlider(float f, float f2) {
        float f3 = this.slider.getValue();
        if (f3 != f3 || f3 <= f || f3 >= f2) {
            f3 = (f + f2) / 2.0f;
        }
        this.slider.setBounds(f, f2, f3);
    }

    public void setTable(float[][] fArray) throws RemoteException, VisADException {
        float[][] fArray2 = SimpleColorMapWidget.copy_table(fArray);
        this.baseMap.setValues(fArray2);
    }

    static float[][] copy_table(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[n][n2];
        try {
            int n3 = 0;
            while (n3 < n) {
                System.arraycopy(fArray[n3], 0, fArray2[n3], 0, n2);
                ++n3;
            }
            return fArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    static float[][] table_reorg(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[n2][n];
        try {
            int n3 = 0;
            while (n3 < n2) {
                fArray2[n3][0] = fArray[0][n3];
                fArray2[n3][1] = fArray[1][n3];
                fArray2[n3][2] = fArray[2][n3];
                if (n > 3) {
                    fArray2[n3][3] = fArray[3][n3];
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            fArray2 = null;
        }
        return fArray2;
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        try {
            JFrame jFrame = new JFrame("Empty SimpleColorMapWidget");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            SimpleColorMapWidget simpleColorMapWidget = new SimpleColorMapWidget("Foo", null, 0.0f, 1.0f);
            jFrame.getContentPane().add(simpleColorMapWidget);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            int n = 4;
            int n2 = 256;
            float[][] fArray = new float[4][256];
            float f = 0.0039215684f;
            float f2 = 1.0f;
            int n3 = 0;
            while (n3 < 256) {
                float f3 = f2;
                fArray[2][n3] = f3;
                fArray[1][n3] = f3;
                fArray[0][n3] = f3;
                fArray[3][n3] = 1.0f;
                f2 -= 0.0039215684f;
                ++n3;
            }
            jFrame = new JFrame("Full SimpleColorMapWidget");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            simpleColorMapWidget = new SimpleColorMapWidget("Foo", fArray, 0.0f, 1.0f);
            jFrame.getContentPane().add(simpleColorMapWidget);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }

    public SimpleColorMapWidget(String string, float[][] fArray, float f, float f2) throws RemoteException, VisADException {
        float[][] fArray2 = fArray != null && fArray[0] != null && fArray.length >= 3 && fArray.length <= 4 && fArray[0].length > 4 ? SimpleColorMapWidget.table_reorg(fArray) : fArray;
        if (fArray2 != null && (fArray2[0] == null || fArray2[0].length < 3 || fArray2[0].length > 4)) {
            throw new VisADException("Bad initial table");
        }
        this.baseMap = fArray2 == null ? new BaseRGBMap(false) : new BaseRGBMap(fArray2);
        this.finishInit(string, f, f2);
    }

    public SimpleColorMapWidget(String string, Control control, float f, float f2) throws RemoteException, VisADException {
        if (control == null) {
            throw new DisplayException(this.getClass().getName() + ": Null control");
        }
        if (!(control instanceof BaseColorControl)) {
            throw new DisplayException(this.getClass().getName() + ": Control must " + "be BaseColorControl, not " + control.getClass().getName());
        }
        this.baseMap = new BaseRGBMap((BaseColorControl)control);
        this.finishInit(string, f, f2);
    }
}

