/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.rmi.RemoteException;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.RangeControl;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.util.RangeSlider;
import visad.util.Util;

public class SelectRangeWidget
extends RangeSlider
implements ScalarMapListener,
ControlListener {
    private RangeControl rangeControl;

    private void updateWidget(float f, float f2) throws VisADException, RemoteException {
        this.rangeControl.setRange(new float[]{f, f2});
        this.setBounds(f, f2);
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        ScalarMap scalarMap = scalarMapEvent.getScalarMap();
        double[] dArray = scalarMap.getRange();
        try {
            float f = (float)dArray[0];
            float f2 = (float)dArray[1];
            if (this.minValue != this.minValue || !Util.isApproximatelyEqual(f, this.minValue) || this.maxValue != this.maxValue || !Util.isApproximatelyEqual(f2, this.maxValue)) {
                this.updateWidget(f, f2);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) throws RemoteException, VisADException {
        int n = scalarMapControlEvent.getId();
        if (this.rangeControl != null && (n == 4 || n == 5)) {
            this.rangeControl.removeControlListener(this);
        }
        if (n == 5 || n == 3) {
            this.rangeControl = (RangeControl)scalarMapControlEvent.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(this.rangeControl));
            this.rangeControl.addControlListener(this);
        }
    }

    public void valuesUpdated() {
        try {
            this.rangeControl.setRange(new float[]{this.minValue, this.maxValue});
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        float[] fArray = this.rangeControl.getRange();
        this.setValues(fArray[0], fArray[1]);
    }

    public SelectRangeWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(scalarMap, true);
    }

    public SelectRangeWidget(ScalarMap scalarMap, float f, float f2) throws VisADException, RemoteException {
        this(scalarMap, true);
        if (f == f || f2 == f2) {
            System.err.println("Warning:  SelectRangeWidget initial range  values ignored");
        }
    }

    public SelectRangeWidget(ScalarMap scalarMap, float f, float f2, boolean bl) throws VisADException, RemoteException {
        this(scalarMap, true);
        if (f == f || f2 == f2) {
            System.err.println("Warning:  SelectRangeWidget initial range  values ignored");
        }
    }

    public SelectRangeWidget(ScalarMap scalarMap, boolean bl) throws VisADException, RemoteException {
        super(RangeSlider.nameOf(scalarMap), 0.0f, 1.0f);
        if (!Display.SelectRange.equals(scalarMap.getDisplayScalar())) {
            throw new DisplayException("SelectRangeWidget: ScalarMap must be to Display.SelectRange");
        }
        double[] dArray = scalarMap.getRange();
        this.resetValues((float)dArray[0], (float)dArray[1]);
        this.rangeControl = (RangeControl)scalarMap.getControl();
        if (bl) {
            scalarMap.addScalarMapListener(this);
        } else {
            this.setBounds(this.minLimit, this.maxLimit);
        }
        this.rangeControl.addControlListener(this);
        float[] fArray = this.rangeControl.getRange();
        if (fArray == null) {
            fArray = new float[]{this.minLimit, this.maxLimit};
        }
        if (fArray[0] != fArray[0] || fArray[1] != fArray[1]) {
            fArray[0] = this.minLimit;
            fArray[1] = this.maxLimit;
        }
        this.setValues(fArray[0], fArray[1]);
    }
}

