/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ActivityHandler;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.ScalarMap;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;

public class ResSwitcher
implements ActivityHandler {
    private static final boolean DEBUG = true;
    private LocalDisplay display;
    private DataReferenceImpl hi_ref;
    private DataReferenceImpl lo_ref;
    private DataRenderer hi_rend;
    private DataRenderer lo_rend;
    private CellImpl cell;
    private double scale = 0.5;

    public static FieldImpl rescale(FieldImpl fieldImpl, double d) throws VisADException, RemoteException {
        Unit[] unitArray;
        Serializable serializable;
        Set set = fieldImpl.getDomainSet();
        if (!(set instanceof LinearSet)) {
            return null;
        }
        LinearSet linearSet = (LinearSet)((Object)set);
        int n = set.getDimension();
        Linear1DSet[] linear1DSetArray = new Linear1DSet[n];
        int n2 = 0;
        while (n2 < n) {
            serializable = linearSet.getLinear1DComponent(n2);
            unitArray = ((DataImpl)serializable).getType();
            double d2 = ((Linear1DSet)serializable).getFirst();
            double d3 = ((Linear1DSet)serializable).getLast();
            int n3 = (int)((double)((Set)serializable).getLength() * d);
            if (n3 < 1) {
                n3 = 1;
            }
            CoordinateSystem coordinateSystem = ((Set)serializable).getCoordinateSystem();
            Unit[] unitArray2 = ((Set)serializable).getSetUnits();
            linear1DSetArray[n2] = new Linear1DSet((MathType)unitArray, d2, d3, n3, coordinateSystem, unitArray2, null);
            ++n2;
        }
        MathType mathType = set.getType();
        serializable = set.getCoordinateSystem();
        unitArray = set.getSetUnits();
        GriddedSet griddedSet = n == 1 ? linear1DSetArray[0] : (n == 2 ? new Linear2DSet(mathType, linear1DSetArray, (CoordinateSystem)serializable, unitArray, null) : (n == 3 ? new Linear3DSet(mathType, linear1DSetArray, (CoordinateSystem)serializable, unitArray, null) : new LinearNDSet(mathType, linear1DSetArray, (CoordinateSystem)serializable, unitArray, null)));
        return (FieldImpl)fieldImpl.resample(griddedSet, 101, 202);
    }

    public void unlink() throws VisADException {
        this.display.removeActivityHandler(this);
    }

    public void setResolutionScale(double d) throws VisADException {
        if (!(d > 1.0)) {
            throw new VisADException("ResSwitcher: scale factor must be greater than 1");
        }
        this.scale = 1.0 / d;
    }

    public void busyDisplay(LocalDisplay localDisplay) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.lo_rend.toggle(true);
            this.hi_rend.toggle(false);
        }
    }

    public void idleDisplay(LocalDisplay localDisplay) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.hi_rend.toggle(true);
            this.lo_rend.toggle(false);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("Please specify a datafile on the command line.");
            return;
        }
        DefaultFamily defaultFamily = new DefaultFamily("loader");
        DataImpl dataImpl = defaultFamily.open(stringArray[0]);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display");
        ScalarMap[] scalarMapArray = dataImpl.getType().guessMaps(true);
        if (scalarMapArray != null) {
            int n = 0;
            while (n < scalarMapArray.length) {
                displayImplJ3D.addMap(scalarMapArray[n]);
                ++n;
            }
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref");
        dataReferenceImpl.setData(dataImpl);
        displayImplJ3D.addReference(dataReferenceImpl);
        ResSwitcher resSwitcher = new ResSwitcher(displayImplJ3D, dataReferenceImpl);
        if (stringArray.length > 1) {
            try {
                resSwitcher.setResolutionScale(Double.parseDouble(stringArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        JFrame jFrame = new JFrame("ResSwitcher test");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.setContentPane(jPanel);
        jPanel.add(displayImplJ3D.getComponent());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.pack();
        jFrame.show();
    }

    static /* synthetic */ boolean access$0() {
        return DEBUG;
    }

    static /* synthetic */ DataReferenceImpl access$1(ResSwitcher resSwitcher) {
        return resSwitcher.hi_ref;
    }

    static /* synthetic */ double access$2(ResSwitcher resSwitcher) {
        return resSwitcher.scale;
    }

    static /* synthetic */ DataReferenceImpl access$3(ResSwitcher resSwitcher) {
        return resSwitcher.lo_ref;
    }

    public ResSwitcher(LocalDisplay localDisplay, DataReferenceImpl dataReferenceImpl) throws VisADException, RemoteException {
        this.display = localDisplay;
        this.hi_ref = dataReferenceImpl;
        this.lo_ref = new DataReferenceImpl("ResSwitcher_ref");
        this.display.addReference(this.lo_ref);
        this.cell = new CellImpl(this){
            private final /* synthetic */ ResSwitcher this$0;

            public void doAction() {
                try {
                    FieldImpl fieldImpl;
                    Data data = ResSwitcher.access$1(this.this$0).getData();
                    if (data == null || !(data instanceof FieldImpl)) {
                        return;
                    }
                    FieldImpl fieldImpl2 = (FieldImpl)data;
                    FunctionType functionType = (FunctionType)data.getType();
                    RealTupleType realTupleType = functionType.getDomain();
                    MathType mathType = functionType.getRange();
                    if (realTupleType.getDimension() == 1 && mathType instanceof FunctionType) {
                        fieldImpl = new FieldImpl(functionType, fieldImpl2.getDomainSet());
                        int n = fieldImpl2.getLength();
                        int n2 = 0;
                        while (n2 < n) {
                            Data data2 = fieldImpl2.getSample(n2);
                            if (!(data2 instanceof FieldImpl)) {
                                return;
                            }
                            fieldImpl.setSample(n2, (Data)ResSwitcher.rescale((FieldImpl)data2, ResSwitcher.access$2(this.this$0)));
                            ++n2;
                        }
                    } else {
                        fieldImpl = ResSwitcher.rescale(fieldImpl2, ResSwitcher.access$2(this.this$0));
                    }
                    ResSwitcher.access$3(this.this$0).setData(fieldImpl);
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
            {
                this.this$0 = resSwitcher;
                this.constructor$0(resSwitcher);
            }

            private final void constructor$0(ResSwitcher resSwitcher) {
            }
        };
        this.cell.addReference(this.hi_ref);
        Vector vector = this.display.getRendererVector();
        int n = vector == null ? 0 : vector.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && n2 != 3) {
            DataRenderer dataRenderer = (DataRenderer)vector.elementAt(n3);
            DataDisplayLink[] dataDisplayLinkArray = dataRenderer.getLinks();
            int n4 = 0;
            while (n4 < dataDisplayLinkArray.length && n2 != 3) {
                DataReference dataReference = dataDisplayLinkArray[n4].getDataReference();
                if (dataReference == this.hi_ref) {
                    this.hi_rend = dataRenderer;
                    n2 &= 1;
                } else if (dataReference == this.lo_ref) {
                    this.lo_rend = dataRenderer;
                    n2 &= 2;
                }
                ++n4;
            }
            ++n3;
        }
        localDisplay.addActivityHandler(this);
    }
}

