/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.PlotText;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;

public class RangeWidget
extends JPanel
implements ActionListener,
ScalarMapListener {
    private JTextField data_low;
    private JTextField data_hi;
    private ScalarMap map;

    private void updateTextFields(double[] dArray) {
        this.data_low.setText(PlotText.shortString(dArray[0]));
        this.data_hi.setText(PlotText.shortString(dArray[1]));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        double[] dArray = new double[]{Double.parseDouble(this.data_low.getText()), Double.parseDouble(this.data_hi.getText())};
        try {
            this.map.setRange(dArray[0], dArray[1]);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        this.map.getScale(dArray, dArray2, dArray3);
        this.updateTextFields(dArray2);
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
    }

    public RangeWidget(ScalarMap scalarMap) throws VisADException {
        this.map = scalarMap;
        if (this.map == null) {
            throw new VisADException("RangeWidget: ScalarMap cannot be null");
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        boolean bl = this.map.getScale(dArray, dArray2, dArray3);
        if (!bl) {
            throw new VisADException("RangeWidget: ScalarMap must have linearly scalable range");
        }
        this.data_low = new JTextField();
        this.data_hi = new JTextField();
        this.updateTextFields(dArray2);
        Dimension dimension = this.data_low.getMaximumSize();
        Dimension dimension2 = this.data_low.getPreferredSize();
        dimension.height = dimension2.height;
        this.data_low.setMaximumSize(dimension);
        this.data_hi.setMaximumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("low: "));
        jPanel.add(this.data_low);
        jPanel.add(new JLabel(" hi: "));
        jPanel.add(this.data_hi);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Range of " + this.map.getScalarName() + " mapped to " + this.map.getDisplayScalar().getName().substring(7)));
        this.add(jPanel);
        this.map.addScalarMapListener(this);
        this.data_low.addActionListener(this);
        this.data_hi.addActionListener(this);
    }
}

