/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.ColorMapWidget;
import visad.util.SimpleColorMapWidget;

public class LabeledColorWidget
extends JPanel
implements ActionListener {
    ColorMapWidget wrappedWidget;
    private float[][] original;
    private float[][] grey = null;

    private JPanel buildButtons() {
        JButton jButton = new JButton("Reset");
        jButton.setActionCommand("reset");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Grey Scale");
        jButton2.setActionCommand("grey");
        jButton2.addActionListener(this);
        boolean bl = false;
        JPanel jPanel = this.wrappedWidget.getButtonPanel();
        if (jPanel == null) {
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1, 5, 5));
            bl = true;
        }
        jPanel.add((Component)jButton, 0);
        jPanel.add((Component)jButton2, 1);
        return bl ? jPanel : null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("reset")) {
            try {
                this.wrappedWidget.setTable(this.original);
            }
            catch (RemoteException remoteException) {
            }
            catch (VisADException visADException) {}
        } else if (actionEvent.getActionCommand().equals("grey")) {
            if (this.grey == null && this.original != null && this.original[0] != null) {
                int n = this.original.length;
                int n2 = this.original[0].length;
                this.grey = new float[n][n2];
                float f = 1.0f / ((float)n2 - 1.0f);
                int n3 = 0;
                while (n3 < n2) {
                    float f2 = (float)n3 * f;
                    this.grey[2][n3] = f2;
                    this.grey[1][n3] = f2;
                    this.grey[0][n3] = f2;
                    if (n > 3) {
                        this.grey[3][n3] = 1.0f;
                    }
                    ++n3;
                }
            }
            if (this.grey != null) {
                try {
                    this.wrappedWidget.setTable(this.grey);
                }
                catch (RemoteException remoteException) {
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
        }
    }

    public Dimension getMaximumSize() {
        return this.wrappedWidget.getMaximumSize();
    }

    public void setMaximumSize(Dimension dimension) {
        this.wrappedWidget.setMaximumSize(dimension);
    }

    public Dimension getMinimumSize() {
        return this.wrappedWidget.getMinimumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        this.wrappedWidget.setMinimumSize(dimension);
    }

    public Dimension getPreferredSize() {
        return this.wrappedWidget.getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        this.wrappedWidget.setPreferredSize(dimension);
    }

    public static void main(String[] stringArray) {
        try {
            RealType realType = new RealType("vis", null, null);
            ScalarMap scalarMap = new ScalarMap(realType, Display.RGBA);
            scalarMap.setRange(0.0, 1.0);
            RealType realType2 = new RealType("ir", null, null);
            ScalarMap scalarMap2 = new ScalarMap(realType, Display.RGB);
            scalarMap2.setRange(0.0, 1.0);
            DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("2d");
            displayImplJ2D.addMap(scalarMap);
            displayImplJ2D.addMap(scalarMap2);
            JFrame jFrame = new JFrame("0");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new LabeledColorWidget(scalarMap));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("1");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new LabeledColorWidget(scalarMap, null));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("!Updated");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new LabeledColorWidget(scalarMap, null, false));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("!Immediate");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            ColorMapWidget colorMapWidget = new ColorMapWidget(scalarMap, null, false, false);
            jFrame.getContentPane().add(new LabeledColorWidget(colorMapWidget));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            int n = 3;
            int n2 = 256;
            float[][] fArray = new float[3][256];
            float f = 0.0039215684f;
            float f2 = 1.0f;
            int n3 = 0;
            while (n3 < 256) {
                float f3 = f2;
                fArray[2][n3] = f3;
                fArray[1][n3] = f3;
                fArray[0][n3] = f3;
                f2 -= 0.0039215684f;
                ++n3;
            }
            jFrame = new JFrame("Table");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new ColorMapWidget(scalarMap2, fArray));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            scalarMap.setRange(-10.0, 10.0);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }

    public LabeledColorWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(scalarMap, null, true);
    }

    public LabeledColorWidget(ScalarMap scalarMap, float f, float f2) throws VisADException, RemoteException {
        this(scalarMap, null, true);
    }

    public LabeledColorWidget(ScalarMap scalarMap, float[][] fArray) throws VisADException, RemoteException {
        this(scalarMap, fArray, true);
    }

    public LabeledColorWidget(ScalarMap scalarMap, float f, float f2, float[][] fArray) throws VisADException, RemoteException {
        this(scalarMap, fArray, true);
    }

    public LabeledColorWidget(ScalarMap scalarMap, float[][] fArray, boolean bl) throws VisADException, RemoteException {
        this(new ColorMapWidget(scalarMap, fArray, bl));
    }

    public LabeledColorWidget(ColorMapWidget colorMapWidget) {
        this.wrappedWidget = colorMapWidget;
        this.original = SimpleColorMapWidget.copy_table(this.wrappedWidget.control.getTable());
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", this.wrappedWidget);
        JPanel jPanel = this.buildButtons();
        if (jPanel != null) {
            this.add("South", jPanel);
        }
    }
}

