/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HersheyFont {
    private static final int MAX_CHARACTERS = 256;
    private static final int MAX_POINTS = 300;
    protected static final int X = 0;
    protected static final int Y = 1;
    private String copyright = "Copyright (c) James P. Buzbee Mar 30, 1996";
    protected String name;
    protected char[][][] characterVectors = new char[256][2][300];
    protected int[] numberOfPoints = new int[256];
    protected int[] characterMinX;
    protected int[] characterMaxX;
    protected int characterSetMinY;
    protected int characterSetMaxY;
    protected int characterSetMinX;
    protected int characterSetMaxX;
    protected int charactersInSet;
    private static /* synthetic */ Class class$Lvisad$util$HersheyFont;

    public int getMaxPoints() {
        return 300;
    }

    public int[] getCharacterMinX() {
        return this.characterMinX;
    }

    public int[] getCharacterMaxX() {
        return this.characterMaxX;
    }

    public int getCharacterSetMinY() {
        return this.characterSetMinY;
    }

    public int getCharacterSetMaxY() {
        return this.characterSetMaxY;
    }

    public int getCharacterSetMinX() {
        return this.characterSetMinX;
    }

    public int getCharacterSetMaxX() {
        return this.characterSetMaxX;
    }

    public int getCharactersInSet() {
        return this.charactersInSet;
    }

    public int getNumberOfPoints(int n) {
        if (n < this.characterVectors.length) {
            return this.numberOfPoints[n];
        }
        return 0;
    }

    public char[][] getCharacterVector(int n) {
        if (n < this.characterVectors.length) {
            return this.characterVectors[n];
        }
        return null;
    }

    public boolean getIsCursive() {
        return this.name.toLowerCase().indexOf("cursive") != -1;
    }

    private int getInt(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            return -1;
        }
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = inputStream.read();
            while (n4 == 10 || n4 == 13) {
                n4 = inputStream.read();
            }
            if (n4 == -1) {
                return n4;
            }
            if ((char)n4 != ' ') {
                cArray[n2++] = (char)n4;
            }
            ++n3;
        }
        return Integer.parseInt(String.copyValueOf(cArray, 0, n2));
    }

    private int fontAdjustment(String string) {
        int n = 0;
        if (string.indexOf("scri") < 0) {
            n = string.indexOf("goth") >= 0 ? 2 : 3;
        }
        return n;
    }

    private void LoadHersheyFont(String string, InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        int n = this.fontAdjustment(string);
        try {
            int n2;
            int n3 = 0;
            while (true) {
                int n4;
                if (this.getInt(inputStream, 5) < 1) break;
                this.numberOfPoints[n3] = n4 = this.getInt(inputStream, 3);
                n2 = 0;
                while (n2 < n4) {
                    int n5;
                    if (n2 == 32 || n2 == 68 || n2 == 104 || n2 == 140) {
                        inputStream.read();
                    }
                    if ((n5 = inputStream.read()) == 10) {
                        n5 = inputStream.read();
                    }
                    this.characterVectors[n3][0][n2] = (char)n5;
                    this.characterVectors[n3][1][n2] = (char)inputStream.read();
                    ++n2;
                }
                inputStream.read();
                ++n3;
            }
            this.charactersInSet = n3;
            this.characterMinX = new int[this.charactersInSet];
            this.characterMaxX = new int[this.charactersInSet];
            this.characterSetMinY = 1000;
            this.characterSetMaxY = -1000;
            this.characterSetMinX = 1000;
            this.characterSetMaxX = -1000;
            n2 = 1;
            while (n2 < this.charactersInSet) {
                this.calculateCharacterSize(n2, n);
                ++n2;
            }
            if (65 <= this.charactersInSet) {
                this.characterMinX[0] = this.characterMinX[65];
                this.characterMaxX[0] = this.characterMaxX[65];
            } else {
                this.characterMinX[0] = this.characterMinX[this.charactersInSet - 1];
                this.characterMaxX[0] = this.characterMaxX[this.charactersInSet - 1];
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    protected void calculateCharacterSize(int n, int n2) {
        this.characterMinX[n] = 1000;
        this.characterMaxX[n] = -1000;
        int n3 = 1;
        while (n3 < this.numberOfPoints[n]) {
            int n4 = this.characterVectors[n][0][n3];
            int n5 = this.characterVectors[n][1][n3];
            if (n4 != 32) {
                if (n4 < this.characterMinX[n]) {
                    this.characterMinX[n] = n4;
                }
                if (n4 < this.characterSetMinX) {
                    this.characterSetMinX = n4;
                }
                if (n4 > this.characterMaxX[n]) {
                    this.characterMaxX[n] = n4;
                }
                if (n4 > this.characterSetMaxX) {
                    this.characterSetMaxX = n4;
                }
                if (n5 < this.characterSetMinY) {
                    this.characterSetMinY = n5;
                }
                if (n5 > this.characterSetMaxY) {
                    this.characterSetMaxY = n5;
                }
            }
            ++n3;
        }
        int n6 = n;
        this.characterMinX[n6] = this.characterMinX[n6] - n2;
        int n7 = n;
        this.characterMaxX[n7] = this.characterMaxX[n7] + n2;
    }

    public String toString() {
        return "HersheyFont: " + this.name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public HersheyFont() {
        this("futural");
    }

    public HersheyFont(String string) {
        this.name = string;
        try {
            String string2 = string + ".jhf";
            InputStream inputStream = (class$Lvisad$util$HersheyFont != null ? class$Lvisad$util$HersheyFont : (class$Lvisad$util$HersheyFont = HersheyFont.class$("visad.util.HersheyFont"))).getResourceAsStream(string2);
            this.LoadHersheyFont(string, inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error processing HersheyFont named " + string + ": " + exception);
        }
    }

    public HersheyFont(URL uRL, String string) {
        this.name = string;
        try {
            InputStream inputStream = new URL(uRL, string).openStream();
            this.LoadHersheyFont(string, inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error processing font " + string + ": " + exception);
        }
    }

    public HersheyFont(URL uRL) {
        this.name = uRL.toString();
        try {
            InputStream inputStream = uRL.openStream();
            this.LoadHersheyFont(this.name, inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error processing font " + this.name + ": " + exception);
        }
    }
}

