/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.ControlEvent;
import visad.ControlListener;
import visad.GraphicsModeControl;
import visad.PlotText;
import visad.VisADException;
import visad.util.Util;

public class GMCWidget
extends JPanel
implements ActionListener,
ItemListener,
ControlListener {
    GraphicsModeControl control;
    JCheckBox scale;
    JCheckBox point;
    JCheckBox texture;
    JTextField lineWidth;
    JTextField pointSize;
    float gmcLineWidth;
    float gmcPointSize;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("line")) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.lineWidth.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
            }
            if (f == f && this.control != null) {
                try {
                    this.control.setLineWidth(f);
                    this.gmcLineWidth = f;
                    this.scale.requestFocus();
                }
                catch (VisADException visADException) {
                    this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
                }
                catch (RemoteException remoteException) {
                    this.lineWidth.setText(PlotText.shortString(this.gmcLineWidth));
                }
            }
        } else if (string.equals("point")) {
            float f = Float.NaN;
            try {
                f = Float.valueOf(this.pointSize.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
            }
            if (f == f && this.control != null) {
                try {
                    this.control.setPointSize(f);
                    this.gmcPointSize = f;
                    this.scale.requestFocus();
                }
                catch (VisADException visADException) {
                    this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
                }
                catch (RemoteException remoteException) {
                    this.pointSize.setText(PlotText.shortString(this.gmcPointSize));
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.control != null) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl = itemEvent.getStateChange() == 1;
            try {
                if (itemSelectable == this.scale) {
                    this.control.setScaleEnable(bl);
                } else if (itemSelectable == this.point) {
                    this.control.setPointMode(bl);
                } else if (itemSelectable == this.texture) {
                    this.control.setTextureEnable(bl);
                }
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) {
        float f;
        if (this.control == null) {
            return;
        }
        if (this.control.getScaleEnable() != this.scale.isSelected()) {
            this.scale.setSelected(this.control.getScaleEnable());
        }
        if (this.control.getPointMode() != this.point.isSelected()) {
            this.point.setSelected(this.control.getPointMode());
        }
        if (this.control.getTextureEnable() != this.texture.isSelected()) {
            this.texture.setSelected(this.control.getTextureEnable());
        }
        if (!Util.isApproximatelyEqual(f = this.control.getLineWidth(), this.gmcLineWidth)) {
            this.lineWidth.setText(PlotText.shortString(f));
            this.gmcLineWidth = f;
        }
        if (!Util.isApproximatelyEqual(f = this.control.getPointSize(), this.gmcPointSize)) {
            this.pointSize.setText(PlotText.shortString(f));
            this.gmcPointSize = f;
        }
    }

    public GMCWidget(GraphicsModeControl graphicsModeControl) {
        this.control = graphicsModeControl;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.control != null) {
            bl = this.control.getScaleEnable();
            bl2 = this.control.getPointMode();
            bl3 = this.control.getTextureEnable();
        }
        this.gmcLineWidth = 1.0f;
        this.gmcPointSize = 1.0f;
        if (this.control != null) {
            this.gmcLineWidth = this.control.getLineWidth();
            this.gmcPointSize = this.control.getPointSize();
        }
        this.scale = new JCheckBox("Enable scale", bl);
        this.point = new JCheckBox("Point mode", bl2);
        this.texture = new JCheckBox("Texture mapping", bl3);
        this.lineWidth = new JTextField(PlotText.shortString(this.gmcLineWidth));
        Dimension dimension = this.lineWidth.getMaximumSize();
        Dimension dimension2 = this.lineWidth.getPreferredSize();
        dimension.height = dimension2.height;
        this.lineWidth.setMaximumSize(dimension);
        this.pointSize = new JTextField(PlotText.shortString(this.gmcPointSize));
        dimension = this.pointSize.getMaximumSize();
        dimension2 = this.pointSize.getPreferredSize();
        dimension.height = dimension2.height;
        this.pointSize.setMaximumSize(dimension);
        JLabel jLabel = new JLabel("Line width:");
        JLabel jLabel2 = new JLabel("Point size:");
        jLabel.setForeground(Color.black);
        jLabel2.setForeground(Color.black);
        this.scale.addItemListener(this);
        this.point.addItemListener(this);
        this.texture.addItemListener(this);
        this.lineWidth.addActionListener(this);
        this.lineWidth.setActionCommand("line");
        this.pointSize.addActionListener(this);
        this.pointSize.setActionCommand("point");
        this.control.addControlListener(this);
        jPanel.add(this.scale);
        jPanel.add(this.point);
        jPanel.add(this.texture);
        jPanel2.add(jLabel);
        jPanel2.add(this.lineWidth);
        jPanel2.add(jLabel2);
        jPanel2.add(this.pointSize);
        this.add(jPanel);
        this.add(jPanel2);
    }
}

