/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import ij.process.ColorProcessor;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.ImageHelper;

public class DataUtility {
    private static boolean init = false;
    private static FunctionType simpleImageType;
    private static RealType radiance;
    private static RealTupleType imageDomain;
    private static RealType line;
    private static RealType element;
    private int num_lines;
    private int num_elements;
    private static /* synthetic */ Class class$Lvisad$util$DataUtility;

    private static synchronized void makeTypes() throws VisADException {
        if (!init) {
            init = true;
            simpleImageType = (FunctionType)MathType.stringToType("((ImageElement, ImageLine) -> ImageRadiance)");
            imageDomain = simpleImageType.getDomain();
            line = (RealType)imageDomain.getComponent(1);
            element = (RealType)imageDomain.getComponent(0);
            MathType mathType = simpleImageType.getRange();
            radiance = mathType instanceof RealType ? (RealType)mathType : (RealType)((RealTupleType)mathType).getComponent(0);
        }
    }

    public static FlatField makeImage(float[][] fArray) throws VisADException, RemoteException {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (fArray[n3] != null && fArray[n3].length > n2) {
                n2 = fArray[n3].length;
            }
            ++n3;
        }
        if (!init) {
            DataUtility.makeTypes();
        }
        FlatField flatField = new FlatField(simpleImageType, new Integer2DSet((MathType)imageDomain, n2, n));
        DataUtility.setPixels(flatField, fArray);
        return flatField;
    }

    public static void setPixels(FlatField flatField, float[][] fArray) throws VisADException, RemoteException {
        if (fArray == null) {
            return;
        }
        Integer2DSet integer2DSet = (Integer2DSet)flatField.getDomainSet();
        int n = integer2DSet.getLength(0);
        int n2 = integer2DSet.getLength(1);
        float[][] fArray2 = new float[1][n2 * n];
        int n3 = 0;
        while (n3 < n2 * n) {
            fArray2[0][n3] = Float.NaN;
            ++n3;
        }
        n3 = fArray.length;
        if (n2 < n3) {
            n3 = n2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            if (fArray[n5] != null) {
                int n6 = fArray[n5].length;
                if (n < n6) {
                    n6 = n;
                }
                int n7 = 0;
                while (n7 < n6) {
                    fArray2[0][n4 + n7] = fArray[n5][n7];
                    ++n7;
                }
            }
            n4 += n;
            ++n5;
        }
        flatField.setSamples(fArray2, false);
    }

    public static float[][] getPixels(FlatField flatField) throws VisADException, RemoteException {
        Integer2DSet integer2DSet = (Integer2DSet)flatField.getDomainSet();
        int n = integer2DSet.getLength(0);
        int n2 = integer2DSet.getLength(1);
        float[][] fArray = new float[n2][n];
        double[][] dArray = flatField.getValues();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                fArray[n4][n5] = (float)dArray[0][n3 + n5];
                ++n5;
            }
            n3 += n;
            ++n4;
        }
        return fArray;
    }

    public static FlatField makeField(Image image) throws IOException, VisADException {
        if (image == null) {
            throw new VisADException("image cannot be null");
        }
        ImageHelper imageHelper = new ImageHelper();
        int n = -1;
        int n2 = -1;
        while (true) {
            if (n < 0) {
                n = image.getWidth(imageHelper);
            }
            if (n2 < 0) {
                n2 = image.getHeight(imageHelper);
            }
            if (imageHelper.badImage || n >= 0 && n2 >= 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (imageHelper.badImage) {
            throw new IOException("Not an image");
        }
        int n3 = n * n2;
        int[] nArray = new int[n3];
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n3];
        PixelGrabber pixelGrabber = new PixelGrabber(image.getSource(), 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n4 = 0;
        while (n4 < n3) {
            fArray[n4] = colorModel.getRed(nArray[n4]);
            fArray2[n4] = colorModel.getGreen(nArray[n4]);
            fArray3[n4] = colorModel.getBlue(nArray[n4]);
            ++n4;
        }
        RealType realType = RealType.getRealType("ImageLine");
        RealType realType2 = RealType.getRealType("ImageElement");
        RealType realType3 = RealType.getRealType("Red");
        RealType realType4 = RealType.getRealType("Green");
        RealType realType5 = RealType.getRealType("Blue");
        RealType[] realTypeArray = new RealType[]{realType3, realType4, realType5};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType2, realType};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType2, 0.0, (float)((double)n - 1.0), n, (float)((double)n2 - 1.0), 0.0, n2);
        FunctionType functionType = new FunctionType(realTupleType2, realTupleType);
        FlatField flatField = new FlatField(functionType, linear2DSet);
        float[][] fArray4 = new float[][]{fArray, fArray2, fArray3};
        try {
            flatField.setSamples(fArray4, false);
        }
        catch (RemoteException remoteException) {
            throw new VisADException("Couldn't finish image initialization");
        }
        return flatField;
    }

    public static Image extractImage(FlatField flatField, boolean bl) {
        try {
            Gridded2DSet gridded2DSet = (Gridded2DSet)flatField.getDomainSet();
            int[] nArray = gridded2DSet.getLengths();
            int n = nArray[0];
            int n2 = nArray[1];
            double[][] dArray = flatField.getValues();
            int[] nArray2 = new int[dArray[0].length];
            if (dArray.length == 3) {
                int n3 = dArray[0].length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = (int)dArray[0][n4] & 0xFF;
                    int n6 = (int)dArray[1][n4] & 0xFF;
                    int n7 = (int)dArray[2][n4] & 0xFF;
                    int n8 = bl ? n3 - n4 - 1 : n4;
                    nArray2[n8] = n5 << 16 | n6 << 8 | n7;
                    ++n4;
                }
            } else if (dArray.length == 1) {
                int n9 = dArray[0].length;
                int n10 = 0;
                while (n10 < n9) {
                    int n11 = (int)dArray[0][n10] & 0xFF;
                    int n12 = bl ? n9 - n10 - 1 : n10;
                    nArray2[n12] = n11 << 16 | n11 << 8 | n11;
                    ++n10;
                }
            }
            return new ColorProcessor(n, n2, nArray2).createImage();
        }
        catch (VisADException visADException) {
            return null;
        }
    }

    public static FlatField[] getImageFields(Data data) {
        FlatField[] flatFieldArray = null;
        String string = "((e, l) -> v)";
        String string2 = "((e, l) -> (r, g, b))";
        String string3 = "(t -> " + string + ")";
        String string4 = "(t -> " + string2 + ")";
        try {
            MathType mathType = data.getType();
            if (mathType.equalsExceptName(MathType.stringToType(string3)) || mathType.equalsExceptName(MathType.stringToType(string4))) {
                FieldImpl fieldImpl = (FieldImpl)data;
                int n = fieldImpl.getLength();
                flatFieldArray = new FlatField[n];
                int n2 = 0;
                while (n2 < n) {
                    flatFieldArray[n2] = (FlatField)fieldImpl.getSample(n2);
                    ++n2;
                }
            } else if (mathType.equalsExceptName(MathType.stringToType(string)) || mathType.equalsExceptName(MathType.stringToType(string2))) {
                flatFieldArray = new FlatField[]{(FlatField)data};
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return flatFieldArray;
    }

    public static DisplayImpl makeSimpleDisplay(DataImpl dataImpl) throws VisADException, RemoteException {
        int n;
        boolean bl = true;
        DisplayImpl displayImpl = null;
        try {
            displayImpl = new DisplayImplJ3D("simple data display");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            displayImpl = new DisplayImplJ2D("simple data display");
            bl = false;
        }
        MathType mathType = dataImpl.getType();
        ScalarMap[] scalarMapArray = mathType.guessMaps(bl);
        if (scalarMapArray == null) {
            displayImpl.stop();
            return null;
        }
        if (bl) {
            n = 1;
            int n2 = 0;
            while (n2 < scalarMapArray.length) {
                DisplayRealType displayRealType = scalarMapArray[n2].getDisplayScalar();
                if (Display.ZAxis.equals(scalarMapArray[n2]) || Display.Latitude.equals(scalarMapArray[n2])) {
                    n = 0;
                    break;
                }
                ++n2;
            }
            if (n != 0) {
                displayImpl.stop();
                displayImpl = new DisplayImplJ3D("simple data display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            }
        }
        n = 0;
        while (n < scalarMapArray.length) {
            displayImpl.addMap(scalarMapArray[n]);
            ++n;
        }
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("simple data display");
        dataReferenceImpl.setData(dataImpl);
        displayImpl.addReference(dataReferenceImpl);
        return displayImpl;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        float[][] fArray = new float[64][64];
        int n = 0;
        while (n < 64) {
            int n2 = 0;
            while (n2 < 64) {
                fArray[n][n2] = n * (n - 32) * (n - 64) * n2 * (n2 - 32) * (n2 - 64) + 100000;
                ++n2;
            }
            ++n;
        }
        FlatField flatField = DataUtility.makeImage(fArray);
        DisplayImpl displayImpl = DataUtility.makeSimpleDisplay(flatField);
        JFrame jFrame = new JFrame("SimplImage.main");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.setContentPane((JPanel)displayImpl.getComponent());
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static RealTupleType ensureRealTupleType(MathType mathType) throws TypeException, VisADException {
        RealTupleType realTupleType;
        if (mathType instanceof RealTupleType) {
            realTupleType = (RealTupleType)mathType;
        } else if (mathType instanceof RealType) {
            realTupleType = new RealTupleType((RealType)mathType);
        } else if (mathType instanceof SetType) {
            realTupleType = ((SetType)mathType).getDomain();
        } else {
            throw new TypeException((class$Lvisad$util$DataUtility != null ? class$Lvisad$util$DataUtility : (class$Lvisad$util$DataUtility = DataUtility.class$("visad.util.DataUtility"))).getName() + ".ensureRealTupleType(MathType): Can't convert MathType \"" + mathType + "\" into a RealTupleType");
        }
        return realTupleType;
    }

    public static TupleType ensureTupleType(MathType mathType) throws VisADException {
        return mathType instanceof TupleType ? (TupleType)mathType : (mathType instanceof SetType ? ((SetType)mathType).getDomain() : (mathType instanceof RealType ? new RealTupleType((RealType)mathType) : new TupleType(new MathType[]{mathType})));
    }

    public static TupleIface ensureTuple(Data data) throws VisADException, RemoteException {
        return data instanceof TupleIface ? (TupleIface)data : (data instanceof Real ? new RealTuple(new Real[]{(Real)data}) : new Tuple(new Data[]{data}));
    }

    public static RealTupleType getDomainType(Set set) {
        return ((SetType)set.getType()).getDomain();
    }

    public static RealTupleType getDomainType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getDomain();
    }

    public static MathType getRangeType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getRange();
    }

    public static TupleType getRangeTupleType(Function function) throws VisADException, RemoteException {
        return DataUtility.ensureTupleType(DataUtility.getRangeType(function));
    }

    public static RealTupleType getFlatRangeType(Function function) throws VisADException, RemoteException {
        return ((FunctionType)function.getType()).getFlatRange();
    }

    public static int getRangeDimension(Function function) throws VisADException, RemoteException {
        return DataUtility.getRangeTupleType(function).getDimension();
    }

    public static int getComponentIndex(TupleType tupleType, MathType mathType) throws VisADException, RemoteException {
        int n = tupleType.getDimension();
        while (--n >= 0) {
            if (!mathType.equals(tupleType.getComponent(n))) continue;
            return n;
        }
        n = tupleType.getDimension();
        while (--n >= 0) {
            if (!mathType.equalsExceptNameButUnits(tupleType.getComponent(n))) continue;
            return n;
        }
        return -1;
    }

    public static int getComponentIndex(Set set, MathType mathType) throws VisADException, RemoteException {
        return DataUtility.getComponentIndex(((SetType)set.getType()).getDomain(), mathType);
    }

    public static int getComponentIndex(Function function, MathType mathType) throws VisADException, RemoteException {
        return DataUtility.getComponentIndex(DataUtility.getRangeTupleType(function), mathType);
    }

    public static Field ensureRange(Field field, MathType mathType) throws UnimplementedException, TypeException, VisADException, RemoteException {
        Field field2;
        if (mathType.equals(DataUtility.getRangeType(field))) {
            field2 = field;
        } else if (mathType instanceof RealType) {
            int n = DataUtility.getComponentIndex(field, mathType);
            field2 = n >= 0 ? field.extract(n) : new FlatField(new FunctionType(DataUtility.getDomainType(field), mathType), field.getDomainSet());
        } else if (mathType instanceof RealTupleType) {
            int n = DataUtility.getComponentIndex(field, mathType);
            if (n >= 0) {
                field2 = (FlatField)field.extract(n);
            } else {
                RealTupleType realTupleType = (RealTupleType)mathType;
                int n2 = realTupleType.getDimension();
                ArrayList<Field> arrayList = new ArrayList<Field>(n2);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = DataUtility.getComponentIndex(field, realTupleType.getComponent(n3));
                    if (n4 >= 0) {
                        arrayList.add(field.extract(n4));
                    }
                    ++n3;
                }
                field2 = arrayList.size() != n2 ? new FlatField(new FunctionType(DataUtility.getDomainType(field), mathType), field.getDomainSet()) : (FlatField)FieldImpl.combine(arrayList.toArray(new FlatField[n2]));
            }
        } else {
            if (mathType instanceof TupleType) {
                throw new UnimplementedException("Can't yet create Field with range " + mathType + " from existing Field");
            }
            throw new TypeException("Can't create Field with range " + mathType);
        }
        return field2;
    }

    public static Field consolidate(Field[] fieldArray) throws FieldException, TypeException, VisADException, RemoteException {
        DataImpl dataImpl;
        Unit[] unitArray;
        Object object;
        Object object2;
        ArrayList<Field> arrayList = new ArrayList<Field>(fieldArray.length);
        int n = 0;
        while (n < fieldArray.length) {
            object2 = fieldArray[n];
            if (!object2.isMissing()) {
                arrayList.add((Field)object2);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw new FieldException((class$Lvisad$util$DataUtility != null ? class$Lvisad$util$DataUtility : (class$Lvisad$util$DataUtility = DataUtility.class$("visad.util.DataUtility"))).getName() + "(Field[]): Zero fields to consolidate");
        }
        FunctionType functionType = (FunctionType)fieldArray[0].getType();
        object2 = new TreeSet();
        Object object3 = ((AbstractList)arrayList).iterator();
        while (object3.hasNext()) {
            object = (Field)object3.next();
            if (!object.getType().equals(functionType)) {
                throw new TypeException("Field type mismatch");
            }
            unitArray = object.domainEnumeration();
            while (unitArray.hasMoreElements()) {
                ((TreeSet)object2).add(new ReferencedDomainPoint((RealTuple)unitArray.nextElement(), (Field)object));
            }
        }
        object3 = fieldArray[0];
        object = new float[object3.getDomainDimension()][((TreeSet)object2).size()];
        unitArray = object3.getDomainUnits();
        int n2 = 0;
        Object object4 = ((TreeSet)object2).iterator();
        while (object4.hasNext()) {
            dataImpl = ((ReferencedDomainPoint)object4.next()).sample;
            int n3 = ((Object)object).length;
            while (--n3 >= 0) {
                object[n3][n2] = (float)((Real)((Tuple)dataImpl).getComponent(n3)).getValue(unitArray[n3]);
            }
            ++n2;
        }
        object4 = ((Object)object).length == 1 ? new Gridded1DSet((MathType)DataUtility.getDomainType((Function)object3), (float[][])object, ((Object)object[0]).length, null, object3.getDomainUnits(), null) : (((Object)object).length == 2 ? new Irregular2DSet(DataUtility.getDomainType((Function)object3), (float[][])object, null, object3.getDomainUnits(), null, null) : (((Object)object).length == 3 ? new Irregular3DSet(DataUtility.getDomainType((Function)object3), (float[][])object, null, object3.getDomainUnits(), null, null) : new IrregularSet((MathType)DataUtility.getDomainType((Function)object3), (float[][])object, null, object3.getDomainUnits(), null)));
        dataImpl = object3 instanceof FlatField ? new FlatField(functionType, (Set)object4) : new FieldImpl(functionType, (Set)object4);
        Iterator iterator = ((TreeSet)object2).iterator();
        while (iterator.hasNext()) {
            ReferencedDomainPoint referencedDomainPoint = (ReferencedDomainPoint)iterator.next();
            RealTuple realTuple = referencedDomainPoint.sample;
            dataImpl.setSample(realTuple, referencedDomainPoint.field.evaluate(realTuple));
        }
        return dataImpl;
    }

    public static GriddedSet createGriddedSet(FlatField flatField, boolean bl) throws VisADException, RemoteException {
        int n = flatField.getDomainDimension();
        int n2 = flatField.getRangeDimension();
        RealType[] realTypeArray = new RealType[n + n2];
        RealTupleType realTupleType = DataUtility.getDomainType(flatField);
        int n3 = 0;
        while (n3 < n) {
            realTypeArray[n3] = (RealType)realTupleType.getComponent(n3);
            ++n3;
        }
        realTupleType = DataUtility.getFlatRangeType(flatField);
        n3 = 0;
        while (n3 < n2) {
            realTypeArray[n + n3] = (RealType)realTupleType.getComponent(n3);
            ++n3;
        }
        float[][] fArray = new float[realTypeArray.length][flatField.getLength()];
        System.arraycopy(flatField.getDomainSet().getSamples(), 0, fArray, 0, n);
        System.arraycopy(flatField.getFloats(bl), 0, fArray, n, n2);
        int[] nArray = new int[fArray.length];
        int n4 = fArray.length;
        while (--n4 >= 0) {
            nArray[n4] = fArray[n4].length;
        }
        Unit[] unitArray = new Unit[realTypeArray.length];
        System.arraycopy(flatField.getDomainUnits(), 0, unitArray, 0, n);
        System.arraycopy(flatField.getDefaultRangeUnits(), 0, unitArray, n, n2);
        return GriddedSet.create(new RealTupleType(realTypeArray), fArray, nArray, null, unitArray, null);
    }

    public static MathType simplify(MathType mathType) throws VisADException {
        while (mathType instanceof TupleType && ((TupleType)mathType).getDimension() == 1) {
            mathType = ((TupleType)mathType).getComponent(0);
        }
        return mathType;
    }

    public static int getRealTypes(Data data, Vector vector) throws VisADException, RemoteException {
        return DataUtility.getRealTypes(new Data[]{data}, vector, true, false);
    }

    public static int getRealTypes(Data[] dataArray, Vector vector, boolean bl, boolean bl2) throws VisADException, RemoteException {
        int n = DataUtility.getScalarTypes(dataArray, vector, bl, bl2);
        int n2 = 0;
        while (n2 < vector.size()) {
            ScalarType scalarType = (ScalarType)vector.elementAt(n2);
            if (!(scalarType instanceof RealType)) {
                vector.remove(n2);
                continue;
            }
            ++n2;
        }
        return n;
    }

    public static int getScalarTypes(Data data, Vector vector) throws VisADException, RemoteException {
        return DataUtility.getScalarTypes(new Data[]{data}, vector, true, false);
    }

    public static int getScalarTypes(Data[] dataArray, Vector vector, boolean bl, boolean bl2) throws VisADException, RemoteException {
        Data data;
        Vector vector2 = bl2 ? new Vector() : null;
        int[] nArray = new int[]{0};
        int n = 0;
        while (n < dataArray.length) {
            data = dataArray[n];
            if (data != null) {
                MathType mathType = data.getType();
                DataUtility.parse(mathType, vector, nArray, bl, vector2);
            }
            ++n;
        }
        if (vector2 != null) {
            n = 0;
            while (n < vector2.size()) {
                data = vector2.elementAt(n);
                boolean bl3 = vector.contains(data);
                if (bl3) {
                    nArray[0] = nArray[0] + 1;
                }
                if (bl || !bl3) {
                    vector.add(data);
                }
                ++n;
            }
        }
        return nArray[0];
    }

    private static void parse(MathType mathType, Vector vector, int[] nArray, boolean bl, Vector vector2) throws VisADException {
        if (mathType instanceof FunctionType) {
            DataUtility.parseFunction((FunctionType)mathType, vector, nArray, bl, vector2);
        } else if (mathType instanceof SetType) {
            DataUtility.parseSet((SetType)mathType, vector, nArray, bl, vector2);
        } else if (mathType instanceof TupleType) {
            DataUtility.parseTuple((TupleType)mathType, vector, nArray, bl, vector2);
        } else {
            DataUtility.parseScalar((ScalarType)mathType, vector, nArray, bl);
        }
    }

    private static void parseFunction(FunctionType functionType, Vector vector, int[] nArray, boolean bl, Vector vector2) throws VisADException {
        RealTupleType realTupleType = functionType.getDomain();
        DataUtility.parseTuple(realTupleType, vector, nArray, bl, vector2);
        MathType mathType = functionType.getRange();
        DataUtility.parse(mathType, vector, nArray, bl, vector2);
    }

    private static void parseSet(SetType setType, Vector vector, int[] nArray, boolean bl, Vector vector2) throws VisADException {
        RealTupleType realTupleType = setType.getDomain();
        DataUtility.parseTuple(realTupleType, vector, nArray, bl, vector2);
    }

    private static void parseTuple(TupleType tupleType, Vector vector, int[] nArray, boolean bl, Vector vector2) throws VisADException {
        RealTupleType realTupleType;
        Serializable serializable;
        int n = 0;
        while (n < tupleType.getDimension()) {
            serializable = tupleType.getComponent(n);
            if (serializable != null) {
                DataUtility.parse((MathType)serializable, vector, nArray, bl, vector2);
            }
            ++n;
        }
        if (tupleType instanceof RealTupleType && vector2 != null && (serializable = (realTupleType = (RealTupleType)tupleType).getCoordinateSystem()) != null) {
            RealType realType;
            RealTupleType realTupleType2 = ((CoordinateSystem)serializable).getReference();
            int n2 = 0;
            while (n2 < realTupleType.getDimension()) {
                realType = (RealType)realTupleType.getComponent(n2);
                DataUtility.parseScalar(realType, vector2, new int[1], bl);
                ++n2;
            }
            n2 = 0;
            while (n2 < realTupleType2.getDimension()) {
                realType = (RealType)realTupleType2.getComponent(n2);
                DataUtility.parseScalar(realType, vector2, new int[1], bl);
                ++n2;
            }
        }
    }

    private static void parseScalar(ScalarType scalarType, Vector vector, int[] nArray, boolean bl) {
        if (vector.contains(scalarType)) {
            if (bl) {
                vector.add(scalarType);
            }
            nArray[0] = nArray[0] + 1;
        } else {
            vector.add(scalarType);
        }
    }

    public static ScalarMap[] guessMaps(MathType[] mathTypeArray, boolean bl) {
        int n = mathTypeArray.length;
        ScalarMap[] scalarMapArray = null;
        int n2 = 0;
        while (n2 < n) {
            MathType mathType = mathTypeArray[n2];
            if (mathType != null) {
                scalarMapArray = mathType.guessMaps(bl);
            }
            if (scalarMapArray != null) break;
            ++n2;
        }
        return scalarMapArray;
    }

    public static String convertMapsToString(Vector vector) {
        int n = vector.size();
        ScalarMap[] scalarMapArray = new ScalarMap[n];
        int n2 = 0;
        while (n2 < n) {
            scalarMapArray[n2] = (ScalarMap)vector.elementAt(n2);
            ++n2;
        }
        return DataUtility.convertMapsToString(scalarMapArray);
    }

    public static String convertMapsToString(ScalarMap[] scalarMapArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < scalarMapArray.length) {
            ScalarMap scalarMap = scalarMapArray[n];
            ScalarType scalarType = scalarMap.getScalar();
            DisplayRealType displayRealType = scalarMap.getDisplayScalar();
            int n2 = -1;
            int n3 = 0;
            while (n3 < Display.DisplayRealArray.length) {
                if (displayRealType.equals(Display.DisplayRealArray[n3])) {
                    n2 = n3;
                }
                ++n3;
            }
            stringBuffer.append(' ');
            stringBuffer.append(scalarType.getName());
            stringBuffer.append(' ');
            stringBuffer.append(n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static ScalarMap[] convertStringToMaps(String string, Data data, boolean bl) {
        return DataUtility.convertStringToMaps(string, new Data[]{data}, bl);
    }

    public static ScalarMap[] convertStringToMaps(String string, Data[] dataArray, boolean bl) {
        Vector vector = new Vector();
        int n = 0;
        while (n < dataArray.length) {
            block5: {
                try {
                    DataUtility.getScalarTypes(dataArray[n], vector);
                }
                catch (VisADException visADException) {
                    if (bl) {
                        System.out.println("Warning: could not extract ScalarTypes from Data object.");
                    }
                }
                catch (RemoteException remoteException) {
                    if (!bl) break block5;
                    System.out.println("Warning: could not extract ScalarTypes from Data object.");
                }
            }
            ++n;
        }
        return DataUtility.convertStringToMaps(string, vector, bl);
    }

    public static ScalarMap[] convertStringToMaps(String string, Vector vector, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector2 = new Vector<String>();
        Vector<Integer> vector3 = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                if (!bl) continue;
                System.err.println("Warning: trailing maps value " + string2 + " has no corresponding number and will be ignored");
                continue;
            }
            String string3 = stringTokenizer.nextToken();
            Integer n2 = null;
            try {
                n2 = new Integer(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 == null) {
                if (!bl) continue;
                System.err.println("Warning: maps value " + string3 + " is not a " + "valid integer and the maps pair (" + string2 + ", " + string3 + ") " + "will be ignored");
                continue;
            }
            vector2.add(string2);
            vector3.add(n2);
        }
        if (vector2 != null && (n = vector2.size()) > 0) {
            int n3 = vector.size();
            int n4 = Display.DisplayRealArray.length;
            ScalarMap[] scalarMapArray = new ScalarMap[n];
            int n5 = 0;
            while (n5 < n) {
                ScalarType scalarType;
                ScalarType scalarType2 = null;
                String string4 = (String)vector2.elementAt(n5);
                int n6 = 0;
                while (n6 < n3) {
                    scalarType = (ScalarType)vector.elementAt(n6);
                    if (string4.equals(scalarType.getName())) {
                        scalarType2 = scalarType;
                        break;
                    }
                    ++n6;
                }
                if (scalarType2 == null) {
                    scalarType2 = ScalarType.getScalarTypeByName(string4);
                }
                n6 = (Integer)vector3.elementAt(n5);
                scalarType = null;
                if (n6 >= 0 && n6 < n4) {
                    scalarType = Display.DisplayRealArray[n6];
                }
                if (scalarType2 == null || scalarType == null) {
                    if (bl) {
                        System.err.print("Warning: maps pair (" + string4 + ", " + n6 + ") has an invalid ");
                        if (scalarType2 == null && scalarType == null) {
                            System.err.print("domain and range");
                        } else if (scalarType2 == null) {
                            System.err.print("domain");
                        } else {
                            System.err.print("range");
                        }
                        System.err.println(" and will be ignored");
                    }
                    scalarMapArray[n5] = null;
                } else {
                    try {
                        scalarMapArray[n5] = new ScalarMap(scalarType2, (DisplayRealType)scalarType);
                    }
                    catch (VisADException visADException) {
                        if (bl) {
                            System.err.println("Warning: maps pair (" + string4 + ", " + n6 + ") cannot be converted to a ScalarMap");
                        }
                        scalarMapArray[n5] = null;
                    }
                }
                ++n5;
            }
            return scalarMapArray;
        }
        return null;
    }

    public static boolean isSerializable(Object object, boolean bl) {
        ObjectInputStream objectInputStream;
        ObjectOutputStream objectOutputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            objectOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        try {
            Object object2 = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                classNotFoundException.printStackTrace();
            }
            return false;
        }
        try {
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class RealTupleComparator
    implements Comparator {
        public static final RealTupleComparator INSTANCE = new RealTupleComparator();

        public int compare(Object object, Object object2) throws ClassCastException {
            RealTuple realTuple = (RealTuple)object;
            RealTuple realTuple2 = (RealTuple)object2;
            try {
                int n = realTuple.getDimension();
                int n2 = 0;
                int n3 = n;
                while (--n3 >= 0 && n2 == 0) {
                    n2 = ((Real)realTuple.getComponent(n3)).compareTo((Real)realTuple2.getComponent(n3));
                }
                return n2;
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                throw new ClassCastException("Can't compare RealTuple-s" + (string == null ? "" : ": " + string));
            }
        }

        private RealTupleComparator() {
        }
    }

    private static class ReferencedDomainPoint
    implements Comparable {
        protected final RealTuple sample;
        protected final Field field;

        public int compareTo(Object object) {
            return RealTupleComparator.INSTANCE.compare(this.sample, ((ReferencedDomainPoint)object).sample);
        }

        public ReferencedDomainPoint(RealTuple realTuple, Field field) {
            this.sample = realTuple;
            this.field = field;
        }
    }
}

