/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.ContourControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.PlotText;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.util.RangeSlider;
import visad.util.Util;

public class ContourWidget
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener,
ControlListener,
ScalarMapListener {
    private ContourControl control;
    private float cInterval;
    private float cBase;
    private float cSurface;
    private float cLo;
    private float cHi;
    private String name;
    private JTextField Interval;
    private JTextField Base;
    private JLabel SurfaceLabel;
    private JSlider Surface;
    private JCheckBox Labels;
    private JCheckBox Contours;
    private JCheckBox Dashed;
    private ContourRangeSlider ContourRange;
    private double sliderScale;
    private Dimension prefSize = null;

    void setSliderBounds(float f, float f2) {
        this.sliderScale = 1000.0f / (f2 - f);
        this.Surface.setMinimum((int)(this.sliderScale * (double)f));
        this.Surface.setMaximum((int)(this.sliderScale * (double)f2));
    }

    void setMinMax(float f, float f2) throws VisADException, RemoteException {
        if (!Util.isApproximatelyEqual(this.cLo, f) || !Util.isApproximatelyEqual(this.cHi, f2)) {
            this.cLo = f;
            this.cHi = f2;
            this.control.setContourLimits(this.cLo, this.cHi);
        }
    }

    private void detectValues(double[] dArray) throws VisADException, RemoteException {
        boolean[] blArray = new boolean[2];
        float[] fArray = new float[5];
        this.control.getMainContours(blArray, fArray);
        boolean bl = false;
        if (fArray[0] == fArray[0] && !Util.isApproximatelyEqual(this.cSurface, fArray[0])) {
            this.cSurface = fArray[0];
            bl = true;
        } else if (!Util.isApproximatelyEqual(this.cSurface, (float)dArray[0])) {
            this.cSurface = (float)dArray[0];
            bl = true;
        }
        if (bl) {
            this.control.setSurfaceValue(this.cSurface);
        }
        if (!(Util.isApproximatelyEqual(this.cInterval, fArray[1]) && Util.isApproximatelyEqual(this.cLo, fArray[2]) && Util.isApproximatelyEqual(this.cHi, fArray[3]) && Util.isApproximatelyEqual(this.cBase, fArray[4]))) {
            this.cInterval = fArray[1];
            this.cLo = fArray[2];
            this.cHi = fArray[3];
            this.cBase = fArray[4];
            this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
        }
        this.updateWidgetSurface();
        this.updateWidgetRange();
    }

    private synchronized void updateWidgetSurface() throws VisADException, RemoteException {
        if (this.cSurface == this.cSurface) {
            this.Surface.setEnabled(true);
            double d = this.sliderScale * (double)this.cSurface;
            int n = d < 0.0 ? (int)(d - 0.5) : (int)(d + 0.5);
            this.Surface.setValue(n);
            this.SurfaceLabel.setText(this.name + " = " + PlotText.shortString(this.cSurface));
        } else {
            this.Surface.setEnabled(false);
            this.SurfaceLabel.setText(this.name + " = ---");
        }
    }

    private synchronized void updateWidgetRange() throws VisADException, RemoteException {
        if (this.cInterval == this.cInterval && this.cBase == this.cBase) {
            this.Interval.setEnabled(true);
            this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            this.Base.setEnabled(true);
            this.Base.setText("" + PlotText.shortString(this.cBase));
        } else {
            this.Interval.setEnabled(false);
            this.Interval.setText("---");
            this.Base.setEnabled(false);
            this.Base.setText("---");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f;
        String string = actionEvent.getActionCommand();
        if (string.equals("interval")) {
            f = Float.NaN;
            try {
                f = Float.valueOf(this.Interval.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            }
            if (f == f && f >= 0.0f) {
                if (this.cInterval < 0.0f) {
                    f = -f;
                }
                try {
                    this.control.setContourInterval(f, this.cLo, this.cHi, this.cBase);
                    this.cInterval = f;
                }
                catch (VisADException visADException) {
                    this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
                }
                catch (RemoteException remoteException) {
                    this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
                }
            } else {
                this.Interval.setText(PlotText.shortString(Math.abs(this.cInterval)));
            }
        }
        if (string.equals("base")) {
            f = Float.NaN;
            try {
                f = Float.valueOf(this.Base.getText()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.Base.setText(PlotText.shortString(this.cBase));
            }
            if (f == f) {
                try {
                    this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, f);
                    this.cBase = f;
                }
                catch (VisADException visADException) {
                    this.Base.setText(PlotText.shortString(this.cBase));
                }
                catch (RemoteException remoteException) {
                    this.Base.setText(PlotText.shortString(this.cBase));
                }
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        float f = (float)((double)this.Surface.getValue() / this.sliderScale);
        if (!Util.isApproximatelyEqual(this.cSurface, f)) {
            this.cSurface = f;
            this.SurfaceLabel.setText(this.name + " = " + PlotText.shortString(this.cSurface));
            try {
                this.control.setSurfaceValue(this.cSurface);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.Labels) {
            try {
                this.control.enableLabels(bl);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (itemSelectable == this.Contours) {
            try {
                this.control.enableContours(bl);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (itemSelectable == this.Dashed) {
            this.cInterval = -this.cInterval;
            try {
                this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        float f;
        float f2;
        boolean bl;
        boolean[] blArray = new boolean[2];
        float[] fArray = new float[5];
        this.control.getMainContours(blArray, fArray);
        if (this.Contours.isSelected() != blArray[0]) {
            this.Contours.setSelected(blArray[0]);
        }
        if (this.Labels.isSelected() != blArray[1]) {
            this.Labels.setSelected(blArray[1]);
        }
        boolean bl2 = bl = (f2 = fArray[1]) < 0.0f;
        if (this.Dashed.isSelected() != bl) {
            this.Dashed.setSelected(bl);
        }
        if (!Util.isApproximatelyEqual(f2, f = bl != this.cInterval < 0.0f ? -this.cInterval : this.cInterval)) {
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            this.Interval.setText(PlotText.shortString(f2));
            this.cInterval = fArray[1];
        }
        if (!Util.isApproximatelyEqual(fArray[4], this.cBase)) {
            this.Base.setText(PlotText.shortString(fArray[4]));
            this.cBase = fArray[4];
        }
        if (!Util.isApproximatelyEqual(fArray[0], this.cSurface)) {
            this.cSurface = fArray[0];
            this.updateWidgetSurface();
        }
        if (!Util.isApproximatelyEqual(fArray[2], this.cLo) || !Util.isApproximatelyEqual(fArray[3], this.cHi)) {
            this.cLo = fArray[2];
            this.cHi = fArray[3];
            this.updateWidgetRange();
            this.ContourRange.setValues(this.cLo, this.cHi);
        }
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(300, super.getPreferredSize().height);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) throws RemoteException, VisADException {
        int n = scalarMapControlEvent.getId();
        if (this.control != null && (n == 4 || n == 5)) {
            scalarMapControlEvent.getControl().removeControlListener(this);
        }
        if (n == 5 || n == 3) {
            this.control = (ContourControl)scalarMapControlEvent.getScalarMap().getControl();
            this.controlChanged(new ControlEvent(this.control));
            this.control.addControlListener(this);
        }
    }

    public ContourWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(scalarMap, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, true);
    }

    public ContourWidget(ScalarMap scalarMap, float f) throws VisADException, RemoteException {
        this(scalarMap, Float.NaN, Float.NaN, Float.NaN, Float.NaN, f, true);
    }

    public ContourWidget(ScalarMap scalarMap, float f, float f2, float f3, float f4) throws VisADException, RemoteException {
        this(scalarMap, f, f2, f3, f4, Float.NaN, true);
    }

    public ContourWidget(ScalarMap scalarMap, float f, float f2, float f3, float f4, float f5, boolean bl) throws VisADException, RemoteException {
        if (!Display.IsoContour.equals(scalarMap.getDisplayScalar())) {
            throw new DisplayException("ContourWidget: ScalarMap must be to Display.IsoContour");
        }
        this.name = scalarMap.getScalarName();
        this.control = (ContourControl)scalarMap.getControl();
        boolean[] blArray = new boolean[2];
        float[] fArray = new float[5];
        this.control.getMainContours(blArray, fArray);
        boolean bl2 = blArray[0];
        boolean bl3 = blArray[1];
        boolean bl4 = fArray[1] < 0.0f;
        boolean bl5 = false;
        boolean bl6 = false;
        if (f5 == f5) {
            this.cSurface = f5;
            bl5 = true;
        } else {
            this.cSurface = fArray[0];
        }
        if (f == f) {
            this.cInterval = f;
            bl6 = true;
        } else {
            this.cInterval = fArray[1];
        }
        if (f2 == f2) {
            this.cLo = f2;
            bl6 = true;
        } else {
            this.cLo = fArray[2];
        }
        if (f3 == f3) {
            this.cHi = f3;
            bl6 = true;
        } else {
            this.cHi = fArray[3];
        }
        if (f4 == f4) {
            this.cBase = f4;
            bl6 = true;
        } else {
            this.cBase = fArray[4];
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.Contours = new JCheckBox("contours", bl2);
        this.Labels = new JCheckBox("labels", bl3);
        this.Dashed = new JCheckBox("dashed lines below base", bl4);
        JLabel jLabel = new JLabel("interval:");
        this.Interval = new JTextField("---");
        Dimension dimension = this.Interval.getMaximumSize();
        Dimension dimension2 = this.Interval.getPreferredSize();
        dimension.height = dimension2.height;
        this.Interval.setMaximumSize(dimension);
        JLabel jLabel2 = new JLabel("base:");
        this.Base = new JTextField("---");
        dimension = this.Base.getMaximumSize();
        dimension2 = this.Base.getPreferredSize();
        dimension.height = dimension2.height;
        this.Base.setMaximumSize(dimension);
        this.SurfaceLabel = new JLabel(this.name + " = ---");
        this.Surface = new JSlider();
        this.ContourRange = new ContourRangeSlider(scalarMap, this.cLo, this.cHi, this, bl);
        if (!bl) {
            if (bl5) {
                this.control.setSurfaceValue(this.cSurface);
            }
            if (bl6) {
                this.control.setContourInterval(this.cInterval, this.cLo, this.cHi, this.cBase);
            }
            this.updateWidgetSurface();
            this.updateWidgetRange();
        }
        jLabel.setForeground(Color.black);
        jLabel2.setForeground(Color.black);
        this.SurfaceLabel.setForeground(Color.black);
        this.Dashed.setAlignmentX(0.5f);
        this.SurfaceLabel.setAlignmentX(0.5f);
        this.Interval.addActionListener(this);
        this.Interval.setActionCommand("interval");
        this.Base.addActionListener(this);
        this.Base.setActionCommand("base");
        Dimension dimension3 = new Dimension(Integer.MAX_VALUE, this.SurfaceLabel.getMaximumSize().height);
        this.SurfaceLabel.setMaximumSize(dimension3);
        this.SurfaceLabel.setPreferredSize(dimension3);
        this.Surface.addChangeListener(this);
        this.Labels.addItemListener(this);
        this.Contours.addItemListener(this);
        this.Dashed.addItemListener(this);
        this.control.addControlListener(this);
        scalarMap.addScalarMapListener(this);
        this.Contours.setToolTipText("Toggle contours");
        this.Labels.setToolTipText("Toggle iso-contour labels (2-D only)");
        this.Dashed.setToolTipText("Toggle dashed lines below base value (2-D only)");
        String string = "Specify the iso-contouring interval (2-D only)";
        jLabel.setToolTipText(string);
        this.Interval.setToolTipText(string);
        String string2 = "Specify the iso-contouring base value (2-D only)";
        jLabel2.setToolTipText(string2);
        this.Base.setToolTipText(string2);
        String string3 = "Specify the iso-level value (3-D only)";
        this.SurfaceLabel.setToolTipText(string3);
        this.Surface.setToolTipText(string3);
        jPanel.add(this.Contours);
        jPanel.add(this.Labels);
        jPanel2.add(jLabel);
        jPanel2.add(this.Interval);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jLabel2);
        jPanel2.add(this.Base);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(this.SurfaceLabel);
        this.add(jPanel);
        this.add(this.Dashed);
        this.add(jPanel2);
        this.add(jPanel3);
        this.add(this.Surface);
        this.add(this.ContourRange);
    }

    class ContourRangeSlider
    extends RangeSlider
    implements ScalarMapListener {
        ContourWidget pappy;

        public void mapChanged(ScalarMapEvent scalarMapEvent) {
            ScalarMap scalarMap = scalarMapEvent.getScalarMap();
            ContourControl contourControl = (ContourControl)scalarMap.getControl();
            double[] dArray = scalarMap.getRange();
            try {
                this.minLimit = (float)dArray[0];
                this.maxLimit = (float)dArray[1];
                if (!Util.isApproximatelyEqual(ContourWidget.this.cLo, this.minLimit) || !Util.isApproximatelyEqual(ContourWidget.this.cHi, this.maxLimit)) {
                    ContourWidget.this.cLo = this.minLimit;
                    ContourWidget.this.cHi = this.maxLimit;
                }
                this.pappy.setSliderBounds(this.minLimit, this.maxLimit);
                this.pappy.detectValues(dArray);
                float[] fArray = new float[3];
                boolean[] blArray = new boolean[1];
                float[] fArray2 = contourControl.getLevels(fArray, blArray);
                this.setValues(fArray[0], fArray[1]);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        }

        public void valuesUpdated() {
            try {
                this.pappy.setMinMax(this.minValue, this.maxValue);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        ContourRangeSlider(ScalarMap scalarMap, float f, float f2, ContourWidget contourWidget2, boolean bl) throws VisADException, RemoteException {
            super(RangeSlider.nameOf(scalarMap), f, f2);
            this.pappy = contourWidget2;
            if (bl) {
                scalarMap.addScalarMapListener(this);
            }
        }
    }
}

