/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import visad.VisADException;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;
import visad.util.ColorMap;
import visad.util.ColorPreview;
import visad.util.RGBAMap;
import visad.util.RGBMap;

public class ColorWidget
extends Applet
implements ColorChangeListener {
    private boolean previewVisible;
    private ColorMap map;
    private ColorPreview colorPreview;
    private Vector listeners = new Vector();
    private Object listeners_lock = new Object();

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        JFrame jFrame = new JFrame("VisAD Color Widget");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        ColorWidget colorWidget = new ColorWidget(new RGBAMap());
        jFrame.add(colorWidget);
        ((Component)jFrame).setSize(colorWidget.getPreferredSize());
        ((Component)jFrame).setVisible(true);
    }

    public void addColorChangeListener(ColorChangeListener colorChangeListener) {
        Object object = this.listeners_lock;
        synchronized (object) {
            if (!this.listeners.contains(colorChangeListener)) {
                this.listeners.addElement(colorChangeListener);
            }
        }
    }

    public void removeColorChangeListener(ColorChangeListener colorChangeListener) {
        Object object = this.listeners_lock;
        synchronized (object) {
            if (this.listeners.contains(colorChangeListener)) {
                this.listeners.removeElement(colorChangeListener);
            }
        }
    }

    protected void notifyListeners(ColorChangeEvent colorChangeEvent) {
        Vector vector = null;
        Object object = this.listeners_lock;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ColorChangeListener colorChangeListener = (ColorChangeListener)vector.elementAt(n);
            colorChangeListener.colorChanged(colorChangeEvent);
            ++n;
        }
    }

    public void colorChanged(ColorChangeEvent colorChangeEvent) {
        this.notifyListeners(colorChangeEvent);
    }

    public void setColorMap(ColorMap colorMap) {
        if (this.map != null) {
            this.map.removeColorChangeListener(this);
        }
        this.map = colorMap;
        colorMap.addColorChangeListener(this);
        this.removeAll();
        this.add(colorMap);
        if (this.previewVisible) {
            if (this.colorPreview == null) {
                this.colorPreview = new ColorPreview(colorMap);
            }
            this.add(this.colorPreview);
        }
        this.validate();
        int n = colorMap.getMapResolution();
        this.notifyListeners(new ColorChangeEvent(colorMap, 0.0f, n));
    }

    public void showPreview() {
        if (this.previewVisible) {
            return;
        }
        this.previewVisible = true;
        this.setColorMap(this.map);
    }

    public void hidePreview() {
        if (!this.previewVisible) {
            return;
        }
        this.previewVisible = false;
        this.setColorMap(this.map);
    }

    public ColorMap getColorMap() {
        return this.map;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.map.getPreferredSize();
        if (this.previewVisible) {
            Dimension dimension2;
            Dimension dimension3 = this.colorPreview.getPreferredSize();
            dimension = dimension2 = new Dimension(dimension.width, dimension.height + dimension3.height);
        }
        return dimension;
    }

    public ColorWidget() throws RemoteException, VisADException {
        this(true);
    }

    public ColorWidget(boolean bl) throws RemoteException, VisADException {
        this(new RGBMap(), bl);
    }

    public ColorWidget(ColorMap colorMap) {
        this(colorMap, true);
    }

    public ColorWidget(ColorMap colorMap, boolean bl) {
        this.map = colorMap;
        this.previewVisible = bl;
        if (bl) {
            this.colorPreview = new ColorPreview(colorMap);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setColorMap(colorMap);
    }
}

