/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;
import visad.util.ColorMap;
import visad.util.ColorWidget;

public class ColorPreview
extends JPanel
implements ColorChangeListener {
    private ColorMap map;
    private int height = 15;
    private float updateLeft;
    private float updateRight;

    ColorPreview(ColorMap colorMap) {
        this(colorMap, 15);
    }

    public ColorPreview(ColorMap colorMap, int n) {
        this.map = colorMap;
        this.height = n;
        colorMap.addColorChangeListener(this);
    }

    ColorPreview(ColorWidget colorWidget) {
        this(colorWidget, 15);
    }

    public ColorPreview(ColorWidget colorWidget, int n) {
        this(colorWidget.getColorMap(), n);
    }

    public void colorChanged(ColorChangeEvent colorChangeEvent) {
        ColorPreview colorPreview = this;
        synchronized (colorPreview) {
            if (colorChangeEvent.getStart() < this.updateLeft) {
                this.updateLeft = colorChangeEvent.getStart();
            }
            if (colorChangeEvent.getEnd() > this.updateRight) {
                this.updateRight = colorChangeEvent.getEnd();
            }
        }
        this.validate();
        this.repaint();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.map.getPreferredSize();
        return new Dimension(dimension.width, this.height);
    }

    public void paint(Graphics graphics) {
        this.updateLeft = 0.0f;
        this.updateRight = 1.0f;
        this.update(graphics);
    }

    public void setMap(ColorMap colorMap) {
        this.map.removeColorChangeListener(this);
        colorMap.addColorChangeListener(this);
        this.map = colorMap;
    }

    public void update(Graphics graphics) {
        float f;
        Color[] colorArray;
        int n;
        int n2;
        int n3;
        ColorPreview colorPreview = this;
        synchronized (colorPreview) {
            n3 = (int)Math.floor(this.updateLeft * (float)this.getBounds().width);
            n2 = (int)Math.floor(this.updateRight * (float)this.getBounds().width);
            this.updateLeft = 1.0f;
            this.updateRight = 0.0f;
        }
        if (n3 > n2) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.getBounds().width) {
            n3 = this.getBounds().width - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.getBounds().width) {
            n2 = this.getBounds().width - 1;
        }
        if ((n = n2 - n3 + 1) > (colorArray = this.map.getColors((float)n3 / (f = (float)this.getBounds().width), (float)n2 / f, n)).length) {
            n = colorArray.length;
        }
        int n5 = 0;
        while (n5 < n) {
            graphics.setColor(colorArray[n5]);
            graphics.drawLine(n5 + n3, 0, n5 + n3, this.getBounds().height - 1);
            ++n5;
        }
    }
}

