/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BaseColorControl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.BaseRGBMap;
import visad.util.SimpleColorMapWidget;

public class ColorMapWidget
extends SimpleColorMapWidget
implements ActionListener,
ControlListener,
ScalarMapListener {
    private JPanel buttonPanel = null;
    private float[][] undoTable = null;
    BaseColorControl control;
    BaseColorControl realControl;

    private JPanel buildButtons() {
        JButton jButton = new JButton("Apply");
        jButton.setActionCommand("apply");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Undo");
        jButton2.setActionCommand("undo");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.undoTable = this.control.getTable();
        return jPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("apply")) {
            this.undoTable = this.realControl.getTable();
            try {
                this.realControl.syncControl(this.control);
            }
            catch (VisADException visADException) {}
        } else if (actionEvent.getActionCommand().equals("undo")) {
            try {
                this.realControl.setTable(this.undoTable);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws RemoteException, VisADException {
        if (this.realControl == controlEvent.getControl()) {
            this.control.syncControl(this.realControl);
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        double[] dArray = scalarMapEvent.getScalarMap().getRange();
        this.updateSlider((float)dArray[0], (float)dArray[1]);
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) throws RemoteException, VisADException {
        int n = scalarMapControlEvent.getId();
        if ((n == 4 || n == 5) && this.realControl != null) {
            scalarMapControlEvent.getControl().removeControlListener(this);
        }
        if (n == 5 || n == 3) {
            BaseColorControl baseColorControl = (BaseColorControl)scalarMapControlEvent.getScalarMap().getControl();
            if (this.realControl != null) {
                this.realControl = baseColorControl;
                this.realControl.addControlListener(this);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            RealType realType = new RealType("vis", null, null);
            ScalarMap scalarMap = new ScalarMap(realType, Display.RGBA);
            scalarMap.setRange(0.0, 1.0);
            RealType realType2 = new RealType("ir", null, null);
            ScalarMap scalarMap2 = new ScalarMap(realType, Display.RGB);
            scalarMap2.setRange(0.0, 1.0);
            DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("2d");
            displayImplJ2D.addMap(scalarMap);
            displayImplJ2D.addMap(scalarMap2);
            JFrame jFrame = new JFrame("0");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new ColorMapWidget(scalarMap));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("1");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new ColorMapWidget(scalarMap, false));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("!Updated");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new ColorMapWidget(scalarMap, null, false, true));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            int n = 3;
            int n2 = 256;
            float[][] fArray = new float[3][256];
            float f = 0.0039215684f;
            float f2 = 1.0f;
            int n3 = 0;
            while (n3 < 256) {
                float f3 = f2;
                fArray[2][n3] = f3;
                fArray[1][n3] = f3;
                fArray[0][n3] = f3;
                f2 -= 0.0039215684f;
                ++n3;
            }
            jFrame = new JFrame("Table");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(new ColorMapWidget(scalarMap2, fArray));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            scalarMap.setRange(-10.0, 10.0);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }

    public ColorMapWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(scalarMap, null, true, true);
    }

    public ColorMapWidget(ScalarMap scalarMap, boolean bl) throws VisADException, RemoteException {
        this(scalarMap, null, true, bl);
    }

    public ColorMapWidget(ScalarMap scalarMap, float[][] fArray) throws VisADException, RemoteException {
        this(scalarMap, fArray, true, true);
    }

    public ColorMapWidget(ScalarMap scalarMap, float[][] fArray, boolean bl) throws VisADException, RemoteException {
        this(scalarMap, fArray, bl, true);
    }

    public ColorMapWidget(ScalarMap scalarMap, float[][] fArray, boolean bl, boolean bl2) throws VisADException, RemoteException {
        super(scalarMap.getScalarName(), scalarMap.getControl(), (float)scalarMap.getRange()[0], (float)scalarMap.getRange()[1] + 1.0f);
        Control control = scalarMap.getControl();
        if (!(control instanceof BaseColorControl)) {
            throw new DisplayException(this.getClass().getName() + ": ScalarMap must " + "be Display.RGB or Display.RGBA");
        }
        if (bl2) {
            this.control = (BaseColorControl)control;
            this.realControl = null;
        } else {
            this.realControl = (BaseColorControl)control;
            this.control = new BaseColorControl(this.realControl.getDisplay(), this.realControl.getNumberOfComponents());
            this.control.syncControl(this.realControl);
            this.baseMap = new BaseRGBMap(this.control);
            this.preview.setMap(this.baseMap);
            this.rebuildGUI();
        }
        if (fArray != null) {
            this.control.setTable(fArray);
        }
        if (!bl2) {
            this.buttonPanel = this.buildButtons();
            this.add(this.buttonPanel);
        }
        if (this.realControl != null) {
            this.realControl.addControlListener(this);
        } else {
            this.control.addControlListener(this);
        }
        if (bl) {
            scalarMap.addScalarMapListener(this);
        }
    }
}

