/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.util.Vector;
import javax.swing.JPanel;
import visad.util.ColorChangeEvent;
import visad.util.ColorChangeListener;

public abstract class ColorMap
extends JPanel {
    private Vector listeners = new Vector();

    public Color getColor(float f) {
        if (f < 0.0f || f > 1.0f) {
            return Color.black;
        }
        float[] fArray = this.getRGBTuple(f);
        if (fArray[0] < 0.0f) {
            fArray[0] = 0.0f;
        }
        if (fArray[1] < 0.0f) {
            fArray[1] = 0.0f;
        }
        if (fArray[2] < 0.0f) {
            fArray[2] = 0.0f;
        }
        if (fArray[0] > 1.0f) {
            fArray[0] = 1.0f;
        }
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
        return new Color(fArray[0], fArray[1], fArray[2]);
    }

    public Color[] getColors(float f, float f2, int n) {
        float[][] fArray = this.getMapDimension() < 3 ? this.getRGBTuples(f, f2, n) : this.getTuples(f, f2, n);
        if (fArray == null) {
            return null;
        }
        Color[] colorArray = new Color[fArray.length];
        int n2 = fArray.length - 1;
        while (n2 >= 0) {
            if (fArray[n2][0] < 0.0f) {
                fArray[n2][0] = 0.0f;
            } else if (fArray[n2][0] > 1.0f) {
                fArray[n2][0] = 1.0f;
            }
            if (fArray[n2][1] < 0.0f) {
                fArray[n2][1] = 0.0f;
            } else if (fArray[n2][1] > 1.0f) {
                fArray[n2][1] = 1.0f;
            }
            if (fArray[n2][2] < 0.0f) {
                fArray[n2][2] = 0.0f;
            } else if (fArray[n2][2] > 1.0f) {
                fArray[n2][2] = 1.0f;
            }
            colorArray[n2] = new Color(fArray[n2][0], fArray[n2][1], fArray[n2][2]);
            --n2;
        }
        return colorArray;
    }

    public abstract float[] getRGBTuple(float var1);

    public abstract float[][] getRGBTuples(float var1, float var2, int var3);

    public abstract float[] getTuple(float var1);

    public abstract float[][] getTuples(float var1, float var2, int var3);

    public abstract int getMapResolution();

    public abstract int getMapDimension();

    public abstract float[][] getColorMap();

    public void addColorChangeListener(ColorChangeListener colorChangeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(colorChangeListener)) {
                this.listeners.addElement(colorChangeListener);
            }
        }
    }

    public void removeColorChangeListener(ColorChangeListener colorChangeListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(colorChangeListener)) {
                this.listeners.removeElement(colorChangeListener);
            }
        }
    }

    protected void notifyListeners(ColorChangeEvent colorChangeEvent) {
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ColorChangeListener colorChangeListener = (ColorChangeListener)vector.elementAt(n);
            colorChangeListener.colorChanged(colorChangeEvent);
            ++n;
        }
    }
}

