/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import visad.VisADException;
import visad.util.TextEditor;

public abstract class CodeEditor
extends TextEditor {
    protected JTextArea lineNumbers;
    protected int numLines;
    protected int numDigits;

    public void highlightLine(int n) {
        int n2 = 0;
        String string = this.text.getText() + "\n";
        int n3 = 0;
        while (n3 < n - 1) {
            n2 = string.indexOf("\n", n2) + 1;
            ++n3;
        }
        n3 = string.indexOf("\n", n2);
        this.text.requestFocus();
        this.text.setCaretPosition(n2);
        this.text.moveCaretPosition(n3);
    }

    public abstract void run() throws VisADException;

    public abstract void compile() throws VisADException;

    public abstract void exec(String var1) throws VisADException;

    protected void updateLineNumbers() {
        String string;
        String string2 = this.text.getText();
        int n = string2.length();
        int n2 = 1;
        int n3 = string2.indexOf("\n");
        while (n3 >= 0) {
            ++n2;
            n3 = string2.indexOf("\n", n3 + 1);
        }
        if (n2 == this.numLines) {
            return;
        }
        String string3 = this.lineNumbers.getText() + "\n";
        int n4 = ("" + n2).length();
        int n5 = 0;
        int n6 = 9;
        int n7 = 2;
        while (n7 <= n4) {
            n5 += n7 * n6;
            n6 *= 10;
            ++n7;
        }
        n7 = n6 / 9;
        int n8 = string3.length();
        if ((n5 += (n4 + 1) * (n2 - n7 + 1)) < n8) {
            string = string3.substring(0, n5 - 1);
        } else {
            StringBuffer stringBuffer = new StringBuffer(n5);
            stringBuffer.append(string3);
            int n9 = this.numLines + 1;
            while (n9 < n2) {
                stringBuffer.append(n9);
                stringBuffer.append("\n");
                ++n9;
            }
            stringBuffer.append(n2);
            string = stringBuffer.toString();
        }
        this.numLines = n2;
        this.numDigits = n4;
        this.lineNumbers.setText(string);
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.updateLineNumbers();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.updateLineNumbers();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        super.undoableEditHappened(undoableEditEvent);
        if (!undoableEditEvent.getEdit().isSignificant()) {
            return;
        }
        this.updateLineNumbers();
    }

    public CodeEditor() {
        this((String)null);
    }

    public CodeEditor(String string) {
        super(string);
        int n = ((Component)this).getFontMetrics(TextEditor.MONO).stringWidth(" ");
        this.lineNumbers = new JTextArea(this, n, "1"){
            private final /* synthetic */ CodeEditor this$0;
            private final /* synthetic */ int val$fontWidth;

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = this.this$0.numDigits * this.val$fontWidth;
                return dimension;
            }
            {
                this.val$fontWidth = n;
                this.this$0 = codeEditor;
                this.constructor$0(codeEditor, string);
            }

            private final void constructor$0(CodeEditor codeEditor, String string) {
            }
        };
        this.lineNumbers.setEditable(false);
        this.numLines = 1;
        this.numDigits = 1;
        JPanel jPanel = new JPanel(this){
            private final /* synthetic */ CodeEditor this$0;

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                int n = dimension.width - 5;
                int n2 = dimension.height - 1;
                graphics.setColor(Color.gray);
                graphics.drawLine(n, 0, n, n2);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = this.this$0.lineNumbers.getPreferredSize();
                dimension.width += 10;
                return dimension;
            }
            {
                this.this$0 = codeEditor;
                this.constructor$0(codeEditor);
            }

            private final void constructor$0(CodeEditor codeEditor) {
            }
        };
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lineNumbers);
        this.setRowHeaderView(jPanel);
    }
}

