/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import visad.DataReference;
import visad.DisplayImpl;
import visad.LocalDisplay;
import visad.RemoteDisplay;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.VisADException;

public class ClientServer {
    private static final int maximumWaitTime = 60;
    private static /* synthetic */ Class class$Lvisad$RemoteDisplay;

    public static RemoteServer connectToServer(String string, String string2) throws RemoteException, VisADException {
        return ClientServer.connectToServer(string, string2, false);
    }

    public static RemoteServer connectToServer(String string, String string2, boolean bl) throws RemoteException, VisADException {
        RemoteServer remoteServer = null;
        String string3 = "//" + string + "/" + string2;
        int n = 0;
        while (remoteServer == null && n < 60) {
            if (n > 0) {
                try {
                    remoteServer = (RemoteServer)Naming.lookup(string3);
                }
                catch (NotBoundException notBoundException) {
                    remoteServer = null;
                }
                catch (ConnectException connectException) {
                    remoteServer = null;
                }
                catch (Exception exception) {
                    throw new VisADException("Cannot connect to server on \"" + string + "\" (" + exception.getClass().getName() + ": " + exception.getMessage() + ")");
                }
            }
            try {
                if (remoteServer != null) {
                    RemoteDisplay remoteDisplay = remoteServer.getDisplay(0);
                }
            }
            catch (ConnectException connectException) {
                remoteServer = null;
            }
            if (remoteServer != null) continue;
            if (bl) {
                if (n == 0) {
                    System.err.print("Client waiting for server ");
                } else {
                    System.err.print(".");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        if (n == 60) {
            if (bl) {
                System.err.println(" giving up!");
            }
            throw new VisADException("Cannot connect to " + string + ":" + string2);
        }
        if (n > 0 && bl) {
            System.err.println(" connected");
        }
        return remoteServer;
    }

    private static LocalDisplay wrapRemoteDisplay(RemoteDisplay remoteDisplay) throws RemoteException, VisADException {
        DisplayImpl displayImpl;
        Constructor<?> constructor;
        Class<?> clazz;
        String string = remoteDisplay.getDisplayClassName();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VisADException("Couldn't create " + string);
        }
        try {
            constructor = clazz.getConstructor(class$Lvisad$RemoteDisplay != null ? class$Lvisad$RemoteDisplay : (class$Lvisad$RemoteDisplay = ClientServer.class$("visad.RemoteDisplay")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new VisADException(string + " has no RemoteDisplay" + " constructor");
        }
        Object[] objectArray = new Object[]{remoteDisplay};
        try {
            displayImpl = (DisplayImpl)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof VisADException) {
                throw (VisADException)throwable;
            }
            if (throwable instanceof ConnectException) {
                throw new VisADException("Couldn't create local shadow for " + remoteDisplay + ": Connection refused");
            }
            throw new VisADException("Couldn't create local shadow for " + remoteDisplay + ": " + throwable.getClass().getName() + ": " + throwable.getMessage());
        }
        catch (Exception exception) {
            throw new VisADException("Couldn't create local shadow for " + remoteDisplay + ": " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        return displayImpl;
    }

    public static LocalDisplay getClientDisplay(RemoteServer remoteServer, int n) throws RemoteException, VisADException {
        return ClientServer.getClientDisplay(remoteServer, n, null);
    }

    public static LocalDisplay getClientDisplay(RemoteServer remoteServer, int n, DataReference[] dataReferenceArray) throws RemoteException, VisADException {
        if (remoteServer == null) {
            return null;
        }
        RemoteDisplay remoteDisplay = null;
        int n2 = 0;
        while (remoteDisplay == null && n2 < 60) {
            try {
                remoteDisplay = remoteServer.getDisplay(n);
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace();
            }
            if (remoteDisplay != null) continue;
            if (n2 == 0) {
                System.err.print("Client waiting for server display #" + n + " ");
            } else {
                System.err.print(".");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        if (remoteDisplay == null && n2 == 60) {
            System.err.println(" giving up!");
            System.exit(1);
        } else if (n2 > 0) {
            System.err.println(". ready");
        }
        if (remoteDisplay == null) {
            return null;
        }
        LocalDisplay localDisplay = ClientServer.wrapRemoteDisplay(remoteDisplay);
        if (localDisplay != null && dataReferenceArray != null) {
            localDisplay.replaceReferences(remoteDisplay, null, dataReferenceArray, null);
        }
        return localDisplay;
    }

    public static LocalDisplay[] getClientDisplays(RemoteServer remoteServer) throws RemoteException, VisADException {
        return ClientServer.getClientDisplays(remoteServer, null);
    }

    public static LocalDisplay[] getClientDisplays(RemoteServer remoteServer, DataReference[] dataReferenceArray) throws RemoteException, VisADException {
        if (remoteServer == null) {
            return null;
        }
        RemoteDisplay[] remoteDisplayArray = null;
        int n = 0;
        while (remoteDisplayArray == null && n < 60) {
            try {
                remoteDisplayArray = remoteServer.getDisplays();
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            if (remoteDisplayArray != null) continue;
            if (n == 0) {
                System.err.print("Client waiting for server displays ");
            } else {
                System.err.print(".");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        if (remoteDisplayArray == null && n == 60) {
            System.err.println(" giving up!");
            System.exit(1);
        } else if (n > 0) {
            System.err.println(". ready");
        }
        if (remoteDisplayArray == null) {
            return null;
        }
        LocalDisplay[] localDisplayArray = new LocalDisplay[remoteDisplayArray.length];
        int n2 = 0;
        while (n2 < localDisplayArray.length) {
            localDisplayArray[n2] = ClientServer.wrapRemoteDisplay(remoteDisplayArray[n2]);
            if (localDisplayArray[n2] != null && dataReferenceArray != null) {
                localDisplayArray[n2].replaceReferences(remoteDisplayArray[n2], null, dataReferenceArray, null);
            }
            ++n2;
        }
        return localDisplayArray;
    }

    public static RemoteServerImpl startServer(String string) throws RemoteException, VisADException {
        RemoteServerImpl remoteServerImpl;
        block5: {
            boolean bl;
            boolean bl2 = false;
            do {
                bl = true;
                try {
                    remoteServerImpl = new RemoteServerImpl();
                    String string2 = "///" + string;
                    Naming.rebind(string2, remoteServerImpl);
                    break block5;
                }
                catch (ConnectException connectException) {
                    if (!bl2) {
                        LocateRegistry.createRegistry(1099);
                        bl2 = true;
                        continue;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                }
            } while (bl);
            throw new VisADException("Cannot set up server (rmiregistry may not be running)");
        }
        return remoteServerImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

