/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Display;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.util.ChosenColorWidget;
import visad.util.ColorMapWidget;
import visad.util.SimpleColorMapWidget;

public class ChosenColorWidget
extends JPanel
implements ActionListener {
    ColorMapWidget wrappedWidget;
    private float[][] original;
    private JComboBox choice;

    private Component buildChoices() {
        this.choice = new JComboBox();
        this.choice.addItem(new ComboItem(null, "Original", this.original));
        this.choice.addActionListener(this);
        boolean bl = false;
        JPanel jPanel = this.wrappedWidget.getButtonPanel();
        if (jPanel != null) {
            jPanel.add(this.choice);
            bl = true;
        }
        return bl ? jPanel : this.choice;
    }

    public int getNumberOfRows() throws VisADException {
        if (this.original == null) {
            throw new VisADException("Unknown original table size");
        }
        return this.original.length;
    }

    public int getRowLength() throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        return this.original[0].length;
    }

    public void addGreyWedgeItem() throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        int n = this.original.length;
        int n2 = this.original[0].length;
        float[][] fArray = new float[n][n2];
        float f = 1.0f / ((float)n2 - 1.0f);
        float f2 = 0.0f;
        int n3 = 0;
        while (n3 < n2) {
            float f3 = f2;
            fArray[2][n3] = f3;
            fArray[1][n3] = f3;
            fArray[0][n3] = f3;
            if (n > 3) {
                fArray[3][n3] = 1.0f;
            }
            f2 += f;
            ++n3;
        }
        this.addItem("Grey Wedge", fArray);
    }

    public void addItem(String string, float[][] fArray) throws VisADException {
        if (this.original == null || this.original[0] == null) {
            throw new VisADException("Unknown original table size");
        }
        if (fArray == null) {
            throw new VisADException("Null table");
        }
        int n = fArray.length - 1;
        while (n >= 0) {
            if (fArray[n] == null || fArray[n].length != this.original[n].length) {
                throw new VisADException("Table row " + n + " should have " + this.original[n].length + " elements");
            }
            --n;
        }
        this.choice.addItem(new ComboItem(null, string, fArray));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
            ComboItem comboItem = (ComboItem)this.choice.getSelectedItem();
            try {
                this.wrappedWidget.setTable(comboItem.table);
            }
            catch (RemoteException remoteException) {
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public Dimension getMaximumSize() {
        return this.wrappedWidget.getMaximumSize();
    }

    public void setMaximumSize(Dimension dimension) {
        this.wrappedWidget.setMaximumSize(dimension);
    }

    public Dimension getMinimumSize() {
        return this.wrappedWidget.getMinimumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        this.wrappedWidget.setMinimumSize(dimension);
    }

    public Dimension getPreferredSize() {
        return this.wrappedWidget.getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        this.wrappedWidget.setPreferredSize(dimension);
    }

    public static void main(String[] stringArray) {
        try {
            RealType realType = new RealType("vis", null, null);
            ScalarMap scalarMap = new ScalarMap(realType, Display.RGBA);
            scalarMap.setRange(0.0, 1.0);
            DisplayImplJ2D displayImplJ2D = new DisplayImplJ2D("2d");
            displayImplJ2D.addMap(scalarMap);
            ChosenColorWidget chosenColorWidget = new ChosenColorWidget(scalarMap);
            chosenColorWidget.addGreyWedgeItem();
            JFrame jFrame = new JFrame("0");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(chosenColorWidget);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            chosenColorWidget = new ChosenColorWidget(new ColorMapWidget(scalarMap, null));
            int n = chosenColorWidget.getNumberOfRows();
            int n2 = chosenColorWidget.getRowLength();
            float[][] fArray = new float[n][n2];
            float f = 1.0f / ((float)n2 - 1.0f);
            float f2 = 1.0f;
            int n3 = 0;
            while (n3 < n2) {
                float f3 = f2;
                fArray[2][n3] = f3;
                fArray[1][n3] = f3;
                fArray[0][n3] = f3;
                if (n > 3) {
                    fArray[3][n3] = 1.0f;
                }
                f2 -= f;
                ++n3;
            }
            chosenColorWidget.addItem("Reverse Wedge", fArray);
            jFrame = new JFrame("1");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.getContentPane().add(chosenColorWidget);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("!Updated");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            ColorMapWidget colorMapWidget = new ColorMapWidget(scalarMap, null, false);
            jFrame.getContentPane().add(new ChosenColorWidget(colorMapWidget));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            jFrame = new JFrame("!Immediate");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            ColorMapWidget colorMapWidget2 = new ColorMapWidget(scalarMap, null, true, false);
            jFrame.getContentPane().add(new ChosenColorWidget(colorMapWidget2));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            scalarMap.setRange(-10.0, 10.0);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }

    public ChosenColorWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(new ColorMapWidget(scalarMap));
    }

    public ChosenColorWidget(ColorMapWidget colorMapWidget) {
        this.wrappedWidget = colorMapWidget;
        this.original = SimpleColorMapWidget.copy_table(this.wrappedWidget.control.getTable());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.wrappedWidget);
        this.add(this.buildChoices());
    }

    class ComboItem {
        private String name;
        private float[][] table;

        public String toString() {
            return this.name;
        }

        private ComboItem(String string, float[][] fArray) {
            this.name = string;
            this.table = fArray;
        }

        /* synthetic */ ComboItem(1 var2_2, String string, float[][] fArray) {
            this(string, fArray);
        }
    }
}

