/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.rmi.RemoteException;
import visad.BaseColorControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.VisADException;
import visad.util.ColorChangeEvent;
import visad.util.ColorMap;
import visad.util.Util;

public class BaseRGBMap
extends ColorMap
implements ControlListener,
MouseListener,
MouseMotionListener {
    public static boolean USE_COLOR_CURSORS = false;
    public static final int DEFAULT_RESOLUTION = 256;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static Cursor[] cursor = null;
    private static final Color bluish = new Color(80, 80, 255);
    private BaseColorControl ctl;
    private int valLeft = 0;
    private int valRight = 0;
    private Object mutex = new Object();
    private int state = 0;
    private int resolution = 256;
    private boolean hasAlpha;
    private Dimension preferredSize = null;
    private int oldX;
    private int oldY;
    private Object mouseMutex = new Object();
    private float updateLeft = 0.0f;
    private float updateRight = 1.0f;

    static float[][] defaultTable(int n, boolean bl) {
        int n2 = bl ? 4 : 3;
        float[][] fArray = new float[n2][n];
        return BaseColorControl.initTableVis5D(fArray);
    }

    static Cursor buildRGBACursor(int n) {
        String string;
        if (n < 0 || n > 3) {
            n = 0;
        }
        int n2 = 15;
        int n3 = 15;
        int[] nArray = new int[225];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = 0;
            ++n4;
        }
        switch (n) {
            case 0: {
                n4 = Color.red.getRGB();
                break;
            }
            case 1: {
                n4 = Color.green.getRGB();
                break;
            }
            case 2: {
                n4 = bluish.getRGB();
                break;
            }
            default: {
                n4 = Color.gray.getRGB();
                break;
            }
        }
        int n5 = 105;
        int n6 = 119;
        while (n6 >= 105) {
            nArray[n6] = n4;
            --n6;
        }
        n6 = 7;
        int n7 = 0;
        while (n7 < 15) {
            nArray[n7 * 15 + 7] = n4;
            ++n7;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(15, 15, nArray, 0, 15);
        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        Point point = new Point(image.getWidth(null) / 2, image.getHeight(null) / 2);
        switch (n) {
            case 0: {
                string = "crossRed";
                break;
            }
            case 1: {
                string = "crossGreen";
                break;
            }
            case 2: {
                string = "crossBlue";
                break;
            }
            default: {
                string = "crossAlpha";
                break;
            }
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(image, point, string);
    }

    private void buildCursors() {
        if (cursor != null) {
            return;
        }
        String string = System.getProperty("java.version");
        if (string == null) {
            return;
        }
        if (string.length() < 3) {
            return;
        }
        if (string.charAt(0) < '1') {
            return;
        }
        if (string.charAt(1) != '.') {
            return;
        }
        if (string.charAt(0) == '1' && string.charAt(2) < '3') {
            return;
        }
        cursor = new Cursor[4];
        BaseRGBMap.cursor[0] = BaseRGBMap.buildRGBACursor(0);
        BaseRGBMap.cursor[1] = BaseRGBMap.buildRGBACursor(1);
        BaseRGBMap.cursor[2] = BaseRGBMap.buildRGBACursor(2);
        BaseRGBMap.cursor[3] = BaseRGBMap.buildRGBACursor(3);
        this.setCursor(cursor[this.state]);
    }

    public void setValues(float[][] fArray) throws RemoteException, VisADException {
        if (fArray == null) {
            throw new VisADException("Can't set table to null");
        }
        if (fArray.length >= 3 && fArray.length <= 4 && fArray[0].length > 4) {
            this.hasAlpha = fArray.length > 3;
            this.resolution = fArray[0].length;
        } else if (fArray[0].length >= 3 && fArray[0].length <= 4 && fArray.length > 4) {
            this.hasAlpha = fArray[0].length > 3;
            this.resolution = fArray.length;
            float[][] fArray2 = new float[this.hasAlpha ? 4 : 3][this.resolution];
            int n = 0;
            while (n < this.resolution) {
                fArray2[0][n] = fArray[n][0];
                fArray2[1][n] = fArray[n][1];
                fArray2[2][n] = fArray[n][2];
                if (this.hasAlpha) {
                    fArray2[3][n] = fArray[n][3];
                }
                ++n;
            }
            fArray = fArray2;
        } else {
            throw new VisADException("Cannot set table with dimensions [" + fArray.length + "][" + fArray[0].length + "]");
        }
        if (this.ctl == null) {
            this.ctl = new BaseColorControl(null, this.hasAlpha ? 4 : 3);
        }
        this.ctl.setTable(fArray);
        this.sendUpdate(0, this.resolution - 1);
    }

    public int getMapResolution() {
        return this.resolution;
    }

    public int getMapDimension() {
        return this.ctl.getNumberOfComponents();
    }

    public float[][] getColorMap() {
        return this.ctl.getTable();
    }

    public float[][] getTuples(float f, float f2, int n) {
        float[][] fArray;
        int n2;
        if (n <= 0 || f > f2 || n == 1 && !Util.isApproximatelyEqual(f, f2)) {
            return null;
        }
        float f3 = f * (float)(this.resolution - 1);
        int n3 = (int)Math.floor(f3);
        f3 = f2 * (float)(this.resolution - 1);
        int n4 = (int)Math.floor(f3);
        float f4 = f3 - (float)n4;
        boolean bl = f4 != 0.0f;
        float[][] fArray2 = new float[n][this.hasAlpha ? 4 : 3];
        int n5 = n3;
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 >= this.resolution) {
            n5 = this.resolution - 1;
        }
        int n6 = n2 = bl ? n4 + 1 : n4;
        if (n2 >= this.resolution) {
            n2 = this.resolution - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        int n7 = n2 - n5 + 1;
        try {
            fArray = this.ctl.lookupRange(n5, n2);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return null;
        }
        float f5 = (f2 - f) / (float)n;
        int n8 = 0;
        while (n8 < n) {
            boolean bl2;
            float f6 = f + (float)n8 * f5;
            f3 = f6 * (float)(this.resolution - 1);
            int n9 = (int)Math.floor(f3);
            float f7 = f3 - (float)n9;
            boolean bl3 = bl2 = f7 != 0.0f;
            if ((n9 -= n5) < 0 || n9 >= n7 || n9 == n7 - 1 && bl2) {
                fArray2[n8][2] = 0.0f;
                fArray2[n8][1] = 0.0f;
                fArray2[n8][0] = 0.0f;
                if (this.hasAlpha) {
                    fArray2[n8][3] = 0.0f;
                }
            } else if (bl2) {
                fArray2[n8][0] = fArray[0][n9] * (1.0f - f7) + fArray[0][n9 + 1] * f7;
                fArray2[n8][1] = fArray[1][n9] * (1.0f - f7) + fArray[1][n9 + 1] * f7;
                fArray2[n8][2] = fArray[2][n9] * (1.0f - f7) + fArray[2][n9 + 1] * f7;
                if (this.hasAlpha) {
                    fArray2[n8][3] = fArray[3][n9] * (1.0f - f7) + fArray[3][n9 + 1] * f7;
                }
            } else {
                fArray2[n8][0] = fArray[0][n9];
                fArray2[n8][1] = fArray[1][n9];
                fArray2[n8][2] = fArray[2][n9];
                if (this.hasAlpha) {
                    fArray2[n8][3] = fArray[3][n9];
                }
            }
            ++n8;
        }
        return fArray2;
    }

    public float[] getTuple(float f) {
        float[][] fArray = this.getTuples(f, f, 1);
        return fArray == null ? null : fArray[0];
    }

    public float[][] getRGBTuples(float f, float f2, int n) {
        float[][] fArray = this.getTuples(f, f2, n);
        if (fArray[0].length > 3) {
            float[][] fArray2 = new float[fArray.length][3];
            int n2 = fArray.length - 1;
            while (n2 >= 0) {
                fArray2[n2][0] = fArray[n2][0];
                fArray2[n2][1] = fArray[n2][1];
                fArray2[n2][2] = fArray[n2][2];
                --n2;
            }
            fArray = fArray2;
        }
        return fArray;
    }

    public float[] getRGBTuple(float f) {
        float[] fArray = this.getTuple(f);
        if (fArray.length > 3) {
            float[] fArray2 = new float[]{fArray[0], fArray[1], fArray[2]};
            fArray = fArray2;
        }
        return fArray;
    }

    protected void sendUpdate(int n, int n2) {
        this.notifyListeners(new ColorChangeEvent(this, n, n2));
        if (n != 0) {
            --n;
        }
        if (n2 != this.resolution - 1) {
            ++n2;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (n < this.valLeft) {
                this.valLeft = n;
            }
            if (n2 > this.valRight) {
                this.valRight = n2;
            }
        }
        this.validate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        float[][] fArray;
        if ((mouseEvent.getModifiers() & InputEvent.BUTTON1_MASK) == 0 && mouseEvent.getModifiers() != 0) {
            return;
        }
        int n = this.getBounds().width;
        int n2 = this.getBounds().height;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= n) {
            n3 = n - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= n2) {
            n4 = n2 - 1;
        }
        float f = (float)(this.resolution - 1) / (float)n;
        int n5 = (int)Math.floor((double)((float)n3 * f) + 0.5);
        try {
            fArray = this.ctl.lookupRange(n5, n5);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        fArray[this.state][0] = 1.0f - (float)n4 / (float)n2;
        try {
            this.ctl.setRange(n5, n5, fArray);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        this.oldX = n3;
        this.oldY = n4;
        this.sendUpdate(n5, n5);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & (InputEvent.BUTTON2_MASK | InputEvent.BUTTON3_MASK)) == 0) {
            return;
        }
        this.state = (this.state + 1) % (this.hasAlpha ? 4 : 3);
        if (cursor != null) {
            this.setCursor(cursor[this.state]);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & InputEvent.BUTTON1_MASK) == 0 && mouseEvent.getModifiers() != 0) {
            return;
        }
        this.drag(mouseEvent.getX(), mouseEvent.getY(), this.oldX, this.oldY);
        this.oldX = mouseEvent.getX();
        this.oldY = mouseEvent.getY();
    }

    private void drag(int n, int n2, int n3, int n4) {
        float[][] fArray;
        int n5;
        int n6;
        int n7 = this.getBounds().width;
        int n8 = this.getBounds().height;
        if (n < 0) {
            n = 0;
        } else if (n >= n7) {
            n = n7 - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n8) {
            n2 = n8 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= n7) {
            n3 = n7 - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= n8) {
            n4 = n8 - 1;
        }
        int n9 = -1;
        int n10 = -1;
        float f = (float)(this.resolution - 1) / (float)n7;
        int n11 = (int)Math.floor((double)((float)n3 * f) + 0.5);
        int n12 = (int)Math.floor((double)((float)n * f) + 0.5);
        float f2 = 1.0f - (float)n4 / (float)n8;
        float f3 = 1.0f - (float)n2 / (float)n8;
        if (n12 > n11) {
            n6 = n11;
            n5 = n12;
        } else {
            n6 = n12;
            n5 = n11;
        }
        try {
            fArray = this.ctl.lookupRange(n6, n5);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        if (n == n3) {
            fArray[this.state][0] = f3;
            n9 = n10 = n12;
        } else {
            int n13;
            float f4;
            float f5;
            if (n12 > n11) {
                f5 = f3;
                f4 = f2;
                n13 = 1;
            } else {
                f5 = f2;
                f4 = f3;
                n13 = 0;
            }
            int n14 = n5 - n6;
            int n15 = n13;
            while (n15 < n14 + n13) {
                float f6;
                fArray[this.state][n15] = f6 = (f4 * (float)(n14 - n15) + f5 * (float)n15) / (float)n14;
                ++n15;
            }
            n9 = n6 + n13;
            n10 = n5 + (1 - n13);
        }
        try {
            this.ctl.setRange(n6, n5, fArray);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            return;
        }
        if (n9 > -1 && n10 > -1) {
            this.sendUpdate(n9, n10);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Object object = this.mutex;
        synchronized (object) {
            this.valLeft = 0;
            this.valRight = this.resolution - 1;
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        float[][] fArray;
        int n = this.resolution - 1;
        int n2 = 0;
        int n3 = n;
        Object object = this.mutex;
        synchronized (object) {
            if (this.valLeft > this.valRight) {
                Object var6_6 = null;
                return;
            }
            n2 = this.valLeft;
            n3 = this.valRight;
            this.valLeft = n;
            this.valRight = 0;
        }
        int n4 = this.ctl.getNumberOfColors() - 1;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > 0) {
            --n2;
        }
        if (n3 < n) {
            ++n3;
        }
        int n5 = this.getBounds().width - 1;
        int n6 = this.getBounds().height - 1;
        int n7 = n2 * n5 / n;
        int n8 = n3 * n5 / n;
        graphics.setColor(Color.black);
        graphics.fillRect(n7, 0, n8 - n7 + 1, n6 + 1);
        if (n2 > 0) {
            --n2;
        }
        if (n3 < n) {
            ++n3;
        }
        n7 = n2 * n5 / n;
        n8 = n3 * n5 / n;
        try {
            fArray = this.ctl.lookupRange(n2, n3 < n ? n3 + 1 : n);
        }
        catch (Exception exception) {
            System.err.println("Error in " + this.getClass().getName() + ": " + exception.getClass().getName() + ": " + exception.getMessage());
            fArray = null;
        }
        if (fArray == null) {
            return;
        }
        int n9 = n7;
        int n10 = (int)Math.floor((1.0f - fArray[0][0]) * (float)n6);
        int n11 = (int)Math.floor((1.0f - fArray[1][0]) * (float)n6);
        int n12 = (int)Math.floor((1.0f - fArray[2][0]) * (float)n6);
        int n13 = this.hasAlpha ? (int)Math.floor((1.0f - fArray[3][0]) * (float)n6) : 0;
        int n14 = 0;
        int n15 = 1;
        while (n15 < fArray[0].length) {
            int n16 = (n2 + n15) * n5 / n;
            int n17 = (int)Math.floor((1.0f - fArray[0][n15]) * (float)n6);
            int n18 = (int)Math.floor((1.0f - fArray[1][n15]) * (float)n6);
            int n19 = (int)Math.floor((1.0f - fArray[2][n15]) * (float)n6);
            if (this.hasAlpha) {
                n14 = (int)Math.floor((1.0f - fArray[3][n15]) * (float)n6);
            }
            graphics.setColor(Color.red);
            graphics.drawLine(n9, n10, n16, n17);
            graphics.setColor(Color.green);
            graphics.drawLine(n9, n11, n16, n18);
            graphics.setColor(bluish);
            graphics.drawLine(n9, n12, n16, n19);
            if (this.hasAlpha) {
                graphics.setColor(Color.gray);
                graphics.drawLine(n9, n13, n16, n14);
            }
            n9 = n16;
            n10 = n17;
            n11 = n18;
            n12 = n19;
            if (this.hasAlpha) {
                n13 = n14;
            }
            ++n15;
        }
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            int n = 170;
            this.preferredSize = new Dimension(this.resolution, 170);
        }
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void controlChanged(ControlEvent controlEvent) throws RemoteException, VisADException {
        this.hasAlpha = this.ctl.getNumberOfComponents() == 4;
        this.resolution = this.ctl.getNumberOfColors();
        this.sendUpdate(0, this.getMapResolution() - 1);
    }

    public BaseRGBMap(boolean bl) throws RemoteException, VisADException {
        this(BaseRGBMap.defaultTable(256, bl));
    }

    public BaseRGBMap(int n, boolean bl) throws RemoteException, VisADException {
        this(BaseRGBMap.defaultTable(n, bl));
    }

    public BaseRGBMap(float[][] fArray, boolean bl) throws RemoteException, VisADException {
        this(fArray != null ? fArray : BaseRGBMap.defaultTable(256, bl));
    }

    public BaseRGBMap(float[][] fArray) throws RemoteException, VisADException {
        if (fArray == null) {
            fArray = BaseRGBMap.defaultTable(256, true);
        }
        this.setValues(fArray);
        if (USE_COLOR_CURSORS) {
            this.buildCursors();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ctl.addControlListener(this);
    }

    public BaseRGBMap(BaseColorControl baseColorControl) {
        this.ctl = baseColorControl;
        this.hasAlpha = baseColorControl.getNumberOfComponents() == 4;
        this.resolution = baseColorControl.getNumberOfColors();
        if (USE_COLOR_CURSORS) {
            this.buildCursors();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        baseColorControl.addControlListener(this);
    }
}

