/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.util.Slider;
import visad.util.SliderChangeEvent;

public class BarSlider
extends Slider
implements MouseListener,
MouseMotionListener {
    private float upper;
    private float lower;
    private float val;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private int oldxval;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Visad Bar Slider");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        BarSlider barSlider = new BarSlider();
        jFrame.add(barSlider);
        ((Component)jFrame).setSize(barSlider.getPreferredSize());
        ((Component)jFrame).setVisible(true);
    }

    public float getMinimum() {
        return this.lower;
    }

    public synchronized void setMinimum(float f) {
        if (f > this.val || f == this.val && f == this.upper) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new minimum value greater than the current value");
        }
        this.lower = f;
        this.notifyListeners(new SliderChangeEvent(2, f));
        this.repaint();
    }

    public float getMaximum() {
        return this.upper;
    }

    public synchronized void setMaximum(float f) {
        if (f < this.val || f == this.val && f == this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new maximum value less than the current value");
        }
        this.upper = f;
        this.notifyListeners(new SliderChangeEvent(3, f));
        this.repaint();
    }

    public float getValue() {
        return this.val;
    }

    public synchronized void setValue(float f) {
        if (f > this.upper || f < this.lower) {
            throw new IllegalArgumentException("BarSlider: Attemped to set new value out of slider range");
        }
        this.val = f;
        this.notifyListeners(new SliderChangeEvent(1, f));
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 16);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 16);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(40, 16);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updatePosition(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updatePosition(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void updatePosition(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0) {
            n = 0;
        }
        if (n >= this.getBounds().width) {
            n = this.getBounds().width - 1;
        }
        float f = (float)n / (float)(this.getBounds().width - 1);
        this.setValue(this.lower + f * (this.upper - this.lower));
    }

    public void update(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(this.oldxval - 2, 0, 5, this.getBounds().height - 1);
        graphics.setColor(Color.gray);
        graphics.fillRect(this.oldxval - 2, this.getBounds().height / 2 - 1, 6, 3);
        graphics.setColor(Color.white);
        int n = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        graphics.drawRect(n - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = n;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics.setColor(Color.gray);
        graphics.fillRect(0, this.getBounds().height / 2 - 1, this.getBounds().width, 3);
        graphics.setColor(Color.white);
        int n = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        graphics.drawRect(n - 2, 0, 5, this.getBounds().height - 1);
        this.oldxval = n;
    }

    public BarSlider() {
        this(-1.0f, 1.0f, 0.0f);
    }

    public BarSlider(float f, float f2, float f3) {
        if (f > f3) {
            throw new IllegalArgumentException("BarSlider: lower bound is greater than initial value");
        }
        if (f3 > f2) {
            throw new IllegalArgumentException("BarSlider: initial value is greater than the upper bound");
        }
        this.upper = f2;
        this.lower = f;
        this.val = f3;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

