/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import visad.util.Slider;
import visad.util.SliderChangeEvent;

public class ArrowSlider
extends Slider
implements MouseListener,
MouseMotionListener {
    private float upper;
    private float lower;
    private float val;
    Dimension minSize = null;
    Dimension prefSize = null;
    Dimension maxSize = null;
    private Object lock = new Object();
    private int oldxval;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Visad Arrow Slider");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        ArrowSlider arrowSlider = new ArrowSlider();
        jFrame.getContentPane().add(arrowSlider);
        ((Component)jFrame).setSize(arrowSlider.getPreferredSize());
        ((Component)jFrame).setVisible(true);
    }

    public void setBounds(float f, float f2, float f3) {
        Object object = this.lock;
        synchronized (object) {
            if (f > f2) {
                throw new IllegalArgumentException("ArrowSlider: min cannot be greater than max");
            }
            if (f3 < f || f3 > f2) {
                throw new IllegalArgumentException("ArrowSlider: initial value must be between min and max");
            }
            this.lower = f;
            this.upper = f2;
            this.val = f3;
        }
        this.notifyListeners(new SliderChangeEvent(2, f));
        this.notifyListeners(new SliderChangeEvent(3, f2));
        this.notifyListeners(new SliderChangeEvent(1, f3));
        this.validate();
        this.repaint();
    }

    public float getMinimum() {
        return this.lower;
    }

    public void setMinimum(float f) {
        Object object = this.lock;
        synchronized (object) {
            if (f > this.val || f == this.val && f == this.upper) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new minimum value greater than the current value");
            }
            this.lower = f;
        }
        this.notifyListeners(new SliderChangeEvent(2, f));
        this.validate();
        this.repaint();
    }

    public float getMaximum() {
        return this.upper;
    }

    public void setMaximum(float f) {
        Object object = this.lock;
        synchronized (object) {
            if (f < this.val || f == this.val && f == this.lower) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new maximum value less than the current value");
            }
            this.upper = f;
        }
        this.notifyListeners(new SliderChangeEvent(3, f));
        this.validate();
        this.repaint();
    }

    public float getValue() {
        return this.val;
    }

    public void setValue(float f) {
        Object object = this.lock;
        synchronized (object) {
            if (f > this.upper || f < this.lower) {
                throw new IllegalArgumentException("ArrowSlider: Attemped to set new value out of slider range");
            }
            this.val = f;
        }
        this.notifyListeners(new SliderChangeEvent(1, f));
        this.validate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension(256, 16);
        }
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public Dimension getMaximumSize() {
        if (this.maxSize == null) {
            this.maxSize = new Dimension(Integer.MAX_VALUE, 16);
        }
        return this.maxSize;
    }

    public void setMaximumSize(Dimension dimension) {
        this.maxSize = dimension;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension(40, 16);
        }
        return this.minSize;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minSize = dimension;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updatePosition(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updatePosition(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void updatePosition(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (n < 0) {
            n = 0;
        }
        if (n >= this.getBounds().width) {
            n = this.getBounds().width - 1;
        }
        float f = (float)n / (float)(this.getBounds().width - 1);
        this.setValue(this.lower + f * (this.upper - this.lower));
    }

    public void update(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(this.oldxval, 0, this.oldxval, this.getBounds().height - 1);
        graphics.drawLine(this.oldxval, 0, this.oldxval - 4, 4);
        graphics.drawLine(this.oldxval, 0, this.oldxval + 4, 4);
        graphics.setColor(Color.white);
        int n = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        graphics.drawLine(n, 0, n, this.getBounds().height - 1);
        graphics.drawLine(n, 0, n - 4, 4);
        graphics.drawLine(n, 0, n + 4, 4);
        this.oldxval = n;
    }

    public void paint(Graphics graphics) {
        if (this.val != this.val || this.lower != this.lower || this.upper != this.upper) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics.setColor(Color.white);
        int n = (int)Math.floor((this.val - this.lower) * (float)(this.getBounds().width - 1) / (this.upper - this.lower));
        graphics.drawLine(n, 0, n, this.getBounds().height - 1);
        graphics.drawLine(n, 0, n - 4, 4);
        graphics.drawLine(n, 0, n + 4, 4);
        this.oldxval = n;
    }

    public ArrowSlider() {
        this(-1.0f, 1.0f, 0.0f);
    }

    public ArrowSlider(float f, float f2, float f3) {
        this(f, f2, f3, "value");
    }

    public ArrowSlider(float f, float f2, float f3, String string) {
        if (f > f3) {
            throw new IllegalArgumentException("ArrowSlider: lower bound is greater than initial value");
        }
        if (f3 > f2) {
            throw new IllegalArgumentException("ArrowSlider: initial value is greater than the upper bound");
        }
        this.upper = f2;
        this.lower = f;
        this.val = f3;
        this.name = string;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

