/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Display;
import visad.DisplayException;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.VisADException;

public class AnimationWidget
extends JPanel
implements ActionListener,
ChangeListener,
ControlListener,
ScalarMapListener {
    private static final boolean DEBUG = false;
    private boolean aDir;
    private boolean aAnim;
    private int aMs;
    private JRadioButton forward;
    private JRadioButton reverse;
    private JButton onOff;
    private JButton step;
    private JTextField ms;
    private JSlider TimeSlider;
    private AnimationControl control;

    private void getControlSettings(AnimationControl animationControl) {
        this.control = animationControl;
        if (this.control != null) {
            this.aDir = this.control.getDirection();
            this.aAnim = this.control.getOn();
            this.aMs = (int)this.control.getStep();
        }
    }

    private void fixAnimUI() {
        if (this.aAnim) {
            this.onOff.setText("Stop");
            this.step.setEnabled(false);
        } else {
            this.onOff.setText("Go");
            this.step.setEnabled(true);
        }
    }

    private void fixDirUI() {
        if (this.aDir) {
            this.forward.setSelected(true);
        } else {
            this.reverse.setSelected(true);
        }
    }

    private void fixSpeedUI() {
        this.ms.setText(Integer.toString(this.aMs));
    }

    private void fixSliderUI() {
        int n = 1;
        int n2 = 1;
        if (this.control != null) {
            try {
                Set set = this.control.getSet();
                if (set != null) {
                    n = set.getLength();
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            n2 = this.control.getCurrent() + 1;
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > n) {
                n2 = n;
            }
        }
        this.TimeSlider.setMaximum(n);
        this.TimeSlider.setMinimum(1);
        this.TimeSlider.setValue(n2);
        int n3 = n < 20 ? n / 4 : (n < 30 ? n / 6 : n / 8);
        this.TimeSlider.setMajorTickSpacing(n3);
        this.TimeSlider.setMinorTickSpacing(n3 / 4);
        this.TimeSlider.setPaintLabels(true);
    }

    private void fixControlUI() {
        this.fixAnimUI();
        this.fixDirUI();
        this.fixSpeedUI();
        this.fixSliderUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.control == null) {
            System.out.println("control == null in AnimationWidget.actionPerformed");
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("forward")) {
            try {
                this.control.setDirection(true);
                this.aDir = true;
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("reverse")) {
            try {
                this.control.setDirection(false);
                this.aDir = false;
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("ms") || string.equals("go") && !this.aAnim) {
            int n = -1;
            try {
                n = Integer.parseInt(this.ms.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n > 0) {
                try {
                    this.control.setStep(n);
                    this.aMs = n;
                    if (this.aDir) {
                        this.forward.requestFocus();
                    } else {
                        this.reverse.requestFocus();
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.fixSpeedUI();
        }
        if (string.equals("go")) {
            try {
                this.control.setOn(!this.aAnim);
                this.aAnim = !this.aAnim;
                this.fixAnimUI();
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("step")) {
            try {
                this.control.takeStep();
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            if (this.control != null) {
                this.control.setCurrent(this.TimeSlider.getValue() - 1);
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void controlChanged(ControlEvent controlEvent) {
        if (this.control != null) {
            this.TimeSlider.setValue(this.control.getCurrent() + 1);
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) {
        this.fixSliderUI();
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        int n = scalarMapControlEvent.getId();
        if (n == 4 || n == 5) {
            scalarMapControlEvent.getControl().removeControlListener(this);
            if (n == 4) {
                this.control = null;
            }
        }
        if (n == 5 || n == 3) {
            this.control = (AnimationControl)((Object)scalarMapControlEvent.getScalarMap().getControl());
            this.getControlSettings((AnimationControl)((Object)scalarMapControlEvent.getScalarMap().getControl()));
            this.fixControlUI();
            if (this.control != null) {
                this.control.addControlListener(this);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, dimension.height + 18);
    }

    public AnimationWidget(ScalarMap scalarMap) throws VisADException, RemoteException {
        this(scalarMap, -1);
    }

    public AnimationWidget(ScalarMap scalarMap, int n) throws VisADException, RemoteException {
        if (!Display.Animation.equals(scalarMap.getDisplayScalar())) {
            throw new DisplayException("AnimationWidget: ScalarMap must be to Display.Animation");
        }
        this.aAnim = false;
        this.aDir = true;
        this.aMs = n;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.forward = new JRadioButton("Forward", this.aDir);
        this.reverse = new JRadioButton("Reverse", !this.aDir);
        this.onOff = new JButton("Stop");
        this.step = new JButton("Step");
        this.ms = new JTextField("????????");
        Dimension dimension = this.ms.getMaximumSize();
        Dimension dimension2 = this.ms.getPreferredSize();
        dimension.height = dimension2.height;
        this.ms.setMaximumSize(dimension);
        JLabel jLabel = new JLabel("ms/frame");
        this.TimeSlider = new JSlider(1, 1, 1);
        Color color = jLabel.getForeground();
        this.forward.setForeground(color);
        this.reverse.setForeground(color);
        this.onOff.setForeground(color);
        this.step.setForeground(color);
        this.ms.setForeground(color);
        this.TimeSlider.setPaintTicks(true);
        this.onOff.setMaximumSize(this.step.getMaximumSize());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.forward);
        buttonGroup.add(this.reverse);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.5f);
        jPanel4.setAlignmentY(0.0f);
        this.onOff.setAlignmentX(0.5f);
        this.step.setAlignmentX(0.5f);
        this.ms.setAlignmentY(0.5f);
        jLabel.setAlignmentX(0.5f);
        jPanel3.add(this.forward);
        jPanel3.add(this.reverse);
        jPanel4.add(this.onOff);
        jPanel4.add(this.step);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        this.add(jPanel);
        jPanel2.add(this.ms);
        jPanel2.add(jLabel);
        this.add(jPanel2);
        this.add(this.TimeSlider);
        this.getControlSettings((AnimationControl)((Object)scalarMap.getControl()));
        if (n > 0) {
            this.aMs = n;
            if (this.control != null) {
                this.control.setStep(this.aMs);
            }
        }
        this.fixControlUI();
        if (this.control != null) {
            this.control.addControlListener(this);
        }
        scalarMap.addScalarMapListener(this);
        this.forward.addActionListener(this);
        this.forward.setActionCommand("forward");
        this.reverse.addActionListener(this);
        this.reverse.setActionCommand("reverse");
        this.onOff.addActionListener(this);
        this.onOff.setActionCommand("go");
        this.step.addActionListener(this);
        this.step.setActionCommand("step");
        this.ms.addActionListener(this);
        this.ms.setActionCommand("ms");
        this.TimeSlider.addChangeListener(this);
    }
}

