/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.util.Calendar;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import visad.CellImpl;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RemoteActionImpl;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.Scalar;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.VisADException;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.tiff.TiffForm;
import visad.data.visad.VisADForm;
import visad.formula.FormulaManager;
import visad.formula.FormulaVar;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.ss.MappingDialog;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellListener;
import visad.ss.SSLayout;
import visad.ss.SpreadSheet;
import visad.util.ExtensionFileFilter;
import visad.util.GUIFrame;
import visad.util.Util;

public class SpreadSheet
extends GUIFrame
implements AdjustmentListener,
DisplayListener,
KeyListener,
ItemListener,
MouseListener,
MouseMotionListener,
SSCellListener {
    protected static final int WIDTH_PERCENT = 60;
    protected static final int HEIGHT_PERCENT = 80;
    protected static final int MIN_VIS_WIDTH = 120;
    protected static final int MIN_VIS_HEIGHT = 120;
    protected static final int DEFAULT_VIS_WIDTH = 250;
    protected static final int DEFAULT_VIS_HEIGHT = 250;
    protected static final String Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final int LABEL_WIDTH = 30;
    protected static final int LABEL_HEIGHT = 20;
    protected static final boolean SHOW_CONNECT_MESSAGES = true;
    protected static final String SSFileHeader = "# VisAD Visualization SpreadSheet spreadsheet file";
    protected static final Class[] cellArgs = new Class[]{class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SpreadSheet.class$("java.lang.String")), class$Lvisad$formula$FormulaManager != null ? class$Lvisad$formula$FormulaManager : (class$Lvisad$formula$FormulaManager = SpreadSheet.class$("visad.formula.FormulaManager")), class$Lvisad$RemoteServer != null ? class$Lvisad$RemoteServer : (class$Lvisad$RemoteServer = SpreadSheet.class$("visad.RemoteServer")), Boolean.TYPE, class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SpreadSheet.class$("java.lang.String")), class$Ljava$awt$Frame != null ? class$Ljava$awt$Frame : (class$Ljava$awt$Frame = SpreadSheet.class$("java.awt.Frame"))};
    protected static Constructor cellConstructor;
    protected static boolean Possible3D;
    protected static boolean CanDo3D;
    protected static boolean CanDoHDF5;
    protected static boolean CanDoJPEG;
    protected static boolean CanDoPython;
    protected static boolean BugFix;
    private static double[] matrix3D;
    private static double[] matrix2D;
    private static double[] matrixJ2D;
    protected JFileChooser SSFileDialog;
    protected String bTitle;
    protected int NumVisX;
    protected int NumVisY;
    protected FormulaManager fm;
    protected String serverName;
    protected String cloneAddress;
    protected RemoteServerImpl rsi = null;
    protected boolean IsRemote = false;
    protected boolean IsSlave = false;
    protected double CollabID = 0.0;
    protected RemoteDataReference RemoteColRow;
    protected RemoteDataReference RemoteCanDo3D;
    protected boolean AutoSwitch = true;
    protected boolean AutoDetect = true;
    protected boolean AutoShowControls = true;
    protected Panel DisplayPanel;
    protected JPanel ScrollPanel;
    protected ScrollPane SCPane;
    protected JViewport HorizLabels;
    protected JViewport VertLabels;
    protected JPanel[] HorizLabel;
    protected JPanel[] VertLabel;
    protected JComponent[] HorizDrag;
    protected JComponent[] VertDrag;
    protected JPanel HorizPanel;
    protected JPanel VertPanel;
    protected FancySSCell[][] DisplayCells = null;
    protected JComboBox FormulaBox;
    protected ComboBoxEditor FormulaEditor;
    protected JTextField FormulaText;
    protected ActionListener FormulaListener;
    protected JToolBar Toolbar;
    protected JMenuItem FileSave1;
    protected JMenuItem FileSave2;
    protected JMenuItem FileSave3;
    protected JMenuItem FileSave4;
    protected JMenuItem FileSnap;
    protected JMenuItem EditPaste;
    protected JMenuItem EditClear;
    protected JMenuItem CellDel;
    protected JMenuItem CellPrint;
    protected JMenuItem CellEdit;
    protected JMenuItem CellReset;
    protected JMenuItem CellShow;
    protected JMenuItem LayAddCol;
    protected JMenuItem LayDelCol;
    protected JMenuItem LayDelRow;
    protected JCheckBoxMenuItem CellDim3D3D;
    protected JCheckBoxMenuItem CellDim2D2D;
    protected JCheckBoxMenuItem CellDim2D3D;
    protected JCheckBoxMenuItem AutoSwitchBox;
    protected JCheckBoxMenuItem AutoDetectBox;
    protected JCheckBoxMenuItem AutoShowBox;
    protected JButton ToolSave;
    protected JButton ToolPaste;
    protected JButton Tool3D;
    protected JButton Tool2D;
    protected JButton ToolJ2D;
    protected JButton ToolMap;
    protected JButton ToolShow;
    protected JButton ToolReset;
    protected JButton FormulaAdd;
    protected JButton FormulaDel;
    protected int CurX = 0;
    protected int CurY = 0;
    protected String Clipboard = null;
    protected File CurrentFile = null;
    protected Object Lock = new Object();
    private boolean commandKey;
    private boolean shiftHeld;
    private int oldX;
    private int oldY;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lvisad$formula$FormulaManager;
    private static /* synthetic */ Class class$Lvisad$RemoteServer;
    private static /* synthetic */ Class class$Ljava$awt$Frame;
    private static /* synthetic */ Class class$Lvisad$ss$FancySSCell;
    private static /* synthetic */ Class class$Lvisad$ss$SpreadSheet;

    public static void snooze(long l) {
        block2: {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                if (!BasicSSCell.DEBUG) break block2;
                interruptedException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "\nUsage: java [-mx###m] visad.ss.SpreadSheet [cols rows]\n       [-file filename] [-gui] [-no3d] [-debug] [-bugfix]\n       [-server name] [-client address] [-slave address]\n\n###\n     Maximum megabytes of memory to use.\ncols\n     Number of columns in this SpreadSheet.\nrows\n     Number of rows in this SpreadSheet.\n-file filename\n     Load the given filename at launch. If file is a\n     spreadsheet file, the layout is configured accordingly.\n     If file is data, it is loaded into cell A1.\n-gui\n     Pop up an options window so that the user can\n     select SpreadSheet settings graphically.\n-no3d\n     Disable Java3D.\n-debug\n     Print stack traces for all errors.\n-bugfix\n     Disable toolbar. For some systems, will prevent\n     lockups on spreadsheet start.\n-server name\n     Initialize this SpreadSheet as an RMI server\n     with the given name.\n-client address\n     Initialize this SpreadSheet as a clone of\n     the server at the given RMI address.\n-slave address\n     Initialize this SpreadSheet as a slaved clone\n     of the server at the given RMI address.";
        int n = 2;
        int n2 = 2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n3 = stringArray.length;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n3) {
                if (stringArray[n4].charAt(0) == '-') {
                    if (stringArray[n4].equals("-file")) {
                        if (n4 < n3 - 1) {
                            string2 = stringArray[++n4];
                        }
                    } else if (stringArray[n4].equals("-server")) {
                        if (string4 != null) {
                            System.out.println("A spreadsheet cannot be both a server and a clone!");
                            System.out.println(string);
                            System.exit(3);
                        } else if (n4 < n3 - 1) {
                            string3 = stringArray[++n4];
                        } else {
                            System.out.println("You must specify a server name after the '-server' flag!");
                            System.out.println(string);
                            System.exit(4);
                        }
                    } else if (stringArray[n4].equals("-client") || stringArray[n4].equals("-slave")) {
                        if (string3 != null) {
                            System.out.println("A spreadsheet cannot be both a server and a clone!");
                            System.out.println(string);
                            System.exit(3);
                        } else if (n4 < n3 - 1) {
                            string4 = stringArray[n4 + 1];
                            if (stringArray[n4].equals("-slave")) {
                                string4 = "slave:" + string4;
                            }
                            ++n4;
                        } else {
                            System.out.println("You must specify a server after the '" + stringArray[n4] + "' flag!");
                            System.out.println(string);
                            System.exit(5);
                        }
                    } else if (stringArray[n4].equals("-gui")) {
                        bl = true;
                    } else if (stringArray[n4].equals("-bugfix")) {
                        BugFix = true;
                    } else if (stringArray[n4].equals("-no3d")) {
                        BasicSSCell.disable3D();
                    } else if (stringArray[n4].equals("-debug")) {
                        BasicSSCell.DEBUG = true;
                        FormulaVar.DEBUG = true;
                    } else {
                        if (!stringArray[n4].equals("-help")) {
                            System.out.println("Unknown option: " + stringArray[n4]);
                        }
                        System.out.println(string);
                        System.exit(1);
                    }
                } else {
                    boolean bl2 = true;
                    if (n4 < n3 - 1) {
                        try {
                            n = Integer.parseInt(stringArray[n4]);
                            n2 = Integer.parseInt(stringArray[n4 + 1]);
                            ++n4;
                            if (n2 < 1 || n < 1 || n > Letters.length()) {
                                bl2 = false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = false;
                        }
                        if (!bl2) {
                            System.out.println("Invalid number of columns and rows: " + stringArray[n4] + " x " + stringArray[n4 + 1]);
                            System.out.println(string);
                            System.exit(2);
                        }
                    } else {
                        System.out.println("Unknown option: " + stringArray[n4]);
                        System.out.println(string);
                        System.exit(1);
                    }
                }
                ++n4;
            }
        }
        SpreadSheet spreadSheet = new SpreadSheet(60, 80, n, n2, string3, string4, "VisAD SpreadSheet", null, bl);
        if (string2 != null) {
            File file = new File(string2);
            String string5 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                string5 = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                if (BasicSSCell.DEBUG) {
                    iOException.printStackTrace();
                }
                System.out.println("Could not read file " + string2);
            }
            if (string5 != null) {
                boolean bl3 = string5.equals(SSFileHeader);
                String string6 = string2;
                BasicSSCell.invoke(false, new Runnable(string6, bl3, spreadSheet){
                    private final /* synthetic */ String val$filename;
                    private final /* synthetic */ boolean val$ssfile;
                    private final /* synthetic */ SpreadSheet val$ss;

                    public void run() {
                        try {
                            if (this.val$ssfile) {
                                this.val$ss.openFile(this.val$filename);
                            } else {
                                this.val$ss.DisplayCells[0][0].addDataSource(this.val$filename);
                            }
                        }
                        catch (Exception exception) {
                            if (BasicSSCell.DEBUG) {
                                exception.printStackTrace();
                            }
                            System.out.println("Could not load file " + this.val$filename + " into the SpreadSheet");
                        }
                    }
                    {
                        this.val$filename = string;
                        this.val$ssfile = bl;
                        this.val$ss = spreadSheet;
                        this.constructor$0();
                    }

                    private final void constructor$0() {
                    }
                });
            }
        }
    }

    public void loadDataSet() {
        this.DisplayCells[this.CurX][this.CurY].loadDataDialog();
    }

    public void exportDataSetNetcdf() {
        try {
            this.exportDataSet(new Plain());
        }
        catch (VisADException visADException) {
            if (BasicSSCell.DEBUG) {
                visADException.printStackTrace();
            }
            this.displayErrorMessage("Error initializing netCDF export", visADException, "VisAD SpreadSheet error");
        }
    }

    public void exportDataSetSerial() {
        this.exportDataSet(new VisADForm());
    }

    public void exportDataSetHDF5() {
        Form form = null;
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> clazz = classLoader.loadClass("visad.data.hdf5.HDF5Form");
            form = (Form)clazz.newInstance();
        }
        catch (Exception exception) {
            if (BasicSSCell.DEBUG) {
                exception.printStackTrace();
            }
            this.displayErrorMessage("Error initializing HDF-5 export", exception, "VisAD SpreadSheet error");
        }
        if (form != null) {
            this.exportDataSet(form);
        }
    }

    public void exportDataSetTIFF() {
        this.exportDataSet(new TiffForm());
    }

    public void exportDataSet(Form form) {
        String string = (String)this.FormulaBox.getSelectedItem();
        String string2 = string.substring(0, string.indexOf(":"));
        this.DisplayCells[this.CurX][this.CurY].saveDataDialog(string2, form);
    }

    public void captureImageJPEG() {
        this.DisplayCells[this.CurX][this.CurY].captureDialog();
    }

    public void quitProgram() {
        try {
            this.DisplayCells[this.CurX][this.CurY].hideWidgetFrame();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((Component)this).setVisible(false);
        Thread thread = new Thread(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                Object object;
                boolean bl = BasicSSCell.isSaving();
                JFrame jFrame = null;
                if (bl) {
                    jFrame = new JFrame("Please wait");
                    ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(3));
                    object = new JPanel();
                    jFrame.setContentPane((Container)object);
                    ((JComponent)object).setBorder(new EmptyBorder(10, 20, 10, 20));
                    ((Container)object).setLayout(new BorderLayout());
                    ((Container)object).add("Center", new JLabel("Please wait while the VisAD SpreadSheet finishes saving files..."));
                    jFrame.setResizable(false);
                    jFrame.pack();
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension dimension2 = jFrame.getSize();
                    ((Component)jFrame).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
                    ((Component)jFrame).setVisible(true);
                }
                while (BasicSSCell.isSaving()) {
                    SpreadSheet.snooze(200L);
                }
                if (bl) {
                    ((Component)jFrame).setCursor(Cursor.getDefaultCursor());
                    ((Component)jFrame).setVisible(false);
                }
                object = new boolean[this.this$0.NumVisX][this.this$0.NumVisY];
                int n = 0;
                while (n < this.this$0.NumVisY) {
                    int n2 = 0;
                    while (n2 < this.this$0.NumVisX) {
                        object[n2][n] = true;
                        ++n2;
                    }
                    ++n;
                }
                n = this.this$0.NumVisX * this.this$0.NumVisY;
                while (n > 0) {
                    int n3 = 0;
                    while (n3 < this.this$0.NumVisY) {
                        int n4 = 0;
                        while (n4 < this.this$0.NumVisX) {
                            if (object[n4][n3] != false && !this.this$0.DisplayCells[n4][n3].othersDepend()) {
                                try {
                                    this.this$0.DisplayCells[n4][n3].destroyCell();
                                    object[n4][n3] = false;
                                    --n;
                                }
                                catch (VisADException visADException) {
                                    if (BasicSSCell.DEBUG) {
                                        visADException.printStackTrace();
                                    }
                                    this.this$0.displayErrorMessage("Cannot destroy cell (1)", visADException, "VisAD SpreadSheet error");
                                }
                                catch (RemoteException remoteException) {
                                    if (BasicSSCell.DEBUG) {
                                        remoteException.printStackTrace();
                                    }
                                    this.this$0.displayErrorMessage("Cannot destroy cell (2)", remoteException, "VisAD SpreadSheet error");
                                }
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                System.exit(0);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        thread.start();
    }

    public void cutCell() {
        if (this.DisplayCells[this.CurX][this.CurY].confirmClear()) {
            this.copyCell();
            this.clearCell(false);
        }
    }

    public void copyCell() {
        this.Clipboard = this.DisplayCells[this.CurX][this.CurY].getSaveString();
        this.EditPaste.setEnabled(true);
        if (!BugFix) {
            this.ToolPaste.setEnabled(true);
        }
    }

    public void pasteCell() {
        if (this.Clipboard != null) {
            try {
                boolean bl = this.DisplayCells[this.CurX][this.CurY].getAutoDetect();
                this.DisplayCells[this.CurX][this.CurY].setAutoDetect(false);
                this.DisplayCells[this.CurX][this.CurY].setSaveString(this.Clipboard);
                this.DisplayCells[this.CurX][this.CurY].setAutoDetect(bl);
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                this.displayErrorMessage("Cannot paste cell", visADException, "VisAD SpreadSheet error");
            }
            catch (RemoteException remoteException) {
                if (BasicSSCell.DEBUG) {
                    remoteException.printStackTrace();
                }
                this.displayErrorMessage("Cannot paste cell", remoteException, "VisAD SpreadSheet error");
            }
        }
    }

    public void clearCell() {
        this.clearCell(true);
    }

    protected void clearCell(boolean bl) {
        try {
            if (bl) {
                this.DisplayCells[this.CurX][this.CurY].smartClear();
            } else {
                this.DisplayCells[this.CurX][this.CurY].clearCell();
            }
        }
        catch (VisADException visADException) {
            if (BasicSSCell.DEBUG) {
                visADException.printStackTrace();
            }
            this.displayErrorMessage("Cannot clear display mappings", visADException, "VisAD SpreadSheet error");
        }
        catch (RemoteException remoteException) {
            if (BasicSSCell.DEBUG) {
                remoteException.printStackTrace();
            }
            this.displayErrorMessage("Cannot clear display mappings", remoteException, "VisAD SpreadSheet error");
        }
        this.refreshFormulaBar();
        this.refreshMenuCommands();
    }

    public boolean newFile() {
        return this.newFile(true);
    }

    protected boolean newFile(boolean bl) {
        int n;
        int n2;
        if (bl && (n2 = JOptionPane.showConfirmDialog(this, "Clear all spreadsheet cells?", "Are you sure?", 0)) != 0) {
            return false;
        }
        this.DisplayCells[this.CurX][this.CurY].hideWidgetFrame();
        boolean[][] blArray = new boolean[this.NumVisX][this.NumVisY];
        int n3 = 0;
        while (n3 < this.NumVisY) {
            n = 0;
            while (n < this.NumVisX) {
                blArray[n][n3] = true;
                ++n;
            }
            ++n3;
        }
        n3 = this.NumVisX * this.NumVisY;
        while (n3 > 0) {
            n = 0;
            while (n < this.NumVisY) {
                int n4 = 0;
                while (n4 < this.NumVisX) {
                    if (blArray[n4][n] && !this.DisplayCells[n4][n].othersDepend()) {
                        try {
                            this.DisplayCells[n4][n].clearCell();
                            blArray[n4][n] = false;
                            --n3;
                        }
                        catch (VisADException visADException) {
                            if (BasicSSCell.DEBUG) {
                                visADException.printStackTrace();
                            }
                            this.displayErrorMessage("Cannot clear cell (1)", visADException, "VisAD SpreadSheet error");
                        }
                        catch (RemoteException remoteException) {
                            if (BasicSSCell.DEBUG) {
                                remoteException.printStackTrace();
                            }
                            this.displayErrorMessage("Cannot clear cell (2)", remoteException, "VisAD SpreadSheet error");
                        }
                    }
                    ++n4;
                }
                ++n;
            }
        }
        this.CurrentFile = null;
        this.setTitle(this.bTitle);
        return true;
    }

    public void openFile() {
        this.SSFileDialog.setDialogType(0);
        if (this.SSFileDialog.showOpenDialog(this) != 0) {
            return;
        }
        File file = this.SSFileDialog.getSelectedFile();
        if (!file.exists()) {
            this.displayErrorMessage("The file " + file.getName() + " does not exist", null, "VisAD SpreadSheet error");
            return;
        }
        this.openFile(file.getPath());
    }

    public void openFile(String string) {
        int n;
        int n2;
        Object object;
        int n3;
        String string2;
        Object object2;
        File file = new File(string);
        boolean bl = this.AutoSwitch;
        boolean bl2 = this.AutoDetect;
        boolean bl3 = this.AutoShowControls;
        this.setAutoSwitch(false);
        this.setAutoDetect(false);
        this.setAutoShowControls(false);
        this.newFile(false);
        int n4 = (int)file.length();
        char[] cArray = new char[n4];
        try {
            object2 = new FileReader(file);
            ((InputStreamReader)object2).read(cArray, 0, n4);
            ((InputStreamReader)object2).close();
        }
        catch (IOException iOException) {
            if (BasicSSCell.DEBUG) {
                iOException.printStackTrace();
            }
            this.displayErrorMessage("Unable to read the file " + string + " from disk", null, "VisAD SpreadSheet error");
            this.setAutoSwitch(bl);
            this.setAutoDetect(bl2);
            this.setAutoShowControls(bl3);
            return;
        }
        object2 = new StringTokenizer(new String(cArray), "\n\r");
        int n5 = ((StringTokenizer)object2).countTokens();
        String[] stringArray = new String[n5 + 1];
        int n6 = 0;
        while (n6 < n5) {
            stringArray[n6] = ((StringTokenizer)object2).nextToken();
            ++n6;
        }
        stringArray[n5] = null;
        object2 = null;
        n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        int n10 = 0;
        boolean bl7 = false;
        while (!bl7) {
            if ((string2 = stringArray[n10++]) == null) {
                this.displayErrorMessage("The file " + string + " does not contain " + "the required [Global] tag", null, "VisAD SpreadSheet error");
                this.setAutoSwitch(bl);
                this.setAutoDetect(bl2);
                this.setAutoShowControls(bl3);
                return;
            }
            n3 = string2.length();
            object = string2.trim();
            n2 = ((String)object).length();
            if (((String)object).charAt(0) != '[' || ((String)object).charAt(n2 - 1) != ']') continue;
            String string3 = ((String)object).substring(1, n2 - 1).trim();
            if (!string3.equalsIgnoreCase("global")) {
                this.displayErrorMessage("The file " + string + " does not contain the " + "[Global] tag as its first entry", null, "VisAD SpreadSheet error");
                this.setAutoSwitch(bl);
                this.setAutoDetect(bl2);
                this.setAutoShowControls(bl3);
                return;
            }
            int n11 = n10;
            while (stringArray[n11] != null && stringArray[n11].trim().indexOf("[") != 0) {
                ++n11;
            }
            n = n10;
            while (n < n11) {
                int n12;
                string2 = stringArray[n].trim();
                if (string2 != null && string2.charAt(0) != '#' && (n12 = string2.indexOf("=")) >= 0) {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    block47: {
                        String string8;
                        String string9;
                        int n13;
                        block46: {
                            string7 = string2.substring(0, n12).trim();
                            if ((string7.equalsIgnoreCase("sheet size") || string7.equalsIgnoreCase("sheet_size") || string7.equalsIgnoreCase("sheetsize") || string7.equalsIgnoreCase("size")) && (n13 = string2.indexOf("x", n12)) >= 0) {
                                string9 = string2.substring(n12 + 1, n13).trim();
                                string8 = string2.substring(n13 + 1).trim();
                                try {
                                    n6 = Integer.parseInt(string9);
                                    n7 = Integer.parseInt(string8);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!BasicSSCell.DEBUG) break block46;
                                    numberFormatException.printStackTrace();
                                }
                            }
                        }
                        if ((string7.equalsIgnoreCase("dimension") || string7.equalsIgnoreCase("dimensions") || string7.equalsIgnoreCase("dim")) && (n13 = string2.indexOf("x", n12)) >= 0) {
                            string9 = string2.substring(n12 + 1, n13).trim();
                            string8 = string2.substring(n13 + 1).trim();
                            try {
                                n8 = Integer.parseInt(string9);
                                n9 = Integer.parseInt(string8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!BasicSSCell.DEBUG) break block47;
                                numberFormatException.printStackTrace();
                            }
                        }
                    }
                    if (string7.equalsIgnoreCase("columns") || string7.equalsIgnoreCase("column") || string7.equalsIgnoreCase("column widths") || string7.equalsIgnoreCase("column_widths") || string7.equalsIgnoreCase("columnwidths") || string7.equalsIgnoreCase("column width") || string7.equalsIgnoreCase("column_width") || string7.equalsIgnoreCase("columnwidth")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n12 + 1));
                        int n14 = stringTokenizer.countTokens();
                        int n15 = 0;
                        while (n15 < n14) {
                            int n16;
                            block48: {
                                n16 = 0;
                                try {
                                    n16 = Integer.parseInt(stringTokenizer.nextToken());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!BasicSSCell.DEBUG) break block48;
                                    numberFormatException.printStackTrace();
                                }
                            }
                            if (n16 >= 120) {
                                vector.add(new Integer(n16));
                            }
                            ++n15;
                        }
                    }
                    if (string7.equalsIgnoreCase("rows") || string7.equalsIgnoreCase("row") || string7.equalsIgnoreCase("row heights") || string7.equalsIgnoreCase("row_heights") || string7.equalsIgnoreCase("rowheights") || string7.equalsIgnoreCase("row height") || string7.equalsIgnoreCase("row_height") || string7.equalsIgnoreCase("rowheight")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n12 + 1));
                        int n17 = stringTokenizer.countTokens();
                        int n18 = 0;
                        while (n18 < n17) {
                            int n19;
                            block49: {
                                n19 = 0;
                                try {
                                    n19 = Integer.parseInt(stringTokenizer.nextToken());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!BasicSSCell.DEBUG) break block49;
                                    numberFormatException.printStackTrace();
                                }
                            }
                            if (n19 >= 120) {
                                vector2.add(new Integer(n19));
                            }
                            ++n18;
                        }
                    }
                    if ((string7.equalsIgnoreCase("auto switch") || string7.equalsIgnoreCase("auto_switch") || string7.equalsIgnoreCase("auto-switch") || string7.equalsIgnoreCase("autoswitch")) && ((string6 = string2.substring(n12 + 1).trim()).equalsIgnoreCase("false") || string6.equalsIgnoreCase("F"))) {
                        bl4 = false;
                    }
                    if ((string7.equalsIgnoreCase("auto detect") || string7.equalsIgnoreCase("auto_detect") || string7.equalsIgnoreCase("auto-detect") || string7.equalsIgnoreCase("autodetect")) && ((string5 = string2.substring(n12 + 1).trim()).equalsIgnoreCase("false") || string5.equalsIgnoreCase("F"))) {
                        bl5 = false;
                    }
                    if ((string7.equalsIgnoreCase("auto show") || string7.equalsIgnoreCase("auto_show") || string7.equalsIgnoreCase("auto-show") || string7.equalsIgnoreCase("autoshow")) && ((string4 = string2.substring(n12 + 1).trim()).equalsIgnoreCase("false") || string4.equalsIgnoreCase("F"))) {
                        bl6 = false;
                    }
                }
                ++n;
            }
            bl7 = true;
        }
        if (n8 < 1 || n9 < 1) {
            this.displayErrorMessage("The file " + string + " has an invalid " + "global dimension entry", null, "VisAD SpreadSheet error");
            this.setAutoSwitch(bl);
            this.setAutoDetect(bl2);
            this.setAutoShowControls(bl3);
            return;
        }
        n3 = vector.size();
        object = new int[n8];
        n2 = 0;
        while (n2 < n8) {
            object[n2] = n2 < n3 ? (Object)((Integer)vector.elementAt(n2)) : (Object)250;
            ++n2;
        }
        n3 = vector2.size();
        int[] nArray = new int[n9];
        int n20 = 0;
        while (n20 < n9) {
            nArray[n20] = n20 < n3 ? (Integer)vector2.elementAt(n20) : 250;
            ++n20;
        }
        String[][] stringArray2 = new String[n8][n9];
        String[][] stringArray3 = new String[n8][n9];
        n = 0;
        while (n < n9) {
            int n21 = 0;
            while (n21 < n8) {
                stringArray2[n21][n] = null;
                do {
                    if ((string2 = stringArray[n10++]) == null) {
                        this.displayErrorMessage("The file " + string + " is incomplete", null, "VisAD SpreadSheet error");
                        this.setAutoSwitch(bl);
                        this.setAutoDetect(bl2);
                        this.setAutoShowControls(bl3);
                        return;
                    }
                    String string10 = string2.trim();
                    int n22 = string10.length();
                    if (string10.charAt(0) != '[' || string10.charAt(n22 - 1) != ']') continue;
                    stringArray2[n21][n] = string10.substring(1, n22 - 1).trim();
                } while (stringArray2[n21][n] == null);
                int n23 = n10 + 1;
                while (stringArray[n23] != null && stringArray[n23].trim().indexOf("[") != 0) {
                    ++n23;
                }
                String string11 = "";
                int n24 = n10;
                while (n24 < n23) {
                    string11 = string11 + stringArray[n24] + "\n";
                    ++n24;
                }
                stringArray3[n21][n] = string11;
                ++n21;
            }
            ++n;
        }
        if (n6 > 0 && n7 > 0) {
            ((Component)this).setSize(n6, n7);
        }
        this.NumVisX = n8;
        this.NumVisY = n9;
        this.reconstructSpreadsheet(stringArray2, (int[])object, nArray, null);
        this.synchColRow();
        n = 0;
        while (n < this.NumVisY) {
            int n25 = 0;
            while (n25 < this.NumVisX) {
                try {
                    this.DisplayCells[n25][n].setSaveString(stringArray3[n25][n]);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Invalid save string", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.displayErrorMessage("Invalid save string", remoteException, "VisAD SpreadSheet error");
                }
                ++n25;
            }
            ++n;
        }
        this.setAutoSwitch(bl4);
        this.setAutoDetect(bl5);
        this.setAutoShowControls(bl6);
        this.CurrentFile = file;
        this.setTitle(this.bTitle + " - " + file.getPath());
        this.refreshDisplayMenuItems();
        this.refreshFormulaBar();
        this.refreshMenuCommands();
        this.refreshOptions();
        this.validate();
        this.repaint();
    }

    public void saveFile() {
        if (this.CurrentFile == null) {
            this.saveAsFile();
        } else {
            StringBuffer stringBuffer = new StringBuffer(1024 * this.NumVisX * this.NumVisY + 1024);
            stringBuffer.append(SSFileHeader);
            stringBuffer.append("\n");
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            int n7 = calendar.get(14);
            stringBuffer.append("# File ");
            stringBuffer.append(this.CurrentFile.getName());
            stringBuffer.append(" written at ");
            stringBuffer.append(n);
            stringBuffer.append("/");
            if (n2 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2 + 1);
            stringBuffer.append("/");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n3);
            stringBuffer.append(", ");
            if (n4 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n4);
            stringBuffer.append(":");
            if (n5 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n5);
            stringBuffer.append(":");
            if (n6 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n6);
            stringBuffer.append(".");
            if (n7 < 100) {
                stringBuffer.append("0");
            }
            if (n7 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n7);
            stringBuffer.append("\n\n");
            stringBuffer.append("[Global]\n");
            stringBuffer.append("sheet size = ");
            stringBuffer.append(this.getWidth());
            stringBuffer.append(" x ");
            stringBuffer.append(this.getHeight());
            stringBuffer.append("\n");
            stringBuffer.append("dimension = ");
            stringBuffer.append(this.NumVisX);
            stringBuffer.append(" x ");
            stringBuffer.append(this.NumVisY);
            stringBuffer.append("\n");
            stringBuffer.append("columns =");
            int n8 = 0;
            while (n8 < this.NumVisX) {
                stringBuffer.append(" ");
                stringBuffer.append(this.HorizLabel[n8].getSize().width);
                ++n8;
            }
            stringBuffer.append("\n");
            stringBuffer.append("rows =");
            n8 = 0;
            while (n8 < this.NumVisY) {
                stringBuffer.append(" ");
                stringBuffer.append(this.VertLabel[n8].getSize().height);
                ++n8;
            }
            stringBuffer.append("\n");
            stringBuffer.append("auto switch = ");
            stringBuffer.append(this.AutoSwitch);
            stringBuffer.append("\n");
            stringBuffer.append("auto detect = ");
            stringBuffer.append(this.AutoDetect);
            stringBuffer.append("\n");
            stringBuffer.append("auto show = ");
            stringBuffer.append(this.AutoShowControls);
            stringBuffer.append("\n\n");
            n8 = 0;
            while (n8 < this.NumVisY) {
                int n9 = 0;
                while (n9 < this.NumVisX) {
                    stringBuffer.append("[");
                    stringBuffer.append(this.DisplayCells[n9][n8].getName());
                    stringBuffer.append("]\n");
                    stringBuffer.append(this.DisplayCells[n9][n8].getSaveString());
                    stringBuffer.append("\n");
                    ++n9;
                }
                ++n8;
            }
            char[] cArray = stringBuffer.toString().toCharArray();
            try {
                FileWriter fileWriter = new FileWriter(this.CurrentFile);
                fileWriter.write(cArray, 0, cArray.length);
                fileWriter.close();
            }
            catch (IOException iOException) {
                if (BasicSSCell.DEBUG) {
                    iOException.printStackTrace();
                }
                this.displayErrorMessage("Could not save file " + this.CurrentFile.getName() + ". Make sure there is enough disk space", null, "VisAD SpreadSheet error");
            }
        }
    }

    public void saveAsFile() {
        File file;
        this.SSFileDialog.setDialogType(1);
        if (this.SSFileDialog.showSaveDialog(this) != 0) {
            return;
        }
        this.CurrentFile = file = this.SSFileDialog.getSelectedFile();
        this.setTitle(this.bTitle + " - " + file.getPath());
        this.saveFile();
    }

    public void setDim3D() {
        this.setDim(1);
    }

    public void setDimJ2D() {
        this.setDim(2);
    }

    public void setDim2D() {
        this.setDim(3);
    }

    protected void setDim(int n) {
        try {
            this.DisplayCells[this.CurX][this.CurY].setDimension(n);
        }
        catch (VisADException visADException) {
            if (BasicSSCell.DEBUG) {
                visADException.printStackTrace();
            }
            this.displayErrorMessage("Cannot alter display dimension", visADException, "VisAD SpreadSheet error");
        }
        catch (RemoteException remoteException) {
            if (BasicSSCell.DEBUG) {
                remoteException.printStackTrace();
            }
            this.displayErrorMessage("Cannot alter display dimension", remoteException, "VisAD SpreadSheet error");
        }
        this.refreshDisplayMenuItems();
    }

    public void printCurrentCell() {
        if (!this.DisplayCells[this.CurX][this.CurY].hasData()) {
            this.displayErrorMessage("The current cell contains no data to be printed", null, "VisAD SpreadSheet error");
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        DisplayImpl displayImpl = this.DisplayCells[this.CurX][this.CurY].getDisplay();
        Printable printable = displayImpl.getPrintable();
        printerJob.setPrintable(printable);
        if (printerJob.printDialog()) {
            Runnable runnable = new Runnable(this, printerJob){
                private final /* synthetic */ SpreadSheet this$0;
                private final /* synthetic */ PrinterJob val$printJob;

                public void run() {
                    try {
                        this.val$printJob.print();
                    }
                    catch (Exception exception) {
                        if (BasicSSCell.DEBUG) {
                            exception.printStackTrace();
                        }
                        this.this$0.displayErrorMessage("Cannot print the current cell", exception, "VisAD SpreadSheet error");
                    }
                }
                {
                    this.val$printJob = printerJob;
                    this.this$0 = spreadSheet;
                    this.constructor$0(spreadSheet);
                }

                private final void constructor$0(SpreadSheet spreadSheet) {
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public void createMappings() {
        this.DisplayCells[this.CurX][this.CurY].addMapDialog();
        this.refreshMenuCommands();
    }

    public void resetOrientation() {
        ProjectionControl projectionControl;
        DisplayImpl displayImpl = this.DisplayCells[this.CurX][this.CurY].getDisplay();
        if (displayImpl != null && (projectionControl = displayImpl.getProjectionControl()) != null) {
            int n = this.DisplayCells[this.CurX][this.CurY].getDimension();
            double[] dArray = n == 1 ? matrix3D : (n == 2 ? matrixJ2D : matrix2D);
            try {
                projectionControl.setMatrix(dArray);
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                this.displayErrorMessage("Cannot reset orientation", visADException, "VisAD SpreadSheet error");
            }
            catch (RemoteException remoteException) {
                if (BasicSSCell.DEBUG) {
                    remoteException.printStackTrace();
                }
                this.displayErrorMessage("Cannot reset orientation", remoteException, "VisAD SpreadSheet error");
            }
        }
    }

    public void showControls() {
        this.DisplayCells[this.CurX][this.CurY].showWidgetFrame();
    }

    public synchronized void addColumn() {
        JLabel jLabel = (JLabel)this.HorizLabel[this.NumVisX - 1].getComponent(0);
        int n = Letters.indexOf(jLabel.getText()) + 1;
        int n2 = Letters.length() - n;
        if (n2 > 0) {
            JPanel[] jPanelArray = new JPanel[this.NumVisX + 1];
            int n3 = 0;
            while (n3 < this.NumVisX) {
                jPanelArray[n3] = this.HorizLabel[n3];
                ++n3;
            }
            jPanelArray[this.NumVisX] = new JPanel();
            jPanelArray[this.NumVisX].setBorder(new LineBorder(Color.black, 1));
            jPanelArray[this.NumVisX].setLayout(new BorderLayout());
            jPanelArray[this.NumVisX].setPreferredSize(new Dimension(250, 20));
            String string = String.valueOf(Letters.charAt(n));
            jPanelArray[this.NumVisX].add("Center", new JLabel(string, 0));
            if (this.IsRemote) {
                this.HorizLabel = jPanelArray;
                this.synchColRow();
            } else {
                JComponent[] jComponentArray = new JComponent[this.NumVisX + 1];
                int n4 = 0;
                while (n4 < this.NumVisX) {
                    jComponentArray[n4] = this.HorizDrag[n4];
                    ++n4;
                }
                jComponentArray[this.NumVisX] = new JComponent(this){
                    private final /* synthetic */ SpreadSheet this$0;

                    public void paint(Graphics graphics) {
                        Dimension dimension = this.getSize();
                        graphics.setColor(Color.black);
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                        graphics.setColor(Color.yellow);
                        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
                    }
                    {
                        this.this$0 = spreadSheet;
                        this.constructor$0(spreadSheet);
                    }

                    private final void constructor$0(SpreadSheet spreadSheet) {
                    }
                };
                jComponentArray[this.NumVisX].setPreferredSize(new Dimension(5, 0));
                jComponentArray[this.NumVisX].addMouseListener(this);
                jComponentArray[this.NumVisX].addMouseMotionListener(this);
                this.HorizPanel.removeAll();
                FancySSCell[][] fancySSCellArray = new FancySSCell[this.NumVisX + 1][this.NumVisY];
                this.DisplayPanel.removeAll();
                int n5 = 0;
                while (n5 < this.NumVisY) {
                    int n6 = 0;
                    while (n6 < this.NumVisX) {
                        fancySSCellArray[n6][n5] = this.DisplayCells[n6][n5];
                        ++n6;
                    }
                    try {
                        String string2 = String.valueOf(Letters.charAt(n)) + String.valueOf(n5 + 1);
                        FancySSCell fancySSCell = this.createCell(string2, null);
                        fancySSCell.addSSCellListener(this);
                        fancySSCell.addMouseListener(this);
                        fancySSCell.setAutoSwitch(this.AutoSwitch);
                        fancySSCell.setAutoDetect(this.AutoDetect);
                        fancySSCell.setAutoShowControls(this.AutoShowControls);
                        fancySSCell.setDimension(CanDo3D ? 1 : 2);
                        fancySSCell.addDisplayListener(this);
                        fancySSCell.setPreferredSize(new Dimension(250, 250));
                        fancySSCellArray[this.NumVisX][n5] = fancySSCell;
                        if (this.rsi != null) {
                            fancySSCellArray[this.NumVisX][n5].addToRemoteServer(this.rsi);
                        }
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot add the column. Unable to create new displays", visADException, "VisAD SpreadSheet error");
                    }
                    catch (RemoteException remoteException) {
                        if (BasicSSCell.DEBUG) {
                            remoteException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot add the column. A remote error occurred", remoteException, "VisAD SpreadSheet error");
                    }
                    ++n5;
                }
                ++this.NumVisX;
                this.reconstructHoriz(jPanelArray, jComponentArray, fancySSCellArray);
                if (n2 == 1) {
                    this.LayAddCol.setEnabled(false);
                }
                this.LayDelCol.setEnabled(true);
            }
        }
    }

    public void addRow() {
        JLabel jLabel = (JLabel)this.VertLabel[this.NumVisY - 1].getComponent(0);
        int n = Integer.parseInt(jLabel.getText());
        JPanel[] jPanelArray = new JPanel[this.NumVisY + 1];
        JComponent[] jComponentArray = new JComponent[this.NumVisY + 1];
        int n2 = 0;
        while (n2 < this.NumVisY) {
            jPanelArray[n2] = this.VertLabel[n2];
            ++n2;
        }
        jPanelArray[this.NumVisY] = new JPanel();
        jPanelArray[this.NumVisY].setBorder(new LineBorder(Color.black, 1));
        jPanelArray[this.NumVisY].setLayout(new BorderLayout());
        jPanelArray[this.NumVisY].setPreferredSize(new Dimension(30, 250));
        String string = String.valueOf(n + 1);
        jPanelArray[this.NumVisY].add("Center", new JLabel(string, 0));
        if (this.IsRemote) {
            this.VertLabel = jPanelArray;
            this.synchColRow();
        } else {
            int n3 = 0;
            while (n3 < this.NumVisY) {
                jComponentArray[n3] = this.VertDrag[n3];
                ++n3;
            }
            jComponentArray[this.NumVisY] = new JComponent(this){
                private final /* synthetic */ SpreadSheet this$0;

                public void paint(Graphics graphics) {
                    Dimension dimension = this.getSize();
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                    graphics.setColor(Color.yellow);
                    graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
                }
                {
                    this.this$0 = spreadSheet;
                    this.constructor$0(spreadSheet);
                }

                private final void constructor$0(SpreadSheet spreadSheet) {
                }
            };
            jComponentArray[this.NumVisY].setPreferredSize(new Dimension(0, 5));
            jComponentArray[this.NumVisY].addMouseListener(this);
            jComponentArray[this.NumVisY].addMouseMotionListener(this);
            this.VertPanel.removeAll();
            FancySSCell[][] fancySSCellArray = new FancySSCell[this.NumVisX][this.NumVisY + 1];
            this.DisplayPanel.removeAll();
            int n4 = 0;
            while (n4 < this.NumVisX) {
                int n5 = 0;
                while (n5 < this.NumVisY) {
                    fancySSCellArray[n4][n5] = this.DisplayCells[n4][n5];
                    ++n5;
                }
                try {
                    String string2 = String.valueOf(Letters.charAt(n4)) + String.valueOf(n + 1);
                    FancySSCell fancySSCell = this.createCell(string2, null);
                    fancySSCell.addSSCellListener(this);
                    fancySSCell.addMouseListener(this);
                    fancySSCell.setAutoSwitch(this.AutoSwitch);
                    fancySSCell.setAutoDetect(this.AutoDetect);
                    fancySSCell.setAutoShowControls(this.AutoShowControls);
                    fancySSCell.setDimension(CanDo3D ? 1 : 2);
                    fancySSCell.addDisplayListener(this);
                    fancySSCell.setPreferredSize(new Dimension(250, 250));
                    fancySSCellArray[n4][this.NumVisY] = fancySSCell;
                    if (this.rsi != null) {
                        fancySSCellArray[n4][this.NumVisY].addToRemoteServer(this.rsi);
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot add the row. Unable to create new displays", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot add the row. A remote error occurred", remoteException, "VisAD SpreadSheet error");
                }
                ++n4;
            }
            ++this.NumVisY;
            this.reconstructVert(jPanelArray, jComponentArray, fancySSCellArray);
            this.LayDelRow.setEnabled(true);
        }
    }

    public synchronized boolean deleteColumn() {
        if (this.NumVisX == 1) {
            this.displayErrorMessage("This is the last column", null, "Cannot delete column");
            return false;
        }
        int n = 0;
        while (n < this.NumVisY) {
            if (this.DisplayCells[this.CurX][n].othersDepend()) {
                this.displayErrorMessage("Other cells depend on cells from this column. Make sure that no cells depend on this column before attempting to delete it", null, "Cannot delete column");
                return false;
            }
            ++n;
        }
        JLabel jLabel = (JLabel)this.HorizLabel[this.CurX].getComponent(0);
        char c = jLabel.getText().charAt(0);
        char c2 = Letters.charAt(Letters.length() - 1);
        JPanel[] jPanelArray = new JPanel[this.NumVisX - 1];
        int n2 = 0;
        while (n2 < this.CurX) {
            jPanelArray[n2] = this.HorizLabel[n2];
            ++n2;
        }
        n2 = this.CurX + 1;
        while (n2 < this.NumVisX) {
            jPanelArray[n2 - 1] = this.HorizLabel[n2];
            ++n2;
        }
        if (this.IsRemote) {
            this.HorizLabel = jPanelArray;
            this.synchColRow();
        } else {
            JComponent[] jComponentArray = new JComponent[this.NumVisX - 1];
            int n3 = 0;
            while (n3 < this.NumVisX - 1) {
                jComponentArray[n3] = this.HorizDrag[n3];
                ++n3;
            }
            this.HorizPanel.removeAll();
            FancySSCell[][] fancySSCellArray = new FancySSCell[this.NumVisX - 1][this.NumVisY];
            this.DisplayPanel.removeAll();
            int n4 = 0;
            while (n4 < this.NumVisY) {
                int n5 = 0;
                while (n5 < this.CurX) {
                    fancySSCellArray[n5][n4] = this.DisplayCells[n5][n4];
                    ++n5;
                }
                n5 = this.CurX + 1;
                while (n5 < this.NumVisX) {
                    fancySSCellArray[n5 - 1][n4] = this.DisplayCells[n5][n4];
                    ++n5;
                }
                try {
                    this.DisplayCells[this.CurX][n4].destroyCell();
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (3)", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (4)", remoteException, "VisAD SpreadSheet error");
                }
                this.DisplayCells[this.CurX][n4] = null;
                ++n4;
            }
            --this.NumVisX;
            if (this.CurX > this.NumVisX - 1) {
                this.selectCell(this.NumVisX - 1, this.CurY);
            }
            this.reconstructHoriz(jPanelArray, jComponentArray, fancySSCellArray);
            if (c == c2) {
                this.LayAddCol.setEnabled(true);
            }
            if (this.NumVisX == 1) {
                this.LayDelCol.setEnabled(false);
            }
        }
        return true;
    }

    public synchronized boolean deleteRow() {
        if (this.NumVisY == 1) {
            this.displayErrorMessage("This is the last row", null, "Cannot delete row");
            return false;
        }
        int n = 0;
        while (n < this.NumVisX) {
            if (this.DisplayCells[n][this.CurY].othersDepend()) {
                this.displayErrorMessage("Other cells depend on cells from this row. Make sure that no cells depend on this row before attempting to delete it", null, "Cannot delete row");
                return false;
            }
            ++n;
        }
        JPanel[] jPanelArray = new JPanel[this.NumVisY - 1];
        int n2 = 0;
        while (n2 < this.CurY) {
            jPanelArray[n2] = this.VertLabel[n2];
            ++n2;
        }
        n2 = this.CurY + 1;
        while (n2 < this.NumVisY) {
            jPanelArray[n2 - 1] = this.VertLabel[n2];
            ++n2;
        }
        if (this.IsRemote) {
            this.VertLabel = jPanelArray;
            this.synchColRow();
        } else {
            JComponent[] jComponentArray = new JComponent[this.NumVisY];
            int n3 = 0;
            while (n3 < this.NumVisY) {
                jComponentArray[n3] = this.VertDrag[n3];
                ++n3;
            }
            this.VertPanel.removeAll();
            FancySSCell[][] fancySSCellArray = new FancySSCell[this.NumVisX][this.NumVisY - 1];
            this.DisplayPanel.removeAll();
            int n4 = 0;
            while (n4 < this.NumVisX) {
                int n5 = 0;
                while (n5 < this.CurY) {
                    fancySSCellArray[n4][n5] = this.DisplayCells[n4][n5];
                    ++n5;
                }
                n5 = this.CurY + 1;
                while (n5 < this.NumVisY) {
                    fancySSCellArray[n4][n5 - 1] = this.DisplayCells[n4][n5];
                    ++n5;
                }
                try {
                    this.DisplayCells[n4][this.CurY].destroyCell();
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (5)", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.displayErrorMessage("Cannot destroy cell (6)", remoteException, "VisAD SpreadSheet error");
                }
                this.DisplayCells[n4][this.CurY] = null;
                ++n4;
            }
            --this.NumVisY;
            if (this.CurY > this.NumVisY - 1) {
                this.selectCell(this.CurX, this.NumVisY - 1);
            }
            this.reconstructVert(jPanelArray, jComponentArray, fancySSCellArray);
            if (this.NumVisY == 1) {
                this.LayDelRow.setEnabled(false);
            }
        }
        return true;
    }

    public void tileCells() {
        Dimension dimension = this.SCPane.getSize();
        int n = dimension.width - this.SCPane.getVScrollbarWidth() - 5 * this.NumVisX;
        int n2 = dimension.height - this.SCPane.getHScrollbarHeight() - 5 * this.NumVisY;
        int n3 = n / this.NumVisX;
        int n4 = n2 / this.NumVisY;
        if (n3 < 120) {
            n3 = 120;
        }
        if (n4 < 120) {
            n4 = 120;
        }
        Dimension dimension2 = new Dimension(n3, 20);
        Dimension dimension3 = new Dimension(30, n4);
        int n5 = 0;
        while (n5 < this.NumVisX) {
            this.HorizLabel[n5].setSize(dimension2);
            this.HorizLabel[n5].setPreferredSize(dimension2);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.NumVisY) {
            this.VertLabel[n5].setSize(dimension3);
            this.VertLabel[n5].setPreferredSize(dimension3);
            ++n5;
        }
        this.synchLabelAndCellSizes();
    }

    public void optionsSwitch() {
        this.setAutoSwitch(this.AutoSwitchBox.getState());
    }

    public void optionsDetect() {
        this.setAutoDetect(this.AutoDetectBox.getState());
    }

    public void optionsDisplay() {
        this.setAutoShowControls(this.AutoShowBox.getState());
    }

    protected void setAutoSwitch(boolean bl) {
        int n = 0;
        while (n < this.NumVisY) {
            int n2 = 0;
            while (n2 < this.NumVisX) {
                this.DisplayCells[n2][n].setAutoSwitch(bl);
                ++n2;
            }
            ++n;
        }
        this.AutoSwitch = bl;
    }

    protected void setAutoDetect(boolean bl) {
        int n = 0;
        while (n < this.NumVisY) {
            int n2 = 0;
            while (n2 < this.NumVisX) {
                this.DisplayCells[n2][n].setAutoDetect(bl);
                ++n2;
            }
            ++n;
        }
        this.AutoDetect = bl;
    }

    protected void setAutoShowControls(boolean bl) {
        int n = 0;
        while (n < this.NumVisY) {
            int n2 = 0;
            while (n2 < this.NumVisX) {
                this.DisplayCells[n2][n].setAutoShowControls(bl);
                ++n2;
            }
            ++n;
        }
        this.AutoShowControls = bl;
    }

    public void formulaAdd() {
        this.FormulaEditor.setItem("");
        this.FormulaEditor.selectAll();
    }

    public void formulaDel() {
        String string = (String)this.FormulaBox.getSelectedItem();
        if (string == null) {
            return;
        }
        int n = string.indexOf(":");
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        try {
            this.DisplayCells[this.CurX][this.CurY].removeData(string2);
            this.FormulaBox.removeItem(string);
        }
        catch (VisADException visADException) {
            if (BasicSSCell.DEBUG) {
                visADException.printStackTrace();
            }
            this.displayErrorMessage("Cannot delete data " + string2, visADException, "VisAD SpreadSheet error");
        }
        catch (RemoteException remoteException) {
            if (BasicSSCell.DEBUG) {
                remoteException.printStackTrace();
            }
            this.displayErrorMessage("Cannot delete data " + string2, remoteException, "VisAD SpreadSheet error");
        }
    }

    protected void refreshCells() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                int n = 0;
                while (n < this.this$0.NumVisX) {
                    int n2 = 0;
                    while (n2 < this.this$0.NumVisY) {
                        this.this$0.DisplayCells[n][n2].refresh();
                        ++n2;
                    }
                    ++n;
                }
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected void refreshOptions() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                this.this$0.AutoSwitchBox.setState(this.this$0.AutoSwitch);
                this.this$0.AutoDetectBox.setState(this.this$0.AutoDetect);
                this.this$0.AutoShowBox.setState(this.this$0.AutoShowControls);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected void refreshShowControls() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                boolean bl = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].hasControls();
                this.this$0.CellShow.setEnabled(bl);
                if (!BugFix) {
                    this.this$0.ToolShow.setEnabled(bl);
                }
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected void refreshMenuCommands() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                boolean bl = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].hasData();
                this.this$0.FileSave1.setEnabled(bl);
                this.this$0.FileSave2.setEnabled(bl);
                this.this$0.FileSave3.setEnabled(bl && CanDoHDF5);
                this.this$0.FileSave4.setEnabled(bl);
                this.this$0.FileSnap.setEnabled(bl && CanDoJPEG);
                this.this$0.EditClear.setEnabled(bl);
                this.this$0.CellPrint.setEnabled(bl);
                this.this$0.CellEdit.setEnabled(bl);
                this.this$0.CellReset.setEnabled(bl && !this.this$0.IsSlave);
                if (!BugFix) {
                    this.this$0.ToolSave.setEnabled(bl);
                    this.this$0.ToolMap.setEnabled(bl);
                    this.this$0.ToolReset.setEnabled(bl && !this.this$0.IsSlave);
                }
                this.this$0.refreshShowControls();
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected void refreshFormulaBar() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                if (this.this$0.FormulaBox.getItemCount() > 0) {
                    this.this$0.FormulaBox.removeAllItems();
                }
                String[] stringArray = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].getVariableNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String string2 = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].getDataSource(string);
                    this.this$0.FormulaBox.addItem(string + ": " + string2);
                    ++n2;
                }
                n2 = n <= 0 ? 0 : 1;
                this.this$0.CellDel.setEnabled(n2 != 0);
                if (!BugFix) {
                    this.this$0.FormulaDel.setEnabled(n2 != 0);
                }
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected void refreshDisplayMenuItems() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void run() {
                int n = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].getDimension();
                boolean bl = n == 1;
                boolean bl2 = n == 2;
                boolean bl3 = n == 3;
                this.this$0.CellDim3D3D.setState(bl);
                this.this$0.CellDim2D2D.setState(bl2);
                this.this$0.CellDim2D3D.setState(bl3);
                if (!BugFix) {
                    this.this$0.Tool3D.setEnabled(!bl && CanDo3D);
                    this.this$0.Tool2D.setEnabled(!bl3 && CanDo3D);
                    this.this$0.ToolJ2D.setEnabled(!bl2);
                }
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    private double getColRowID() {
        block6: {
            TupleIface tupleIface = null;
            Real real = null;
            try {
                tupleIface = (TupleIface)this.RemoteColRow.getData();
                real = (Real)tupleIface.getComponent(0);
                return real.getValue();
            }
            catch (NullPointerException nullPointerException) {
                if (BasicSSCell.DEBUG) {
                    nullPointerException.printStackTrace();
                }
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!BasicSSCell.DEBUG) break block6;
                remoteException.printStackTrace();
            }
        }
        return Double.NaN;
    }

    private String[][] getNewCellNames() {
        Scalar scalar;
        int n;
        int n2;
        RealTuple realTuple;
        TupleIface tupleIface;
        block25: {
            block24: {
                TupleIface tupleIface2 = null;
                tupleIface = null;
                realTuple = null;
                try {
                    tupleIface2 = (TupleIface)this.RemoteColRow.getData();
                    tupleIface = (TupleIface)tupleIface2.getComponent(1);
                    realTuple = (RealTuple)tupleIface2.getComponent(2);
                }
                catch (NullPointerException nullPointerException) {
                    if (BasicSSCell.DEBUG) {
                        nullPointerException.printStackTrace();
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block24;
                    remoteException.printStackTrace();
                }
            }
            if (tupleIface == null || realTuple == null) {
                return null;
            }
            n2 = -1;
            n = -1;
            try {
                n2 = tupleIface.getDimension();
                n = realTuple.getDimension();
            }
            catch (RemoteException remoteException) {
                if (!BasicSSCell.DEBUG) break block25;
                remoteException.printStackTrace();
            }
        }
        if (n < 1 || n2 < 1) {
            return null;
        }
        String[] stringArray = new String[n2];
        int[] nArray = new int[n];
        String[][] stringArray2 = new String[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            block26: {
                scalar = null;
                try {
                    scalar = (Text)tupleIface.getComponent(n3);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block26;
                    remoteException.printStackTrace();
                }
            }
            if (scalar == null) {
                return null;
            }
            stringArray[n3] = ((Text)scalar).getValue();
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            block27: {
                scalar = null;
                try {
                    scalar = (Real)realTuple.getComponent(n3);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block27;
                    remoteException.printStackTrace();
                }
            }
            if (scalar == null) {
                return null;
            }
            nArray[n3] = (int)((Real)scalar).getValue();
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                stringArray2[n3][n4] = stringArray[n3] + nArray[n4];
                ++n4;
            }
            ++n3;
        }
        return stringArray2;
    }

    private void synchColRow() {
        if (this.RemoteColRow != null) {
            RemoteDataReference remoteDataReference = this.RemoteColRow;
            synchronized (remoteDataReference) {
                block10: {
                    int n = this.HorizLabel.length;
                    int n2 = this.VertLabel.length;
                    try {
                        Object object;
                        Real[] realArray;
                        MathType[] mathTypeArray = new MathType[3];
                        Real real = new Real(this.CollabID);
                        mathTypeArray[0] = real.getType();
                        Data[] dataArray = new Text[n];
                        MathType[] mathTypeArray2 = new TextType[n];
                        int n3 = 0;
                        while (n3 < n) {
                            realArray = ((JLabel)this.HorizLabel[n3].getComponent(0)).getText();
                            dataArray[n3] = new Text((String)realArray);
                            mathTypeArray2[n3] = (TextType)((DataImpl)dataArray[n3]).getType();
                            ++n3;
                        }
                        mathTypeArray[1] = new TupleType(mathTypeArray2);
                        Tuple tuple = new Tuple((TupleType)mathTypeArray[1], dataArray);
                        realArray = new Real[n2];
                        int n4 = 0;
                        while (n4 < n2) {
                            object = ((JLabel)this.VertLabel[n4].getComponent(0)).getText();
                            realArray[n4] = new Real(Integer.parseInt((String)object));
                            ++n4;
                        }
                        RealTuple realTuple = new RealTuple(realArray);
                        mathTypeArray[2] = realTuple.getType();
                        object = new Tuple(new TupleType(mathTypeArray), new Data[]{real, tuple, realTuple});
                        this.RemoteColRow.setData((Data)object);
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!BasicSSCell.DEBUG) break block10;
                        remoteException.printStackTrace();
                    }
                }
            }
        }
    }

    private void synchLabelAndCellSizes() {
        int n = 0;
        while (n < this.NumVisY) {
            int n2 = this.VertLabel[n].getSize().height;
            int n3 = 0;
            while (n3 < this.NumVisX) {
                int n4 = this.HorizLabel[n3].getSize().width;
                this.DisplayCells[n3][n].setPreferredSize(new Dimension(n4, n2));
                ++n3;
            }
            ++n;
        }
        this.HorizLabels.validate();
        this.VertLabels.validate();
        this.DisplayPanel.doLayout();
        this.SCPane.validate();
        this.refreshCells();
    }

    private void constructSpreadsheetCells(RemoteServer remoteServer) {
        String[][] stringArray = new String[this.NumVisX][this.NumVisY];
        int n = 0;
        while (n < this.NumVisX) {
            int n2 = 0;
            while (n2 < this.NumVisY) {
                stringArray[n][n2] = "" + Letters.charAt(n) + (n2 + 1);
                ++n2;
            }
            ++n;
        }
        this.constructSpreadsheetCells(stringArray, remoteServer);
    }

    private void constructSpreadsheetCells(String[][] stringArray, RemoteServer remoteServer) {
        Object object = this.Lock;
        synchronized (object) {
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            this.DisplayCells = new FancySSCell[this.NumVisX][this.NumVisY];
            int n = 0;
            while (n < this.NumVisY) {
                int n2 = this.VertLabel[n].getPreferredSize().height;
                int n3 = 0;
                while (n3 < this.NumVisX) {
                    int n4 = this.HorizLabel[n3].getPreferredSize().width;
                    try {
                        FancySSCell fancySSCell = (FancySSCell)BasicSSCell.getSSCellByName(stringArray[n3][n]);
                        if (fancySSCell == null) {
                            fancySSCell = this.createCell(stringArray[n3][n], remoteServer);
                            fancySSCell.addSSCellListener(this);
                            fancySSCell.addMouseListener(this);
                            fancySSCell.setAutoSwitch(this.AutoSwitch);
                            fancySSCell.setAutoDetect(this.AutoDetect);
                            fancySSCell.setAutoShowControls(this.AutoShowControls);
                            if (remoteServer == null) {
                                fancySSCell.setDimension(CanDo3D ? 1 : 2);
                            }
                            fancySSCell.addDisplayListener(this);
                            if (this.rsi != null) {
                                fancySSCell.addToRemoteServer(this.rsi);
                            }
                        }
                        fancySSCell.setPreferredSize(new Dimension(n4, n2));
                        this.DisplayCells[n3][n] = fancySSCell;
                        this.DisplayPanel.add(this.DisplayCells[n3][n]);
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot construct spreadsheet cells. An error occurred", visADException, "VisAD SpreadSheet error");
                    }
                    catch (RemoteException remoteException) {
                        if (BasicSSCell.DEBUG) {
                            remoteException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot construct spreadsheet cells. A remote error occurred", remoteException, "VisAD SpreadSheet error");
                    }
                    ++n3;
                }
                ++n;
            }
            this.selectCell(0, 0);
        }
    }

    private void constructHorizontalLabels() {
        this.constructHorizontalLabels(null, null);
    }

    private void constructHorizontalLabels(String[] stringArray, int[] nArray) {
        int n;
        if (stringArray == null) {
            stringArray = new String[this.NumVisX];
            n = 0;
            while (n < this.NumVisX) {
                stringArray[n] = "" + Letters.charAt(n);
                ++n;
            }
        }
        if (nArray == null) {
            nArray = new int[this.NumVisX];
            n = 0;
            while (n < this.NumVisX) {
                nArray[n] = 250;
                ++n;
            }
        }
        Object object = this.Lock;
        synchronized (object) {
            this.HorizPanel.setLayout(new SSLayout(2 * this.NumVisX, 1, 0, 0));
            this.HorizLabel = new JPanel[this.NumVisX];
            this.HorizDrag = new JComponent[this.NumVisX];
            int n2 = 0;
            while (n2 < this.NumVisX) {
                this.HorizLabel[n2] = new JPanel();
                this.HorizLabel[n2].setBorder(new LineBorder(Color.black, 1));
                this.HorizLabel[n2].setLayout(new BorderLayout());
                this.HorizLabel[n2].setPreferredSize(new Dimension(nArray[n2], 20));
                this.HorizLabel[n2].add("Center", new JLabel(stringArray[n2], 0));
                this.HorizPanel.add(this.HorizLabel[n2]);
                this.HorizDrag[n2] = new JComponent(this){
                    private final /* synthetic */ SpreadSheet this$0;

                    public void paint(Graphics graphics) {
                        Dimension dimension = this.getSize();
                        graphics.setColor(Color.black);
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                        graphics.setColor(Color.yellow);
                        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(5, 20);
                    }
                    {
                        this.this$0 = spreadSheet;
                        this.constructor$0(spreadSheet);
                    }

                    private final void constructor$0(SpreadSheet spreadSheet) {
                    }
                };
                this.HorizDrag[n2].setPreferredSize(new Dimension(5, 0));
                this.HorizDrag[n2].addMouseListener(this);
                this.HorizDrag[n2].addMouseMotionListener(this);
                this.HorizPanel.add(this.HorizDrag[n2]);
                ++n2;
            }
        }
    }

    private void constructVerticalLabels() {
        this.constructVerticalLabels(null, null);
    }

    private void constructVerticalLabels(String[] stringArray, int[] nArray) {
        int n;
        if (stringArray == null) {
            stringArray = new String[this.NumVisY];
            n = 0;
            while (n < this.NumVisY) {
                stringArray[n] = "" + (n + 1);
                ++n;
            }
        }
        if (nArray == null) {
            nArray = new int[this.NumVisY];
            n = 0;
            while (n < this.NumVisY) {
                nArray[n] = 250;
                ++n;
            }
        }
        Object object = this.Lock;
        synchronized (object) {
            this.VertPanel.setLayout(new SSLayout(1, 2 * this.NumVisY, 0, 0));
            this.VertLabel = new JPanel[this.NumVisY];
            this.VertDrag = new JComponent[this.NumVisY];
            int n2 = 0;
            while (n2 < this.NumVisY) {
                this.VertLabel[n2] = new JPanel();
                this.VertLabel[n2].setBorder(new LineBorder(Color.black, 1));
                this.VertLabel[n2].setLayout(new BorderLayout());
                this.VertLabel[n2].setPreferredSize(new Dimension(30, nArray[n2]));
                this.VertLabel[n2].add("Center", new JLabel(stringArray[n2], 0));
                this.VertPanel.add(this.VertLabel[n2]);
                this.VertDrag[n2] = new JComponent(this){
                    private final /* synthetic */ SpreadSheet this$0;

                    public void paint(Graphics graphics) {
                        Dimension dimension = this.getSize();
                        graphics.setColor(Color.black);
                        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                        graphics.setColor(Color.yellow);
                        graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(30, 5);
                    }
                    {
                        this.this$0 = spreadSheet;
                        this.constructor$0(spreadSheet);
                    }

                    private final void constructor$0(SpreadSheet spreadSheet) {
                    }
                };
                this.VertDrag[n2].setBackground(Color.white);
                this.VertDrag[n2].setPreferredSize(new Dimension(0, 5));
                this.VertDrag[n2].addMouseListener(this);
                this.VertDrag[n2].addMouseMotionListener(this);
                this.VertPanel.add(this.VertDrag[n2]);
                ++n2;
            }
        }
    }

    private void reconstructLabels(String[][] stringArray, int[] nArray, int[] nArray2) {
        String[] stringArray2 = new String[this.NumVisX];
        Object object = this.Lock;
        synchronized (object) {
            this.HorizPanel.removeAll();
            int n = 0;
            while (n < this.NumVisX) {
                stringArray2[n] = "" + stringArray[n][0].charAt(0);
                ++n;
            }
        }
        this.constructHorizontalLabels(stringArray2, nArray);
        String[] stringArray3 = new String[this.NumVisY];
        object = this.Lock;
        synchronized (object) {
            this.VertPanel.removeAll();
            int n = 0;
            while (n < this.NumVisY) {
                stringArray3[n] = stringArray[0][n].substring(1);
                ++n;
            }
        }
        this.constructVerticalLabels(stringArray3, nArray2);
    }

    protected void reconstructSpreadsheet(String[][] stringArray, int[] nArray, int[] nArray2, RemoteServer remoteServer) {
        int n;
        this.reconstructLabels(stringArray, nArray, nArray2);
        Object object = this.Lock;
        synchronized (object) {
            int n2;
            this.DisplayPanel.removeAll();
            if (this.DisplayCells == null) {
                n = 0;
                n2 = 0;
            } else {
                n = this.DisplayCells.length;
                n2 = this.DisplayCells[0].length;
            }
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    try {
                        String string = this.DisplayCells[n3][n4].getName();
                        boolean bl = true;
                        int n5 = 0;
                        while (n5 < stringArray.length) {
                            int n6 = 0;
                            while (n6 < stringArray[n5].length) {
                                if (string.equals(stringArray[n5][n6])) {
                                    bl = false;
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                        if (bl) {
                            this.DisplayCells[n3][n4].destroyCell();
                        }
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot destroy cell (7)", visADException, "VisAD SpreadSheet error");
                    }
                    catch (RemoteException remoteException) {
                        if (BasicSSCell.DEBUG) {
                            remoteException.printStackTrace();
                        }
                        this.displayErrorMessage("Cannot destroy cell (8)", remoteException, "VisAD SpreadSheet error");
                    }
                    this.DisplayCells[n3][n4] = null;
                    ++n4;
                }
                ++n3;
            }
        }
        this.constructSpreadsheetCells(stringArray, remoteServer);
        object = this.Lock;
        synchronized (object) {
            this.HorizPanel.doLayout();
            n = 0;
            while (n < this.NumVisX) {
                this.HorizLabel[n].doLayout();
                ++n;
            }
            this.VertPanel.doLayout();
            n = 0;
            while (n < this.NumVisY) {
                this.VertLabel[n].doLayout();
                ++n;
            }
            this.SCPane.doLayout();
            this.DisplayPanel.doLayout();
            this.refreshCells();
        }
    }

    private void reconstructHoriz(JPanel[] jPanelArray, JComponent[] jComponentArray, FancySSCell[][] fancySSCellArray) {
        Object object = this.Lock;
        synchronized (object) {
            this.HorizLabel = jPanelArray;
            this.HorizDrag = jComponentArray;
            this.HorizPanel.setLayout(new SSLayout(2 * this.NumVisX, 1, 0, 0));
            int n = 0;
            while (n < this.NumVisX) {
                this.HorizPanel.add(this.HorizLabel[n]);
                this.HorizPanel.add(this.HorizDrag[n]);
                ++n;
            }
            this.DisplayCells = fancySSCellArray;
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            n = 0;
            while (n < this.NumVisY) {
                int n2 = 0;
                while (n2 < this.NumVisX) {
                    this.DisplayPanel.add(this.DisplayCells[n2][n]);
                    ++n2;
                }
                ++n;
            }
            this.HorizPanel.validate();
            this.HorizLabels.validate();
            this.HorizLabels.repaint();
            n = 0;
            while (n < this.NumVisX) {
                this.HorizLabel[n].validate();
                ++n;
            }
            this.SCPane.validate();
            this.DisplayPanel.repaint();
            this.refreshCells();
        }
        this.synchColRow();
    }

    private void reconstructVert(JPanel[] jPanelArray, JComponent[] jComponentArray, FancySSCell[][] fancySSCellArray) {
        Object object = this.Lock;
        synchronized (object) {
            this.VertLabel = jPanelArray;
            this.VertDrag = jComponentArray;
            this.VertPanel.setLayout(new SSLayout(1, 2 * this.NumVisY, 0, 0));
            int n = 0;
            while (n < this.NumVisY) {
                this.VertPanel.add(this.VertLabel[n]);
                this.VertPanel.add(this.VertDrag[n]);
                ++n;
            }
            this.DisplayCells = fancySSCellArray;
            this.DisplayPanel.setLayout(new SSLayout(this.NumVisX, this.NumVisY, 5, 5));
            n = 0;
            while (n < this.NumVisY) {
                int n2 = 0;
                while (n2 < this.NumVisX) {
                    this.DisplayPanel.add(this.DisplayCells[n2][n]);
                    ++n2;
                }
                ++n;
            }
            this.VertPanel.validate();
            this.VertLabels.validate();
            this.VertLabels.repaint();
            n = 0;
            while (n < this.NumVisY) {
                this.VertLabel[n].validate();
                ++n;
            }
            this.SCPane.validate();
            this.DisplayPanel.repaint();
            this.refreshCells();
        }
        this.synchColRow();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals("3-D (Java3D)")) {
            this.setDim(1);
        } else if (string.equals("2-D (Java2D)")) {
            this.setDim(2);
        } else if (string.equals("2-D (Java3D)")) {
            this.setDim(3);
        } else if (string.equals("Auto-switch to 3-D")) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.setAutoSwitch(bl);
        } else if (string.equals("Auto-detect mappings")) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.setAutoDetect(bl);
        } else if (string.equals("Auto-display controls")) {
            boolean bl = itemEvent.getStateChange() == 1;
            this.setAutoShowControls(bl);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustable.getValue();
        if (adjustable.getOrientation() == 0) {
            this.HorizLabels.setViewPosition(new Point(n, 0));
        } else {
            this.VertLabels.setViewPosition(new Point(0, n));
        }
    }

    public void displayChanged(DisplayEvent displayEvent) {
        if (displayEvent.getId() == 1 && !displayEvent.isRemote()) {
            EventListener eventListener;
            String string;
            block10: {
                string = null;
                try {
                    eventListener = displayEvent.getDisplay();
                    string = eventListener.getName();
                    if (string.endsWith(".remote")) {
                        string = string.substring(0, string.length() - 7);
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block10;
                    remoteException.printStackTrace();
                }
            }
            eventListener = (FancySSCell)BasicSSCell.getSSCellByName(string);
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            while (n3 < this.NumVisY) {
                int n4 = 0;
                while (n4 < this.NumVisX) {
                    if (eventListener == this.DisplayCells[n4][n3]) {
                        n = n4;
                        n2 = n3;
                    }
                    ++n4;
                }
                ++n3;
            }
            if (BasicSSCell.DEBUG && (n < 0 || n2 < 0)) {
                System.err.println("Warning: an unknown display change occurred: display (" + string + ") has changed, but there is no " + "corresponding SSCell with that name!");
            }
            this.selectCell(n, n2);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.commandKey = true;
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.FormulaListener.actionPerformed(new ActionEvent(this.FormulaEditor, 0, ""));
        } else if (n == 8) {
            int n2;
            String string = this.FormulaText.getText();
            int n3 = this.FormulaText.getSelectionStart();
            if (n3 != (n2 = this.FormulaText.getSelectionEnd()) || n3 != 0) {
                int n4 = n3 == n2 ? n3 - 1 : n3;
                String string2 = string.substring(0, n4);
                String string3 = string.substring(n2);
                this.FormulaText.setText(string2 + string3);
                this.FormulaText.getCaret().setDot(n4);
            }
        } else if (n == 16) {
            this.shiftHeld = true;
        } else if (n == 37) {
            int n5 = this.FormulaText.getCaretPosition();
            if (this.shiftHeld) {
                if (n5 > 0) {
                    this.FormulaText.getCaret().moveDot(n5 - 1);
                }
            } else if (n5 > 0) {
                this.FormulaText.getCaret().setDot(n5 - 1);
            }
        } else if (n == 39) {
            int n6 = this.FormulaText.getCaretPosition();
            if (this.shiftHeld) {
                if (n6 < this.FormulaText.getText().length()) {
                    this.FormulaText.getCaret().moveDot(n6 + 1);
                }
            } else if (n6 < this.FormulaText.getText().length()) {
                this.FormulaText.getCaret().setDot(n6 + 1);
            }
        } else if (n == 36) {
            if (this.shiftHeld) {
                this.FormulaText.getCaret().moveDot(0);
            } else {
                this.FormulaText.getCaret().setDot(0);
            }
        } else if (n == 35) {
            if (this.shiftHeld) {
                this.FormulaText.getCaret().moveDot(this.FormulaText.getText().length());
            } else {
                this.FormulaText.getCaret().setDot(this.FormulaText.getText().length());
            }
        } else {
            this.commandKey = false;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftHeld = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!this.commandKey && !keyEvent.isActionKey() && c >= ' ') {
            int n = this.FormulaText.getSelectionStart();
            int n2 = this.FormulaText.getSelectionEnd();
            String string = this.FormulaText.getText();
            this.FormulaText.setText(string.substring(0, n) + c + string.substring(n2));
            this.FormulaText.getCaret().setDot(n + 1);
        }
        keyEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        int n = 0;
        while (n < this.NumVisY) {
            int n2 = 0;
            while (n2 < this.NumVisX) {
                if (component == this.DisplayCells[n2][n]) {
                    this.selectCell(n2, n);
                    return;
                }
                ++n2;
            }
            ++n;
        }
        this.oldX = mouseEvent.getX();
        this.oldY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Component component = mouseEvent.getComponent();
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.NumVisX) {
            if (component == this.HorizDrag[n3]) {
                bl = true;
                break;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.NumVisY) {
            if (component == this.VertDrag[n3]) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            this.synchLabelAndCellSizes();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 0;
        while (n3 < this.NumVisX) {
            if (component == this.HorizDrag[n3]) {
                Dimension dimension = this.HorizLabel[n3].getSize();
                int n4 = dimension.width;
                dimension.width += n - this.oldX;
                if (dimension.width < 120) {
                    dimension.width = 120;
                }
                this.HorizLabel[n3].setSize(dimension);
                this.HorizLabel[n3].setPreferredSize(dimension);
                this.HorizLabels.validate();
                return;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.NumVisY) {
            if (component == this.VertDrag[n3]) {
                Dimension dimension = this.VertLabel[n3].getSize();
                int n5 = dimension.height;
                dimension.height += n2 - this.oldY;
                if (dimension.height < 120) {
                    dimension.height = 120;
                }
                this.VertLabel[n3].setSize(dimension);
                this.VertLabel[n3].setPreferredSize(dimension);
                this.VertLabels.validate();
                return;
            }
            ++n3;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void ssCellChanged(SSCellChangeEvent sSCellChangeEvent) {
        FancySSCell fancySSCell = (FancySSCell)sSCellChangeEvent.getSSCell();
        if (this.CurX < this.NumVisX && this.CurY < this.NumVisY && this.DisplayCells[this.CurX][this.CurY] == fancySSCell) {
            int n = sSCellChangeEvent.getChangeType();
            if (n == SSCellChangeEvent.DATA_CHANGE) {
                this.refreshFormulaBar();
                this.refreshMenuCommands();
            } else if (n == SSCellChangeEvent.DISPLAY_CHANGE) {
                this.refreshShowControls();
                if (this.IsSlave) {
                    this.refreshFormulaBar();
                    this.refreshMenuCommands();
                }
            } else if (n == SSCellChangeEvent.DIMENSION_CHANGE) {
                this.refreshDisplayMenuItems();
            }
        }
    }

    public static void setSSCellClass(Class clazz) {
        block2: {
            try {
                cellConstructor = clazz.getConstructor(cellArgs);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!BasicSSCell.DEBUG) break block2;
                noSuchMethodException.printStackTrace();
            }
        }
    }

    public void selectCell(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= this.NumVisX) {
            n = this.NumVisX - 1;
        }
        if (n2 >= this.NumVisY) {
            n2 = this.NumVisY - 1;
        }
        int n3 = 0;
        while (n3 < this.NumVisY) {
            int n4 = 0;
            while (n4 < this.NumVisX) {
                boolean bl = n == n4 && n2 == n3;
                this.DisplayCells[n4][n3].setSelected(bl);
                this.DisplayCells[n4][n3].setAutoShowControls(bl && this.AutoShowControls);
                ++n4;
            }
            ++n3;
        }
        this.CurX = n;
        this.CurY = n2;
        this.FormulaText.getCaret().setVisible(true);
        this.refreshFormulaBar();
        this.refreshMenuCommands();
        this.refreshDisplayMenuItems();
    }

    protected boolean getOptions(int n, int n2, String string, String string2, boolean bl) {
        SSOptions sSOptions = new SSOptions(n, n2, CanDo3D, BugFix, BasicSSCell.DEBUG, string, string2, bl);
        boolean[] blArray = new boolean[]{false};
        JDialog jDialog = new JDialog(null, "VisAD SpreadSheet Options", true);
        JPanel jPanel = new JPanel();
        jDialog.setContentPane(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel("Columns"));
        JTextField jTextField = new JTextField("" + n);
        Util.adjustTextField(jTextField);
        jTextField.setEnabled(string2 == null);
        jPanel3.add(jTextField);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(new JLabel(" x "));
        jPanel4.add(new JLabel(" x "));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(new JLabel("Rows"));
        JTextField jTextField2 = new JTextField("" + n2);
        Util.adjustTextField(jTextField2);
        jTextField2.setEnabled(string2 == null);
        jPanel5.add(jTextField2);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JCheckBox jCheckBox = new JCheckBox("Enable Java3D", CanDo3D);
        jCheckBox.setEnabled(Possible3D);
        jPanel6.add(jCheckBox);
        JCheckBox jCheckBox2 = new JCheckBox("Enable toolbar", !BugFix);
        jPanel6.add(jCheckBox2);
        JCheckBox jCheckBox3 = new JCheckBox("Debug mode", BasicSSCell.DEBUG);
        jPanel6.add(jCheckBox3);
        jPanel2.add(jPanel6);
        jPanel.add(jPanel2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Server");
        jRadioButton.setSelected(string != null && string2 == null);
        buttonGroup.add(jRadioButton);
        jPanel7.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton("Clone");
        jRadioButton2.setSelected(string2 != null && !bl);
        buttonGroup.add(jRadioButton2);
        jPanel7.add(jRadioButton2);
        JRadioButton jRadioButton3 = new JRadioButton("Slave");
        jRadioButton3.setSelected(bl);
        buttonGroup.add(jRadioButton3);
        jPanel7.add(jRadioButton3);
        JRadioButton jRadioButton4 = new JRadioButton("Stand-alone");
        jRadioButton4.setSelected(string == null && string2 == null);
        buttonGroup.add(jRadioButton4);
        jPanel7.add(jRadioButton4);
        jPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.add(new JLabel("Server name "));
        JTextField jTextField3 = new JTextField(string == null ? "" : string);
        Util.adjustTextField(jTextField3);
        jTextField3.setEnabled(string != null);
        jPanel8.add(jTextField3);
        jPanel.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.add(new JLabel("Server address "));
        JTextField jTextField4 = new JTextField(string2 == null ? "" : string2);
        Util.adjustTextField(jTextField4);
        jTextField4.setEnabled(string2 != null);
        jPanel9.add(jTextField4);
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        boolean bl2 = true;
        String string3 = "Extras: ";
        if (Possible3D) {
            string3 = string3 + (bl2 ? "" : ", ") + "Java3D";
            bl2 = false;
        }
        if (CanDoHDF5) {
            string3 = string3 + (bl2 ? "" : ", ") + "HDF-5";
            bl2 = false;
        }
        if (CanDoJPEG) {
            string3 = string3 + (bl2 ? "" : ", ") + "JPEG snapshot";
            bl2 = false;
        }
        if (CanDoPython) {
            string3 = string3 + (bl2 ? "" : ", ") + "JPython scripting";
            bl2 = false;
        }
        if (bl2) {
            string3 = string3 + "None";
        }
        string3 = string3 + ".";
        jPanel10.add(new JLabel(string3));
        jPanel.add(jPanel10);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        JButton jButton = new JButton("Ok");
        jDialog.getRootPane().setDefaultButton(jButton);
        jPanel11.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jPanel11.add(jButton2);
        JButton jButton3 = new JButton("Quit");
        jPanel11.add(jButton3);
        jPanel.add(jPanel11);
        ActionListener actionListener = new ActionListener(this, jRadioButton, jTextField, jTextField2, jTextField3, jTextField4, jRadioButton2, jRadioButton3, jRadioButton4, jButton, sSOptions, jDialog, jCheckBox, jCheckBox2, jCheckBox3, blArray, jButton2, jButton3){
            private final /* synthetic */ SpreadSheet this$0;
            private final /* synthetic */ JRadioButton val$serverChoice;
            private final /* synthetic */ JTextField val$colField;
            private final /* synthetic */ JTextField val$rowField;
            private final /* synthetic */ JTextField val$name;
            private final /* synthetic */ JTextField val$host;
            private final /* synthetic */ JRadioButton val$cloneChoice;
            private final /* synthetic */ JRadioButton val$slaveChoice;
            private final /* synthetic */ JRadioButton val$aloneChoice;
            private final /* synthetic */ JButton val$ok;
            private final /* synthetic */ SSOptions val$options;
            private final /* synthetic */ JDialog val$dialog;
            private final /* synthetic */ JCheckBox val$java3d;
            private final /* synthetic */ JCheckBox val$toolBox;
            private final /* synthetic */ JCheckBox val$debugBox;
            private final /* synthetic */ boolean[] val$success;
            private final /* synthetic */ JButton val$cancel;
            private final /* synthetic */ JButton val$quit;

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.val$serverChoice) {
                    this.val$colField.setEnabled(true);
                    this.val$rowField.setEnabled(true);
                    this.val$name.setEnabled(true);
                    this.val$host.setEnabled(false);
                } else if (object == this.val$cloneChoice || object == this.val$slaveChoice) {
                    this.val$colField.setEnabled(false);
                    this.val$rowField.setEnabled(false);
                    this.val$name.setEnabled(true);
                    this.val$host.setEnabled(true);
                } else if (object == this.val$aloneChoice) {
                    this.val$colField.setEnabled(true);
                    this.val$rowField.setEnabled(true);
                    this.val$name.setEnabled(false);
                    this.val$host.setEnabled(false);
                } else if (object == this.val$ok) {
                    boolean bl = this.val$serverChoice.isSelected();
                    boolean bl2 = this.val$cloneChoice.isSelected();
                    boolean bl3 = this.val$slaveChoice.isSelected();
                    boolean bl4 = this.val$aloneChoice.isSelected();
                    if (bl2 || bl3) {
                        this.val$options.cols = 2;
                        this.val$options.rows = 2;
                    } else {
                        this.val$options.cols = 0;
                        try {
                            this.val$options.cols = Integer.parseInt(this.val$colField.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.val$options.cols <= 0) {
                            this.this$0.displayErrorMessage(this.val$dialog, "The columns field must contain a number greater than zero", null, "Invalid value");
                            return;
                        }
                        this.val$options.rows = 0;
                        try {
                            this.val$options.rows = Integer.parseInt(this.val$rowField.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (this.val$options.rows <= 0) {
                            this.this$0.displayErrorMessage(this.val$dialog, "The rows field must contain a number greater than zero", null, "Invalid value");
                            return;
                        }
                    }
                    this.val$options.enable3d = this.val$java3d.isSelected();
                    this.val$options.bugfix = !this.val$toolBox.isSelected();
                    this.val$options.debug = this.val$debugBox.isSelected();
                    this.val$options.name = bl4 ? null : this.val$name.getText();
                    this.val$options.address = bl2 || bl3 ? this.val$host.getText() : null;
                    this.val$options.slave = bl3;
                    this.this$0.NumVisX = this.val$options.cols;
                    this.this$0.NumVisY = this.val$options.rows;
                    CanDo3D = this.val$options.enable3d;
                    BasicSSCell.DEBUG = this.val$options.debug;
                    BugFix = this.val$options.bugfix;
                    this.this$0.serverName = this.val$options.name;
                    this.this$0.cloneAddress = this.val$options.address;
                    this.this$0.IsSlave = this.val$options.slave;
                    this.val$success[0] = true;
                    ((Component)this.val$dialog).setVisible(false);
                } else if (object == this.val$cancel) {
                    this.val$success[0] = false;
                    ((Component)this.val$dialog).setVisible(false);
                } else if (object == this.val$quit) {
                    System.exit(0);
                }
            }
            {
                this.val$serverChoice = jRadioButton;
                this.val$colField = jTextField;
                this.val$rowField = jTextField2;
                this.val$name = jTextField3;
                this.val$host = jTextField4;
                this.val$cloneChoice = jRadioButton2;
                this.val$slaveChoice = jRadioButton3;
                this.val$aloneChoice = jRadioButton4;
                this.val$ok = jButton;
                this.val$options = sSOptions;
                this.val$dialog = jDialog;
                this.val$java3d = jCheckBox;
                this.val$toolBox = jCheckBox2;
                this.val$debugBox = jCheckBox3;
                this.val$success = blArray;
                this.val$cancel = jButton2;
                this.val$quit = jButton3;
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        jRadioButton.addActionListener(actionListener);
        jRadioButton2.addActionListener(actionListener);
        jRadioButton3.addActionListener(actionListener);
        jRadioButton4.addActionListener(actionListener);
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jDialog.pack();
        Util.centerWindow(jDialog);
        ((Component)jDialog).setVisible(true);
        return blArray[0];
    }

    public JToolBar getToolbar() {
        return this.Toolbar;
    }

    protected FancySSCell createCell(String string, RemoteServer remoteServer) throws VisADException, RemoteException {
        Object var4_4;
        block9: {
            Object[] objectArray = new Object[]{string, this.fm, remoteServer, new Boolean(this.IsSlave), null, this};
            if (cellConstructor == null) {
                SpreadSheet.setSSCellClass(class$Lvisad$ss$FancySSCell != null ? class$Lvisad$ss$FancySSCell : (class$Lvisad$ss$FancySSCell = SpreadSheet.class$("visad.ss.FancySSCell")));
            }
            var4_4 = null;
            try {
                var4_4 = cellConstructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (BasicSSCell.DEBUG) {
                    illegalAccessException.printStackTrace();
                }
            }
            catch (InstantiationException instantiationException) {
                if (BasicSSCell.DEBUG) {
                    instantiationException.printStackTrace();
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!BasicSSCell.DEBUG) break block9;
                invocationTargetException.getTargetException().printStackTrace();
            }
        }
        if (!(var4_4 instanceof FancySSCell)) {
            if (BasicSSCell.DEBUG) {
                System.err.println("Cell constructor failed to produce a FancySSCell object!");
            }
            return null;
        }
        return var4_4;
    }

    protected void displayErrorMessage(String string, Exception exception, String string2) {
        this.displayErrorMessage(this, string, exception, string2);
    }

    protected void displayErrorMessage(Component component, String string, Exception exception, String string2) {
        String string3 = exception == null ? null : exception.getMessage();
        Component component2 = component;
        String string4 = string + (string3 == null ? "." : ": " + string3);
        String string5 = string2;
        BasicSSCell.invoke(false, new Runnable(this, component2, string4, string5){
            private final /* synthetic */ SpreadSheet this$0;
            private final /* synthetic */ Component val$c;
            private final /* synthetic */ String val$m;
            private final /* synthetic */ String val$t;

            public void run() {
                JOptionPane.showMessageDialog(this.val$c, this.val$m, this.val$t, 0);
            }
            {
                this.val$c = component;
                this.val$m = string;
                this.val$t = string2;
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
    }

    protected JButton addToolbarButton(String string, String string2, String string3, boolean bl, JComponent jComponent) {
        URL uRL = (class$Lvisad$ss$SpreadSheet != null ? class$Lvisad$ss$SpreadSheet : (class$Lvisad$ss$SpreadSheet = SpreadSheet.class$("visad.ss.SpreadSheet"))).getResource(string + ".gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon != null) {
            JButton jButton = new JButton(imageIcon);
            jButton.setAlignmentY(0.5f);
            jButton.setToolTipText(string2);
            jButton.addActionListener(this);
            jButton.setActionCommand(string3);
            jButton.setEnabled(bl);
            if (jComponent instanceof JPanel) {
                int n = imageIcon.getIconWidth() + 4;
                int n2 = imageIcon.getIconHeight() + 4;
                jButton.setPreferredSize(new Dimension(n, n2));
            }
            jComponent.add(jButton);
            return jButton;
        }
        return null;
    }

    public static void adjustTextField(JTextField jTextField) {
        Util.adjustTextField(jTextField);
    }

    public static void centerWindow(Window window) {
        Util.centerWindow(window);
    }

    static /* synthetic */ double access$0(SpreadSheet spreadSheet) {
        return spreadSheet.getColRowID();
    }

    static /* synthetic */ String[][] access$1(SpreadSheet spreadSheet) {
        return spreadSheet.getNewCellNames();
    }

    static /* synthetic */ void access$2(SpreadSheet spreadSheet) {
        spreadSheet.synchColRow();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SpreadSheet() {
        this(60, 80, 2, 2, null, null, "VisAD SpreadSheet", null, true);
    }

    public SpreadSheet(int n, int n2, int n3, int n4, String string, String string2, String string3) {
        this(n, n2, n3, n4, string, string2, string3, null, false);
    }

    public SpreadSheet(int n, int n2, int n3, int n4, String string, String string2, String string3, FormulaManager formulaManager) {
        this(n, n2, n3, n4, string, string2, string3, formulaManager, false);
    }

    public SpreadSheet(int n, int n2, int n3, int n4, String string, String string2, String string3, FormulaManager formulaManager, boolean bl) {
        super(true);
        Object object;
        JViewport jViewport;
        JViewport jViewport2;
        Serializable serializable;
        boolean bl2;
        this.bTitle = string3;
        this.NumVisX = n3;
        this.NumVisY = n4;
        this.fm = formulaManager;
        Possible3D = BasicSSCell.possible3D();
        CanDo3D = BasicSSCell.canDo3D();
        MappingDialog.initDialog();
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.quitProgram();
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
        ((Component)this).setBackground(Color.white);
        boolean bl3 = bl2 = string2 != null && string2.startsWith("slave:");
        if (bl2) {
            string2 = string2.substring(6);
        }
        if (string2 != null) {
            int n5 = string2.lastIndexOf("/");
            if (n5 < 0) {
                n5 = string2.lastIndexOf(":");
            }
            string = string2.substring(n5 + 1);
            string2 = string2.substring(0, n5);
        }
        this.serverName = string;
        this.cloneAddress = string2;
        this.IsSlave = bl2;
        CanDoHDF5 = false;
        if (!CanDoHDF5 && BasicSSCell.DEBUG) {
            System.err.println("Warning: HDF-5 library not found");
        }
        if (!(CanDoJPEG = Util.canDoJPEG()) && BasicSSCell.DEBUG) {
            System.err.println("Warning: JPEG codec not found");
        }
        if (!(CanDoPython = Util.canDoPython()) && BasicSSCell.DEBUG) {
            System.err.println("Warning: JPython not found");
        }
        this.SSFileDialog = new JFileChooser(System.getProperty("user.dir"));
        this.SSFileDialog.addChoosableFileFilter(new ExtensionFileFilter("ss", "SpreadSheet files"));
        if (bl) {
            this.getOptions(this.NumVisX, this.NumVisY, this.serverName, this.cloneAddress, this.IsSlave);
        }
        string2 = this.cloneAddress == null ? null : this.cloneAddress + "/" + this.serverName;
        string = this.cloneAddress == null ? this.serverName : null;
        RemoteServer remoteServer = null;
        String[][] stringArray = null;
        if (string2 != null) {
            boolean bl4 = true;
            System.out.print("Connecting to " + string2 + " ");
            while (stringArray == null && bl4) {
                SpreadSheet.snooze(1000L);
                System.out.print(".");
                try {
                    remoteServer = (RemoteServer)Naming.lookup("//" + string2);
                    this.RemoteCanDo3D = remoteServer.getDataReference("CanDo3D");
                    serializable = (Real)this.RemoteCanDo3D.getData();
                    if (((Real)serializable).getValue() == 0.0) {
                        CanDo3D = false;
                        BasicSSCell.disable3D();
                    }
                    this.RemoteColRow = remoteServer.getDataReference("ColRow");
                    stringArray = this.getNewCellNames();
                }
                catch (UnmarshalException unmarshalException) {
                    if (BasicSSCell.DEBUG) {
                        unmarshalException.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + string2 + ". The server is using an incompatible version of Java", null, "Failed to clone spreadsheet");
                    bl4 = false;
                }
                catch (MalformedURLException malformedURLException) {
                    if (BasicSSCell.DEBUG) {
                        malformedURLException.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + string2 + ". The server name is not valid", null, "Failed to clone spreadsheet");
                    bl4 = false;
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to clone the spreadsheet at " + string2 + ". An error occurred while downloading the necessary data", visADException, "Failed to clone spreadsheet");
                    bl4 = false;
                }
                catch (NotBoundException notBoundException) {
                    if (!BasicSSCell.DEBUG) continue;
                    notBoundException.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {
                    if (!BasicSSCell.DEBUG) continue;
                    nullPointerException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) continue;
                    remoteException.printStackTrace();
                }
            }
            if (bl4) {
                System.out.println(" done");
                this.bTitle = this.bTitle + " [" + (this.IsSlave ? "slaved" : "collaborative") + " mode: " + string2 + "]";
                this.IsRemote = true;
            } else {
                System.out.println(" failed");
                this.IsSlave = false;
                remoteServer = null;
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setContentPane(jPanel);
        this.addMenuItem("File", "Import data...", "loadDataSet", 'i');
        this.FileSave1 = this.addMenuItem("File", "Export data to netCDF...", "exportDataSetNetcdf", 'n', false);
        this.FileSave2 = this.addMenuItem("File", "Export serialized data...", "exportDataSetSerial", 's', false);
        this.FileSave3 = this.addMenuItem("File", "Export data to HDF-5...", "exportDataSetHDF5", 'h', false);
        this.FileSave4 = this.addMenuItem("File", "Export data to TIFF...", "exportDataSetTIFF", 't', false);
        this.addMenuSeparator("File");
        this.FileSnap = this.addMenuItem("File", "Take JPEG snapshot...", "captureImageJPEG", 'j', false);
        this.addMenuSeparator("File");
        this.addMenuItem("File", "Exit", "quitProgram", 'x');
        this.addMenuItem("Edit", "Cut", "cutCell", 't', !this.IsRemote);
        this.addMenuItem("Edit", "Copy", "copyCell", 'c', !this.IsRemote);
        this.EditPaste = this.addMenuItem("Edit", "Paste", "pasteCell", 'p', false);
        this.EditClear = this.addMenuItem("Edit", "Clear", "clearCell", 'l', false);
        this.addMenuItem("Setup", "New spreadsheet file", "newFile", 'n');
        this.addMenuItem("Setup", "Open spreadsheet file...", "openFile", 'o', !this.IsRemote);
        this.addMenuItem("Setup", "Save spreadsheet file", "saveFile", 's', !this.IsRemote);
        this.addMenuItem("Setup", "Save spreadsheet file as...", "saveAsFile", 'a', !this.IsRemote);
        this.CellDim3D3D = new JCheckBoxMenuItem("3-D (Java3D)", CanDo3D);
        this.addMenuItem("Cell", this.CellDim3D3D, "setDim3D", '3', CanDo3D);
        this.CellDim2D2D = new JCheckBoxMenuItem("2-D (Java2D)", !CanDo3D);
        this.addMenuItem("Cell", this.CellDim2D2D, "setDimJ2D", 'j', true);
        this.CellDim2D3D = new JCheckBoxMenuItem("2-D (Java3D)", false);
        this.addMenuItem("Cell", this.CellDim2D3D, "setDim2D", '2', CanDo3D);
        this.addMenuSeparator("Cell");
        this.addMenuItem("Cell", "Add data object", "formulaAdd", 'a');
        this.CellDel = this.addMenuItem("Cell", "Delete data object", "formulaDel", 'd', false);
        this.addMenuSeparator("Cell");
        this.CellPrint = this.addMenuItem("Cell", "Print cell...", "printCurrentCell", 'p', false);
        this.addMenuSeparator("Cell");
        this.CellEdit = this.addMenuItem("Cell", "Edit mappings...", "createMappings", 'e', false);
        this.CellReset = this.addMenuItem("Cell", "Reset orientation", "resetOrientation", 'r', false);
        this.CellShow = this.addMenuItem("Cell", "Show controls", "showControls", 's', false);
        this.LayAddCol = this.addMenuItem("Layout", "Add column", "addColumn", 'c');
        this.addMenuItem("Layout", "Add row", "addRow", 'r');
        this.LayDelCol = this.addMenuItem("Layout", "Delete column", "deleteColumn", 'l', this.NumVisX > 1);
        this.LayDelRow = this.addMenuItem("Layout", "Delete row", "deleteRow", 'w', this.NumVisY > 1);
        this.addMenuSeparator("Layout");
        this.addMenuItem("Layout", "Tile cells", "tileCells", 't');
        if (!CanDo3D) {
            this.AutoSwitch = false;
        }
        this.AutoSwitchBox = new JCheckBoxMenuItem("Auto-switch to 3-D", this.AutoSwitch && !this.IsRemote);
        this.addMenuItem("Options", this.AutoSwitchBox, "optionsSwitch", '3', CanDo3D && !this.IsRemote);
        this.AutoDetectBox = new JCheckBoxMenuItem("Auto-detect mappings", this.AutoDetect && !this.IsRemote);
        this.addMenuItem("Options", this.AutoDetectBox, "optionsDetect", 'm', !this.IsRemote);
        this.AutoShowBox = new JCheckBoxMenuItem("Auto-display controls", this.AutoShowControls && !this.IsSlave);
        this.addMenuItem("Options", this.AutoShowBox, "optionsDisplay", 'c', !this.IsSlave);
        if (!BugFix) {
            this.Toolbar = new JToolBar();
            this.Toolbar.setBackground(Color.lightGray);
            this.Toolbar.setBorder(new EtchedBorder());
            this.Toolbar.setFloatable(false);
            jPanel.add(this.Toolbar);
            this.addToolbarButton("open", "Import data", "loadDataSet", true, this.Toolbar);
            this.ToolSave = this.addToolbarButton("save", "Export data to netCDF", "exportDataSetNetcdf", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.addToolbarButton("cut", "Cut", "cutCell", !this.IsRemote, this.Toolbar);
            this.addToolbarButton("copy", "Copy", "copyCell", !this.IsRemote, this.Toolbar);
            this.ToolPaste = this.addToolbarButton("paste", "Paste", "pasteCell", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.Tool3D = this.addToolbarButton("3d", "3-D (Java3D)", "setDim3D", false, this.Toolbar);
            this.ToolJ2D = this.addToolbarButton("j2d", "2-D (Java2D)", "setDimJ2D", CanDo3D, this.Toolbar);
            this.Tool2D = this.addToolbarButton("2d", "2-D (Java3D)", "setDim2D", CanDo3D, this.Toolbar);
            this.Toolbar.addSeparator();
            this.ToolMap = this.addToolbarButton("mappings", "Edit mappings", "createMappings", false, this.Toolbar);
            this.ToolReset = this.addToolbarButton("reset", "Reset orientation", "resetOrientation", false, this.Toolbar);
            this.ToolShow = this.addToolbarButton("show", "Show controls", "showControls", false, this.Toolbar);
            this.Toolbar.addSeparator();
            this.addToolbarButton("tile", "Tile cells", "tileCells", true, this.Toolbar);
            this.Toolbar.add(Box.createHorizontalGlue());
        }
        serializable = new JPanel();
        ((JComponent)serializable).setPreferredSize(new Dimension(Integer.MAX_VALUE, 25));
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        ((JComponent)serializable).setBorder(new EtchedBorder());
        jPanel.add((Component)serializable);
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        if (!BugFix) {
            this.FormulaAdd = this.addToolbarButton("add", "Add data", "formulaAdd", true, (JComponent)serializable);
            this.FormulaDel = this.addToolbarButton("del", "Remove data", "formulaDel", true, (JComponent)serializable);
        }
        this.FormulaBox = new JComboBox();
        ((Container)serializable).add(this.FormulaBox);
        this.FormulaBox.setLightWeightPopupEnabled(false);
        this.FormulaBox.setEditable(true);
        this.FormulaEditor = this.FormulaBox.getEditor();
        this.FormulaListener = new ActionListener(this){
            private final /* synthetic */ SpreadSheet this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((String)this.this$0.FormulaEditor.getItem()).trim();
                try {
                    Object object;
                    String string2;
                    int n = 0;
                    int n2 = -1;
                    boolean bl = true;
                    int n3 = string.indexOf("d", 2);
                    int n4 = string.indexOf(":");
                    if (n3 > 0 && n4 > 0 && n3 < n4) {
                        int n5;
                        block13: {
                            string2 = string.substring(0, n3);
                            object = BasicSSCell.getSSCellByName(string2);
                            n5 = 0;
                            try {
                                n5 = Integer.parseInt(string.substring(n3 + 1, n4));
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) break block13;
                                numberFormatException.printStackTrace();
                            }
                        }
                        if (object == this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY] && n5 > 0) {
                            String string3 = string.substring(0, n4);
                            String string4 = ((BasicSSCell)object).getDataSource(string3);
                            if (string4 != null) {
                                ((BasicSSCell)object).removeData(string3);
                                String string5 = null;
                                int n6 = 0;
                                while (n6 < this.this$0.FormulaBox.getItemCount()) {
                                    String string6 = (String)this.this$0.FormulaBox.getItemAt(n6);
                                    if (string6.startsWith(string3 + ":")) {
                                        string5 = string6;
                                        break;
                                    }
                                    ++n6;
                                }
                                if (string5 != null) {
                                    this.this$0.FormulaBox.removeItem(string5);
                                }
                            }
                            n = n5;
                            string = string.substring(n4 + 1).trim();
                        }
                    }
                    string2 = this.this$0.DisplayCells[this.this$0.CurX][this.this$0.CurY].addDataSource(n, string, n2, bl);
                    object = string2 + ": " + string;
                    this.this$0.FormulaBox.addItem(object);
                    this.this$0.FormulaBox.setSelectedItem(object);
                    this.this$0.FormulaText.getCaret().setVisible(true);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.this$0.displayErrorMessage("Unable to compute data object from \"" + string + "\"", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.this$0.displayErrorMessage("Unable to compute data object from \"" + string + "\"", remoteException, "VisAD SpreadSheet error");
                }
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        this.FormulaEditor.addActionListener(this.FormulaListener);
        this.FormulaText = (JTextField)this.FormulaEditor.getEditorComponent();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(36, 0)));
        jPanel.add(jPanel2);
        this.HorizPanel = new JPanel(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width, 20);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        this.HorizPanel.setBackground(Color.white);
        this.constructHorizontalLabels();
        this.HorizLabels = jViewport2 = new JViewport(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getMinimumSize() {
                return new Dimension(0, 20);
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, 20);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 20);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        this.HorizLabels.setView(this.HorizPanel);
        jPanel2.add(this.HorizLabels);
        jPanel2.add(new JComponent(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getMinimumSize() {
                return new Dimension(6 + this.this$0.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(6 + this.this$0.SCPane.getVScrollbarWidth(), 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(6 + this.this$0.SCPane.getVScrollbarWidth(), 0);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.white);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBackground(Color.white);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel3.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel3.add(jPanel4);
        this.VertPanel = new JPanel(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(30, dimension.height);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        this.VertPanel.setBackground(Color.white);
        this.constructVerticalLabels();
        this.VertLabels = jViewport = new JViewport(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getMinimumSize() {
                return new Dimension(30, 0);
            }

            public Dimension getPreferredSize() {
                return new Dimension(30, 0);
            }

            public Dimension getMaximumSize() {
                return new Dimension(30, Integer.MAX_VALUE);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        };
        this.VertLabels.setView(this.VertPanel);
        jPanel4.add(this.VertLabels);
        jPanel4.add(new JComponent(this){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getMinimumSize() {
                return new Dimension(0, this.this$0.SCPane.getHScrollbarHeight());
            }

            public Dimension getPreferredSize() {
                return new Dimension(0, this.this$0.SCPane.getHScrollbarHeight());
            }

            public Dimension getMaximumSize() {
                return new Dimension(0, this.this$0.SCPane.getHScrollbarHeight());
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet);
            }

            private final void constructor$0(SpreadSheet spreadSheet) {
            }
        });
        this.ScrollPanel = new JPanel();
        this.ScrollPanel.setBackground(Color.white);
        this.ScrollPanel.setLayout(new BoxLayout(this.ScrollPanel, 0));
        jPanel3.add(this.ScrollPanel);
        jPanel3.add(Box.createRigidArea(new Dimension(6, 0)));
        this.SCPane = new ScrollPane(this, 1){
            private final /* synthetic */ SpreadSheet this$0;

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
            {
                this.this$0 = spreadSheet;
                this.constructor$0(spreadSheet, n);
            }

            private final void constructor$0(SpreadSheet spreadSheet, int n) {
            }
        };
        Adjustable adjustable = this.SCPane.getHAdjustable();
        Adjustable adjustable2 = this.SCPane.getVAdjustable();
        adjustable.setBlockIncrement(120);
        adjustable.setUnitIncrement(30);
        adjustable.addAdjustmentListener(this);
        adjustable2.setBlockIncrement(120);
        adjustable2.setUnitIncrement(30);
        adjustable2.addAdjustmentListener(this);
        this.ScrollPanel.add(this.SCPane);
        this.DisplayPanel = new Panel();
        this.DisplayPanel.setBackground(Color.darkGray);
        this.SCPane.add(this.DisplayPanel);
        String string4 = System.getProperty("os.name");
        if (!string4.startsWith("Windows")) {
            this.addKeyListener(this);
            this.SCPane.addKeyListener(this);
            this.ScrollPanel.addKeyListener(this);
            this.DisplayPanel.addKeyListener(this);
            this.FormulaBox.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ SpreadSheet this$0;

                public void focusGained(FocusEvent focusEvent) {
                    this.this$0.SCPane.requestFocus();
                }
                {
                    this.this$0 = spreadSheet;
                    this.constructor$0(spreadSheet);
                }

                private final void constructor$0(SpreadSheet spreadSheet) {
                }
            });
        }
        DataReferenceImpl dataReferenceImpl = null;
        if (string != null) {
            boolean bl5 = true;
            boolean bl6 = false;
            do {
                try {
                    this.rsi = new RemoteServerImpl();
                    Naming.rebind("///" + string, this.rsi);
                    break;
                }
                catch (ConnectException connectException) {
                    if (!bl6) {
                        try {
                            LocateRegistry.createRegistry(1099);
                            bl6 = true;
                        }
                        catch (RemoteException remoteException) {
                            if (BasicSSCell.DEBUG) {
                                connectException.printStackTrace();
                            }
                            this.displayErrorMessage("Unable to autostart rmiregistry. Please start rmiregistry before launching the SpreadSheet in server mode", null, "Failed to initialize RemoteServer");
                            bl5 = false;
                        }
                        continue;
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses. Make sure you are running rmiregistry before launching the SpreadSheet in server mode", null, "Failed to initialize RemoteServer");
                    bl5 = false;
                }
                catch (MalformedURLException malformedURLException) {
                    if (BasicSSCell.DEBUG) {
                        malformedURLException.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses. The name \"" + string + "\" is not valid", null, "Failed to initialize RemoteServer");
                    bl5 = false;
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    this.displayErrorMessage("Unable to export cells as RMI addresses", remoteException, "Failed to initialize RemoteServer");
                    bl5 = false;
                }
            } while (bl5);
            try {
                object = new DataReferenceImpl("CanDo3D");
                this.RemoteCanDo3D = new RemoteDataReferenceImpl((DataReferenceImpl)object);
                this.RemoteCanDo3D.setData(new Real(CanDo3D ? 1 : 0));
                this.rsi.addDataReference((RemoteDataReferenceImpl)this.RemoteCanDo3D);
                dataReferenceImpl = new DataReferenceImpl("ColRow");
                this.RemoteColRow = new RemoteDataReferenceImpl(dataReferenceImpl);
                this.rsi.addDataReference((RemoteDataReferenceImpl)this.RemoteColRow);
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                this.displayErrorMessage("Unable to export cells as RMI addresses. An error occurred setting up the necessary data", visADException, "Failed to initialize RemoteServer");
                bl5 = false;
            }
            catch (RemoteException remoteException) {
                if (BasicSSCell.DEBUG) {
                    remoteException.printStackTrace();
                }
                this.displayErrorMessage("Unable to export cells as RMI addresses. A remote error occurred setting up the necessary data", remoteException, "Failed to initialize RemoteServer");
                bl5 = false;
            }
            if (bl5) {
                this.bTitle = this.bTitle + " (" + string + ")";
            } else {
                this.rsi = null;
            }
        }
        if (remoteServer == null) {
            this.constructSpreadsheetCells(null);
        } else {
            this.NumVisX = stringArray.length;
            this.NumVisY = stringArray[0].length;
            this.reconstructLabels(stringArray, null, null);
            this.constructSpreadsheetCells(stringArray, remoteServer);
        }
        if (this.rsi != null) {
            this.synchColRow();
        }
        this.CollabID = this.DisplayCells[0][0].getRemoteId();
        if (this.rsi != null || this.IsRemote) {
            RemoteServer remoteServer2 = remoteServer;
            CellImpl cellImpl = new CellImpl(this, remoteServer2){
                private final /* synthetic */ SpreadSheet this$0;
                private /* synthetic */ RemoteServer val$frs;

                public void doAction() {
                    if (SpreadSheet.access$0(this.this$0) != this.this$0.CollabID) {
                        BasicSSCell.invoke(true, new Runnable(this, this.val$frs){
                            private final /* synthetic */ 11 this$0;
                            private final /* synthetic */ RemoteServer val$frs;
                            private final /* synthetic */ SpreadSheet this$1;

                            public void run() {
                                String[][] stringArray = SpreadSheet.access$1(this.this$1);
                                if (stringArray == null) {
                                    if (BasicSSCell.DEBUG) {
                                        System.out.println("Warning: could not obtain new spreadsheet dimensions!");
                                    }
                                    return;
                                }
                                int n = this.this$1.NumVisX;
                                int n2 = this.this$1.NumVisY;
                                this.this$1.NumVisX = stringArray.length;
                                this.this$1.NumVisY = stringArray[0].length;
                                if (this.this$1.NumVisX != n || this.this$1.NumVisY != n2) {
                                    this.this$1.reconstructSpreadsheet(stringArray, null, null, this.val$frs);
                                    if (!this.this$1.IsRemote) {
                                        SpreadSheet.access$2(this.this$1);
                                    }
                                }
                            }
                            {
                                this.val$frs = remoteServer;
                                this.this$0 = var1_1;
                                this.this$1 = 11.access$0(this.this$0);
                                this.constructor$0(var1_1);
                            }

                            private final void constructor$0(11 var1_1) {
                            }
                        });
                    }
                }

                static /* synthetic */ SpreadSheet access$0(11 var0) {
                    return var0.this$0;
                }
                {
                    this.val$frs = remoteServer;
                    this.this$0 = spreadSheet;
                    this.constructor$0(spreadSheet);
                }

                private final void constructor$0(SpreadSheet spreadSheet) {
                }
            };
            try {
                object = new RemoteCellImpl(cellImpl);
                ((RemoteActionImpl)object).addReference(this.RemoteColRow);
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
                this.displayErrorMessage("Remote cell error (1)", visADException, "VisAD SpreadSheet error");
            }
            catch (RemoteException remoteException) {
                try {
                    cellImpl.addReference(dataReferenceImpl);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    this.displayErrorMessage("Remote cell error (2)", visADException, "VisAD SpreadSheet error");
                }
                catch (RemoteException remoteException2) {
                    if (BasicSSCell.DEBUG) {
                        remoteException2.printStackTrace();
                    }
                    this.displayErrorMessage("Remote cell error (3)", remoteException2, "VisAD SpreadSheet error");
                }
            }
        }
        this.setTitle(this.bTitle);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n6 = (int)(0.01 * (double)n * (double)dimension.width);
        int n7 = (int)(0.01 * (double)n2 * (double)dimension.height);
        ((Component)this).setSize(n6, n7);
        Util.centerWindow(this);
        ((Component)this).setVisible(true);
        SpreadSheet.snooze(500L);
        this.FormulaText.getCaret().setVisible(true);
        this.tileCells();
    }

    static {
        matrix3D = new double[]{0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 1.0};
        matrix2D = new double[]{0.65, 0.0, 0.0, 0.0, 0.0, 0.65, 0.0, 0.0, 0.0, 0.0, 0.65, 0.0, 0.0, 0.0, 0.0, 1.0};
        matrixJ2D = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, 0.0};
    }

    public class SSOptions {
        public int cols;
        public int rows;
        public boolean enable3d;
        public boolean bugfix;
        public boolean debug;
        public String name;
        public String address;
        public boolean slave;

        public SSOptions(int n, int n2, boolean bl, boolean bl2, boolean bl3, String string, String string2, boolean bl4) {
            this.cols = n;
            this.rows = n2;
            this.enable3d = bl;
            this.bugfix = bl2;
            this.debug = bl3;
            this.name = string;
            this.address = string2;
            this.slave = bl4;
        }
    }
}

