/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CellImpl;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Real;
import visad.RealType;
import visad.ScalarType;
import visad.VisADException;
import visad.formula.FormulaManager;
import visad.formula.VRealType;
import visad.ss.BasicSSCell;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.util.DataUtility;

public class SSCellImpl
extends CellImpl {
    public static final Real TRUE = new Real(1.0);
    public static final Real FALSE = new Real(0.0);
    private SSCellData cellData;
    private DataReferenceImpl ref;
    private String cellName;
    private String varName;
    private String[] errors;
    private FormulaManager fm;
    private boolean inited = false;
    private int skipNotify = 1;
    private int skipErrors = 0;

    public boolean isInited() {
        return this.inited;
    }

    String[] getErrors() {
        return this.errors;
    }

    void skipNextNotify() {
        ++this.skipNotify;
    }

    void skipNextErrors() {
        ++this.skipErrors;
    }

    public synchronized void doAction() {
        Data data = this.ref.getData();
        if (this.skipErrors == 0) {
            this.cellData.setErrors(this.fm.getErrors(this.varName), true, false);
        } else {
            --this.skipErrors;
        }
        if (data != null) {
            Vector vector;
            block19: {
                this.cellData.ssCell.updateDisplay(true);
                vector = new Vector();
                try {
                    DataUtility.getScalarTypes(new Data[]{data}, vector, false, true);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block19;
                    remoteException.printStackTrace();
                }
            }
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    ScalarType scalarType = (ScalarType)vector.elementAt(n2);
                    if (scalarType instanceof RealType) {
                        RealType realType = (RealType)scalarType;
                        try {
                            this.fm.setThing(realType.getName(), VRealType.get(realType));
                        }
                        catch (VisADException visADException) {
                            if (BasicSSCell.DEBUG) {
                                visADException.printStackTrace();
                            }
                        }
                        catch (RemoteException remoteException) {
                            if (!BasicSSCell.DEBUG) break block20;
                            remoteException.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            if (this.skipNotify == 0) {
                try {
                    this.cellData.ssCell.sendMessage(6, this.varName, data);
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                }
            } else {
                --this.skipNotify;
            }
        } else {
            this.cellData.ssCell.updateDisplay();
        }
        BasicSSCell.updateDependencies();
        this.cellData.ssCell.notifySSCellListeners(SSCellChangeEvent.DATA_CHANGE, this.varName);
        this.inited = true;
    }

    public SSCellImpl(SSCellData sSCellData, DataReferenceImpl dataReferenceImpl, String string, boolean bl) throws VisADException, RemoteException {
        this.cellData = sSCellData;
        this.ref = dataReferenceImpl;
        this.cellName = sSCellData.ssCell.getName();
        this.varName = string;
        this.fm = sSCellData.ssCell.getFormulaManager();
        this.inited = false;
        if (!bl) {
            this.skipNextErrors();
        }
        this.addReference(dataReferenceImpl);
    }
}

