/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.rmi.RemoteException;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Real;
import visad.RemoteDataReferenceImpl;
import visad.VisADException;
import visad.formula.FormulaManager;
import visad.ss.BasicSSCell;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellImpl;

public class SSCellData {
    BasicSSCell ssCell;
    private int id;
    private DataReferenceImpl ref;
    private ConstantMap[] cmaps;
    private RemoteDataReferenceImpl remoteRef;
    private String source;
    private int type;
    private String cellName;
    private String varName;
    private String[] errors;
    private FormulaManager fm;
    boolean othersDepend;
    SSCellImpl cell;

    public int getId() {
        return this.id;
    }

    public Data getData() {
        return this.ref.getData();
    }

    public DataReferenceImpl getReference() {
        return this.ref;
    }

    public ConstantMap[] getConstantMaps() {
        return this.cmaps;
    }

    public RemoteDataReferenceImpl getRemoteReference() {
        return this.remoteRef;
    }

    public String getSource() {
        return this.source;
    }

    public int getSourceType() {
        return this.type;
    }

    public String getVariableName() {
        return this.varName;
    }

    public String[] getErrors() {
        return this.errors;
    }

    public boolean othersDepend() {
        return this.othersDepend;
    }

    public boolean isInited() {
        return this.cell.isInited();
    }

    public void setData(Data data) throws VisADException, RemoteException {
        this.setData(data, true);
    }

    void setData(Data data, boolean bl) throws VisADException, RemoteException {
        DataImpl dataImpl = data.local();
        if (!bl) {
            this.cell.skipNextNotify();
        }
        this.ref.setData(dataImpl);
    }

    public void setError(String string) {
        this.setErrors(new String[]{string}, true, true);
    }

    public void setErrors(String[] stringArray) {
        this.setErrors(stringArray, true, true);
    }

    void setErrors(String[] stringArray, boolean bl) {
        this.setErrors(stringArray, bl, true);
    }

    void setErrors(String[] stringArray, boolean bl, boolean bl2) {
        block5: {
            if (BasicSSCell.arraysEqual(this.errors, stringArray)) {
                return;
            }
            this.errors = stringArray;
            if (bl2) {
                this.ssCell.updateDisplay();
            }
            if (bl) {
                try {
                    this.ssCell.sendMessage(5, this.varName, BasicSSCell.stringsToTuple(stringArray));
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block5;
                    remoteException.printStackTrace();
                }
            }
        }
    }

    public void setDependencies(Real real) {
        this.othersDepend = real.equals(SSCellImpl.TRUE);
    }

    public void destroy() {
        block10: {
            block9: {
                try {
                    this.fm.setThing(this.varName, null);
                    if (this.id == 1) {
                        this.fm.setThing(this.cellName, null);
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!BasicSSCell.DEBUG) break block9;
                    remoteException.printStackTrace();
                }
            }
            try {
                this.cell.removeAllReferences();
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!BasicSSCell.DEBUG) break block10;
                remoteException.printStackTrace();
            }
        }
        this.cell.stop();
        this.cell = null;
        this.ssCell.notifySSCellListeners(SSCellChangeEvent.DATA_CHANGE, this.varName);
    }

    public SSCellData(int n, BasicSSCell basicSSCell, DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray, String string, int n2, boolean bl) throws VisADException, RemoteException {
        this.ssCell = basicSSCell;
        this.id = n;
        this.ref = dataReferenceImpl;
        this.remoteRef = new RemoteDataReferenceImpl(dataReferenceImpl);
        this.source = string;
        this.type = n2;
        this.cellName = basicSSCell.getName();
        this.varName = this.cellName + "d" + n;
        this.errors = new String[0];
        this.othersDepend = false;
        this.fm = basicSSCell.getFormulaManager();
        this.fm.setReference(this.varName, dataReferenceImpl);
        if (this.id == 1) {
            this.fm.setReference(this.cellName, dataReferenceImpl);
        }
        this.cell = new SSCellImpl(this, dataReferenceImpl, this.varName, bl);
    }
}

