/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.Display;
import visad.DisplayRealType;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.ss.BasicSSCell;
import visad.util.DataUtility;
import visad.util.Util;

public class MappingDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final Font Mono = new Font("Monospaced", 0, 11);
    private static final String[][] MapNames = new String[][]{{"X Axis", "Y Axis", "Z Axis", "X Offset", "Y Offset", "Z Offset"}, {"Latitude", "Longitude", "Radius", "Cyl Radius", "Cyl Azimuth", "Cyl Z Axis"}, {"Flow1 X", "Flow1 Y", "Flow1 Z", "Flow2 X", "Flow2 Y", "Flow2 Z"}, {"Flow1 Elevation", "Flow1 Azimuth", "Flow1 Radial", "Flow2 Elevation", "Flow2 Azimuth", "Flow2 Radial"}, {"Red", "Green", "Blue", "RGB", "RGBA", "Alpha"}, {"Cyan", "Magenta", "Yellow", "CMY", "Animation", "Iso-contour"}, {"Hue", "Saturation", "Value", "HSV", "Select Value", "Select Range"}, {"", "Text", "", "", "Shape", ""}};
    private static final DisplayRealType[][] MapTypes = new DisplayRealType[][]{{Display.XAxis, Display.YAxis, Display.ZAxis, Display.XAxisOffset, Display.YAxisOffset, Display.ZAxisOffset}, {Display.Latitude, Display.Longitude, Display.Radius, Display.CylRadius, Display.CylAzimuth, Display.CylZAxis}, {Display.Flow1X, Display.Flow1Y, Display.Flow1Z, Display.Flow2X, Display.Flow2Y, Display.Flow2Z}, {Display.Flow1Elevation, Display.Flow1Azimuth, Display.Flow1Radial, Display.Flow2Elevation, Display.Flow2Azimuth, Display.Flow2Radial}, {Display.Red, Display.Green, Display.Blue, Display.RGB, Display.RGBA, Display.Alpha}, {Display.Cyan, Display.Magenta, Display.Yellow, Display.CMY, Display.Animation, Display.IsoContour}, {Display.Hue, Display.Saturation, Display.Value, Display.HSV, Display.SelectValue, Display.SelectRange}, {null, Display.Text, null, null, Display.Shape, null}};
    private static final Point[] AlphaMaps = new Point[]{new Point(4, 4), new Point(4, 5)};
    private static final Point[] ThreeDMaps = new Point[]{new Point(0, 2), new Point(0, 5), new Point(1, 0), new Point(1, 5), new Point(2, 2), new Point(2, 5), new Point(3, 0), new Point(3, 3)};
    private static final int MapWidth = MapTypes[0].length;
    private static final int MapHeight = MapTypes.length;
    private static Image DRT = null;
    private static boolean Inited = false;
    private boolean Confirm;
    private ScalarMap[] ScalarMaps;
    private JComponent MathCanvas;
    private JScrollPane MathCanvasView;
    private JComponent CoordCanvas;
    private JScrollPane CoordCanvasView;
    private boolean CoordRefs;
    private JList MathList;
    private JComponent DisplayCanvas;
    private DefaultListModel CurMaps;
    private JList CurrentMaps;
    private JScrollPane CurrentMapsView;
    private JLabel description;
    private ScalarType[] MathTypes;
    private String[] Scalars;
    private int[] ScW;
    private Vector[] ScP;
    private int ScH;
    private Dimension StrSize;
    private Dimension CoordSize;
    private boolean[][][] Maps;
    private String[][][] CurMapLabel;
    private Object Lock;
    private boolean[][] Illegal;
    private Image MapTo;
    private MathType[] Types;
    private boolean AllowAlpha;
    private boolean Allow3D;
    private static /* synthetic */ Class class$Lvisad$ss$MappingDialog;

    public static void initDialog() {
        if (DRT == null) {
            URL uRL = (class$Lvisad$ss$MappingDialog != null ? class$Lvisad$ss$MappingDialog : (class$Lvisad$ss$MappingDialog = MappingDialog.class$("visad.ss.MappingDialog"))).getResource("display.gif");
            DRT = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        Inited = true;
    }

    private static String prettyCoordSys(MathType mathType) {
        String string = "";
        if (mathType instanceof FunctionType) {
            string = string + MappingDialog.pcsFunction((FunctionType)mathType);
        } else if (mathType instanceof SetType) {
            string = string + MappingDialog.pcsSet((SetType)mathType);
        } else if (mathType instanceof TupleType) {
            string = string + MappingDialog.pcsTuple((TupleType)mathType);
        }
        return string;
    }

    private static String pcsFunction(FunctionType functionType) {
        String string = "";
        RealTupleType realTupleType = functionType.getDomain();
        string = string + MappingDialog.pcsTuple(realTupleType);
        MathType mathType = functionType.getRange();
        string = string + MappingDialog.prettyCoordSys(mathType);
        return string;
    }

    private static String pcsSet(SetType setType) {
        RealTupleType realTupleType = setType.getDomain();
        return MappingDialog.pcsTuple(realTupleType);
    }

    private static String pcsTuple(TupleType tupleType) {
        String string = "";
        if (tupleType instanceof RealTupleType) {
            RealTupleType realTupleType;
            RealTupleType realTupleType2 = (RealTupleType)tupleType;
            CoordinateSystem coordinateSystem = realTupleType2.getCoordinateSystem();
            if (coordinateSystem != null && (realTupleType = coordinateSystem.getReference()) != null) {
                string = string + realTupleType2.prettyString() + " ==> " + realTupleType.prettyString() + "\n";
            }
        } else {
            int n = 0;
            while (n < tupleType.getDimension()) {
                MathType mathType = null;
                try {
                    mathType = tupleType.getComponent(n);
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
                if (mathType != null) {
                    string = string + MappingDialog.prettyCoordSys(mathType);
                }
                ++n;
            }
        }
        return string;
    }

    private static Point indexToPoint(int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < nArray.length && nArray[n4] <= n) {
            ++n4;
        }
        int n5 = n - nArray[n4 - 1];
        return new Point(n2 * n5 + 5, (n3 + 2) * (n4 - 1) + 6);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        String string = System.getProperty("os.name");
        int n = string.startsWith("Windows") ? 60 : 20;
        int n2 = dimension.width;
        int n3 = dimension.height;
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n2 > dimension2.width - n) {
            n2 = dimension2.width - n;
        }
        if (n3 > dimension2.height - n) {
            n3 = dimension2.height - n;
        }
        return new Dimension(n2, n3);
    }

    public void display() {
        this.pack();
        Util.centerWindow(this);
        ((Component)this).setVisible(true);
    }

    public ScalarMap[] getMaps() {
        return this.ScalarMaps;
    }

    public boolean okPressed() {
        return this.Confirm;
    }

    /*
     * Unable to fully structure code
     */
    private void sort(int var1_1, int var2_2) {
        var3_3 = var1_1;
        var4_4 = var2_2;
        var5_5 = this.Scalars[(var1_1 + var2_2) / 2].toLowerCase();
        ** GOTO lbl26
        {
            ++var3_3;
            do {
                if (var3_3 < var2_2 && this.Scalars[var3_3].toLowerCase().compareTo(var5_5) < 0) continue block0;
                while (var4_4 > var1_1 && this.Scalars[var4_4].toLowerCase().compareTo(var5_5) > 0) {
                    --var4_4;
                }
                if (var3_3 > var4_4) continue;
                var6_6 = this.MathTypes[var3_3];
                this.MathTypes[var3_3] = this.MathTypes[var4_4];
                this.MathTypes[var4_4] = var6_6;
                var7_7 = this.Scalars[var3_3];
                this.Scalars[var3_3] = this.Scalars[var4_4];
                this.Scalars[var4_4] = var7_7;
                var8_8 = this.ScW[var3_3];
                this.ScW[var3_3] = this.ScW[var4_4];
                this.ScW[var4_4] = var8_8;
                var9_9 = this.ScP[var3_3];
                this.ScP[var3_3] = this.ScP[var4_4];
                this.ScP[var4_4] = var9_9;
                ++var3_3;
                --var4_4;
lbl26:
                // 3 sources

            } while (var3_3 <= var4_4);
        }
        if (var1_1 < var4_4) {
            this.sort(var1_1, var4_4);
        }
        if (var3_3 < var2_2) {
            this.sort(var3_3, var2_2);
        }
    }

    void eraseBox(int n, int n2, Graphics graphics) {
        int n3 = 40 * n;
        int n4 = 40 * n2;
        graphics.setColor(Color.black);
        int n5 = 0;
        while (n5 < 40) {
            graphics.drawLine(n3, n4 + n5, n3 + n5, n4);
            graphics.drawLine(n3 + n5, n4 + 38, n3 + 38, n4 + n5);
            n5 += 2;
        }
    }

    void highlightBox(int n, int n2, Graphics graphics) {
        int n3 = 40 * n;
        int n4 = 40 * n2;
        int n5 = 11;
        int n6 = 29;
        graphics.setColor(Color.blue);
        graphics.drawRect(n3, n4, 39, 39);
        graphics.drawLine(n3, n4 + 11, n3 + 11, n4);
        graphics.drawLine(n3, n4 + 29, n3 + 29, n4);
        graphics.drawLine(n3 + 11, n4 + 39, n3 + 39, n4 + 11);
        graphics.drawLine(n3 + 29, n4 + 39, n3 + 39, n4 + 29);
        graphics.drawLine(n3 + 29, n4, n3 + 39, n4 + 11);
        graphics.drawLine(n3 + 11, n4, n3 + 39, n4 + 29);
        graphics.drawLine(n3, n4 + 11, n3 + 29, n4 + 39);
        graphics.drawLine(n3, n4 + 29, n3 + 11, n4 + 39);
    }

    private void clearAll() {
        this.CurrentMaps.clearSelection();
        this.CurMaps.removeAllElements();
        int n = 0;
        while (n < this.CurMapLabel.length) {
            int n2 = 0;
            while (n2 < MapHeight) {
                int n3 = 0;
                while (n3 < MapWidth) {
                    this.Maps[n][n2][n3] = false;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void updateDescriptionLabel(int n) {
        ScalarType scalarType = this.MathTypes[n];
        String string = "     " + this.Scalars[n];
        if (scalarType instanceof RealType) {
            String string2;
            String string3;
            RealType realType = (RealType)scalarType;
            Unit unit = realType.getDefaultUnit();
            Set set = realType.getDefaultSet();
            String string4 = string3 = unit == null ? "none" : unit.toString();
            if (set == null) {
                string2 = "none";
            } else {
                String string5 = set.getClass().getName();
                int n2 = string5.lastIndexOf(".");
                if (n2 >= 0) {
                    string5 = string5.substring(n2 + 1);
                }
                int n3 = set.getDimension();
                string2 = string5 + "(" + n3 + ")";
            }
            string = string + ": Unit=" + string3 + "; Set=" + string2;
        } else {
            string = string + " (text)";
        }
        this.description.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = this.Lock;
        synchronized (object) {
            if (string.equals("all")) {
                if (this.CurMaps.getSize() > 0) {
                    this.clearAll();
                    Graphics graphics = this.DisplayCanvas.getGraphics();
                    this.DisplayCanvas.paint(graphics);
                    graphics.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                }
            } else if (string.equals("sel")) {
                int[] nArray = this.CurrentMaps.getSelectedIndices();
                int n = nArray.length;
                int n2 = n - 1;
                while (n2 >= 0) {
                    String string2 = (String)this.CurMaps.getElementAt(nArray[n2]);
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < this.CurMapLabel.length && bl) {
                        int n4 = 0;
                        while (n4 < MapHeight && bl) {
                            int n5 = 0;
                            while (n5 < MapWidth && bl) {
                                if (this.CurMapLabel[n3][n4][n5] == string2) {
                                    this.Maps[n3][n4][n5] = false;
                                    bl = false;
                                }
                                ++n5;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    this.CurMaps.removeElementAt(nArray[n2]);
                    --n2;
                }
                if (n > 0) {
                    Graphics graphics = this.DisplayCanvas.getGraphics();
                    this.DisplayCanvas.paint(graphics);
                    graphics.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                }
            } else if (string.equals("detect")) {
                ScalarMap[] scalarMapArray = DataUtility.guessMaps(this.Types, this.Allow3D);
                if (this.CurMaps.getSize() > 0) {
                    this.clearAll();
                }
                if (scalarMapArray != null) {
                    int n = 0;
                    while (n < this.MathTypes.length) {
                        int n6 = 0;
                        while (n6 < MapHeight) {
                            int n7 = 0;
                            while (n7 < MapWidth) {
                                int n8 = 0;
                                while (n8 < scalarMapArray.length) {
                                    if (scalarMapArray[n8].getScalar() == this.MathTypes[n] && scalarMapArray[n8].getDisplayScalar() == MapTypes[n6][n7]) {
                                        this.Maps[n][n6][n7] = true;
                                        this.CurMaps.addElement(this.CurMapLabel[n][n6][n7]);
                                    }
                                    ++n8;
                                }
                                ++n7;
                            }
                            ++n6;
                        }
                        ++n;
                    }
                }
                Graphics graphics = this.DisplayCanvas.getGraphics();
                this.DisplayCanvas.paint(graphics);
                graphics.dispose();
                this.CurrentMaps.repaint();
                this.CurrentMapsView.validate();
            } else if (string.equals("done")) {
                boolean bl = true;
                int n = this.CurMaps.getSize();
                this.ScalarMaps = new ScalarMap[n];
                int n9 = 0;
                int n10 = 0;
                while (n10 < this.CurMapLabel.length) {
                    int n11 = 0;
                    while (n11 < MapHeight) {
                        int n12 = 0;
                        while (n12 < MapWidth) {
                            if (this.Maps[n10][n11][n12]) {
                                try {
                                    this.ScalarMaps[n9++] = new ScalarMap(this.MathTypes[n10], MapTypes[n11][n12]);
                                }
                                catch (VisADException visADException) {
                                    bl = false;
                                    JOptionPane.showMessageDialog(this, "The mapping (" + this.Scalars[n10] + " -> " + MapNames[n11][n12] + ") is not valid.", "Illegal mapping", 0);
                                }
                            }
                            ++n12;
                        }
                        ++n11;
                    }
                    ++n10;
                }
                if (bl) {
                    this.Confirm = true;
                    ((Component)this).setVisible(false);
                }
            } else if (string.equals("cancel")) {
                ((Component)this).setVisible(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = this.Lock;
        synchronized (object) {
            if (!listSelectionEvent.getValueIsAdjusting() && (JList)listSelectionEvent.getSource() == this.MathList) {
                Graphics graphics = this.DisplayCanvas.getGraphics();
                this.DisplayCanvas.paint(graphics);
                graphics.dispose();
                int n = this.MathList.getSelectedIndex();
                MDTuple mDTuple = (MDTuple)this.ScP[n].elementAt(0);
                Rectangle rectangle = new Rectangle(mDTuple.x, mDTuple.y, this.ScW[n], this.ScH);
                this.MathList.ensureIndexIsVisible(n);
                if (mDTuple.b) {
                    this.CoordCanvas.scrollRectToVisible(rectangle);
                } else {
                    this.MathCanvas.scrollRectToVisible(rectangle);
                }
                this.MathCanvas.repaint();
                if (this.CoordRefs) {
                    this.CoordCanvas.repaint();
                }
                this.updateDescriptionLabel(n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = this.Lock;
        synchronized (object) {
            Rectangle rectangle;
            int n;
            block17: {
                Component component = mouseEvent.getComponent();
                if (component == this.MathCanvas) {
                    Point point = mouseEvent.getPoint();
                    int n2 = 0;
                    block3: while (n2 < this.Scalars.length) {
                        int n3 = 0;
                        while (true) {
                            Rectangle rectangle2;
                            if (n3 >= this.ScP[n2].size()) {
                                ++n2;
                                continue block3;
                            }
                            MDTuple mDTuple = (MDTuple)this.ScP[n2].elementAt(n3);
                            if (!mDTuple.b && (rectangle2 = new Rectangle(mDTuple.x, mDTuple.y, this.ScW[n2], this.ScH)).contains(point)) {
                                this.MathList.setSelectedIndex(n2);
                                this.MathList.ensureIndexIsVisible(n2);
                                this.MathCanvas.scrollRectToVisible(rectangle2);
                                this.updateDescriptionLabel(n2);
                                return;
                            }
                            ++n3;
                        }
                    }
                } else if (component == this.DisplayCanvas) {
                    int n4 = mouseEvent.getX() / 40;
                    int n5 = mouseEvent.getY() / 40;
                    int n6 = this.MathList.getSelectedIndex();
                    if (n6 < 0) return;
                    if (n5 < 0) return;
                    if (n4 < 0) return;
                    if (n5 >= MapHeight) return;
                    if (n4 >= MapWidth) return;
                    if (this.Illegal[n5][n4]) return;
                    boolean bl = this.Maps[n6][n5][n4] = !this.Maps[n6][n5][n4];
                    if (this.Maps[n6][n5][n4]) {
                        this.CurMaps.addElement(this.CurMapLabel[n6][n5][n4]);
                    } else {
                        this.CurrentMaps.clearSelection();
                        this.CurMaps.removeElement(this.CurMapLabel[n6][n5][n4]);
                    }
                    Graphics graphics = this.DisplayCanvas.getGraphics();
                    graphics.setClip(40 * n4, 40 * n5, 41, 41);
                    this.DisplayCanvas.paint(graphics);
                    graphics.dispose();
                    this.CurrentMaps.repaint();
                    this.CurrentMapsView.validate();
                } else {
                    if (component != this.CoordCanvas) return;
                    Point point = mouseEvent.getPoint();
                    n = 0;
                    block5: while (n < this.Scalars.length) {
                        int n7 = 0;
                        while (true) {
                            if (n7 >= this.ScP[n].size()) {
                                ++n;
                                continue block5;
                            }
                            MDTuple mDTuple = (MDTuple)this.ScP[n].elementAt(n7);
                            if (!mDTuple.b || !(rectangle = new Rectangle(mDTuple.x, mDTuple.y, this.ScW[n], this.ScH)).contains(point)) {
                                ++n7;
                                continue;
                            }
                            break block17;
                            break;
                        }
                    }
                }
                return;
            }
            this.MathList.setSelectedIndex(n);
            this.MathList.ensureIndexIsVisible(n);
            this.CoordCanvas.scrollRectToVisible(rectangle);
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static /* synthetic */ JList access$0(MappingDialog mappingDialog) {
        return mappingDialog.MathList;
    }

    static /* synthetic */ Vector[] access$1(MappingDialog mappingDialog) {
        return mappingDialog.ScP;
    }

    static /* synthetic */ Font access$2() {
        return Mono;
    }

    static /* synthetic */ String[] access$3(MappingDialog mappingDialog) {
        return mappingDialog.Scalars;
    }

    static /* synthetic */ int[] access$4(MappingDialog mappingDialog) {
        return mappingDialog.ScW;
    }

    static /* synthetic */ int access$5(MappingDialog mappingDialog) {
        return mappingDialog.ScH;
    }

    static /* synthetic */ JComponent access$6(MappingDialog mappingDialog) {
        return mappingDialog.MathCanvas;
    }

    static /* synthetic */ Dimension access$7(MappingDialog mappingDialog) {
        return mappingDialog.StrSize;
    }

    static /* synthetic */ JComponent access$8(MappingDialog mappingDialog) {
        return mappingDialog.CoordCanvas;
    }

    static /* synthetic */ Dimension access$9(MappingDialog mappingDialog) {
        return mappingDialog.CoordSize;
    }

    static /* synthetic */ int access$10() {
        return MapHeight;
    }

    static /* synthetic */ Image access$11(MappingDialog mappingDialog) {
        return mappingDialog.MapTo;
    }

    static /* synthetic */ int access$12() {
        return MapWidth;
    }

    static /* synthetic */ boolean[][][] access$13(MappingDialog mappingDialog) {
        return mappingDialog.Maps;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MappingDialog(Frame frame, Data data, ScalarMap[] scalarMapArray, boolean bl, boolean bl2) {
        this(frame, new Data[]{data}, scalarMapArray, bl, bl2);
    }

    public MappingDialog(Frame frame, Data[] dataArray, ScalarMap[] scalarMapArray, boolean bl, boolean bl2) {
        Object object;
        int n;
        int n2;
        Object object2;
        Object object3;
        int n3;
        Object object4;
        Object object5;
        Serializable serializable;
        int n4;
        int n5;
        int n6;
        Vector vector;
        String string;
        String string2;
        JPanel jPanel;
        block51: {
            super(frame, "Set up data mappings", true);
            this.Confirm = false;
            this.Lock = new Object();
            this.Illegal = new boolean[MapHeight][MapWidth];
            this.Types = null;
            this.AllowAlpha = bl;
            this.Allow3D = bl2;
            ((Component)this).setBackground(Color.white);
            jPanel = new JPanel();
            this.setContentPane(jPanel);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            int n7 = dataArray.length;
            this.Types = new MathType[n7];
            string2 = "";
            string = "";
            int n8 = 0;
            while (n8 < n7) {
                block50: {
                    try {
                        Data data = dataArray[n8];
                        if (data == null) {
                            this.Types[n8] = null;
                        } else {
                            this.Types[n8] = data.getType();
                            string2 = string2 + this.Types[n8].prettyString() + "\n";
                            string = string + MappingDialog.prettyCoordSys(this.Types[n8]);
                        }
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!BasicSSCell.DEBUG) break block50;
                        remoteException.printStackTrace();
                    }
                }
                ++n8;
            }
            vector = new Vector();
            n6 = 0;
            try {
                n6 = DataUtility.getScalarTypes(dataArray, vector, true, true);
            }
            catch (VisADException visADException) {
                if (BasicSSCell.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!BasicSSCell.DEBUG) break block51;
                remoteException.printStackTrace();
            }
        }
        FontMetrics fontMetrics = this.getFontMetrics(Mono);
        this.ScH = fontMetrics.getHeight();
        int n9 = fontMetrics.stringWidth(" ");
        int n10 = 1;
        int n11 = -1;
        int n12 = 0;
        do {
            int n13;
            if ((n13 = string2.indexOf("\n", n11 + 1)) < 0) {
                n13 = string2.length();
            }
            if ((n5 = n9 * (n13 - n11)) > n10) {
                n10 = n5;
            }
            n11 = n13;
            ++n12;
        } while (n11 < string2.length());
        this.StrSize = new Dimension(n10, (this.ScH + 2) * n12 + 10);
        int[] nArray = new int[n12];
        n11 = -1;
        n5 = 0;
        while (n5 < n12) {
            nArray[n5] = n11 + 1;
            n11 = string2.indexOf("\n", n11 + 1);
            ++n5;
        }
        n10 = 1;
        n11 = -1;
        n12 = 0;
        do {
            if ((n4 = n9 * ((n5 = string.indexOf("\n", n11 + 1)) - n11)) > n10) {
                n10 = n4;
            }
            n11 = n5;
            ++n12;
        } while (n11 < string.length() - 1);
        this.CoordSize = new Dimension(n10, (this.ScH + 2) * n12 + 10);
        int[] nArray2 = new int[n12];
        n11 = -1;
        n4 = 0;
        while (n4 < n12) {
            nArray2[n4] = n11 + 1;
            n11 = string.indexOf("\n", n11 + 1);
            ++n4;
        }
        n4 = vector.size();
        int n14 = n4 - n6;
        this.MathTypes = new ScalarType[n14];
        this.Scalars = new String[n14];
        this.ScW = new int[n14];
        this.ScP = new Vector[n14];
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n15 = 0;
        boolean bl3 = false;
        n11 = -1;
        int n16 = 0;
        while (n16 < n4) {
            Point point;
            serializable = (ScalarType)vector.elementAt(n16);
            object5 = ((ScalarType)serializable).getName();
            if (vector.indexOf(serializable) == n16) {
                this.MathTypes[n15] = serializable;
                this.Scalars[n15] = object5;
                this.ScW[n15] = n9 * ((String)object5).length();
                this.ScP[n15] = new Vector();
                hashtable.put((String)object5, new Integer(n15));
                ++n15;
            }
            int n17 = (Integer)hashtable.get(object5);
            object4 = null;
            if (!bl3) {
                if ((n11 = string2.indexOf((String)object5, n11 + 1)) == -1) {
                    bl3 = true;
                } else {
                    point = MappingDialog.indexToPoint(n11, nArray, n9, this.ScH);
                    object4 = new MDTuple(point.x, point.y, false);
                }
            }
            if (bl3) {
                n11 = string.indexOf((String)object5, n11 + 1);
                point = MappingDialog.indexToPoint(n11, nArray2, n9, this.ScH);
                object4 = new MDTuple(point.x, point.y, true);
            }
            this.ScP[n17].add(object4);
            ++n16;
        }
        this.sort(0, n14 - 1);
        this.CoordRefs = !string.equals("");
        JLabel jLabel = new JLabel("MathType:");
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 0));
        jPanel.add((Component)serializable);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        if (this.CoordRefs) {
            object5 = new JLabel("CoordinateSystem references:");
            ((JComponent)object5).setAlignmentX(0.5f);
            jPanel.add((Component)object5);
        }
        object5 = new JPanel();
        ((Container)object5).setLayout(new BoxLayout((Container)object5, 0));
        jPanel.add((Component)object5);
        BufferedImage bufferedImage = new BufferedImage(this.StrSize.width, this.StrSize.height, 1);
        object4 = bufferedImage.getGraphics();
        ((Graphics)object4).setFont(Mono);
        ((Graphics)object4).setColor(Color.white);
        ((Graphics)object4).fillRect(0, 0, this.StrSize.width, this.StrSize.height);
        ((Graphics)object4).setColor(Color.black);
        int n18 = 0;
        while (n18 < nArray.length) {
            n3 = nArray[n18];
            int n19 = n18 < nArray.length - 1 ? nArray[n18 + 1] - 1 : string2.length();
            object3 = string2.substring(n3, n19);
            ((Graphics)object4).drawString((String)object3, 5, (this.ScH + 2) * (n18 + 1));
            ++n18;
        }
        ((Graphics)object4).dispose();
        this.MathCanvas = new JComponent(this, bufferedImage){
            private final /* synthetic */ MappingDialog this$0;
            private final /* synthetic */ BufferedImage val$ppImg;

            public void paint(Graphics graphics) {
                graphics.drawImage(this.val$ppImg, 0, 0, this);
                int n = MappingDialog.access$0(this.this$0).getSelectedIndex();
                if (n >= 0) {
                    int n2 = 0;
                    while (n2 < MappingDialog.access$1(this.this$0)[n].size()) {
                        MDTuple mDTuple = (MDTuple)MappingDialog.access$1(this.this$0)[n].elementAt(n2);
                        if (!mDTuple.b) {
                            graphics.setFont(MappingDialog.access$2());
                            String string = MappingDialog.access$3(this.this$0)[n];
                            int n3 = mDTuple.x;
                            int n4 = mDTuple.y;
                            graphics.setColor(Color.blue);
                            graphics.fillRect(mDTuple.x, mDTuple.y, MappingDialog.access$4(this.this$0)[n], MappingDialog.access$5(this.this$0));
                            graphics.setColor(Color.white);
                            graphics.drawString(string, mDTuple.x, mDTuple.y + MappingDialog.access$5(this.this$0) - 4);
                        }
                        ++n2;
                    }
                }
                Dimension dimension = MappingDialog.access$6(this.this$0).getSize();
                graphics.setColor(Color.white);
                graphics.fillRect(MappingDialog.access$7((MappingDialog)this.this$0).width, 0, dimension.width, dimension.height);
                graphics.fillRect(0, MappingDialog.access$7((MappingDialog)this.this$0).height, MappingDialog.access$7((MappingDialog)this.this$0).width, dimension.height);
            }
            {
                this.val$ppImg = bufferedImage;
                this.this$0 = mappingDialog;
                this.constructor$0(mappingDialog);
            }

            private final void constructor$0(MappingDialog mappingDialog) {
            }
        };
        this.MathCanvas.setMinimumSize(this.StrSize);
        this.MathCanvas.setPreferredSize(this.StrSize);
        this.MathCanvas.addMouseListener(this);
        this.MathCanvas.setBackground(Color.white);
        this.MathCanvasView = new JScrollPane(this.MathCanvas);
        this.MathCanvasView.setMinimumSize(new Dimension(0, 0));
        n18 = this.StrSize.height + 10;
        if (n18 < 70) {
            n18 = 70;
        }
        if (n18 > (n3 = Toolkit.getDefaultToolkit().getScreenSize().height / 2)) {
            n18 = n3;
        }
        this.MathCanvasView.setPreferredSize(new Dimension(0, n18));
        this.MathCanvasView.setBackground(Color.white);
        JScrollBar jScrollBar = this.MathCanvasView.getHorizontalScrollBar();
        object3 = this.MathCanvasView.getVerticalScrollBar();
        jScrollBar.setBlockIncrement(5 * this.ScH + 10);
        jScrollBar.setUnitIncrement(this.ScH + 2);
        ((JScrollBar)object3).setBlockIncrement(5 * this.ScH + 10);
        ((JScrollBar)object3).setUnitIncrement(this.ScH + 2);
        ((Container)serializable).add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.MathCanvasView);
        ((Container)serializable).add(jPanel2);
        ((Container)serializable).add(Box.createRigidArea(new Dimension(5, 0)));
        this.description = new JLabel(" ");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        jPanel3.add(this.description);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel.add(jPanel4);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add(jPanel5);
        if (this.CoordRefs) {
            object2 = new BufferedImage(this.CoordSize.width, this.CoordSize.height, 1);
            object4 = ((BufferedImage)object2).getGraphics();
            ((Graphics)object4).setFont(Mono);
            ((Graphics)object4).setColor(Color.white);
            ((Graphics)object4).fillRect(0, 0, this.CoordSize.width, this.CoordSize.height);
            ((Graphics)object4).setColor(Color.black);
            n2 = 0;
            while (n2 < nArray2.length) {
                n = nArray2[n2];
                int n20 = n2 < nArray2.length - 1 ? nArray2[n2 + 1] - 1 : string.length() - 1;
                object = string.substring(n, n20);
                ((Graphics)object4).drawString((String)object, 5, (this.ScH + 2) * (n2 + 1));
                ++n2;
            }
            ((Graphics)object4).dispose();
            this.CoordCanvas = new JComponent(this, (BufferedImage)object2){
                private final /* synthetic */ MappingDialog this$0;
                private final /* synthetic */ BufferedImage val$csImg;

                public void paint(Graphics graphics) {
                    graphics.drawImage(this.val$csImg, 0, 0, this);
                    int n = MappingDialog.access$0(this.this$0).getSelectedIndex();
                    if (n >= 0) {
                        int n2 = 0;
                        while (n2 < MappingDialog.access$1(this.this$0)[n].size()) {
                            MDTuple mDTuple = (MDTuple)MappingDialog.access$1(this.this$0)[n].elementAt(n2);
                            if (mDTuple.b) {
                                graphics.setFont(MappingDialog.access$2());
                                String string = MappingDialog.access$3(this.this$0)[n];
                                int n3 = mDTuple.x;
                                int n4 = mDTuple.y;
                                graphics.setColor(Color.blue);
                                graphics.fillRect(mDTuple.x, mDTuple.y, MappingDialog.access$4(this.this$0)[n], MappingDialog.access$5(this.this$0));
                                graphics.setColor(Color.white);
                                graphics.drawString(string, mDTuple.x, mDTuple.y + MappingDialog.access$5(this.this$0) - 4);
                            }
                            ++n2;
                        }
                    }
                    Dimension dimension = MappingDialog.access$8(this.this$0).getSize();
                    graphics.setColor(Color.white);
                    graphics.fillRect(MappingDialog.access$9((MappingDialog)this.this$0).width, 0, dimension.width, dimension.height);
                    graphics.fillRect(0, MappingDialog.access$9((MappingDialog)this.this$0).height, MappingDialog.access$9((MappingDialog)this.this$0).width, dimension.height);
                }
                {
                    this.val$csImg = bufferedImage;
                    this.this$0 = mappingDialog;
                    this.constructor$0(mappingDialog);
                }

                private final void constructor$0(MappingDialog mappingDialog) {
                }
            };
            this.CoordCanvas.setMinimumSize(this.CoordSize);
            this.CoordCanvas.setPreferredSize(this.CoordSize);
            this.CoordCanvas.addMouseListener(this);
            this.CoordCanvas.setBackground(Color.white);
            this.CoordCanvasView = new JScrollPane(this.CoordCanvas);
            this.CoordCanvasView.setMinimumSize(new Dimension(0, 0));
            this.CoordCanvasView.setPreferredSize(new Dimension(0, this.CoordSize.height));
            n2 = this.CoordSize.height + 10;
            if (n2 < 70) {
                n2 = 70;
            }
            if (n2 > (n = Toolkit.getDefaultToolkit().getScreenSize().height / 2)) {
                n2 = n;
            }
            this.CoordCanvasView.setPreferredSize(new Dimension(0, n2));
            this.CoordCanvasView.setBackground(Color.white);
            jScrollBar = this.CoordCanvasView.getHorizontalScrollBar();
            object3 = this.CoordCanvasView.getVerticalScrollBar();
            jScrollBar.setBlockIncrement(5 * this.ScH + 10);
            jScrollBar.setUnitIncrement(this.ScH + 2);
            ((JScrollBar)object3).setBlockIncrement(5 * this.ScH + 10);
            ((JScrollBar)object3).setUnitIncrement(this.ScH + 2);
            ((Container)object5).add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel jPanel6 = new JPanel();
            jPanel6.setBackground(Color.white);
            jPanel6.setLayout(new BoxLayout(jPanel6, 0));
            jPanel6.add(this.CoordCanvasView);
            ((Container)object5).add(jPanel6);
            ((Container)object5).add(Box.createRigidArea(new Dimension(5, 0)));
        }
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 1));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel4.add((Component)object2);
        this.CurMaps = new DefaultListModel();
        n2 = this.MathTypes.length;
        this.CurMaps.ensureCapacity(n2 * MapWidth * MapHeight);
        this.CurrentMaps = new JList(this.CurMaps);
        this.Maps = new boolean[n2][MapHeight][MapWidth];
        this.CurMapLabel = new String[n2][MapHeight][MapWidth];
        n = 0;
        while (n < n2) {
            int n21 = 0;
            while (n21 < MapHeight) {
                int n22 = 0;
                while (n22 < MapWidth) {
                    this.Maps[n][n21][n22] = false;
                    this.CurMapLabel[n][n21][n22] = this.Scalars[n] + " -> " + MapNames[n21][n22];
                    if (scalarMapArray != null) {
                        int n23 = 0;
                        while (n23 < scalarMapArray.length) {
                            if (scalarMapArray[n23].getScalar().equals(this.MathTypes[n]) && scalarMapArray[n23].getDisplayScalar().equals(MapTypes[n21][n22])) {
                                this.Maps[n][n21][n22] = true;
                                this.CurMaps.addElement(this.CurMapLabel[n][n21][n22]);
                            }
                            ++n23;
                        }
                    }
                    ++n22;
                }
                ++n21;
            }
            ++n;
        }
        this.MathList = new JList<String>(this.Scalars);
        this.MathList.addListSelectionListener(this);
        this.MathList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this, this.MathList){
            private final /* synthetic */ MappingDialog this$0;

            public Dimension getMinimumSize() {
                return new Dimension(0, 40 * MappingDialog.access$10() + 64);
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 40 * MappingDialog.access$10() + 64);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 40 * MappingDialog.access$10() + 64);
            }
            {
                this.this$0 = mappingDialog;
                this.constructor$0(mappingDialog, component);
            }

            private final void constructor$0(MappingDialog mappingDialog, Component component) {
            }
        };
        JLabel jLabel2 = new JLabel("Map from:");
        jLabel2.setAlignmentX(0.5f);
        ((Container)object2).add(jLabel2);
        ((Container)object2).add(jScrollPane);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        jPanel4.add((Component)object);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel jLabel3 = new JLabel("Map to:");
        jLabel3.setAlignmentX(0.5f);
        ((Container)object).add(jLabel3);
        if (!Inited) {
            MappingDialog.initDialog();
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(DRT, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n24 = 0;
        while (n24 < MapHeight) {
            int n25 = 0;
            while (n25 < MapWidth) {
                this.Illegal[n24][n25] = MapTypes[n24][n25] == null;
                ++n25;
            }
            ++n24;
        }
        if (!this.AllowAlpha) {
            n24 = 0;
            while (n24 < AlphaMaps.length) {
                Point point = AlphaMaps[n24];
                this.Illegal[point.x][point.y] = true;
                ++n24;
            }
        }
        if (!this.Allow3D) {
            n24 = 0;
            while (n24 < ThreeDMaps.length) {
                Point point = ThreeDMaps[n24];
                this.Illegal[point.x][point.y] = true;
                ++n24;
            }
        }
        this.MapTo = new BufferedImage(40 * MapWidth, 40 * MapHeight, 1);
        Graphics graphics = this.MapTo.getGraphics();
        graphics.drawImage(DRT, 0, 0, this);
        int n26 = 0;
        while (n26 < MapHeight) {
            int n27 = 0;
            while (n27 < MapWidth) {
                if (this.Illegal[n26][n27]) {
                    this.eraseBox(n27, n26, graphics);
                }
                ++n27;
            }
            ++n26;
        }
        graphics.dispose();
        this.DisplayCanvas = new JComponent(this){
            private final /* synthetic */ MappingDialog this$0;

            public void paint(Graphics graphics) {
                graphics.drawImage(MappingDialog.access$11(this.this$0), 0, 0, this);
                int n = MappingDialog.access$0(this.this$0).getSelectedIndex();
                if (n >= 0) {
                    int n2 = 0;
                    while (n2 < MappingDialog.access$12()) {
                        int n3 = 0;
                        while (n3 < MappingDialog.access$10()) {
                            if (MappingDialog.access$13(this.this$0)[n][n3][n2]) {
                                this.this$0.highlightBox(n2, n3, graphics);
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                }
            }

            public Dimension getMinimumSize() {
                return new Dimension(40 * MappingDialog.access$12(), 40 * MappingDialog.access$10());
            }

            public Dimension getPreferredSize() {
                return new Dimension(40 * MappingDialog.access$12(), 40 * MappingDialog.access$10());
            }

            public Dimension getMaximumSize() {
                return new Dimension(40 * MappingDialog.access$12(), 40 * MappingDialog.access$10());
            }
            {
                this.this$0 = mappingDialog;
                this.constructor$0(mappingDialog);
            }

            private final void constructor$0(MappingDialog mappingDialog) {
            }
        };
        this.DisplayCanvas.addMouseListener(this);
        ((Container)object).add(this.DisplayCanvas);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        ((Container)object).add(jPanel7);
        ((Container)object).add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel7.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Clear all");
        jButton.setAlignmentX(0.5f);
        jButton.setToolTipText("Clear all mappings from mappings box");
        jButton.setActionCommand("all");
        jButton.addActionListener(this);
        jPanel7.add(jButton);
        jPanel7.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton2 = new JButton("Clear selected");
        jButton2.setAlignmentX(0.5f);
        jButton2.setToolTipText("Clear selected mappings from mappings box");
        jButton2.setActionCommand("sel");
        jButton2.addActionListener(this);
        jPanel7.add(jButton2);
        jPanel7.add(Box.createHorizontalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        ((Container)object).add(jPanel8);
        jPanel8.add(Box.createHorizontalGlue());
        JButton jButton3 = new JButton("Done");
        jButton3.setAlignmentX(0.5f);
        jButton3.setToolTipText("Apply selected mappings");
        jButton3.setActionCommand("done");
        jButton3.addActionListener(this);
        jPanel8.add(jButton3);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton4 = new JButton("Cancel");
        jButton4.setAlignmentX(0.5f);
        jButton4.setToolTipText("Close dialog box without applying mappings");
        jButton4.setActionCommand("cancel");
        jButton4.addActionListener(this);
        jPanel8.add(jButton4);
        jPanel8.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton5 = new JButton("Detect");
        jButton5.setAlignmentX(0.5f);
        jButton5.setToolTipText("Automatically identify some good mappings");
        jButton5.setActionCommand("detect");
        jButton5.addActionListener(this);
        jPanel8.add(jButton5);
        jPanel8.add(Box.createHorizontalGlue());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel4.add(jPanel9);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        this.CurrentMaps.addListSelectionListener(this);
        this.CurrentMapsView = new JScrollPane(this, this.CurrentMaps){
            private final /* synthetic */ MappingDialog this$0;

            public Dimension getMinimumSize() {
                return new Dimension(0, 40 * MappingDialog.access$10() + 64);
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 40 * MappingDialog.access$10() + 64);
            }

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, 40 * MappingDialog.access$10() + 64);
            }
            {
                this.this$0 = mappingDialog;
                this.constructor$0(mappingDialog, component);
            }

            private final void constructor$0(MappingDialog mappingDialog, Component component) {
            }
        };
        JLabel jLabel4 = new JLabel("Current maps:");
        jLabel4.setAlignmentX(0.5f);
        jPanel9.add(jLabel4);
        jPanel9.add(this.CurrentMapsView);
    }

    class MDTuple {
        int x;
        int y;
        boolean b;

        MDTuple(int n, int n2, boolean bl) {
            this.x = n;
            this.y = n2;
            this.b = bl;
        }
    }
}

