/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayRealType;
import visad.MathType;
import visad.RemoteServer;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADForm;
import visad.formula.FormulaManager;
import visad.ss.BasicSSCell;
import visad.ss.MappingDialog;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.ss.SSCellListener;
import visad.util.DataUtility;
import visad.util.Util;

public class FancySSCell
extends BasicSSCell
implements SSCellListener {
    public static final Color DARK_RED = new Color(0.5f, 0.0f, 0.0f);
    public static final Color DARK_GREEN = new Color(0.0f, 0.5f, 0.0f);
    public static final Color DARK_BLUE = new Color(0.0f, 0.0f, 0.5f);
    public static final Color DARK_YELLOW = new Color(0.5f, 0.5f, 0.0f);
    public static final Color DARK_PURPLE = new Color(0.5f, 0.0f, 0.5f);
    public static final Color DARK_CYAN = new Color(0.0f, 0.5f, 0.5f);
    public static final Border B_EMPTY = new LineBorder(Color.gray, 3);
    public static final Border B_HIGHLIGHT = new LineBorder(Color.yellow, 3);
    public static final Border B_UNKNOWN = new LineBorder(DARK_PURPLE, 3);
    public static final Border B_DIRECT = new LineBorder(DARK_CYAN, 3);
    public static final Border B_URL = new LineBorder(DARK_GREEN, 3);
    public static final Border B_FORMULA = new LineBorder(DARK_RED, 3);
    public static final Border B_RMI = new LineBorder(DARK_BLUE, 3);
    public static final Border B_REMOTE = new LineBorder(DARK_YELLOW, 3);
    public static final Border B_MULTI = new CompoundBorder(new CompoundBorder(new LineBorder(DARK_RED), new LineBorder(DARK_GREEN)), new LineBorder(DARK_BLUE));
    protected static JFileChooser FileBox = Util.getVisADFileChooser();
    protected Frame Parent;
    protected JFrame WidgetFrame;
    protected boolean Selected = false;
    protected boolean AutoSwitch = true;
    protected boolean AutoDetect = true;
    protected boolean AutoShowControls = true;
    private Object MapLock = new Object();
    private int MapCount = 0;
    private boolean mapDialogUp = false;

    public void removeData(String string) throws VisADException, RemoteException {
        super.removeData(string);
        if (this.CellData.size() == 0) {
            this.clearWidgetFrame();
        }
    }

    public void loadDataSource(String string) {
        this.loadDataSource(string, -1);
    }

    public void loadDataSource(String string, int n) {
        String string2 = string;
        int n2 = n;
        FancySSCell fancySSCell = this;
        Runnable runnable = new Runnable(this, string2, n2, fancySSCell){
            private final /* synthetic */ FancySSCell this$0;
            private final /* synthetic */ String val$fsource;
            private final /* synthetic */ int val$ftype;
            private final /* synthetic */ BasicSSCell val$cell;

            public void run() {
                try {
                    this.val$cell.addDataSource(this.val$fsource, this.val$ftype);
                    if (!this.val$cell.hasData()) {
                        JOptionPane.showMessageDialog(this.this$0.Parent, "Unable to import data", "Error importing data", 0);
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(this.this$0.Parent, visADException.getMessage(), "Error importing data", 0);
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    JOptionPane.showMessageDialog(this.this$0.Parent, remoteException.getMessage(), "Error importing data", 0);
                }
            }
            {
                this.val$fsource = string;
                this.val$ftype = n;
                this.val$cell = basicSSCell;
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void loadDataDialog() {
        FileBox.setDialogType(0);
        if (FileBox.showOpenDialog(this.Parent) != 0) {
            return;
        }
        File file = FileBox.getSelectedFile();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this.Parent, file.getName() + " does not exist", "Cannot load file", 0);
            return;
        }
        this.loadDataSource(file.getAbsolutePath(), 1);
    }

    private File getSaveFile() {
        if (!this.hasData()) {
            JOptionPane.showMessageDialog(this.Parent, "This cell is empty.", "Nothing to save", 0);
            return null;
        }
        FileBox.setDialogType(1);
        if (FileBox.showSaveDialog(this.Parent) != 0) {
            return null;
        }
        return FileBox.getSelectedFile();
    }

    public void saveDataDialog(String string, Form form) {
        File file = this.getSaveFile();
        if (file == null) {
            return;
        }
        FancySSCell fancySSCell = this;
        String string2 = string;
        Form form2 = form;
        Runnable runnable = new Runnable(this, file, form2, string2, fancySSCell){
            private final /* synthetic */ FancySSCell this$0;
            private final /* synthetic */ File val$file;
            private final /* synthetic */ Form val$form;
            private final /* synthetic */ String val$fname;
            private final /* synthetic */ BasicSSCell val$cell;

            public void run() {
                String string = "Could not save the dataset to the file \"" + this.val$file.getName() + "\" in " + this.val$form.getName() + " format. ";
                try {
                    this.val$cell.saveData(this.val$fname, this.val$file.getAbsolutePath(), this.val$form);
                }
                catch (BadFormException badFormException) {
                    if (BasicSSCell.DEBUG) {
                        badFormException.printStackTrace();
                    }
                    string = string + "An error occurred: " + badFormException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                    string = string + "A remote error occurred: " + remoteException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
                catch (IOException iOException) {
                    if (BasicSSCell.DEBUG) {
                        iOException.printStackTrace();
                    }
                    string = string + "An I/O error occurred: " + iOException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    string = string + "An error occurred: " + visADException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
            }
            {
                this.val$file = file;
                this.val$form = form;
                this.val$fname = string;
                this.val$cell = basicSSCell;
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForMaps() {
        Object object = this.MapLock;
        synchronized (object) {
            while (true) {
                if (this.MapCount <= 0) {
                    return;
                }
                try {
                    this.MapLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) continue;
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    protected SSCellData addReferenceImpl(int n, DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray, String string, int n2, boolean bl, boolean bl2) throws VisADException, RemoteException {
        Object object = this.MapLock;
        synchronized (object) {
            ++this.MapCount;
        }
        return super.addReferenceImpl(n, dataReferenceImpl, constantMapArray, string, n2, bl, bl2);
    }

    public boolean confirmClear() {
        int n;
        return !this.othersDepend() || (n = JOptionPane.showConfirmDialog(null, "Other cells depend on this cell. Are you sure you want to clear it?", "Warning", 0)) == 0;
    }

    public boolean smartClear() throws VisADException, RemoteException {
        if (this.confirmClear()) {
            this.clearWidgetFrame();
            this.clearCell();
            return true;
        }
        return false;
    }

    public boolean smartDestroy() throws VisADException, RemoteException {
        if (this.confirmClear()) {
            this.clearWidgetFrame();
            this.destroyCell();
            return true;
        }
        return false;
    }

    public void setMapsAuto(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        if (this.AutoSwitch && scalarMapArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < scalarMapArray.length) {
                DisplayRealType displayRealType = scalarMapArray[n2].getDisplayScalar();
                if (displayRealType.equals(Display.ZAxis) || displayRealType.equals(Display.Latitude)) {
                    n = 2;
                }
                if ((displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.RGBA)) && n < 1) {
                    n = 1;
                }
                ++n2;
            }
            if (n == 2) {
                this.setDimension(1);
            } else if (n == 1 && this.Dim != 1) {
                this.setDimension(3);
            }
        }
        this.setMaps(scalarMapArray);
    }

    public void setMaps(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        super.setMaps(scalarMapArray);
        if (this.WidgetFrame.isVisible() || this.AutoShowControls) {
            this.showWidgetFrame();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMapDialog() {
        block11: {
            block10: {
                if (this.mapDialogUp) {
                    return;
                }
                this.mapDialogUp = true;
                try {
                    if (this.getDataCount() == 0) {
                        JOptionPane.showMessageDialog(this.Parent, "This cell has no data", "FancySSCell error", 0);
                        Object var2_1 = null;
                        this.mapDialogUp = false;
                        return;
                    }
                    MappingDialog mappingDialog = new MappingDialog(this.Parent, this.getData(), this.getMaps(), this.Dim != 2 || this.AutoSwitch, this.Dim == 1 || this.AutoSwitch);
                    mappingDialog.display();
                    if (!mappingDialog.okPressed()) {
                        break block10;
                    }
                    try {
                        this.setMapsAuto(mappingDialog.getMaps());
                    }
                    catch (VisADException visADException) {
                        if (BasicSSCell.DEBUG) {
                            visADException.printStackTrace();
                        }
                        JOptionPane.showMessageDialog(this.Parent, "This combination of mappings is not valid: " + visADException.getMessage(), "Cannot assign mappings", 0);
                    }
                    catch (RemoteException remoteException) {
                        if (BasicSSCell.DEBUG) {
                            remoteException.printStackTrace();
                        }
                        JOptionPane.showMessageDialog(this.Parent, "This combination of mappings is not valid: " + remoteException.getMessage(), "Cannot assign mappings", 0);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.mapDialogUp = false;
                    throw throwable;
                }
            }
            Object var2_2 = null;
            this.mapDialogUp = false;
            return;
        }
        Object var2_3 = null;
        this.mapDialogUp = false;
    }

    protected void autoDetectMappings() throws VisADException, RemoteException {
        if (this.AutoDetect) {
            boolean bl = this.Dim != 2 || this.AutoSwitch;
            int n = this.getDataCount();
            Data[] dataArray = this.getData();
            MathType[] mathTypeArray = new MathType[n];
            int n2 = 0;
            while (n2 < n) {
                Data data = dataArray[n2];
                mathTypeArray[n2] = data == null ? null : data.getType();
                ++n2;
            }
            ScalarMap[] scalarMapArray = DataUtility.guessMaps(mathTypeArray, bl);
            this.setMapsAuto(scalarMapArray);
        }
        Object object = this.MapLock;
        synchronized (object) {
            --this.MapCount;
            this.MapLock.notifyAll();
        }
    }

    public synchronized void showWidgetFrame() {
        if (this.VDisplay == null || this.CellData.size() == 0) {
            return;
        }
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ FancySSCell this$0;

            public void run() {
                Container container = this.this$0.VDisplay.getWidgetPanel();
                if (container != null && container.getComponentCount() > 0) {
                    this.this$0.WidgetFrame.setContentPane(container);
                    this.this$0.WidgetFrame.pack();
                    ((Component)this.this$0.WidgetFrame).setVisible(true);
                }
            }
            {
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        });
    }

    public void hideWidgetFrame() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ FancySSCell this$0;

            public void run() {
                ((Component)this.this$0.WidgetFrame).setVisible(false);
            }
            {
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        });
    }

    public void setBorderEnabled(boolean bl) {
        if (bl) {
            this.setSelected(this.Selected);
        } else {
            this.setBorder(null);
        }
    }

    public void setSelected(boolean bl) {
        if (this.Selected == bl) {
            return;
        }
        this.Selected = bl;
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ FancySSCell this$0;

            public void run() {
                FancySSCell.access$0(this.this$0, this.this$0.Selected);
                if (!this.this$0.Selected) {
                    this.this$0.hideWidgetFrame();
                } else if (this.this$0.AutoShowControls) {
                    this.this$0.showWidgetFrame();
                }
                this.this$0.refresh();
            }
            {
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        });
    }

    public synchronized void setAutoSwitch(boolean bl) {
        this.AutoSwitch = bl;
    }

    public synchronized void setAutoDetect(boolean bl) {
        this.AutoDetect = bl;
    }

    public synchronized void setAutoShowControls(boolean bl) {
        this.AutoShowControls = bl;
    }

    private void clearWidgetFrame() {
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ FancySSCell this$0;

            public void run() {
                ((Component)this.this$0.WidgetFrame).setVisible(false);
                JPanel jPanel = new JPanel();
                jPanel.add((Component)new JLabel("No controls"), "CENTER");
                this.this$0.WidgetFrame.setContentPane(jPanel);
            }
            {
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        });
    }

    private void setHighlighted(boolean bl) {
        if (bl) {
            this.setBorder(B_HIGHLIGHT);
        } else {
            int n = this.getDataCount();
            if (n == 0) {
                this.setBorder(B_EMPTY);
            } else if (n == 1) {
                int n2 = this.getDataSourceType(this.getFirstVariableName());
                if (n2 == 0) {
                    this.setBorder(B_DIRECT);
                } else if (n2 == 1) {
                    this.setBorder(B_URL);
                } else if (n2 == 2) {
                    this.setBorder(B_FORMULA);
                } else if (n2 == 3) {
                    this.setBorder(B_RMI);
                } else if (n2 == 4) {
                    this.setBorder(B_REMOTE);
                } else {
                    this.setBorder(B_UNKNOWN);
                }
            } else {
                this.setBorder(B_MULTI);
            }
        }
    }

    public void ssCellChanged(SSCellChangeEvent sSCellChangeEvent) {
        int n = sSCellChangeEvent.getChangeType();
        if (n == SSCellChangeEvent.DATA_CHANGE) {
            BasicSSCell.invoke(false, new Runnable(this){
                private final /* synthetic */ FancySSCell this$0;

                public void run() {
                    FancySSCell.access$0(this.this$0, this.this$0.Selected);
                }
                {
                    this.this$0 = fancySSCell;
                    this.constructor$0(fancySSCell);
                }

                private final void constructor$0(FancySSCell fancySSCell) {
                }
            });
            if (!this.IsRemote) {
                Data data;
                block14: {
                    data = null;
                    try {
                        data = (Data)this.fm.getThing(sSCellChangeEvent.getVariableName());
                    }
                    catch (ClassCastException classCastException) {
                        if (BasicSSCell.DEBUG) {
                            classCastException.printStackTrace();
                        }
                    }
                    catch (VisADException visADException) {
                        if (!BasicSSCell.DEBUG) break block14;
                        visADException.printStackTrace();
                    }
                }
                try {
                    if (data != null) {
                        this.autoDetectMappings();
                    }
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (BasicSSCell.DEBUG) {
                        remoteException.printStackTrace();
                    }
                }
            }
        } else if (n == SSCellChangeEvent.DISPLAY_CHANGE && this.IsRemote && this.AutoShowControls) {
            this.showWidgetFrame();
        }
    }

    public void captureDialog() {
        File file = this.getSaveFile();
        if (file == null) {
            return;
        }
        FancySSCell fancySSCell = this;
        Runnable runnable = new Runnable(this, file, fancySSCell){
            private final /* synthetic */ FancySSCell this$0;
            private final /* synthetic */ File val$f;
            private final /* synthetic */ BasicSSCell val$cell;

            public void run() {
                String string = "Could not save image snapshot to file \"" + this.val$f.getName() + "\" in JPEG format. ";
                try {
                    this.val$cell.captureImage(this.val$f);
                }
                catch (VisADException visADException) {
                    if (BasicSSCell.DEBUG) {
                        visADException.printStackTrace();
                    }
                    string = string + "An error occurred: " + visADException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
                catch (IOException iOException) {
                    if (BasicSSCell.DEBUG) {
                        iOException.printStackTrace();
                    }
                    string = string + "An I/O error occurred: " + iOException.getMessage();
                    JOptionPane.showMessageDialog(this.this$0.Parent, string, "Error saving data", 0);
                }
            }
            {
                this.val$f = file;
                this.val$cell = basicSSCell;
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public boolean getAutoSwitch() {
        return this.AutoSwitch;
    }

    public boolean getAutoDetect() {
        return this.AutoDetect;
    }

    public boolean getAutoShowControls() {
        return this.AutoShowControls;
    }

    public boolean hasControls() {
        if (this.VDisplay == null || this.CellData.size() == 0) {
            return false;
        }
        Container container = this.VDisplay.getWidgetPanel();
        if (container == null) {
            return false;
        }
        return container.getComponentCount() > 0;
    }

    public void loadDataRMI(String string) {
        this.loadDataSource(string, 3);
    }

    public synchronized void loadDataString(String string) {
        this.loadDataSource(string, 1);
    }

    public void loadDataURL(URL uRL) {
        this.loadDataSource(uRL.toString(), 1);
    }

    public void saveDataDialog(boolean bl) {
        block2: {
            try {
                Form form = bl ? new Plain() : new VisADForm();
                this.saveDataDialog(this.getFirstVariableName(), form);
            }
            catch (VisADException visADException) {
                if (!BasicSSCell.DEBUG) break block2;
                visADException.printStackTrace();
            }
        }
    }

    public void saveDataDialog(Form form) {
        this.saveDataDialog(this.getFirstVariableName(), form);
    }

    static /* synthetic */ void access$0(FancySSCell fancySSCell, boolean bl) {
        fancySSCell.setHighlighted(bl);
    }

    public FancySSCell(String string) throws VisADException, RemoteException {
        this(string, null, null, false, null, null);
    }

    public FancySSCell(String string, Frame frame) throws VisADException, RemoteException {
        this(string, null, null, false, null, frame);
    }

    public FancySSCell(String string, FormulaManager formulaManager, Frame frame) throws VisADException, RemoteException {
        this(string, formulaManager, null, false, null, frame);
    }

    public FancySSCell(String string, RemoteServer remoteServer, Frame frame) throws VisADException, RemoteException {
        this(string, null, remoteServer, false, null, frame);
    }

    public FancySSCell(String string, String string2, Frame frame) throws VisADException, RemoteException {
        this(string, null, null, false, string2, frame);
    }

    public FancySSCell(String string, FormulaManager formulaManager, RemoteServer remoteServer, String string2, Frame frame) throws VisADException, RemoteException {
        this(string, formulaManager, remoteServer, false, string2, frame);
    }

    public FancySSCell(String string, FormulaManager formulaManager, RemoteServer remoteServer, boolean bl, String string2, Frame frame) throws VisADException, RemoteException {
        super(string, formulaManager, remoteServer, bl, string2);
        this.Parent = frame;
        this.WidgetFrame = new JFrame("Controls (" + this.Name + ")");
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ FancySSCell this$0;

            public void run() {
                FancySSCell.access$0(this.this$0, false);
            }
            {
                this.this$0 = fancySSCell;
                this.constructor$0(fancySSCell);
            }

            private final void constructor$0(FancySSCell fancySSCell) {
            }
        });
        this.addSSCellListener(this);
    }
}

