/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.CellImpl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FieldImpl;
import visad.GraphicsModeControl;
import visad.GriddedSet;
import visad.MathType;
import visad.MessageEvent;
import visad.MessageListener;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.Real;
import visad.RemoteCellImpl;
import visad.RemoteData;
import visad.RemoteDataImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.RemoteSlaveDisplayImpl;
import visad.ScalarMap;
import visad.Set;
import visad.Text;
import visad.ThingReference;
import visad.Tuple;
import visad.ValueControl;
import visad.VisADException;
import visad.bom.ImageRendererJ3D;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADForm;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.ss.SSCellImpl;
import visad.ss.SSCellListener;
import visad.util.DataUtility;
import visad.util.SaveStringTokenizer;

public class BasicSSCell
extends JPanel
implements DisplayListener,
MessageListener {
    public static boolean DEBUG = false;
    public static int DEBUG_LEVEL = 2;
    protected static final Vector SSCellVector = new Vector();
    protected static int Saving = 0;
    protected static boolean Possible3D;
    protected static boolean CanDo3D;
    protected static final FormulaManager defaultFM;
    public static final int ADD_DATA = 0;
    public static final int ADD_SOURCE = 1;
    public static final int REMOVE_DATA = 2;
    public static final int SET_MAPS = 3;
    public static final int SET_DIM = 4;
    public static final int SET_ERRORS = 5;
    public static final int UPDATE_DATA = 6;
    public static final int UPDATE_DEPENDENCIES = 7;
    public static final int STATUS = 8;
    public static final int MAX_ID = 9;
    public static final String[] messages;
    protected static final int POLLING_INTERVAL = 100;
    public static final int UNKNOWN_SOURCE = -1;
    public static final int DIRECT_SOURCE = 0;
    public static final int URL_SOURCE = 1;
    public static final int FORMULA_SOURCE = 2;
    public static final int RMI_SOURCE = 3;
    public static final int REMOTE_SOURCE = 4;
    public static final int JAVA3D_3D = 1;
    public static final int JAVA2D_2D = 2;
    public static final int JAVA3D_2D = 3;
    private static final String j33 = "visad.java3d.DefaultDisplayRendererJ3D";
    private static final String j22 = "visad.java2d.DefaultDisplayRendererJ2D";
    private static final String j32 = "visad.java3d.TwoDDisplayRendererJ3D";
    private static final String jir = "visad.bom.ImageRendererJ3D";
    protected String Name;
    protected FormulaManager fm;
    protected Vector Servers = new Vector();
    protected DisplayImpl MDisplay = null;
    protected RemoteDisplay RemoteMDisplay = null;
    protected RemoteDisplay RemoteVDisplay = null;
    protected RemoteSlaveDisplayImpl RemoteVSlave = null;
    protected RemoteServer RemoteVServer = null;
    protected int CollabID = 0;
    protected boolean IsRemote;
    protected boolean IsSlave;
    protected boolean NewClient;
    protected int Loading = 0;
    protected Vector CellData = new Vector();
    protected DisplayImpl VDisplay;
    protected int Dim = -1;
    protected boolean HasMappings = false;
    protected Object Lock = new Object();
    protected Component VDPanel;
    protected String[] Errors;
    protected boolean HasDisplay = false;
    protected boolean DisplayEnabled = true;
    private JPanel WaitPanel = null;
    protected Vector SListen = new Vector();
    protected Vector DListen = new Vector();
    private static /* synthetic */ Class class$Lvisad$ColorControl;
    private static /* synthetic */ Class class$Lvisad$ContourControl;
    private static /* synthetic */ Class class$Lvisad$RangeControl;
    private static /* synthetic */ Class class$Lvisad$AnimationControl;
    private static /* synthetic */ Class class$Lvisad$ValueControl;

    public static BasicSSCell getSSCellByName(String string) {
        Vector vector = SSCellVector;
        synchronized (vector) {
            int n = SSCellVector.size();
            int n2 = 0;
            while (n2 < n) {
                BasicSSCell basicSSCell = (BasicSSCell)SSCellVector.elementAt(n2);
                if (string.equalsIgnoreCase(basicSSCell.Name)) {
                    BasicSSCell basicSSCell2 = basicSSCell;
                    Object var2_6 = null;
                    return basicSSCell2;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isSaving() {
        return Saving > 0;
    }

    public static Tuple stringsToTuple(String[] stringArray) {
        block7: {
            try {
                if (stringArray == null) {
                    return null;
                }
                int n = stringArray.length;
                if (n == 0) {
                    return null;
                }
                Data[] dataArray = new Text[n];
                int n2 = 0;
                while (n2 < n) {
                    dataArray[n2] = new Text(stringArray[n2]);
                    ++n2;
                }
                Tuple tuple = new Tuple(dataArray);
                return tuple;
            }
            catch (VisADException visADException) {
                if (DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block7;
                remoteException.printStackTrace();
            }
        }
        return null;
    }

    public static String[] tupleToStrings(Tuple tuple) {
        block6: {
            if (tuple == null) {
                return null;
            }
            int n = tuple.getDimension();
            try {
                String[] stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    Text text = (Text)tuple.getComponent(n2);
                    stringArray[n2] = text.getValue();
                    ++n2;
                }
                return stringArray;
            }
            catch (VisADException visADException) {
                if (DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block6;
                remoteException.printStackTrace();
            }
        }
        return null;
    }

    public static boolean arraysEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null && objectArray2 == null) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!objectArray[n].equals(objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static DataImpl makeLocal(Data data) {
        block5: {
            try {
                if (data != null) {
                    return data.local();
                }
            }
            catch (VisADException visADException) {
                if (DEBUG && DEBUG_LEVEL >= 3) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!DEBUG || DEBUG_LEVEL < 3) break block5;
                remoteException.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void invoke(boolean bl, Runnable runnable) {
        if (bl) {
            if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
                runnable.run();
                return;
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    if (!DEBUG || DEBUG_LEVEL < 3) return;
                    interruptedException.printStackTrace();
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!DEBUG) return;
                    invocationTargetException.getTargetException().printStackTrace();
                }
            }
            return;
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static boolean possible3D() {
        return Possible3D;
    }

    public static boolean canDo3D() {
        return CanDo3D;
    }

    public static boolean enable3D() {
        block8: {
            if (Possible3D) {
                CanDo3D = true;
            } else {
                CanDo3D = false;
                Possible3D = false;
                try {
                    DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("test");
                    CanDo3D = true;
                    Possible3D = true;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (DEBUG) {
                        noClassDefFoundError.printStackTrace();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (DEBUG) {
                        System.err.println("Warning: Java3D library not found");
                    }
                }
                catch (Exception exception) {
                    if (!DEBUG) break block8;
                    exception.printStackTrace();
                }
            }
        }
        return CanDo3D;
    }

    public static void disable3D() {
        CanDo3D = false;
    }

    public void addToRemoteServer(RemoteServerImpl remoteServerImpl) throws RemoteException {
        if (remoteServerImpl == null) {
            return;
        }
        if (this.IsRemote) {
            throw new RemoteException("Cannot add a cloned cell to a server");
        }
        Vector vector = this.Servers;
        synchronized (vector) {
            if (!this.Servers.contains(remoteServerImpl)) {
                remoteServerImpl.addDisplay((RemoteDisplayImpl)this.RemoteMDisplay);
                remoteServerImpl.addDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                Vector vector2 = this.CellData;
                synchronized (vector2) {
                    int n = this.CellData.size();
                    int n2 = 0;
                    while (n2 < n) {
                        SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                        remoteServerImpl.addDataReference(sSCellData.getRemoteReference());
                        ++n2;
                    }
                }
                this.Servers.add(remoteServerImpl);
            }
        }
    }

    public void removeFromRemoteServer(RemoteServerImpl remoteServerImpl) throws RemoteException {
        if (remoteServerImpl == null) {
            return;
        }
        if (this.IsRemote) {
            throw new RemoteException("Cannot remove a cloned cell from a server");
        }
        Vector vector = this.Servers;
        synchronized (vector) {
            if (this.Servers.contains(remoteServerImpl)) {
                remoteServerImpl.removeDisplay((RemoteDisplayImpl)this.RemoteMDisplay);
                remoteServerImpl.removeDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                Vector vector2 = this.CellData;
                synchronized (vector2) {
                    int n = this.CellData.size();
                    int n2 = 0;
                    while (n2 < n) {
                        SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                        remoteServerImpl.removeDataReference(sSCellData.getRemoteReference());
                        ++n2;
                    }
                }
                this.Servers.remove(remoteServerImpl);
            }
        }
    }

    void sendMessage(int n, String string, Data data) throws RemoteException {
        RemoteData remoteData = data instanceof RemoteData ? (RemoteData)data : new RemoteDataImpl((DataImpl)data);
        this.MDisplay.sendMessage(new MessageEvent(9 * this.CollabID + n, string, remoteData));
        if (DEBUG && DEBUG_LEVEL >= 2) {
            System.out.println(this.Name + "[" + this.CollabID + "]: sent " + messages[n] + ": msg=" + string + ", data=" + (data == null ? "null" : data.getClass().getName()));
        }
    }

    public void receiveMessage(MessageEvent messageEvent) throws RemoteException {
        block60: {
            Object object;
            int n = messageEvent.getId();
            int n2 = n % 9;
            int n3 = n / 9;
            if (n3 == this.CollabID && n2 != 7) {
                return;
            }
            String string = messageEvent.getString();
            RemoteData remoteData = messageEvent.getData();
            if (DEBUG && DEBUG_LEVEL >= 2) {
                object = BasicSSCell.makeLocal(remoteData);
                System.out.println(this.Name + "[" + this.CollabID + "]: received " + messages[n2] + " from " + n3 + ": msg=" + string + ", data=" + (object == null ? "null" : object.getClass().getName()));
            }
            try {
                if (n2 == 0) {
                    object = this.CellData;
                    synchronized (object) {
                        SSCellData sSCellData = this.addReferenceImpl(0, null, null, string, string.equals("") ? 0 : 1, false, false);
                        sSCellData.setData(remoteData, false);
                        break block60;
                    }
                }
                if (n2 == 1) {
                    object = this.CellData;
                    synchronized (object) {
                        int n4 = (int)((Real)BasicSSCell.makeLocal(remoteData)).getValue();
                        this.addDataSource(0, string, n4, false);
                        break block60;
                    }
                }
                if (n2 == 2) {
                    object = this.CellData;
                    synchronized (object) {
                        SSCellData sSCellData = this.getCellDataByName(string);
                        this.removeDataImpl(sSCellData, false, true);
                        break block60;
                    }
                }
                if (n2 == 3) {
                    if (!this.IsRemote) {
                        if (string == null) {
                            this.clearMaps();
                        } else {
                            this.setMaps(DataUtility.convertStringToMaps(string, this.getData(), true));
                        }
                    }
                    break block60;
                }
                if (n2 == 4) {
                    int n5 = (int)((Real)BasicSSCell.makeLocal(remoteData)).getValue();
                    if (string != null) {
                        if (this.IsRemote) {
                            this.beginWait(true);
                        } else {
                            this.setDimension(n5);
                        }
                    } else if (this.IsRemote) {
                        this.endWait(false);
                        this.setDimClone();
                    }
                    break block60;
                }
                if (n2 == 5) {
                    SSCellData sSCellData;
                    object = (Tuple)BasicSSCell.makeLocal(remoteData);
                    String[] stringArray = BasicSSCell.tupleToStrings((Tuple)object);
                    Vector vector = this.CellData;
                    synchronized (vector) {
                        sSCellData = this.getCellDataByName(string);
                    }
                    if (sSCellData != null) {
                        sSCellData.setErrors(stringArray, false);
                    }
                    break block60;
                }
                if (n2 == 6) {
                    Vector vector = this.CellData;
                    synchronized (vector) {
                        object = this.getCellDataByName(string);
                    }
                    ((SSCellData)object).cell.skipNextErrors();
                    ((SSCellData)object).setData(remoteData, false);
                    break block60;
                }
                if (n2 == 7) {
                    Vector vector = this.CellData;
                    synchronized (vector) {
                        object = this.getCellDataByName(string);
                    }
                    if (object != null) {
                        ((SSCellData)object).setDependencies((Real)BasicSSCell.makeLocal(remoteData));
                    }
                    break block60;
                }
                if (n2 == 8) {
                    if (string == null) {
                        if (!this.IsRemote || !this.NewClient) break block60;
                        object = (Tuple)BasicSSCell.makeLocal(remoteData);
                        if (object != null) {
                            Vector vector = this.CellData;
                            synchronized (vector) {
                                block61: {
                                    try {
                                        int n6 = ((Tuple)object).getDimension();
                                        int n7 = 0;
                                        while (n7 < n6) {
                                            Tuple tuple = (Tuple)BasicSSCell.makeLocal(((Tuple)object).getComponent(n7));
                                            Real real = (Real)BasicSSCell.makeLocal(tuple.getComponent(0));
                                            Data data = tuple.getComponent(1);
                                            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl(this.Name);
                                            dataReferenceImpl.setData(data);
                                            Text text = (Text)BasicSSCell.makeLocal(tuple.getComponent(2));
                                            Real real2 = (Real)BasicSSCell.makeLocal(tuple.getComponent(3));
                                            this.addReferenceImpl((int)real.getValue(), dataReferenceImpl, null, text.getValue(), (int)real2.getValue(), false, false);
                                            ++n7;
                                        }
                                    }
                                    catch (VisADException visADException) {
                                        if (DEBUG) {
                                            visADException.printStackTrace();
                                        }
                                    }
                                    catch (RemoteException remoteException) {
                                        if (!DEBUG) break block61;
                                        remoteException.printStackTrace();
                                    }
                                }
                            }
                        }
                        this.NewClient = false;
                        break block60;
                    }
                    if (this.IsRemote) break block60;
                    object = this.CellData;
                    synchronized (object) {
                        block62: {
                            try {
                                int n8 = this.CellData.size();
                                Data[] dataArray = new Data[n8];
                                int n9 = 0;
                                while (n9 < n8) {
                                    SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n9);
                                    Data[] dataArray2 = new Data[]{new Real(sSCellData.getId()), sSCellData.getData(), new Text(sSCellData.getSource()), new Real(sSCellData.getSourceType())};
                                    dataArray[n9] = new Tuple(dataArray2);
                                    ++n9;
                                }
                                this.sendMessage(8, null, n8 == 0 ? null : new Tuple(dataArray));
                            }
                            catch (VisADException visADException) {
                                if (DEBUG) {
                                    visADException.printStackTrace();
                                }
                            }
                            catch (RemoteException remoteException) {
                                if (!DEBUG) break block62;
                                remoteException.printStackTrace();
                            }
                        }
                        break block60;
                    }
                }
                if (DEBUG) {
                    this.warn("unknown message id (" + n2 + ") received.");
                }
            }
            catch (VisADException visADException) {
                if (!DEBUG) break block60;
                visADException.printStackTrace();
            }
        }
    }

    protected void setupServer() throws VisADException, RemoteException {
        this.MDisplay = new DisplayImplJ2D(this.Name + "_Messenger", null);
        this.RemoteMDisplay = new RemoteDisplayImpl(this.MDisplay);
        this.MDisplay.addMessageListener(this);
        this.CollabID = 0;
        this.setDimension(2);
    }

    protected void setupClient() throws VisADException, RemoteException {
        block2: {
            this.RemoteMDisplay = this.RemoteVServer.getDisplay(this.Name + "_Messenger");
            this.MDisplay = new DisplayImplJ2D(this.RemoteMDisplay, null);
            this.MDisplay.addMessageListener(this);
            try {
                this.CollabID = this.MDisplay.getConnectionID(this.RemoteMDisplay);
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block2;
                remoteException.printStackTrace();
            }
        }
        this.setDimClone();
        this.addDisplayListener(this);
        this.NewClient = true;
        this.sendMessage(8, "", null);
    }

    static void updateDependencies() {
        Vector vector = SSCellVector;
        synchronized (vector) {
            int n = SSCellVector.size();
            int n2 = 0;
            while (n2 < n) {
                BasicSSCell basicSSCell = (BasicSSCell)SSCellVector.elementAt(n2);
                if (!basicSSCell.isRemote()) {
                    Vector vector2 = basicSSCell.CellData;
                    synchronized (vector2) {
                        int n3 = basicSSCell.CellData.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            block16: {
                                SSCellData sSCellData = (SSCellData)basicSSCell.CellData.elementAt(n4);
                                if (!sSCellData.ssCell.isRemote()) {
                                    boolean bl;
                                    String string;
                                    block15: {
                                        string = sSCellData.getVariableName();
                                        bl = true;
                                        try {
                                            bl = basicSSCell.fm.canBeRemoved(string);
                                        }
                                        catch (FormulaException formulaException) {
                                            if (!DEBUG) break block15;
                                            formulaException.printStackTrace();
                                        }
                                    }
                                    if (bl == sSCellData.othersDepend) {
                                        try {
                                            sSCellData.ssCell.sendMessage(7, string, bl ? SSCellImpl.FALSE : SSCellImpl.TRUE);
                                        }
                                        catch (RemoteException remoteException) {
                                            if (!DEBUG) break block16;
                                            remoteException.printStackTrace();
                                        }
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public String addData(Data data) throws VisADException, RemoteException {
        return this.addData(0, data, null, "", 0, true);
    }

    public String addData(Data data, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        return this.addData(0, data, constantMapArray, "", 0, true);
    }

    protected String addData(int n, Data data, ConstantMap[] constantMapArray, String string, int n2, boolean bl) throws VisADException, RemoteException {
        SSCellData sSCellData;
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl(this.Name);
        dataReferenceImpl.setData(data);
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.addReferenceImpl(n, dataReferenceImpl, constantMapArray, string, n2, bl, true);
        }
        return sSCellData.getVariableName();
    }

    public String addReference(DataReferenceImpl dataReferenceImpl) throws VisADException, RemoteException {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.addReferenceImpl(0, dataReferenceImpl, null, "", 0, true, true);
        }
        return sSCellData.getVariableName();
    }

    public String addReference(DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.addReferenceImpl(0, dataReferenceImpl, constantMapArray, "", 0, true, true);
        }
        return sSCellData.getVariableName();
    }

    public String addDataSource(String string) throws VisADException, RemoteException {
        return this.addDataSource(0, string, -1, true);
    }

    public String addDataSource(String string, int n) throws VisADException, RemoteException {
        return this.addDataSource(0, string, n, true);
    }

    String addDataSource(int n, String string, int n2, boolean bl) throws VisADException, RemoteException {
        Object object;
        Object object2;
        String string2 = null;
        if (n2 == -1) {
            if (string.startsWith("rmi://")) {
                n2 = 3;
            } else if (string.startsWith("adde://")) {
                n2 = 1;
            } else {
                object2 = new File(string);
                if (((File)object2).exists()) {
                    n2 = 1;
                } else {
                    block55: {
                        object = null;
                        try {
                            object = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block55;
                            malformedURLException.printStackTrace();
                        }
                    }
                    n2 = object != null ? 1 : 2;
                }
            }
        }
        if (n2 == 0 || n2 == 4) {
            throw new VisADException("Invalid source type");
        }
        if (n2 == 1) {
            this.beginWait(true);
            object2 = null;
            boolean bl2 = true;
            try {
                block56: {
                    try {
                        DefaultFamily defaultFamily = new DefaultFamily("loader");
                        object2 = defaultFamily.open(string);
                        File file = new File(string);
                        if (!file.exists()) break block56;
                        String string3 = file.getAbsolutePath();
                        char[] cArray = string3.toCharArray();
                        int n3 = 0;
                        while (n3 < cArray.length) {
                            if (cArray[n3] == '\\') {
                                cArray[n3] = 47;
                            }
                            ++n3;
                        }
                        string3 = new String(cArray);
                        string = "file:" + (string3.startsWith("/") ? "" : "/") + string3;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        if (DEBUG) {
                            outOfMemoryError.printStackTrace();
                        }
                        bl2 = false;
                        throw new VisADException("Not enough memory to import the data.");
                    }
                    catch (BadFormException badFormException) {
                        if (DEBUG) {
                            badFormException.printStackTrace();
                        }
                        bl2 = false;
                        throw new VisADException("The source could not be converted to VisAD data.");
                    }
                    catch (VisADException visADException) {
                        if (DEBUG) {
                            visADException.printStackTrace();
                        }
                        bl2 = false;
                        throw visADException;
                    }
                }
                Object var9_31 = null;
                this.endWait(!bl2);
            }
            catch (Throwable throwable) {
                Object var9_32 = null;
                this.endWait(!bl2);
                throw throwable;
            }
            if (object2 == null) {
                throw new VisADException("Could not load data from source " + string);
            }
            string2 = this.addData(n, (Data)object2, null, string, 1, bl);
        } else if (n2 == 2) {
            object2 = this.CellData;
            synchronized (object2) {
                SSCellData sSCellData = this.addReferenceImpl(n, null, null, string, 2, false, false);
                string2 = sSCellData.getVariableName();
                if (!this.IsRemote) {
                    this.fm.assignFormula(string2, string);
                }
            }
            if (bl) {
                this.sendMessage(1, string, new Real(n2));
            }
        } else if (n2 == 3) {
            if (!string.startsWith("rmi://")) {
                throw new VisADException("RMI address must begin with rmi://");
            }
            object2 = new DataReferenceImpl(this.Name);
            Vector vector = this.CellData;
            synchronized (vector) {
                object = this.addReferenceImpl(n, (DataReferenceImpl)object2, null, string, 3, false, false);
                string2 = ((SSCellData)object).getVariableName();
            }
            if (!this.IsRemote) {
                this.beginWait(true);
                boolean bl3 = true;
                try {
                    try {
                        int n4 = string.length();
                        int n5 = string.lastIndexOf("/");
                        if (n5 < 6) {
                            n5 = n4;
                        }
                        String string4 = string.substring(4, n5);
                        String string5 = n5 < n4 - 1 ? string.substring(n5 + 1) : "";
                        RemoteServer remoteServer = null;
                        remoteServer = (RemoteServer)Naming.lookup(string4);
                        RemoteDataReference remoteDataReference = remoteServer.getDataReference(string5);
                        if (remoteDataReference == null) {
                            throw new VisADException("The remote object called \"" + string5 + "\" does not exist");
                        }
                        Object object3 = object;
                        RemoteDataReference remoteDataReference2 = remoteDataReference;
                        BasicSSCell basicSSCell = this;
                        CellImpl cellImpl = new CellImpl(this, (SSCellData)object3, remoteDataReference2, (DataReferenceImpl)object2){
                            private final /* synthetic */ BasicSSCell this$0;
                            private final /* synthetic */ SSCellData val$fcd;
                            private final /* synthetic */ RemoteDataReference val$rref;
                            private final /* synthetic */ DataReferenceImpl val$lref;

                            public void doAction() {
                                try {
                                    this.val$lref.setData(BasicSSCell.makeLocal(this.val$rref.getData()));
                                }
                                catch (NullPointerException nullPointerException) {
                                    if (DEBUG) {
                                        nullPointerException.printStackTrace();
                                    }
                                    this.val$fcd.setError("Remote data is null");
                                }
                                catch (VisADException visADException) {
                                    if (DEBUG) {
                                        visADException.printStackTrace();
                                    }
                                    this.val$fcd.setError("Could not update remote data");
                                }
                                catch (RemoteException remoteException) {
                                    if (DEBUG) {
                                        remoteException.printStackTrace();
                                    }
                                    this.val$fcd.setError("Unable to import updated remote data");
                                }
                            }
                            {
                                this.val$fcd = sSCellData;
                                this.val$rref = remoteDataReference;
                                this.val$lref = dataReferenceImpl;
                                this.this$0 = basicSSCell;
                                this.constructor$0(basicSSCell);
                            }

                            private final void constructor$0(BasicSSCell basicSSCell) {
                            }
                        };
                        RemoteCellImpl remoteCellImpl = new RemoteCellImpl(cellImpl);
                        remoteCellImpl.addReference(remoteDataReference);
                    }
                    catch (ClassCastException classCastException) {
                        if (DEBUG) {
                            classCastException.printStackTrace();
                        }
                        bl3 = false;
                        throw new VisADException("The name of the RMI server is not valid.");
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (DEBUG) {
                            malformedURLException.printStackTrace();
                        }
                        bl3 = false;
                        throw new VisADException("The name of the RMI server is not valid.");
                    }
                    catch (NotBoundException notBoundException) {
                        if (DEBUG) {
                            notBoundException.printStackTrace();
                        }
                        bl3 = false;
                        throw new VisADException("The remote data specified does not exist.");
                    }
                    catch (AccessException accessException) {
                        if (DEBUG) {
                            accessException.printStackTrace();
                        }
                        bl3 = false;
                        throw new VisADException("Could not gain access to the remote data.");
                    }
                    catch (RemoteException remoteException) {
                        if (DEBUG) {
                            remoteException.printStackTrace();
                        }
                        bl3 = false;
                        throw new VisADException("Could not connect to the RMI server.");
                    }
                    catch (VisADException visADException) {
                        if (DEBUG) {
                            visADException.printStackTrace();
                        }
                        bl3 = false;
                        throw visADException;
                    }
                    Object var13_20 = null;
                    this.endWait(!bl3);
                }
                catch (Throwable throwable) {
                    Object var13_21 = null;
                    this.endWait(!bl3);
                    throw throwable;
                }
            }
            if (bl) {
                this.sendMessage(1, string, new Real(n2));
            }
        }
        return string2;
    }

    protected SSCellData addReferenceImpl(int n, DataReferenceImpl dataReferenceImpl, ConstantMap[] constantMapArray, String string, int n2, boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (n == 0) {
            n = this.getFirstFreeId();
        }
        if (dataReferenceImpl == null) {
            dataReferenceImpl = new DataReferenceImpl(this.Name);
        }
        if (bl) {
            this.sendMessage(0, string, dataReferenceImpl.getData());
        }
        SSCellData sSCellData = new SSCellData(n, this, dataReferenceImpl, constantMapArray, string, n2, bl2);
        this.CellData.add(sSCellData);
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.addReference(dataReferenceImpl, constantMapArray);
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteDataReferenceImpl = sSCellData.getRemoteReference();
                int n3 = this.Servers.size();
                int n4 = 0;
                while (n4 < n3) {
                    RemoteServerImpl remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n4);
                    remoteServerImpl.addDataReference(remoteDataReferenceImpl);
                    ++n4;
                }
            }
        }
        return sSCellData;
    }

    public void removeData(Data data) throws VisADException, RemoteException {
        boolean bl = false;
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                if (sSCellData.getData() == data) {
                    this.removeDataImpl(sSCellData, true, true);
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            throw new VisADException("The given Data object does not exist");
        }
    }

    public void removeData(String string) throws VisADException, RemoteException {
        Vector vector = this.CellData;
        synchronized (vector) {
            SSCellData sSCellData = this.getCellDataByName(string);
            if (sSCellData == null) {
                throw new VisADException("Data object called " + string + " does not exist");
            }
            this.removeDataImpl(sSCellData, true, true);
        }
    }

    public void removeReference(DataReferenceImpl dataReferenceImpl) throws VisADException, RemoteException {
        boolean bl = false;
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                if (sSCellData.getReference() == dataReferenceImpl) {
                    this.removeDataImpl(sSCellData, true, true);
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            throw new VisADException("The given DataReference does not exist");
        }
    }

    public void removeAllReferences() throws VisADException, RemoteException {
        this.removeAllReferences(true, true);
    }

    protected void removeAllReferences(boolean bl) throws VisADException, RemoteException {
        this.removeAllReferences(bl, true);
    }

    protected void removeAllReferences(boolean bl, boolean bl2) throws VisADException, RemoteException {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            int n2 = 0;
            while (n2 < n) {
                this.removeDataImpl((SSCellData)this.CellData.firstElement(), bl, bl2);
                ++n2;
            }
        }
    }

    protected void removeDataImpl(SSCellData sSCellData, boolean bl, boolean bl2) throws VisADException, RemoteException {
        String string = sSCellData.getVariableName();
        if (bl) {
            this.sendMessage(2, string, null);
        }
        if (!this.IsRemote) {
            if (this.HasMappings) {
                this.VDisplay.removeReference(sSCellData.getReference());
            }
            Vector vector = this.Servers;
            synchronized (vector) {
                RemoteDataReferenceImpl remoteDataReferenceImpl = sSCellData.getRemoteReference();
                int n = this.Servers.size();
                int n2 = 0;
                while (n2 < n) {
                    RemoteServerImpl remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n2);
                    remoteServerImpl.removeDataReference(remoteDataReferenceImpl);
                    ++n2;
                }
            }
        }
        this.CellData.remove(sSCellData);
        sSCellData.destroy();
        sSCellData = null;
        if (bl2) {
            if (this.hasData()) {
                this.updateDisplay();
            } else {
                this.clearDisplay();
            }
        }
    }

    public void waitForData(String string) throws VisADException {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        this.fm.waitForFormula(string);
        while (!sSCellData.isInited()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                if (!DEBUG || DEBUG_LEVEL < 3) continue;
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void waitForData() throws VisADException {
        var3_1 = this.CellData;
        synchronized (var3_1) {
            var2_2 = this.CellData.size();
            var1_3 = new String[var2_2];
            var5_4 = 0;
            while (var5_4 < var2_2) {
                var6_7 = (SSCellData)this.CellData.elementAt(var5_4);
                var1_3[var5_4] = var6_7.getVariableName();
                ++var5_4;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_1
            if (true) ** GOTO lbl23
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var5_5) {
                if (!BasicSSCell.DEBUG || BasicSSCell.DEBUG_LEVEL < 3) continue;
                var5_5.printStackTrace();
            }
lbl23:
            // 4 sources

        } while (this.Loading > 0);
        var5_6 = 0;
        while (var5_6 < var2_2) {
            this.waitForData(var1_3[var5_6]);
            ++var5_6;
        }
    }

    public void saveData(String string, String string2, Form form) throws BadFormException, IOException, VisADException, RemoteException {
        if (this.IsSlave) {
            throw new VisADException("Cannot saveData on a slaved cell");
        }
        Data data = this.getData(string);
        ++Saving;
        try {
            form.save(string2, data, true);
        }
        finally {
            Object var6_5 = null;
            --Saving;
        }
    }

    protected SSCellData getCellDataByName(String string) {
        int n = this.CellData.size();
        SSCellData sSCellData = null;
        int n2 = 0;
        while (n2 < n) {
            SSCellData sSCellData2 = (SSCellData)this.CellData.elementAt(n2);
            if (sSCellData2.getVariableName().equals(string)) {
                sSCellData = sSCellData2;
                break;
            }
            ++n2;
        }
        return sSCellData;
    }

    protected int getFirstFreeId() {
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() == 0) {
                int n = 1;
                Object var2_4 = null;
                return n;
            }
            SSCellData sSCellData = (SSCellData)this.CellData.lastElement();
            int n = sSCellData.getId() + 1;
            Object var2_5 = null;
            return n;
        }
    }

    public synchronized boolean constructDisplay() {
        boolean bl = true;
        DisplayImpl displayImpl = this.VDisplay;
        RemoteDisplay remoteDisplay = this.RemoteVDisplay;
        if (this.IsSlave) {
            try {
                displayImpl = new DisplayImplJ2D("DUMMY");
            }
            catch (VisADException visADException) {
                if (DEBUG) {
                    visADException.printStackTrace();
                }
                bl = false;
            }
            catch (RemoteException remoteException) {
                if (DEBUG) {
                    remoteException.printStackTrace();
                }
                bl = false;
            }
        } else if (!CanDo3D && this.Dim != 2) {
            bl = false;
        } else {
            try {
                TwoDDisplayRendererJ3D twoDDisplayRendererJ3D;
                if (this.IsRemote) {
                    if (this.Dim == 1) {
                        displayImpl = new DisplayImplJ3D(remoteDisplay);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(remoteDisplay);
                    } else {
                        twoDDisplayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(remoteDisplay, (DisplayRendererJ3D)twoDDisplayRendererJ3D);
                    }
                } else {
                    if (this.Dim == 1) {
                        displayImpl = new DisplayImplJ3D(this.Name);
                    } else if (this.Dim == 2) {
                        displayImpl = new DisplayImplJ2D(this.Name);
                    } else {
                        twoDDisplayRendererJ3D = new TwoDDisplayRendererJ3D();
                        displayImpl = new DisplayImplJ3D(this.Name, (DisplayRendererJ3D)twoDDisplayRendererJ3D);
                    }
                    remoteDisplay = new RemoteDisplayImpl(displayImpl);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (DEBUG) {
                    noClassDefFoundError.printStackTrace();
                }
                bl = false;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (DEBUG) {
                    unsatisfiedLinkError.printStackTrace();
                }
                bl = false;
            }
            catch (Exception exception) {
                if (DEBUG) {
                    exception.printStackTrace();
                }
                bl = false;
            }
        }
        if (bl) {
            block32: {
                if (this.VDisplay != null) {
                    try {
                        this.VDisplay.destroy();
                    }
                    catch (VisADException visADException) {
                        if (DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!DEBUG) break block32;
                        remoteException.printStackTrace();
                    }
                }
            }
            this.VDisplay = displayImpl;
            this.RemoteVDisplay = remoteDisplay;
        }
        return bl;
    }

    public void displayChanged(DisplayEvent displayEvent) {
        int n = displayEvent.getId();
        if (n == 2 || n == 3 && this.IsSlave && !this.hasDisplay()) {
            if (!this.hasDisplay()) {
                this.initDisplayPanel();
                this.updateDisplay(true);
            }
            this.notifySSCellListeners(SSCellChangeEvent.DISPLAY_CHANGE);
        } else if (n == 12) {
            this.updateDisplay(false);
        }
    }

    public synchronized void setMaps(ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        if (scalarMapArray == null) {
            return;
        }
        VisADException visADException = null;
        RemoteException remoteException = null;
        if (this.IsRemote) {
            this.sendMessage(3, DataUtility.convertMapsToString(scalarMapArray), null);
        } else {
            int n;
            ConstantMap[][] constantMapArray;
            DataReference[] dataReferenceArray;
            Vector vector = this.CellData;
            synchronized (vector) {
                int n2 = this.CellData.size();
                dataReferenceArray = new DataReference[n2];
                constantMapArray = new ConstantMap[n2][];
                n = 0;
                while (n < n2) {
                    SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n);
                    dataReferenceArray[n] = sSCellData.getReference();
                    constantMapArray[n] = sSCellData.getConstantMaps();
                    ++n;
                }
            }
            String string = this.getPartialSaveString();
            this.VDisplay.disableAction();
            this.clearMaps();
            n = 0;
            while (n < scalarMapArray.length) {
                if (scalarMapArray[n] != null) {
                    try {
                        this.VDisplay.addMap(scalarMapArray[n]);
                    }
                    catch (VisADException visADException2) {
                        visADException = visADException2;
                    }
                    catch (RemoteException remoteException2) {
                        remoteException = remoteException2;
                    }
                }
                ++n;
            }
            n = 0;
            while (n < dataReferenceArray.length) {
                boolean bl;
                block24: {
                    Set set;
                    bl = false;
                    Data data = dataReferenceArray[n].getData();
                    if (data == null) {
                        if (DEBUG) {
                            this.warn("data #" + n + " is null; cannot analyze MathType");
                        }
                    } else if (Possible3D && data instanceof FieldImpl && (set = ((FieldImpl)data).getDomainSet()) instanceof GriddedSet && set.getManifoldDimension() == 2) {
                        MathType mathType = data.getType();
                        try {
                            bl = ImageRendererJ3D.isRendererUsable(mathType, scalarMapArray);
                        }
                        catch (VisADException visADException3) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block24;
                            visADException3.printStackTrace();
                        }
                    }
                }
                if (bl && this.Dim != 2) {
                    this.VDisplay.addReferences((DataRenderer)new ImageRendererJ3D(), dataReferenceArray[n], constantMapArray[n]);
                } else {
                    if (DEBUG) {
                        this.warn("data #" + n + " cannot use ImageRendererJ3D");
                    }
                    this.VDisplay.addReference(dataReferenceArray[n], constantMapArray[n]);
                }
                ++n;
            }
            this.VDisplay.enableAction();
            this.setPartialSaveString(string, true);
        }
        this.HasMappings = true;
        if (visADException != null) {
            throw visADException;
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    public void clearMaps() throws VisADException, RemoteException {
        if (this.IsRemote) {
            this.clearMapsClone(true);
        } else if (this.hasMappings()) {
            this.VDisplay.removeAllReferences();
            this.VDisplay.clearMaps();
            this.HasMappings = false;
        }
    }

    private void clearMapsClone(boolean bl) throws VisADException, RemoteException {
        if (this.hasMappings()) {
            this.RemoteVDisplay.removeAllReferences();
            this.RemoteVDisplay.clearMaps();
            if (bl) {
                this.clearDisplay();
                this.constructDisplay();
                this.initDisplayPanel();
                this.updateDisplay(true);
            }
            this.HasMappings = false;
        }
    }

    public void clearDisplay() throws VisADException, RemoteException {
        if (!this.DisplayEnabled) {
            return;
        }
        this.HasDisplay = false;
        BasicSSCell.invoke(false, new Runnable(this){
            private final /* synthetic */ BasicSSCell this$0;

            public void run() {
                this.this$0.removeAll();
                this.this$0.refresh();
            }
            {
                this.this$0 = basicSSCell;
                this.constructor$0(basicSSCell);
            }

            private final void constructor$0(BasicSSCell basicSSCell) {
            }
        });
    }

    public void clearCell() throws VisADException, RemoteException {
        this.removeAllReferences();
    }

    public void destroyCell() throws VisADException, RemoteException {
        RemoteException remoteException = null;
        this.setDisplayEnabled(false);
        this.removeAllReferences(false, !this.IsRemote);
        if (!this.IsRemote) {
            this.clearCell();
            int n = this.Servers.size();
            int n2 = 0;
            while (n2 < n) {
                RemoteServerImpl remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n2);
                try {
                    this.removeFromRemoteServer(remoteServerImpl);
                }
                catch (RemoteException remoteException2) {
                    remoteException = remoteException2;
                }
                ++n2;
            }
        } else if (this.IsSlave && this.RemoteVSlave != null) {
            try {
                this.RemoteVSlave.unlink();
            }
            catch (RemoteException remoteException3) {
                remoteException = remoteException3;
            }
        }
        Vector vector = SSCellVector;
        synchronized (vector) {
            SSCellVector.remove(this);
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    public void setDimension(int n) throws VisADException, RemoteException {
        if (n == this.Dim) {
            return;
        }
        if (n != 1 && n != 2 && n != 3) {
            throw new VisADException("Invalid dimension");
        }
        if (!this.IsRemote) {
            this.Dim = n;
            Vector vector = this.DListen;
            synchronized (vector) {
                block16: {
                    int n2;
                    Vector vector2;
                    int n3;
                    this.detachListeners();
                    ScalarMap[] scalarMapArray = null;
                    if (this.VDisplay != null && (n3 = (vector2 = this.VDisplay.getMapVector()).size()) > 0) {
                        scalarMapArray = new ScalarMap[n3];
                        n2 = 0;
                        while (n2 < n3) {
                            scalarMapArray[n2] = (ScalarMap)vector2.elementAt(n2);
                            ++n2;
                        }
                    }
                    vector2 = this.Servers;
                    synchronized (vector2) {
                        RemoteServerImpl remoteServerImpl;
                        n2 = this.Servers.size();
                        int n4 = 0;
                        while (n4 < n2) {
                            remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n4);
                            remoteServerImpl.removeDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                            ++n4;
                        }
                        this.constructDisplay();
                        n4 = 0;
                        while (n4 < n2) {
                            remoteServerImpl = (RemoteServerImpl)this.Servers.elementAt(n4);
                            remoteServerImpl.addDisplay((RemoteDisplayImpl)this.RemoteVDisplay);
                            ++n4;
                        }
                    }
                    if (scalarMapArray != null) {
                        try {
                            this.setMaps(scalarMapArray);
                        }
                        catch (VisADException visADException) {
                            if (!DEBUG) break block16;
                            visADException.printStackTrace();
                        }
                    }
                }
                this.initDisplayPanel();
                this.updateDisplay(this.hasData());
                this.attachListeners();
            }
            this.notifySSCellListeners(SSCellChangeEvent.DIMENSION_CHANGE);
        }
        this.sendMessage(4, this.IsRemote ? "" : null, new Real(n));
    }

    private void setDimClone() throws VisADException, RemoteException {
        Vector vector = this.DListen;
        synchronized (vector) {
            String string;
            this.detachListeners();
            this.clearDisplay();
            this.RemoteVDisplay = this.RemoteVServer.getDisplay(this.Name);
            if (this.IsSlave) {
                if (this.RemoteVSlave != null) {
                    this.RemoteVSlave.unlink();
                }
                this.RemoteVSlave = new RemoteSlaveDisplayImpl(this.RemoteVDisplay);
            }
            if ((string = this.RemoteVDisplay.getDisplayRendererClassName()).equals(j33) || string.equals(jir)) {
                this.Dim = 1;
            } else if (string.equals(j22)) {
                this.Dim = 2;
            } else if (string.equals(j32)) {
                this.Dim = 3;
            }
            boolean bl = this.constructDisplay();
            if (!bl) {
                JComponent jComponent = this.Dim == 2 ? new JComponent(this){
                    private final /* synthetic */ BasicSSCell this$0;

                    public void paint(Graphics graphics) {
                        graphics.setColor(Color.white);
                        graphics.drawString("A serious error occurred while constructing this display.", 8, 20);
                    }
                    {
                        this.this$0 = basicSSCell;
                        this.constructor$0(basicSSCell);
                    }

                    private final void constructor$0(BasicSSCell basicSSCell) {
                    }
                } : new JComponent(this){
                    private final /* synthetic */ BasicSSCell this$0;

                    public void paint(Graphics graphics) {
                        graphics.setColor(Color.white);
                        graphics.drawString("This machine does not support Java3D.", 8, 20);
                        graphics.drawString("Switch the dimension to 2-D (Java2D) to view this display.", 8, 35);
                    }
                    {
                        this.this$0 = basicSSCell;
                        this.constructor$0(basicSSCell);
                    }

                    private final void constructor$0(BasicSSCell basicSSCell) {
                    }
                };
                this.VDisplay = new DisplayImplJ2D("DUMMY");
                JComponent jComponent2 = jComponent;
                BasicSSCell.invoke(false, new Runnable(this, jComponent2){
                    private final /* synthetic */ BasicSSCell this$0;
                    private final /* synthetic */ JComponent val$ec;

                    public void run() {
                        this.this$0.removeAll();
                        this.this$0.add(this.val$ec);
                        this.this$0.refresh();
                    }
                    {
                        this.val$ec = jComponent;
                        this.this$0 = basicSSCell;
                        this.constructor$0(basicSSCell);
                    }

                    private final void constructor$0(BasicSSCell basicSSCell) {
                    }
                });
            }
            this.initDisplayPanel();
            if (bl && this.hasData()) {
                this.updateDisplay(true);
            }
            this.attachListeners();
        }
        this.notifySSCellListeners(SSCellChangeEvent.DIMENSION_CHANGE);
    }

    public void captureImage(File file) throws VisADException, IOException {
        BufferedImage bufferedImage = this.IsSlave ? this.RemoteVSlave.getImage() : this.VDisplay.getImage();
        try {
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, true);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.close();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new VisADException("JPEG codec not found");
        }
    }

    public String getSaveString() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            stringBuffer.append("# ");
            stringBuffer.append(this.Name);
            stringBuffer.append(": data information\n");
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                stringBuffer.append("id = ");
                stringBuffer.append(sSCellData.getId());
                stringBuffer.append('\n');
                stringBuffer.append("source = ");
                stringBuffer.append(sSCellData.getSource());
                stringBuffer.append('\n');
                stringBuffer.append("source type = ");
                stringBuffer.append(sSCellData.getSourceType());
                stringBuffer.append('\n');
                ++n2;
            }
        }
        stringBuffer.append("\n# ");
        stringBuffer.append(this.Name);
        stringBuffer.append(": display information\n");
        stringBuffer.append("dim = ");
        stringBuffer.append(this.Dim);
        stringBuffer.append('\n');
        stringBuffer.append(this.getPartialSaveString());
        return stringBuffer.toString();
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        this.setPartialSaveString(string, false);
    }

    protected String getPartialSaveString() {
        int n;
        Cloneable cloneable;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = null;
        if (this.hasMappings() && (n2 = (vector = this.VDisplay.getMapVector()).size()) > 0) {
            stringBuffer.append("maps =");
            stringBuffer.append(DataUtility.convertMapsToString(vector));
            stringBuffer.append('\n');
            stringBuffer.append("map ranges =");
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray;
                cloneable = (ScalarMap)vector.elementAt(n3);
                n = ((ScalarMap)cloneable).getScale(new double[2], dArray = new double[2], new double[2]) ? 1 : 0;
                if (n != 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(dArray[0]);
                    stringBuffer.append(' ');
                    stringBuffer.append(dArray[1]);
                }
                ++n3;
            }
            stringBuffer.append('\n');
        }
        if (this.hasDisplay()) {
            Object object;
            GraphicsModeControl graphicsModeControl;
            ProjectionControl projectionControl = this.VDisplay.getProjectionControl();
            if (projectionControl != null) {
                stringBuffer.append("projection = ");
                stringBuffer.append(projectionControl.getSaveString());
            }
            if ((graphicsModeControl = this.VDisplay.getGraphicsModeControl()) != null) {
                stringBuffer.append("graphics mode = ");
                stringBuffer.append(graphicsModeControl.getSaveString());
                stringBuffer.append('\n');
            }
            if ((cloneable = this.VDisplay.getControls(class$Lvisad$ColorControl != null ? class$Lvisad$ColorControl : (class$Lvisad$ColorControl = BasicSSCell.class$("visad.ColorControl")))) != null) {
                int n4 = ((Vector)cloneable).size();
                n = 0;
                while (n < n4) {
                    object = (ColorControl)((Vector)cloneable).elementAt(n);
                    if (object != null) {
                        stringBuffer.append("color = ");
                        stringBuffer.append(((BaseColorControl)object).getSaveString());
                    }
                    ++n;
                }
            }
            if ((cloneable = this.VDisplay.getControls(class$Lvisad$ContourControl != null ? class$Lvisad$ContourControl : (class$Lvisad$ContourControl = BasicSSCell.class$("visad.ContourControl")))) != null) {
                int n5 = ((Vector)cloneable).size();
                n = 0;
                while (n < n5) {
                    object = (ContourControl)((Vector)cloneable).elementAt(n);
                    if (object != null) {
                        stringBuffer.append("contour = ");
                        stringBuffer.append(((ContourControl)object).getSaveString());
                        stringBuffer.append('\n');
                    }
                    ++n;
                }
            }
            if ((cloneable = this.VDisplay.getControls(class$Lvisad$RangeControl != null ? class$Lvisad$RangeControl : (class$Lvisad$RangeControl = BasicSSCell.class$("visad.RangeControl")))) != null) {
                int n6 = ((Vector)cloneable).size();
                n = 0;
                while (n < n6) {
                    object = (RangeControl)((Vector)cloneable).elementAt(n);
                    if (object != null) {
                        stringBuffer.append("range = ");
                        stringBuffer.append(((RangeControl)object).getSaveString());
                        stringBuffer.append('\n');
                    }
                    ++n;
                }
            }
            if ((cloneable = this.VDisplay.getControls(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = BasicSSCell.class$("visad.AnimationControl")))) != null) {
                int n7 = ((Vector)cloneable).size();
                n = 0;
                while (n < n7) {
                    object = (AnimationControl)((Vector)cloneable).elementAt(n);
                    if (object != null) {
                        stringBuffer.append("anim = ");
                        stringBuffer.append(object.getSaveString());
                        stringBuffer.append('\n');
                    }
                    ++n;
                }
            }
            if ((cloneable = this.VDisplay.getControls(class$Lvisad$ValueControl != null ? class$Lvisad$ValueControl : (class$Lvisad$ValueControl = BasicSSCell.class$("visad.ValueControl")))) != null) {
                int n8 = ((Vector)cloneable).size();
                n = 0;
                while (n < n8) {
                    object = (ValueControl)((Vector)cloneable).elementAt(n);
                    if (object != null) {
                        stringBuffer.append("value = ");
                        stringBuffer.append(object.getSaveString());
                        stringBuffer.append('\n');
                    }
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void setPartialSaveString(String string, boolean bl) throws VisADException, RemoteException {
        int n;
        Object object;
        Object object2;
        String string2;
        if (this.IsRemote) {
            throw new VisADException("Cannot setSaveString on a remote cell");
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        Vector<Integer> vector3 = new Vector<Integer>();
        int n2 = -1;
        String string3 = null;
        ScalarMap[] scalarMapArray = null;
        Vector<Object> vector4 = null;
        Vector<Double> vector5 = null;
        String string4 = null;
        String string5 = null;
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        Vector<String> vector10 = new Vector<String>();
        SaveStringTokenizer saveStringTokenizer = new SaveStringTokenizer(string);
        int n3 = 0;
        while (n3 < saveStringTokenizer.keywords.length) {
            String string6 = saveStringTokenizer.keywords[n3];
            string2 = saveStringTokenizer.values[n3];
            if (string6.equalsIgnoreCase("id") || string6.equalsIgnoreCase("data id") || string6.equalsIgnoreCase("data_id") || string6.equalsIgnoreCase("dataid")) {
                try {
                    vector.add(new Integer(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (DEBUG) {
                        numberFormatException.printStackTrace();
                    }
                    this.warn("data id value " + string2 + " is not valid and will be ignored");
                }
            } else if (string6.equalsIgnoreCase("source") || string6.equalsIgnoreCase("data source") || string6.equalsIgnoreCase("data_source") || string6.equalsIgnoreCase("datasource")) {
                vector2.add(string2);
            } else if (string6.equalsIgnoreCase("source type") || string6.equalsIgnoreCase("source_type") || string6.equalsIgnoreCase("sourcetype") || string6.equalsIgnoreCase("data source type") || string6.equalsIgnoreCase("data_source_type") || string6.equalsIgnoreCase("datasourcetype")) {
                try {
                    vector3.add(new Integer(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (DEBUG) {
                        numberFormatException.printStackTrace();
                    }
                    this.warn("source type value " + string2 + " is not valid and will be ignored");
                }
            } else if (string6.equalsIgnoreCase("filename") || string6.equalsIgnoreCase("file name") || string6.equalsIgnoreCase("file_name") || string6.equalsIgnoreCase("file")) {
                vector.add(new Integer(0));
                vector2.add(string2);
                vector3.add(new Integer(1));
            } else if (string6.equalsIgnoreCase("rmi") || string6.equalsIgnoreCase("rmi address") || string6.equalsIgnoreCase("rmi_address") || string6.equalsIgnoreCase("rmiaddress")) {
                vector.add(new Integer(0));
                vector2.add(string2);
                vector3.add(new Integer(3));
            } else if (string6.equalsIgnoreCase("formula") || string6.equalsIgnoreCase("equation")) {
                vector.add(new Integer(0));
                vector2.add(string2);
                vector3.add(new Integer(2));
            } else if (string6.equalsIgnoreCase("dim") || string6.equalsIgnoreCase("dimension")) {
                int n4;
                block99: {
                    n4 = -1;
                    try {
                        n4 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!DEBUG) break block99;
                        numberFormatException.printStackTrace();
                    }
                }
                if (n4 > 0 && n4 < 4) {
                    n2 = n4;
                } else {
                    this.warn("dimension value " + string2 + " is not valid and will be ignored");
                }
            } else if (string6.equalsIgnoreCase("maps") || string6.equalsIgnoreCase("mappings")) {
                string3 = string2;
            } else if (string6.equalsIgnoreCase("map ranges") || string6.equalsIgnoreCase("map_ranges") || string6.equalsIgnoreCase("mapranges")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                vector4 = new Vector<Object>();
                vector5 = new Vector<Double>();
                while (stringTokenizer.hasMoreTokens()) {
                    Double d;
                    String string7;
                    block101: {
                        object2 = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.warn("trailing map range min value " + (String)object2 + " has no corresponding max value and will be ignored");
                            break;
                        }
                        string7 = stringTokenizer.nextToken();
                        object = null;
                        d = null;
                        try {
                            object = new Double(((String)object2).equals("NaN") ? Double.NaN : Double.parseDouble((String)object2));
                            d = new Double(string7.equals("NaN") ? Double.NaN : Double.parseDouble(string7));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!DEBUG) break block101;
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (object == null || d == null) {
                        this.warn("map range min/max pair (" + (String)object2 + ", " + string7 + ") is not valid and will be ignored");
                        continue;
                    }
                    vector4.add(object);
                    vector5.add(d);
                }
            } else if (string6.equalsIgnoreCase("projection") || string6.equalsIgnoreCase("proj")) {
                string4 = string2;
            } else if (string6.equalsIgnoreCase("graphics mode") || string6.equalsIgnoreCase("graphics_mode") || string6.equalsIgnoreCase("graphicsmode") || string6.equalsIgnoreCase("graphics") || string6.equalsIgnoreCase("mode")) {
                string5 = string2;
            } else if (string6.equalsIgnoreCase("color") || string6.equalsIgnoreCase("color table") || string6.equalsIgnoreCase("color_table") || string6.equalsIgnoreCase("colortable")) {
                vector6.add(string2);
            } else if (string6.equalsIgnoreCase("contour") || string6.equalsIgnoreCase("contours") || string6.equalsIgnoreCase("iso contour") || string6.equalsIgnoreCase("iso_contour") || string6.equalsIgnoreCase("isocontour") || string6.equalsIgnoreCase("iso contours") || string6.equalsIgnoreCase("iso_contours") || string6.equalsIgnoreCase("isocontours")) {
                vector7.add(string2);
            } else if (string6.equalsIgnoreCase("range") || string6.equalsIgnoreCase("select range") || string6.equalsIgnoreCase("select_range") || string6.equalsIgnoreCase("selectrange")) {
                vector8.add(string2);
            } else if (string6.equalsIgnoreCase("anim") || string6.equalsIgnoreCase("animation")) {
                vector9.add(string2);
            } else if (string6.equalsIgnoreCase("value") || string6.equalsIgnoreCase("select value") || string6.equalsIgnoreCase("select_value") || string6.equalsIgnoreCase("selectvalue")) {
                vector10.add(string2);
            } else {
                this.warn("keyword " + string6 + " is unknown and will be ignored");
            }
            ++n3;
        }
        if (bl) {
            scalarMapArray = DataUtility.convertStringToMaps(string3, this.getData(), true);
            if (scalarMapArray != null) {
                n3 = vector4 == null ? -1 : vector4.size();
                int n5 = vector5 == null ? -1 : vector5.size();
                int n6 = 0;
                int n7 = 0;
                object2 = this.VDisplay.getMapVector();
                int n8 = 0;
                while (n8 < scalarMapArray.length) {
                    boolean bl2;
                    if (scalarMapArray[n8] != null && (bl2 = scalarMapArray[n8].getScale(new double[2], new double[2], new double[2])) && n6 < n3 && n7 < n5) {
                        int n9 = ((Vector)object2).indexOf(scalarMapArray[n8]);
                        if (n9 >= 0) {
                            ScalarMap scalarMap = (ScalarMap)((Vector)object2).elementAt(n9);
                            scalarMap.setRange((Double)vector4.elementAt(n6++), (Double)vector5.elementAt(n7++));
                        } else {
                            ++n6;
                            ++n7;
                        }
                    }
                    ++n8;
                }
            }
        } else {
            this.clearCell();
            this.setDimension(n2);
            n3 = vector.size();
            int n10 = vector2.size();
            int n11 = vector3.size();
            if (n3 != n10 || n3 != n11) {
                this.warn("some data object entries are corrupt and will be ignored");
            }
            int n12 = n3 < n10 && n3 < n11 ? n3 : (n10 < n11 ? n10 : n11);
            this.setDisplayEnabled(false);
            int n13 = 0;
            while (n13 < n12) {
                int n14 = (Integer)vector.elementAt(n13);
                object = (String)vector2.elementAt(n13);
                int n15 = (Integer)vector3.elementAt(n13);
                this.addDataSource(n14, (String)object, n15, true);
                ++n13;
            }
            this.waitForData();
            scalarMapArray = DataUtility.convertStringToMaps(string3, this.getData(), true);
            if (scalarMapArray != null) {
                n13 = vector4 == null ? -1 : vector4.size();
                int n16 = vector5 == null ? -1 : vector5.size();
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                while (n19 < scalarMapArray.length) {
                    ScalarMap scalarMap;
                    boolean bl3;
                    if (scalarMapArray[n19] != null && (bl3 = (scalarMap = scalarMapArray[n19]).getScale(new double[2], new double[2], new double[2])) && n17 < n13 && n18 < n16) {
                        scalarMap.setRange((Double)vector4.elementAt(n17++), (Double)vector5.elementAt(n18++));
                    }
                    ++n19;
                }
                this.setMaps(scalarMapArray);
            }
            this.setDisplayEnabled(true);
        }
        if (string4 != null) {
            ProjectionControl projectionControl = this.VDisplay.getProjectionControl();
            if (projectionControl != null) {
                projectionControl.setSaveString(string4);
            } else if (!bl) {
                this.warn("display has no ProjectionControl; the provided projection matrix will be ignored");
            }
        }
        if (string5 != null) {
            GraphicsModeControl graphicsModeControl = this.VDisplay.getGraphicsModeControl();
            if (graphicsModeControl != null) {
                try {
                    graphicsModeControl.setSaveString(string5);
                }
                catch (VisADException visADException) {
                    if (DEBUG && DEBUG_LEVEL >= 3) {
                        visADException.printStackTrace();
                    }
                }
            } else if (!bl) {
                this.warn("display has no GraphicsModeControl; the provided graphics mode settings will be ignored");
            }
        }
        if ((n = vector6.size()) > 0) {
            int n20 = 0;
            while (n20 < n) {
                string2 = (String)vector6.elementAt(n20);
                ColorControl colorControl = (ColorControl)this.VDisplay.getControl(class$Lvisad$ColorControl != null ? class$Lvisad$ColorControl : BasicSSCell.class$("visad.ColorControl"), n20);
                if (colorControl != null) {
                    colorControl.setSaveString(string2);
                } else if (!bl) {
                    this.warn("display has no ColorControl #" + (n20 + 1) + "; " + "the provided color table will be ignored");
                }
                ++n20;
            }
        }
        if ((n = vector7.size()) > 0) {
            int n21 = 0;
            while (n21 < n) {
                string2 = (String)vector7.elementAt(n21);
                ContourControl contourControl = (ContourControl)this.VDisplay.getControl(class$Lvisad$ContourControl != null ? class$Lvisad$ContourControl : BasicSSCell.class$("visad.ContourControl"), n21);
                if (contourControl != null) {
                    contourControl.setSaveString(string2);
                } else if (!bl) {
                    this.warn("display has no ContourControl #" + (n21 + 1) + "; " + "the provided contour settings will be ignored");
                }
                ++n21;
            }
        }
        if ((n = vector8.size()) > 0) {
            int n22 = 0;
            while (n22 < n) {
                string2 = (String)vector8.elementAt(n22);
                RangeControl rangeControl = (RangeControl)this.VDisplay.getControl(class$Lvisad$RangeControl != null ? class$Lvisad$RangeControl : BasicSSCell.class$("visad.RangeControl"), n22);
                if (rangeControl != null) {
                    rangeControl.setSaveString(string2);
                } else if (!bl) {
                    this.warn("display has no RangeControl #" + (n22 + 1) + "; " + "the provided range will be ignored");
                }
                ++n22;
            }
        }
        if ((n = vector9.size()) > 0) {
            int n23 = 0;
            while (n23 < n) {
                string2 = (String)vector9.elementAt(n23);
                AnimationControl animationControl = (AnimationControl)((Object)this.VDisplay.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : BasicSSCell.class$("visad.AnimationControl"), n23));
                if (animationControl != null) {
                    block102: {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!DEBUG || DEBUG_LEVEL < 3) break block102;
                            interruptedException.printStackTrace();
                        }
                    }
                    animationControl.setSaveString(string2);
                } else if (!bl) {
                    this.warn("display has no AnimationControl #" + (n23 + 1) + "; " + "the provided animation settings will be ignored");
                }
                ++n23;
            }
        }
        if ((n = vector10.size()) > 0) {
            int n24 = 0;
            while (n24 < n) {
                string2 = (String)vector10.elementAt(n24);
                ValueControl valueControl = (ValueControl)((Object)this.VDisplay.getControl(class$Lvisad$ValueControl != null ? class$Lvisad$ValueControl : BasicSSCell.class$("visad.ValueControl"), n24));
                if (valueControl != null) {
                    valueControl.setSaveString(string2);
                } else if (!bl) {
                    this.warn("display has no ValueControl #" + (n24 + 1) + "; " + "the provided value will be ignored");
                }
                ++n24;
            }
        }
    }

    public void addVar(String string, ThingReference thingReference) throws VisADException {
        this.fm.createVar(string, thingReference);
    }

    private void warn(String string) {
        System.err.println(this.Name + ": Warning: " + string);
    }

    void refresh() {
        this.validate();
        this.repaint();
    }

    protected void setErrors(String[] stringArray, boolean bl) {
        block4: {
            if (BasicSSCell.arraysEqual(this.Errors, stringArray)) {
                return;
            }
            this.Errors = stringArray;
            this.updateDisplay();
            if (bl) {
                try {
                    this.sendMessage(5, null, BasicSSCell.stringsToTuple(stringArray));
                }
                catch (RemoteException remoteException) {
                    if (!DEBUG) break block4;
                    remoteException.printStackTrace();
                }
            }
        }
    }

    private void initDisplayPanel() {
        this.VDPanel = this.IsSlave ? this.RemoteVSlave.getComponent() : this.VDisplay.getComponent();
    }

    void updateDisplay(boolean bl) {
        this.HasDisplay = bl;
        this.updateDisplay();
    }

    void updateDisplay() {
        int n;
        if (!this.DisplayEnabled) {
            return;
        }
        if (this.WaitPanel == null) {
            this.WaitPanel = new JPanel();
            this.WaitPanel.setBackground(Color.black);
            this.WaitPanel.setLayout(new BoxLayout(this.WaitPanel, 0));
            this.WaitPanel.add(Box.createHorizontalGlue());
            this.WaitPanel.add(new JLabel("Please wait..."));
            this.WaitPanel.add(Box.createHorizontalGlue());
        }
        Vector<String> vector = new Vector<String>();
        if (this.Errors == null) {
            Vector vector2 = this.CellData;
            synchronized (vector2) {
                int n2 = this.CellData.size();
                int n3 = 0;
                while (n3 < n2) {
                    SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n3);
                    String string = sSCellData.getVariableName();
                    String[] stringArray = sSCellData.getErrors();
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            vector.add(string + ": " + stringArray[n4]);
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
        } else {
            int n5 = 0;
            while (n5 < this.Errors.length) {
                vector.add(this.Errors[n5]);
                ++n5;
            }
        }
        JComponent jComponent = (n = vector.size()) == 0 ? null : new JComponent(this, n, vector){
            private final /* synthetic */ BasicSSCell this$0;
            private final /* synthetic */ int val$len;
            private final /* synthetic */ Vector val$e;

            public void paint(Graphics graphics) {
                graphics.setColor(Color.white);
                String string = (this.val$len == 1 ? "An error" : "Errors") + " occurred while computing this cell:";
                graphics.drawString(string, 8, 20);
                int n = 0;
                while (n < this.val$len) {
                    string = (String)this.val$e.elementAt(n);
                    graphics.drawString(string, 8, 15 * n + 50);
                    ++n;
                }
            }
            {
                this.val$len = n;
                this.val$e = vector;
                this.this$0 = basicSSCell;
                this.constructor$0(basicSSCell);
            }

            private final void constructor$0(BasicSSCell basicSSCell) {
            }
        };
        JComponent jComponent2 = jComponent;
        BasicSSCell.invoke(true, new Runnable(this, jComponent2){
            private final /* synthetic */ BasicSSCell this$0;
            private final /* synthetic */ JComponent val$ec;

            public void run() {
                boolean bl;
                Component[] componentArray = this.this$0.getComponents();
                boolean bl2 = bl = componentArray.length > 0 && componentArray[0] == this.this$0.VDPanel;
                if (this.this$0.Loading > 0) {
                    this.this$0.removeAll();
                    this.this$0.add(BasicSSCell.access$0(this.this$0));
                } else if (this.val$ec != null) {
                    this.this$0.removeAll();
                    this.this$0.add(this.val$ec);
                } else if (this.this$0.HasDisplay) {
                    if (!bl) {
                        this.this$0.removeAll();
                        this.this$0.add(this.this$0.VDPanel);
                    }
                } else {
                    this.this$0.removeAll();
                }
                this.this$0.refresh();
            }
            {
                this.val$ec = jComponent;
                this.this$0 = basicSSCell;
                this.constructor$0(basicSSCell);
            }

            private final void constructor$0(BasicSSCell basicSSCell) {
            }
        });
    }

    private void setDisplayEnabled(boolean bl) {
        if (bl == this.DisplayEnabled) {
            return;
        }
        this.DisplayEnabled = bl;
        if (this.DisplayEnabled) {
            this.updateDisplay();
        }
    }

    private void beginWait(boolean bl) {
        ++this.Loading;
        if (bl) {
            this.updateDisplay();
        }
    }

    private void endWait(boolean bl) {
        --this.Loading;
        if (bl) {
            this.updateDisplay();
        }
    }

    public void addDisplayListener(DisplayListener displayListener) {
        Vector vector = this.DListen;
        synchronized (vector) {
            if (!this.DListen.contains(displayListener)) {
                if (this.IsSlave) {
                    this.RemoteVSlave.addDisplayListener(displayListener);
                } else {
                    this.VDisplay.addDisplayListener(displayListener);
                }
                this.DListen.add(displayListener);
            }
        }
    }

    public void removeDisplayListener(DisplayListener displayListener) {
        Vector vector = this.DListen;
        synchronized (vector) {
            if (this.DListen.contains(displayListener)) {
                if (this.IsSlave) {
                    this.RemoteVSlave.removeDisplayListener(displayListener);
                } else {
                    this.VDisplay.removeDisplayListener(displayListener);
                }
                this.DListen.remove(displayListener);
            }
        }
    }

    private void attachListeners() {
        int n = this.DListen.size();
        if (this.IsSlave) {
            int n2 = 0;
            while (n2 < n) {
                DisplayListener displayListener = (DisplayListener)this.DListen.elementAt(n2);
                this.RemoteVSlave.addDisplayListener(displayListener);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                DisplayListener displayListener = (DisplayListener)this.DListen.elementAt(n3);
                this.VDisplay.addDisplayListener(displayListener);
                ++n3;
            }
        }
    }

    private void detachListeners() {
        int n = this.DListen.size();
        if (this.IsSlave) {
            int n2 = 0;
            while (n2 < n) {
                DisplayListener displayListener = (DisplayListener)this.DListen.elementAt(n2);
                this.RemoteVSlave.removeDisplayListener(displayListener);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                DisplayListener displayListener = (DisplayListener)this.DListen.elementAt(n3);
                this.VDisplay.removeDisplayListener(displayListener);
                ++n3;
            }
        }
    }

    public void addSSCellListener(SSCellListener sSCellListener) {
        Vector vector = this.SListen;
        synchronized (vector) {
            if (!this.SListen.contains(sSCellListener)) {
                this.SListen.add(sSCellListener);
            }
        }
    }

    public void removeSSCellListener(SSCellListener sSCellListener) {
        Vector vector = this.SListen;
        synchronized (vector) {
            this.SListen.remove(sSCellListener);
        }
    }

    public void removeAllSSCellListeners() {
        Vector vector = this.SListen;
        synchronized (vector) {
            this.SListen.removeAllElements();
        }
    }

    void notifySSCellListeners(int n) {
        this.notifySSCellListeners(n, null);
    }

    void notifySSCellListeners(int n, String string) {
        int n2;
        SSCellListener[] sSCellListenerArray;
        int n3;
        SSCellChangeEvent sSCellChangeEvent = new SSCellChangeEvent(this, n, string);
        Vector vector = this.SListen;
        synchronized (vector) {
            n3 = this.SListen.size();
            sSCellListenerArray = new SSCellListener[n3];
            n2 = 0;
            while (n2 < n3) {
                sSCellListenerArray[n2] = (SSCellListener)this.SListen.elementAt(n2);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < n3) {
            sSCellListenerArray[n2].ssCellChanged(sSCellChangeEvent);
            ++n2;
        }
    }

    public String getName() {
        return this.Name;
    }

    public boolean isRemote() {
        return this.IsRemote;
    }

    public boolean isSlave() {
        return this.IsSlave;
    }

    public int getRemoteId() {
        return this.CollabID;
    }

    public FormulaManager getFormulaManager() {
        return this.fm;
    }

    public DisplayImpl getDisplay() {
        return this.VDisplay;
    }

    public RemoteDisplay getRemoteDisplay() {
        return this.RemoteVDisplay;
    }

    public ScalarMap[] getMaps() {
        Vector vector;
        block8: {
            vector = null;
            if (this.IsSlave) {
                try {
                    vector = this.RemoteVDisplay.getMapVector();
                }
                catch (VisADException visADException) {
                    if (DEBUG) {
                        visADException.printStackTrace();
                    }
                    break block8;
                }
                catch (RemoteException remoteException) {
                    if (DEBUG) {
                        remoteException.printStackTrace();
                    }
                    break block8;
                }
            }
            if (this.VDisplay != null) {
                vector = this.VDisplay.getMapVector();
            }
        }
        int n = vector == null ? 0 : vector.size();
        ScalarMap[] scalarMapArray = n > 0 ? new ScalarMap[n] : null;
        int n2 = 0;
        while (n2 < n) {
            scalarMapArray[n2] = (ScalarMap)vector.elementAt(n2);
            ++n2;
        }
        return scalarMapArray;
    }

    public int getDimension() {
        return this.Dim;
    }

    public Data getData(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData == null ? null : sSCellData.getData();
    }

    public Data[] getData() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            Data[] dataArray = new Data[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                dataArray[n2] = sSCellData.getData();
                ++n2;
            }
            Data[] dataArray2 = dataArray;
            Object var2_7 = null;
            return dataArray2;
        }
    }

    public DataReference getReference(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData == null ? null : sSCellData.getReference();
    }

    public DataReferenceImpl[] getReferences() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            DataReferenceImpl[] dataReferenceImplArray = new DataReferenceImpl[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                dataReferenceImplArray[n2] = sSCellData.getReference();
                ++n2;
            }
            DataReferenceImpl[] dataReferenceImplArray2 = dataReferenceImplArray;
            Object var2_7 = null;
            return dataReferenceImplArray2;
        }
    }

    public RemoteDataReference getRemoteReference(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData == null ? null : sSCellData.getRemoteReference();
    }

    public RemoteDataReference[] getRemoteReferences() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            RemoteDataReference[] remoteDataReferenceArray = new RemoteDataReference[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                remoteDataReferenceArray[n2] = sSCellData.getRemoteReference();
                ++n2;
            }
            RemoteDataReference[] remoteDataReferenceArray2 = remoteDataReferenceArray;
            Object var2_7 = null;
            return remoteDataReferenceArray2;
        }
    }

    public int getDataSourceType(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData == null ? -1 : sSCellData.getSourceType();
    }

    public int[] getDataSourceTypes() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                nArray[n2] = sSCellData.getSourceType();
                ++n2;
            }
            int[] nArray2 = nArray;
            Object var2_7 = null;
            return nArray2;
        }
    }

    public String getDataSource(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData == null ? null : sSCellData.getSource();
    }

    public String[] getDataSources() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                stringArray[n2] = sSCellData.getSource();
                ++n2;
            }
            String[] stringArray2 = stringArray;
            Object var2_7 = null;
            return stringArray2;
        }
    }

    public String getFirstVariableName() {
        String string = null;
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() > 0) {
                SSCellData sSCellData = (SSCellData)this.CellData.firstElement();
                string = sSCellData.getVariableName();
            }
        }
        return string;
    }

    public String getLastVariableName() {
        String string = null;
        Vector vector = this.CellData;
        synchronized (vector) {
            if (this.CellData.size() > 0) {
                SSCellData sSCellData = (SSCellData)this.CellData.lastElement();
                string = sSCellData.getVariableName();
            }
        }
        return string;
    }

    public String[] getVariableNames() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                stringArray[n2] = sSCellData.getVariableName();
                ++n2;
            }
            String[] stringArray2 = stringArray;
            Object var2_7 = null;
            return stringArray2;
        }
    }

    public int getDataCount() {
        return this.CellData.size();
    }

    public boolean hasData() {
        return this.CellData.size() > 0;
    }

    public boolean hasDisplay() {
        return this.HasDisplay;
    }

    public boolean hasMappings() {
        if (this.IsRemote) {
            Vector vector;
            block5: {
                vector = null;
                try {
                    vector = this.RemoteVDisplay.getMapVector();
                }
                catch (VisADException visADException) {
                    if (DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!DEBUG) break block5;
                    remoteException.printStackTrace();
                }
            }
            return vector != null && !vector.isEmpty();
        }
        return this.HasMappings;
    }

    public boolean othersDepend(String string) {
        SSCellData sSCellData;
        Vector vector = this.CellData;
        synchronized (vector) {
            sSCellData = this.getCellDataByName(string);
        }
        return sSCellData.othersDepend();
    }

    public boolean othersDepend() {
        Vector vector = this.CellData;
        synchronized (vector) {
            int n = this.CellData.size();
            int n2 = 0;
            while (n2 < n) {
                SSCellData sSCellData = (SSCellData)this.CellData.elementAt(n2);
                if (sSCellData.othersDepend()) {
                    boolean bl = true;
                    Object var2_7 = null;
                    return bl;
                }
                ++n2;
            }
            boolean bl = false;
            Object var2_8 = null;
            return bl;
        }
    }

    public static void createVar(String string, ThingReference thingReference) throws VisADException {
        defaultFM.createVar(string, thingReference);
    }

    public void addSSCellChangeListener(SSCellListener sSCellListener) {
        this.addSSCellListener(sSCellListener);
    }

    public void removeListener(SSCellListener sSCellListener) {
        this.removeSSCellListener(sSCellListener);
    }

    public void removeAllListeners() {
        this.removeAllSSCellListeners();
    }

    public void setSSCellString(String string) throws VisADException, RemoteException {
        this.setSaveString(string);
    }

    public String getSSCellString() {
        return this.getSaveString();
    }

    public void saveData(File file, boolean bl) throws BadFormException, IOException, VisADException, RemoteException {
        Form form = bl ? new Plain() : new VisADForm();
        this.saveData(this.getFirstVariableName(), file.getPath(), form);
    }

    public void saveData(File file, Form form) throws BadFormException, IOException, VisADException, RemoteException {
        this.saveData(this.getFirstVariableName(), file.getPath(), form);
    }

    public void setData(Data data) throws VisADException, RemoteException {
        this.removeAllReferences();
        this.addData(data);
    }

    public void setFormula(String string) throws VisADException, RemoteException {
        this.removeAllReferences();
        this.addDataSource(string, 2);
    }

    public void waitForFormula() throws VisADException, RemoteException {
        this.waitForData();
    }

    public DataReferenceImpl getDataRef() {
        return this.getDataCount() > 0 ? (DataReferenceImpl)this.getReference(this.getFirstVariableName()) : null;
    }

    public RemoteDataReferenceImpl getRemoteDataRef() {
        return this.getDataCount() > 0 ? (RemoteDataReferenceImpl)this.getRemoteReference(this.getFirstVariableName()) : null;
    }

    public URL getFileURL() {
        URL uRL;
        block3: {
            uRL = null;
            String string = this.getFirstVariableName();
            if (this.getDataCount() > 0 && this.getDataSourceType(string) == 1) {
                try {
                    uRL = new URL(this.getDataSource(string));
                }
                catch (MalformedURLException malformedURLException) {
                    if (!DEBUG || DEBUG_LEVEL < 3) break block3;
                    malformedURLException.printStackTrace();
                }
            }
        }
        return uRL;
    }

    public String getFilename() {
        String string = "";
        String string2 = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(string2) == 1) {
            string = this.getDataSource(string2);
        }
        return string;
    }

    public String getRMIAddress() {
        String string = null;
        String string2 = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(string2) == 3) {
            string = this.getDataSource(string2);
        }
        return string;
    }

    public String getFormula() {
        String string = "";
        String string2 = this.getFirstVariableName();
        if (this.getDataCount() > 0 && this.getDataSourceType(string2) == 2) {
            string = this.getDataSource(string2);
        }
        return string;
    }

    public void loadData(URL uRL) throws VisADException, RemoteException {
        this.addDataSource(uRL.toString(), 1);
    }

    public void loadData(String string) throws VisADException, RemoteException {
        this.addDataSource(string, 1);
    }

    public void loadRMI(String string) throws VisADException, RemoteException {
        this.addDataSource(string, 3);
    }

    public void setDimension(boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (!bl && bl2) {
            return;
        }
        int n = !bl && !bl2 ? 1 : (bl && bl2 ? 2 : 3);
        this.setDimension(n);
    }

    public boolean hasFormula() {
        return this.getDataCount() > 0 && this.getDataSourceType(this.getFirstVariableName()) == 2;
    }

    public DataReference getReference() {
        return this.getDataCount() > 0 ? this.getReference(this.getFirstVariableName()) : null;
    }

    static /* synthetic */ JPanel access$0(BasicSSCell basicSSCell) {
        return basicSSCell.WaitPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BasicSSCell(String string) throws VisADException, RemoteException {
        this(string, null, null, false, null);
    }

    public BasicSSCell(String string, FormulaManager formulaManager) throws VisADException, RemoteException {
        this(string, formulaManager, null, false, null);
    }

    public BasicSSCell(String string, RemoteServer remoteServer) throws VisADException, RemoteException {
        this(string, null, remoteServer, false, null);
    }

    public BasicSSCell(String string, String string2) throws VisADException, RemoteException {
        this(string, null, null, false, string2);
    }

    public BasicSSCell(String string, FormulaManager formulaManager, RemoteServer remoteServer, String string2) throws VisADException, RemoteException {
        this(string, formulaManager, remoteServer, false, string2);
    }

    public BasicSSCell(String string, FormulaManager formulaManager, RemoteServer remoteServer, boolean bl, String string2) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("BasicSSCell: name cannot be null");
        }
        Vector vector = SSCellVector;
        synchronized (vector) {
            int n = SSCellVector.size();
            int n2 = 0;
            while (n2 < n) {
                BasicSSCell basicSSCell = (BasicSSCell)SSCellVector.elementAt(n2);
                if (string.equalsIgnoreCase(basicSSCell.Name)) {
                    throw new VisADException("BasicSSCell: name already used");
                }
                ++n2;
            }
            this.Name = string;
            SSCellVector.add(this);
        }
        FormulaManager formulaManager2 = this.fm = formulaManager == null ? defaultFM : formulaManager;
        if (remoteServer != null) {
            this.RemoteVServer = remoteServer;
            this.RemoteVDisplay = remoteServer.getDisplay(this.Name);
        }
        this.IsRemote = this.RemoteVDisplay != null;
        this.IsSlave = bl;
        if (this.IsRemote) {
            this.setupClient();
        } else {
            this.setupServer();
        }
        if (string2 != null) {
            this.setSaveString(string2);
        }
        this.initDisplayPanel();
        this.setPreferredSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.setBackground(this.IsSlave ? Color.darkGray : Color.black);
        this.setLayout(new BoxLayout(this, 0));
    }

    static {
        CanDo3D = BasicSSCell.enable3D();
        defaultFM = FormulaUtil.createStandardManager();
        messages = new String[]{"ADD_DATA", "ADD_SOURCE", "REMOVE_DATA", "SET_MAPS", "SET_DIM", "SET_ERRORS", "UPDATE_DATA", "UPDATE_DEPENDENCIES", "STATUS"};
    }
}

