/*
 * Decompiled with CFR 0.152.
 */
package visad.rabin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.DataReferenceImpl;
import visad.RealType;
import visad.VisADException;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.util.VisADSlider;

public class RainSheet
extends JFrame
implements ActionListener {
    static final int N_COLUMNS = 3;
    static final int N_ROWS = 4;
    static final JPanel[] row_panels = new JPanel[4];
    static final FancySSCell[] cells = new FancySSCell[12];
    static final JTextField[] formulas = new JTextField[12];
    static final JButton[] maps = new JButton[12];
    static final int WIDTH = 1100;
    static final int HEIGHT = 900;
    static final int CELL_WIDTH = 200;
    static final int CELL_HEIGHT = 200;
    static String[] formula_name = new String[]{"A1", "B1", "C1", "A2", "B2", "C2", "A3", "B3", "C3", "A4", "B4", "C4"};
    static String[] formula_array = new String[]{"file:dallas_2.5km_v5d.v5d", "A1(0)", "((10^((extract(B1,0))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,1))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,2))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,3))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,4))/10))/SLIDER300)^(1/SLIDER1_4)", "((10^((extract(B1,5))/10))/SLIDER300)^(1/SLIDER1_4)", "(10*C1+10*A2+10*B2+10*C2+10*A3+3*B3)/53", "extract(B1,6)", "extract(B1,7)", "extract(B1,8)"};
    private JTextField Formula1;
    private JTextField Formula2;

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        RainSheet rainSheet = new RainSheet();
        rainSheet.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)rainSheet).setSize(1100, 900);
        Dimension dimension2 = rainSheet.getSize();
        ((Component)rainSheet).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        ((Component)rainSheet).setVisible(true);
    }

    private static void createLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jPanel.add(jLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("quit")) {
            this.quitProgram();
            return;
        }
        int n = 0;
        while (n < 12) {
            if (string.equals("load" + n)) {
                cells[n].loadDataDialog();
            } else if (string.equals("save" + n)) {
                cells[n].saveDataDialog(true);
            } else if (string.equals("map" + n)) {
                cells[n].addMapDialog();
            } else if (string.equals("show" + n)) {
                cells[n].showWidgetFrame();
            } else if (string.equals("formula" + n)) {
                maps[n].requestFocus();
                try {
                    cells[n].setFormula(formulas[n].getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    void quitProgram() {
        Thread thread = new Thread(this){
            private final /* synthetic */ RainSheet this$0;

            public void run() {
                if (BasicSSCell.isSaving()) {
                    System.out.println("Please wait for RainSheet to finish saving files...");
                }
                while (BasicSSCell.isSaving()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
            {
                this.this$0 = rainSheet;
                this.constructor$0(rainSheet);
            }

            private final void constructor$0(RainSheet rainSheet) {
            }
        };
        thread.start();
    }

    public RainSheet() throws VisADException, RemoteException {
        super("RainSheet");
        ((Component)this).setBackground(Color.white);
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ RainSheet this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.quitProgram();
            }
            {
                this.this$0 = rainSheet;
                this.constructor$0(rainSheet);
            }

            private final void constructor$0(RainSheet rainSheet) {
            }
        });
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 10, 5, 10)));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        RainSheet.createLabel(jPanel2, "RainSheet -- a custom spreadsheet");
        RainSheet.createLabel(jPanel2, "for rain estimation");
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("num300");
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("num1_4");
        VisADSlider visADSlider = new VisADSlider("num300", 0, 600, 300, 1.0, dataReferenceImpl, RealType.Generic);
        VisADSlider visADSlider2 = new VisADSlider("num1_4", 0, 280, 140, 0.01, dataReferenceImpl2, RealType.Generic);
        jPanel2.add(visADSlider);
        jPanel2.add(visADSlider2);
        BasicSSCell.createVar("SLIDER300", dataReferenceImpl);
        BasicSSCell.createVar("SLIDER1_4", dataReferenceImpl2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setAlignmentX(0.0f);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(0, 15)));
        jPanel2.add(jPanel4);
        JButton jButton = new JButton("Quit");
        jButton.addActionListener(this);
        jButton.setActionCommand("quit");
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(jButton);
        jPanel4.add(Box.createHorizontalGlue());
        Dimension dimension = jPanel2.getPreferredSize();
        jPanel2.setMinimumSize(dimension);
        jPanel2.setMaximumSize(dimension);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            RainSheet.row_panels[n2] = new JPanel();
            row_panels[n2].setLayout(new BoxLayout(row_panels[n2], 0));
            row_panels[n2].setAlignmentY(0.0f);
            row_panels[n2].setAlignmentX(0.0f);
            jPanel3.add(row_panels[n2]);
            int n3 = 0;
            while (n3 < 3) {
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new BoxLayout(jPanel5, 1));
                row_panels[n2].add(jPanel5);
                FancySSCell fancySSCell = null;
                try {
                    fancySSCell = new FancySSCell(formula_name[n], this);
                    fancySSCell.setDimension(true, false);
                }
                catch (Exception exception) {
                    System.out.println("Could not create the first spreadsheet cell!");
                    System.out.println("Received the following exception:");
                    System.out.println(exception.toString());
                    System.exit(n);
                }
                fancySSCell.setPreferredSize(new Dimension(200, 200));
                fancySSCell.setMaximumSize(new Dimension(200, 200));
                JPanel jPanel6 = new JPanel();
                jPanel6.setLayout(new BoxLayout(jPanel6, 0));
                JButton jButton2 = new JButton("Load");
                jButton2.addActionListener(this);
                jButton2.setActionCommand("load" + n);
                jPanel6.add(jButton2);
                JButton jButton3 = new JButton("Save");
                jButton3.addActionListener(this);
                jButton3.setActionCommand("save" + n);
                jPanel6.add(jButton3);
                JButton jButton4 = new JButton("Maps");
                jButton4.addActionListener(this);
                jButton4.setActionCommand("map" + n);
                jPanel6.add(jButton4);
                JButton jButton5 = new JButton("Show");
                jButton5.addActionListener(this);
                jButton5.setActionCommand("show" + n);
                jPanel6.add(jButton5);
                JTextField jTextField = new JTextField();
                Dimension dimension2 = jTextField.getMaximumSize();
                Dimension dimension3 = jTextField.getPreferredSize();
                dimension2.height = dimension3.height;
                jTextField.setMaximumSize(dimension2);
                JPanel jPanel7 = new JPanel();
                jPanel7.setLayout(new BoxLayout(jPanel7, 0));
                jPanel7.add(Box.createHorizontalGlue());
                JLabel jLabel = new JLabel(formula_name[n]);
                jLabel.setForeground(Color.blue);
                jPanel7.add(jLabel);
                jPanel7.add(Box.createHorizontalGlue());
                JPanel jPanel8 = new JPanel();
                jPanel8.setLayout(new BoxLayout(jPanel8, 0));
                RainSheet.createLabel(jPanel8, "Formula:  ");
                JTextField jTextField2 = new JTextField(formula_array[n]);
                dimension2 = jTextField2.getMaximumSize();
                dimension3 = jTextField2.getPreferredSize();
                dimension2.height = dimension3.height;
                jTextField2.setMaximumSize(dimension2);
                jTextField2.addActionListener(this);
                jTextField2.setActionCommand("formula" + n);
                jPanel8.add(jTextField2);
                jPanel5.add(jPanel7);
                jPanel5.add(jPanel8);
                jPanel5.add(fancySSCell);
                jPanel5.add(jPanel6);
                RainSheet.cells[n] = fancySSCell;
                RainSheet.maps[n] = jButton4;
                RainSheet.formulas[n] = jTextField2;
                ++n;
                ++n3;
            }
            ++n2;
        }
        n = 0;
        while (n < 12) {
            ++n;
        }
    }
}

