/*
 * Decompiled with CFR 0.152.
 */
package visad.rabin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.ActionImpl;
import visad.CellImpl;
import visad.ColorControl;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteActionImpl;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.ShapeControl;
import visad.Text;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.data.Form;
import visad.data.netcdf.Plain;
import visad.data.vis5d.Vis5DForm;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.rabin.Rain;
import visad.util.Delay;
import visad.util.LabeledColorWidget;
import visad.util.VisADSlider;

public class Rain
implements ActionListener,
ControlListener {
    static final int N_COLUMNS = 3;
    static final int N_ROWS = 4;
    static final String[][] cell_names = new String[][]{{"A1", "B1", "C1"}, {"A2", "B2", "C2"}, {"A3", "B3", "C3"}, {"A4", "B4", "C4"}};
    static final String[][] cell_formulas = new String[][]{{"", "A1[0]", "(10^(extract(B1, 0)/10)/num300) ^ (1/num1_4)"}, {"(10^(extract(B1, 1)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 2)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 3)/10)/num300) ^ (1/num1_4)"}, {"(10^(extract(B1, 4)/10)/num300) ^ (1/num1_4)", "(10^(extract(B1, 5)/10)/num300) ^ (1/num1_4)", "(10*C1 + 10*A2 + 10*B2 + 10*C2 + 10*A3 + 3*B3)/53"}, {"extract(B1, 6)", "extract(B1, 7)", "extract(B1, 8)"}};
    static final int WIDTH = 1100;
    static final int HEIGHT = 900;
    static final double MIN = 0.0;
    static final double MAX = 300.0;
    static final double MAXH2 = 10.0;
    RemoteServerImpl server_server = null;
    RemoteServer client_server = null;
    boolean twod = false;
    final JPanel[] column_panels = new JPanel[3];
    final JPanel[][] cell_panels = new JPanel[4][3];
    final DataReference[][] cell_refs = new DataReferenceImpl[4][3];
    final CellImpl[][] cells = new CellImpl[4][3];
    final DisplayImpl[][] displays = new DisplayImpl[4][3];
    final RemoteDisplayImpl[][] remote_displays = new RemoteDisplayImpl[4][3];
    final CellImpl[][] formula_update = new CellImpl[4][3];
    final boolean[][] display_done = new boolean[4][3];
    JLabel[][] cell_fields = new JLabel[4][3];
    DataReference ref300 = null;
    DataReference ref1_4 = null;
    DataReference refMAX = null;
    DataReference ref_cursor = null;
    DataReference ref_vis5d = null;
    DataReference ref_projection = null;
    DataReference ref_colorH1 = null;
    DataReference ref_colorH2 = null;
    DataReference[][] cell_text = new DataReference[4][3];
    VisADSlider slider300;
    LabeledColorWidget color_widgetH1 = null;
    LabeledColorWidget color_widgetH2 = null;
    ColorControl color_controlH1 = null;
    ColorControl color_controlH2 = null;
    ColorControl[][] color_controls = new ColorControl[4][3];
    ProjectionControl[][] projection_controls = new ProjectionControl[4][3];
    ScalarMap[][] color_maps = new ScalarMap[4][3];
    ScalarMap color_mapH1 = null;
    ScalarMap color_mapH2 = null;
    RealType band7 = null;
    RealTupleType cursor_type = null;
    FormulaManager f_manager = null;
    JTextField[][] jtfield = new JTextField[4][3];
    boolean in_proj = false;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("run 'java visad.rabin.Rain file.v5d'\n or");
            System.out.println("    'java visad.rabin.Rain file.nc'\n or");
            System.out.println("    'java visad.rabin.Rain server.ip.name'");
            System.exit(1);
        }
        Rain rain = new Rain(stringArray);
        rain.makeRain();
    }

    private void makeRain() throws VisADException, RemoteException, IOException {
        Serializable serializable;
        int n;
        Object object;
        Serializable serializable2;
        Object object2;
        Cloneable cloneable;
        FieldImpl fieldImpl = (FieldImpl)this.ref_vis5d.getData();
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        RealType realType = (RealType)functionType.getDomain().getComponent(0);
        FunctionType functionType2 = (FunctionType)functionType.getRange();
        RealTupleType realTupleType = functionType2.getDomain();
        RealType realType2 = (RealType)realTupleType.getComponent(0);
        RealType realType3 = (RealType)realTupleType.getComponent(1);
        RealTupleType realTupleType2 = (RealTupleType)functionType2.getRange();
        RealType realType4 = (RealType)realTupleType2.getComponent(0);
        RealType realType5 = (RealType)realTupleType2.getComponent(8);
        int n2 = realTupleType2.getDimension();
        RealType[] realTypeArray = new RealType[n2];
        int n3 = 0;
        while (n3 < n2) {
            realTypeArray[n3] = (RealType)realTupleType2.getComponent(n3);
            ++n3;
        }
        RealType realType6 = new RealType("shape");
        RealTupleType realTupleType3 = new RealTupleType(realType2, realType3, realType6);
        SampledSet sampledSet = (SampledSet)((FlatField)fieldImpl.getSample(0)).getDomainSet();
        float[] fArray = sampledSet.getLow();
        float[] fArray2 = sampledSet.getHi();
        double d = 0.5 * (double)(fArray[0] + fArray2[0]);
        double d2 = 0.5 * (double)(fArray[1] + fArray2[1]);
        RealTuple realTuple = new RealTuple(realTupleType3, new double[]{d, d2, 0.0});
        this.ref_cursor.setData(realTuple);
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)realType6, new float[][]{{0.0f}}, 1);
        VisADLineArray visADLineArray = new VisADLineArray();
        visADLineArray.coordinates = new float[]{0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.1f, 0.0f};
        visADLineArray.colors = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        visADLineArray.vertexCount = visADLineArray.coordinates.length / 3;
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[]{visADLineArray};
        this.f_manager = FormulaUtil.createStandardManager();
        this.f_manager.createVar("num300", this.ref300);
        this.f_manager.createVar("num1_4", this.ref1_4);
        JFrame jFrame = new JFrame("Vis5D");
        WindowAdapter windowAdapter = new WindowAdapter(this){
            private final /* synthetic */ Rain this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = rain;
                this.constructor$0(rain);
            }

            private final void constructor$0(Rain rain) {
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ((Component)jFrame).setSize(1100, 900);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - 550, dimension.height / 2 - 450);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        int n4 = 0;
        while (n4 < 3) {
            this.column_panels[n4] = new JPanel();
            this.column_panels[n4].setLayout(new BoxLayout(this.column_panels[n4], 1));
            this.column_panels[n4].setAlignmentY(0.0f);
            this.column_panels[n4].setAlignmentX(0.0f);
            jPanel3.add(this.column_panels[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < 3) {
                this.cell_panels[n4][n5] = new JPanel();
                this.cell_panels[n4][n5].setLayout(new BoxLayout(this.cell_panels[n4][n5], 1));
                this.cell_panels[n4][n5].setAlignmentY(0.0f);
                this.cell_panels[n4][n5].setAlignmentX(0.0f);
                this.column_panels[n5].add(this.cell_panels[n4][n5]);
                this.cell_refs[n4][n5] = n4 == 0 && n5 == 0 ? this.ref_vis5d : new DataReferenceImpl("cell_" + n4 + "_" + n5);
                this.displays[n4][n5] = this.newDisplay("display_" + n4 + "_" + n5);
                if (this.client_server != null) {
                    this.remote_displays[n4][n5] = new RemoteDisplayImpl(this.displays[n4][n5]);
                }
                this.displays[n4][n5].addMap(new ScalarMap(realType3, Display.XAxis));
                this.displays[n4][n5].addMap(new ScalarMap(realType2, Display.YAxis));
                ScalarMap scalarMap = new ScalarMap(realType6, Display.Shape);
                this.displays[n4][n5].addMap(scalarMap);
                cloneable = (ShapeControl)scalarMap.getControl();
                ((ShapeControl)cloneable).setShapeSet(gridded1DSet);
                ((ShapeControl)cloneable).setShapes(visADGeometryArrayArray);
                this.projection_controls[n4][n5] = this.displays[n4][n5].getProjectionControl();
                this.projection_controls[n4][n5].addControlListener(this);
                this.display_done[n4][n5] = false;
                this.f_manager.createVar(cell_names[n4][n5], this.cell_refs[n4][n5]);
                this.f_manager.setTextRef(cell_names[n4][n5], this.cell_text[n4][n5]);
                object2 = new JPanel();
                ((Container)object2).setLayout(new BoxLayout((Container)object2, 0));
                this.jtfield[n4][n5] = new JTextField(cell_formulas[n4][n5]);
                serializable2 = this.jtfield[n4][n5].getPreferredSize();
                object = this.jtfield[n4][n5].getMaximumSize();
                ((Dimension)object).height = ((Dimension)serializable2).height;
                this.jtfield[n4][n5].setMaximumSize((Dimension)object);
                this.jtfield[n4][n5].addActionListener(this);
                this.jtfield[n4][n5].setActionCommand("fc_" + cell_names[n4][n5]);
                ((Container)object2).add(new JLabel(cell_names[n4][n5] + ": "));
                ((Container)object2).add(this.jtfield[n4][n5]);
                this.cell_panels[n4][n5].add((Component)object2);
                int n6 = n4;
                n = n5;
                Rain rain = this;
                this.formula_update[n4][n5] = new CellImpl(this, n6, n, realType6, gridded1DSet, visADGeometryArrayArray){
                    private final /* synthetic */ Rain this$0;
                    private final /* synthetic */ int val$fi;
                    private final /* synthetic */ int val$fj;
                    private final /* synthetic */ RealType val$shape;
                    private final /* synthetic */ Gridded1DSet val$shape_count_set;
                    private final /* synthetic */ VisADGeometryArray[] val$shapes;

                    public void doAction() {
                        Object object;
                        Serializable serializable;
                        Object object2;
                        RealType realType;
                        ScalarMap[] scalarMapArray = null;
                        Vector vector = this.this$0.displays[this.val$fi][this.val$fj].getMapVector();
                        scalarMapArray = new ScalarMap[vector.size()];
                        int n = 0;
                        while (n < scalarMapArray.length) {
                            scalarMapArray[n] = (ScalarMap)vector.elementAt(n);
                            ++n;
                        }
                        n = 0;
                        int n2 = 0;
                        while (n2 < scalarMapArray.length && n == 0) {
                            RealType realType2 = (RealType)scalarMapArray[n2].getScalar();
                            realType = scalarMapArray[n2].getDisplayScalar();
                            if (realType.equals(Display.RGB)) {
                                try {
                                    object2 = this.this$0.cell_refs[this.val$fi][this.val$fj].getData();
                                    if (object2 != null && !((RealType)(serializable = (RealType)((FunctionType)(object = (FunctionType)object2.getType())).getRange())).equals(realType2)) {
                                        n = 1;
                                    }
                                }
                                catch (ClassCastException classCastException) {
                                }
                                catch (VisADException visADException) {
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                        if (n != 0) {
                            try {
                                this.this$0.displays[this.val$fi][this.val$fj].removeReference(this.this$0.cell_refs[this.val$fi][this.val$fj]);
                                if (this.this$0.color_controls[this.val$fi][this.val$fj] != null || this.val$fi == 0 && this.val$fj == 2) {
                                    this.this$0.removeCursor(this.val$fi, this.val$fj);
                                }
                                this.this$0.displays[this.val$fi][this.val$fj].clearMaps();
                            }
                            catch (VisADException visADException) {
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                            int n3 = 0;
                            while (n3 < scalarMapArray.length) {
                                boolean bl = false;
                                realType = (RealType)scalarMapArray[n3].getScalar();
                                object2 = scalarMapArray[n3].getDisplayScalar();
                                if (((RealType)object2).equals(Display.RGB)) {
                                    try {
                                        object = this.this$0.cell_refs[this.val$fi][this.val$fj].getData();
                                        serializable = (FunctionType)object.getType();
                                        RealType realType3 = (RealType)((FunctionType)serializable).getRange();
                                        if (!realType3.equals(realType)) {
                                            double d;
                                            ScalarMap scalarMap;
                                            scalarMapArray[n3] = scalarMap = new ScalarMap(realType3, Display.RGB);
                                            ColorControl colorControl = null;
                                            if (this.val$fi == 3 && this.val$fj == 2) {
                                                colorControl = this.this$0.color_controlH2;
                                                d = 10.0;
                                            } else {
                                                colorControl = this.this$0.color_controlH1;
                                                d = ((Real)this.this$0.refMAX.getData()).getValue();
                                            }
                                            if (colorControl != null) {
                                                float[][] fArray = colorControl.getTable();
                                                this.this$0.color_maps[this.val$fi][this.val$fj] = scalarMap;
                                                this.this$0.color_maps[this.val$fi][this.val$fj].setRange(0.0, d);
                                                this.this$0.displays[this.val$fi][this.val$fj].addMap(scalarMap);
                                                bl = true;
                                                this.this$0.color_controls[this.val$fi][this.val$fj] = (ColorControl)this.this$0.color_maps[this.val$fi][this.val$fj].getControl();
                                                if (fArray != null) {
                                                    this.this$0.color_controls[this.val$fi][this.val$fj].setTable(fArray);
                                                }
                                            }
                                            boolean bl2 = realType3.equals(this.this$0.band7);
                                            GraphicsModeControl graphicsModeControl = this.this$0.displays[this.val$fi][this.val$fj].getGraphicsModeControl();
                                            graphicsModeControl.setTextureEnable(!bl2);
                                            graphicsModeControl.setPointMode(bl2);
                                            graphicsModeControl.setPointSize(5.0f);
                                        }
                                    }
                                    catch (ClassCastException classCastException) {
                                    }
                                    catch (VisADException visADException) {
                                    }
                                    catch (RemoteException remoteException) {}
                                } else if (((RealType)object2).equals(Display.Shape)) {
                                    try {
                                        object = new ScalarMap(this.val$shape, Display.Shape);
                                        this.this$0.displays[this.val$fi][this.val$fj].addMap((ScalarMap)object);
                                        serializable = (ShapeControl)((ScalarMap)object).getControl();
                                        ((ShapeControl)serializable).setShapeSet(this.val$shape_count_set);
                                        ((ShapeControl)serializable).setShapes(this.val$shapes);
                                        bl = true;
                                    }
                                    catch (VisADException visADException) {
                                    }
                                    catch (RemoteException remoteException) {
                                        // empty catch block
                                    }
                                }
                                if (!bl) {
                                    try {
                                        this.this$0.displays[this.val$fi][this.val$fj].addMap(scalarMapArray[n3]);
                                    }
                                    catch (VisADException visADException) {
                                    }
                                    catch (RemoteException remoteException) {
                                        // empty catch block
                                    }
                                }
                                ++n3;
                            }
                            try {
                                this.this$0.displays[this.val$fi][this.val$fj].addReference(this.this$0.cell_refs[this.val$fi][this.val$fj]);
                                if (this.this$0.color_controls[this.val$fi][this.val$fj] != null) {
                                    this.this$0.addCursor(this.val$fi, this.val$fj);
                                }
                            }
                            catch (VisADException visADException) {
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                    {
                        this.val$fi = n;
                        this.val$fj = n2;
                        this.val$shape = realType;
                        this.val$shape_count_set = gridded1DSet;
                        this.val$shapes = visADGeometryArrayArray;
                        this.this$0 = rain;
                        this.constructor$0(rain);
                    }

                    private final void constructor$0(Rain rain) {
                    }
                };
                serializable = (JPanel)this.displays[n4][n5].getComponent();
                ((JComponent)serializable).setAlignmentX(0.5f);
                CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
                ((JComponent)serializable).setBorder(compoundBorder);
                this.cell_panels[n4][n5].add((Component)serializable);
                this.cell_fields[n4][n5] = new JLabel("---");
                this.cell_fields[n4][n5].setAlignmentX(0.5f);
                this.cell_fields[n4][n5].setMinimumSize(this.jtfield[n4][n5].getMinimumSize());
                this.cell_fields[n4][n5].setPreferredSize(this.jtfield[n4][n5].getPreferredSize());
                this.cell_fields[n4][n5].setMaximumSize(this.jtfield[n4][n5].getMaximumSize());
                this.cell_panels[n4][n5].add(this.cell_fields[n4][n5]);
                ++n5;
            }
            ++n4;
        }
        this.slider300 = new VisADSlider("num300", 0, 600, 300, 1.0, this.ref300, RealType.Generic);
        VisADSlider visADSlider = new VisADSlider("num1_4", 0, 280, 140, 0.01, this.ref1_4, RealType.Generic);
        VisADSlider visADSlider2 = new VisADSlider("colorMAX", 0, 1000, 300, 1.0, this.refMAX, RealType.Generic);
        jPanel2.add(this.slider300);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(visADSlider);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(visADSlider2);
        jPanel2.add(new JLabel("  "));
        int n7 = 0;
        while (n7 < 4) {
            int n8 = 0;
            while (n8 < 3) {
                if (n7 != 0 || n8 != 0) {
                    this.f_manager.assignFormula(cell_names[n7][n8], cell_formulas[n7][n8]);
                }
                ++n8;
            }
            ++n7;
        }
        this.color_mapH1 = new ScalarMap(realType4, Display.RGB);
        DisplayImpl displayImpl = this.newDisplay("display_hidden_1");
        displayImpl.addMap(this.color_mapH1);
        this.color_widgetH1 = new LabeledColorWidget(this.color_mapH1);
        cloneable = new Dimension(500, 170);
        this.color_widgetH1.setMaximumSize((Dimension)cloneable);
        this.color_mapH1.setRange(0.0, 300.0);
        jPanel2.add(this.color_widgetH1);
        jPanel2.add(new JLabel("  "));
        this.color_controlH1 = (ColorControl)this.color_mapH1.getControl();
        this.color_controlH1.addControlListener(this);
        if (this.server_server != null) {
            object2 = this.color_controlH1.getTable();
            serializable2 = new Integer1DSet(object2[0].length);
            object = new FlatField(FunctionType.REAL_1TO3_FUNCTION, (Set)serializable2);
            ((FlatField)object).setSamples((float[][])object2);
            this.ref_colorH1.setData((Data)object);
        }
        if (this.server_server != null || this.client_server != null) {
            object2 = new CellImpl(this){
                private final /* synthetic */ Rain this$0;

                public void doAction() throws VisADException, RemoteException {
                    FlatField flatField = (FlatField)this.this$0.ref_colorH1.getData().local();
                    float[][] fArray = flatField.getFloats();
                    float[][] fArray2 = this.this$0.color_controlH1.getTable();
                    boolean bl = true;
                    int n = 0;
                    while (n < 3) {
                        if (bl) {
                            int n2 = 0;
                            while (n2 < fArray[n].length) {
                                if ((double)Math.abs(fArray[n][n2] - fArray2[n][n2]) > 1.0E-5) {
                                    bl = false;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.this$0.color_controlH1.setTable(fArray);
                    }
                }
                {
                    this.this$0 = rain;
                    this.constructor$0(rain);
                }

                private final void constructor$0(Rain rain) {
                }
            };
            if (this.client_server != null) {
                serializable2 = new RemoteCellImpl((CellImpl)object2);
                ((RemoteActionImpl)serializable2).addReference(this.ref_colorH1);
            } else {
                ((ActionImpl)object2).addReference(this.ref_colorH1);
            }
        }
        this.color_mapH2 = new ScalarMap(realType5, Display.RGB);
        object2 = this.newDisplay("display_hidden_2");
        ((DisplayImpl)object2).addMap(this.color_mapH2);
        this.color_widgetH2 = new LabeledColorWidget(this.color_mapH2);
        serializable2 = new Dimension(500, 170);
        this.color_widgetH2.setMaximumSize((Dimension)serializable2);
        this.color_mapH2.setRange(0.0, 10.0);
        this.color_controlH2 = (ColorControl)this.color_mapH2.getControl();
        this.color_controlH2.addControlListener(this);
        if (this.server_server != null) {
            object = this.color_controlH2.getTable();
            Integer1DSet integer1DSet = new Integer1DSet(((Object)object[0]).length);
            FlatField flatField = new FlatField(FunctionType.REAL_1TO3_FUNCTION, integer1DSet);
            flatField.setSamples((float[][])object);
            this.ref_colorH2.setData(flatField);
        }
        if (this.server_server != null || this.client_server != null) {
            object = new CellImpl(this){
                private final /* synthetic */ Rain this$0;

                public void doAction() throws VisADException, RemoteException {
                    FlatField flatField = (FlatField)this.this$0.ref_colorH2.getData().local();
                    float[][] fArray = flatField.getFloats();
                    float[][] fArray2 = this.this$0.color_controlH2.getTable();
                    boolean bl = true;
                    int n = 0;
                    while (n < 3) {
                        if (bl) {
                            int n2 = 0;
                            while (n2 < fArray[n].length) {
                                if ((double)Math.abs(fArray[n][n2] - fArray2[n][n2]) > 1.0E-5) {
                                    bl = false;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.this$0.color_controlH2.setTable(fArray);
                    }
                }
                {
                    this.this$0 = rain;
                    this.constructor$0(rain);
                }

                private final void constructor$0(Rain rain) {
                }
            };
            if (this.client_server != null) {
                RemoteCellImpl remoteCellImpl = new RemoteCellImpl((CellImpl)object);
                remoteCellImpl.addReference(this.ref_colorH2);
            } else {
                ((ActionImpl)object).addReference(this.ref_colorH2);
            }
        }
        jPanel2.add(this.color_widgetH2);
        jPanel2.add(new JLabel("  "));
        this.displays[0][0].addMap(new ScalarMap(realTypeArray[0], Display.Red));
        this.displays[0][0].addMap(new ScalarMap(realTypeArray[1], Display.Green));
        this.displays[0][0].addMap(new ScalarMap(realTypeArray[2], Display.Blue));
        this.displays[0][0].addMap(new ScalarMap(realType, Display.Animation));
        this.displays[0][0].addReference(this.cell_refs[0][0]);
        this.display_done[0][0] = true;
        if (this.server_server != null) {
            object = this.projection_controls[0][0].getMatrix();
            if (((Object)object).length != 6) {
                object = ProjectionControl.matrix3DTo2D((double[])object);
            }
            Integer1DSet integer1DSet = new Integer1DSet(6);
            FlatField flatField = new FlatField(FunctionType.REAL_1TO1_FUNCTION, integer1DSet);
            flatField.setSamples(new double[][]{(double[])object});
            this.ref_projection.setData(flatField);
        }
        if (this.server_server != null || this.client_server != null) {
            object = new CellImpl(this){
                private final /* synthetic */ Rain this$0;

                public void doAction() throws VisADException, RemoteException {
                    FlatField flatField = (FlatField)this.this$0.ref_projection.getData().local();
                    double[] dArray = flatField.getValues()[0];
                    double[] dArray2 = this.this$0.projection_controls[0][0].getMatrix();
                    double[] dArray3 = null;
                    dArray3 = dArray2.length == 6 ? dArray2 : ProjectionControl.matrix3DTo2D(dArray2);
                    boolean bl = true;
                    int n = 0;
                    while (n < dArray.length) {
                        if (Math.abs(dArray[n] - dArray3[n]) > 1.0E-5) {
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        if (dArray2.length == 6) {
                            this.this$0.projection_controls[0][0].setMatrix(dArray);
                        } else {
                            double[] dArray4 = ProjectionControl.matrix2DTo3D(dArray);
                            this.this$0.projection_controls[0][0].setMatrix(dArray4);
                        }
                    }
                }
                {
                    this.this$0 = rain;
                    this.constructor$0(rain);
                }

                private final void constructor$0(Rain rain) {
                }
            };
            if (this.client_server != null) {
                RemoteCellImpl remoteCellImpl = new RemoteCellImpl((CellImpl)object);
                remoteCellImpl.addReference(this.ref_projection);
            } else {
                ((ActionImpl)object).addReference(this.ref_projection);
            }
        }
        this.displays[0][1].addMap(new ScalarMap(realTypeArray[0], Display.Red));
        this.displays[0][1].addMap(new ScalarMap(realTypeArray[1], Display.Green));
        this.displays[0][1].addMap(new ScalarMap(realTypeArray[2], Display.Blue));
        this.displays[0][1].addReference(this.cell_refs[0][1]);
        this.display_done[0][1] = true;
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(0), 0, 2);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(1), 1, 0);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(2), 1, 1);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(3), 1, 2);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(4), 2, 0);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(5), 2, 1);
        this.finishDisplay(this.client_server, realType4, 2, 2);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(6), 3, 0);
        this.band7 = (RealType)realTupleType2.getComponent(7);
        this.finishDisplay(this.client_server, this.band7, 3, 1);
        object = this.displays[3][1].getGraphicsModeControl();
        ((GraphicsModeControl)object).setTextureEnable(false);
        ((GraphicsModeControl)object).setPointMode(true);
        ((GraphicsModeControl)object).setPointSize(5.0f);
        this.finishDisplay(this.client_server, (RealType)realTupleType2.getComponent(8), 3, 2);
        CellImpl cellImpl = new CellImpl(this){
            private final /* synthetic */ Rain this$0;

            public void doAction() {
                int n = 0;
                while (n < 4) {
                    int n2 = 0;
                    while (n2 < 3) {
                        try {
                            Text text = (Text)this.this$0.cell_text[n][n2].getThing();
                            if (text != null) {
                                String string = text.getValue();
                                if (string == null) {
                                    string = "";
                                }
                                if (!string.equals(this.this$0.jtfield[n][n2].getText())) {
                                    JTextField jTextField = this.this$0.jtfield[n][n2];
                                    String string2 = string;
                                    SwingUtilities.invokeLater(new Runnable(this, string2, jTextField){
                                        private final /* synthetic */ 6 this$0;
                                        private final /* synthetic */ String val$str;
                                        private final /* synthetic */ JTextField val$jtf;

                                        public void run() {
                                            this.val$jtf.setText(this.val$str);
                                        }
                                        {
                                            this.val$str = string;
                                            this.val$jtf = jTextField;
                                            this.this$0 = var1_1;
                                            this.constructor$0(var1_1);
                                        }

                                        private final void constructor$0(6 var1_1) {
                                        }
                                    });
                                }
                            }
                        }
                        catch (VisADException visADException) {
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            {
                this.this$0 = rain;
                this.constructor$0(rain);
            }

            private final void constructor$0(Rain rain) {
            }
        };
        if (this.client_server != null) {
            RemoteCellImpl remoteCellImpl = new RemoteCellImpl(cellImpl);
            int n9 = 0;
            while (n9 < 4) {
                int n10 = 0;
                while (n10 < 3) {
                    remoteCellImpl.addReference(this.cell_text[n9][n10]);
                    ++n10;
                }
                ++n9;
            }
        } else {
            n = 0;
            while (n < 4) {
                int n11 = 0;
                while (n11 < 3) {
                    cellImpl.addReference(this.cell_text[n][n11]);
                    ++n11;
                }
                ++n;
            }
        }
        CellImpl cellImpl2 = new CellImpl(this){
            private final /* synthetic */ Rain this$0;

            public void doAction() throws VisADException, RemoteException {
                double d = ((Real)this.this$0.refMAX.getData()).getValue();
                this.this$0.color_mapH1.setRange(0.0, d);
                int n = 0;
                while (n < 4) {
                    int n2 = 0;
                    while (n2 < 3) {
                        if (this.this$0.color_maps[n][n2] != null && (n != 3 || n2 != 2)) {
                            this.this$0.color_maps[n][n2].setRange(0.0, d);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            {
                this.this$0 = rain;
                this.constructor$0(rain);
            }

            private final void constructor$0(Rain rain) {
            }
        };
        if (this.client_server != null) {
            RemoteCellImpl remoteCellImpl = new RemoteCellImpl(cellImpl2);
            remoteCellImpl.addReference(this.refMAX);
        } else {
            cellImpl2.addReference(this.refMAX);
        }
        CellImpl cellImpl3 = new CellImpl(this){
            private final /* synthetic */ Rain this$0;

            public void doAction() throws VisADException, RemoteException {
                RealTuple realTuple = (RealTuple)this.this$0.ref_cursor.getData();
                RealTuple realTuple2 = new RealTuple(new Real[]{(Real)realTuple.getComponent(0), (Real)realTuple.getComponent(1)});
                int n = 0;
                while (n < 4) {
                    int n2 = 0;
                    while (n2 < 3) {
                        try {
                            FlatField flatField = (FlatField)this.this$0.cell_refs[n][n2].getData();
                            double d = ((Real)flatField.evaluate(realTuple2)).getValue();
                            this.this$0.cell_fields[n][n2].setText("" + d);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            {
                this.this$0 = rain;
                this.constructor$0(rain);
            }

            private final void constructor$0(Rain rain) {
            }
        };
        if (this.client_server != null) {
            serializable = new RemoteCellImpl(cellImpl3);
            ((RemoteActionImpl)serializable).addReference(this.ref_cursor);
        } else {
            cellImpl3.addReference(this.ref_cursor);
        }
        new Delay(1000);
        int n12 = 0;
        while (n12 < 4) {
            int n13 = 0;
            while (n13 < 3) {
                this.formula_update[n12][n13].addReference(this.cell_refs[n12][n13]);
                ++n13;
            }
            ++n12;
        }
        ((Component)jFrame).setVisible(true);
    }

    public DisplayImpl newDisplay(String string) throws VisADException, RemoteException {
        DisplayImpl displayImpl = null;
        if (!this.twod) {
            try {
                displayImpl = new DisplayImplJ3D(string, (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.twod = true;
            }
        }
        if (this.twod) {
            displayImpl = new DisplayImplJ2D(string);
        }
        return displayImpl;
    }

    public void addCursor(int n, int n2) throws VisADException, RemoteException {
        DataRenderer dataRenderer = null;
        dataRenderer = this.twod ? new DirectManipulationRendererJ2D() : new DirectManipulationRendererJ3D();
        if (this.client_server != null) {
            this.remote_displays[n][n2].addReferences(dataRenderer, this.ref_cursor);
        } else {
            this.displays[n][n2].addReferences(dataRenderer, this.ref_cursor);
        }
    }

    public void removeCursor(int n, int n2) throws VisADException, RemoteException {
        if (this.client_server != null) {
            this.remote_displays[n][n2].removeReference(this.ref_cursor);
        } else {
            this.displays[n][n2].removeReference(this.ref_cursor);
        }
    }

    public void finishDisplay(RemoteServer remoteServer, RealType realType, int n, int n2) throws VisADException, RemoteException {
        float[][] fArray;
        this.color_maps[n][n2] = new ScalarMap(realType, Display.RGB);
        this.displays[n][n2].addMap(this.color_maps[n][n2]);
        this.color_maps[n][n2].setRange(0.0, 300.0);
        this.color_controls[n][n2] = (ColorControl)this.color_maps[n][n2].getControl();
        ColorControl colorControl = null;
        colorControl = n == 3 && n2 == 4 ? this.color_controlH2 : this.color_controlH1;
        if (colorControl != null && (fArray = colorControl.getTable()) != null) {
            this.color_controls[n][n2].setTable(fArray);
        }
        this.displays[n][n2].addReference(this.cell_refs[n][n2]);
        this.addCursor(n, n2);
        this.display_done[n][n2] = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("fc_")) {
            this.slider300.requestFocus();
            JTextField jTextField = (JTextField)actionEvent.getSource();
            String string2 = jTextField.getText();
            String string3 = string.substring(3, string.length());
            try {
                this.f_manager.assignFormula(string3, string2);
            }
            catch (FormulaException formulaException) {
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        Control control = controlEvent.getControl();
        if (control.equals(this.color_controlH1)) {
            Field field;
            float[][] fArray = this.color_controlH1.getTable();
            if (fArray != null) {
                int n = 0;
                while (n < 4) {
                    int n2 = 0;
                    while (n2 < 3) {
                        if (this.color_controls[n][n2] != null && (n != 3 || n2 != 2)) {
                            this.color_controls[n][n2].setTable(fArray);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            if ((field = (Field)this.ref_colorH1.getData()) != null) {
                field.setSamples(fArray);
            }
        } else if (control.equals(this.color_controlH2)) {
            float[][] fArray = this.color_controlH2.getTable();
            if (fArray != null) {
                this.color_controls[3][2].setTable(fArray);
            }
        } else if (!this.in_proj && control != null && control instanceof ProjectionControl) {
            this.in_proj = true;
            double[] dArray = ((ProjectionControl)control).getMatrix();
            int n = 0;
            while (n < 4) {
                int n3 = 0;
                while (n3 < 3) {
                    if (control != this.projection_controls[n][n3] && this.projection_controls[n][n3] != null) {
                        this.projection_controls[n][n3].setMatrix(dArray);
                    }
                    ++n3;
                }
                ++n;
            }
            Field field = (Field)this.ref_projection.getData();
            if (dArray.length == 6) {
                if (field != null) {
                    field.setSamples(new double[][]{dArray});
                }
            } else {
                double[] dArray2 = ProjectionControl.matrix3DTo2D(dArray);
                if (field != null) {
                    field.setSamples(new double[][]{dArray2});
                }
            }
            this.in_proj = false;
        }
    }

    private Rain(String[] stringArray) throws VisADException, RemoteException {
        if (stringArray[0].endsWith(".v5d") || stringArray[0].endsWith(".nc")) {
            int n;
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///Rain", this.server_server);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException accessException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            Form form = null;
            if (stringArray[0].endsWith(".v5d")) {
                try {
                    form = new Vis5DForm();
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.out.println("Cannot find vis5d library: " + unsatisfiedLinkError.getMessage());
                    System.exit(1);
                }
            } else {
                form = new Plain();
            }
            FieldImpl fieldImpl = null;
            try {
                fieldImpl = (FieldImpl)form.open(stringArray[0]);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.exit(0);
            }
            if (fieldImpl == null) {
                System.out.println("bad Vis5D file read");
                System.exit(0);
            }
            this.ref300 = new DataReferenceImpl("num300");
            this.ref1_4 = new DataReferenceImpl("num1_4");
            this.refMAX = new DataReferenceImpl("colorMAX");
            this.ref_cursor = new DataReferenceImpl("cursor");
            this.ref_vis5d = new DataReferenceImpl("vis5d");
            this.ref_projection = new DataReferenceImpl("projection");
            this.ref_colorH1 = new DataReferenceImpl("colorH1");
            this.ref_colorH2 = new DataReferenceImpl("colorH2");
            int n2 = 0;
            while (n2 < 4) {
                n = 0;
                while (n < 3) {
                    this.cell_text[n2][n] = new DataReferenceImpl("text_" + n2 + "_" + n);
                    ++n;
                }
                ++n2;
            }
            this.ref_vis5d.setData(fieldImpl);
            if (this.server_server != null) {
                RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[20];
                remoteDataReferenceImplArray[0] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref300);
                remoteDataReferenceImplArray[1] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref1_4);
                remoteDataReferenceImplArray[2] = new RemoteDataReferenceImpl((DataReferenceImpl)this.refMAX);
                remoteDataReferenceImplArray[3] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_cursor);
                remoteDataReferenceImplArray[4] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_vis5d);
                remoteDataReferenceImplArray[5] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_projection);
                remoteDataReferenceImplArray[6] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_colorH1);
                remoteDataReferenceImplArray[7] = new RemoteDataReferenceImpl((DataReferenceImpl)this.ref_colorH2);
                n = 0;
                while (n < 4) {
                    int n3 = 0;
                    while (n3 < 3) {
                        remoteDataReferenceImplArray[8 + 3 * n + n3] = new RemoteDataReferenceImpl((DataReferenceImpl)this.cell_text[n][n3]);
                        ++n3;
                    }
                    ++n;
                }
                this.server_server.setDataReferences(remoteDataReferenceImplArray);
            }
        } else {
            String string = "//" + stringArray[0] + "/Rain";
            try {
                this.client_server = (RemoteServer)Naming.lookup(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException notBoundException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException accessException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            RemoteDataReference[] remoteDataReferenceArray = this.client_server.getDataReferences();
            if (remoteDataReferenceArray == null) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            this.ref300 = remoteDataReferenceArray[0];
            this.ref1_4 = remoteDataReferenceArray[1];
            this.refMAX = remoteDataReferenceArray[2];
            this.ref_cursor = remoteDataReferenceArray[3];
            this.ref_vis5d = new DataReferenceImpl("vis5d");
            this.ref_vis5d.setData(remoteDataReferenceArray[4].getData().local());
            this.ref_projection = remoteDataReferenceArray[5];
            this.ref_colorH1 = remoteDataReferenceArray[6];
            this.ref_colorH2 = remoteDataReferenceArray[7];
            int n = 0;
            while (n < 4) {
                int n4 = 0;
                while (n4 < 3) {
                    this.cell_text[n][n4] = remoteDataReferenceArray[8 + 3 * n + n4];
                    ++n4;
                }
                ++n;
            }
        }
    }
}

