/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import visad.VisADException;
import visad.formula.FormulaUtil;

public class RunJPython {
    private static final boolean DEBUG = false;
    private static final String interp = "org.python.util.PythonInterpreter";
    private static final Class interpClass = RunJPython.constructInterpClass();
    private static final String[] methodNames = new String[]{"org.python.util.PythonInterpreter.eval(java.lang.String)", "org.python.util.PythonInterpreter.exec(java.lang.String)", "org.python.util.PythonInterpreter.execfile(java.lang.String)", "org.python.util.PythonInterpreter.set(java.lang.String, org.python.core.PyObject)", "org.python.util.PythonInterpreter.get(java.lang.String)"};
    private static final Method[] methods = FormulaUtil.stringsToMethods(methodNames);
    private static final Method eval = methods[0];
    private static final Method exec = methods[1];
    private static final Method execfile = methods[2];
    private static final Method set = methods[3];
    private static final Method get = methods[4];
    protected Object python = null;

    private static Class constructInterpClass() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(interp);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public Object eval(String string) throws VisADException {
        try {
            return eval.invoke(this.python, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().toString());
        }
    }

    public void exec(String string) throws VisADException {
        try {
            exec.invoke(this.python, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().toString());
        }
    }

    public void execfile(String string) throws VisADException {
        try {
            execfile.invoke(this.python, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().toString());
        }
    }

    public void set(String string, Object object) throws VisADException {
        try {
            set.invoke(this.python, string, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().toString());
        }
    }

    public Object get(String string) throws VisADException {
        try {
            return get.invoke(this.python, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().toString());
        }
    }

    public static void main(String[] stringArray) throws VisADException {
        if (stringArray.length < 1) {
            return;
        }
        try {
            new RunJPython().execfile(stringArray[0]);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace(System.out);
        }
    }

    public RunJPython() throws VisADException {
        try {
            this.python = interpClass.newInstance();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (this.python == null) {
            throw new VisADException("JPython library not found - install Jython from http://jython.sourceforge.net/");
        }
    }
}

