/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AxisScale;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.data.mcidas.PointDataAdapter;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.DumpType;
import visad.math.FFT;
import visad.math.Histogram;
import visad.matrix.JamaCholeskyDecomposition;
import visad.matrix.JamaEigenvalueDecomposition;
import visad.matrix.JamaLUDecomposition;
import visad.matrix.JamaMatrix;
import visad.matrix.JamaQRDecomposition;
import visad.matrix.JamaSingularValueDecomposition;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.util.Util;

public abstract class JPythonMethods {
    private static final String DEFAULT_NAME = "Jython";
    private static final String ID = (class$Lvisad$python$JPythonMethods != null ? class$Lvisad$python$JPythonMethods : (class$Lvisad$python$JPythonMethods = JPythonMethods.class$("visad.python.JPythonMethods"))).getName();
    private static DefaultFamily form = new DefaultFamily(ID);
    private static Hashtable frames = new Hashtable();
    private static /* synthetic */ Class class$Lvisad$python$JPythonMethods;

    public static DataImpl load(String string) throws VisADException {
        return form.open(string);
    }

    public static void plot(DataImpl dataImpl) throws VisADException, RemoteException {
        JPythonMethods.plot(null, dataImpl, false, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl dataImpl, ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        JPythonMethods.plot(null, dataImpl, false, 1.0, 1.0, 1.0, scalarMapArray);
    }

    public static void plot(DataImpl dataImpl, boolean bl) throws VisADException, RemoteException {
        JPythonMethods.plot(null, dataImpl, bl, 1.0, 1.0, 1.0);
    }

    public static void plot(String string, DataImpl dataImpl) throws VisADException, RemoteException {
        JPythonMethods.plot(string, dataImpl, false, 1.0, 1.0, 1.0);
    }

    public static void plot(String string, DataImpl dataImpl, ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        JPythonMethods.plot(string, dataImpl, false, 1.0, 1.0, 1.0, scalarMapArray);
    }

    public static void plot(String string, DataImpl dataImpl, boolean bl) throws VisADException, RemoteException {
        JPythonMethods.plot(string, dataImpl, bl, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl dataImpl, double d, double d2, double d3) throws VisADException, RemoteException {
        JPythonMethods.plot(null, dataImpl, false, d, d2, d3);
    }

    public static void plot(String string, DataImpl dataImpl, boolean bl, double d, double d2, double d3) throws VisADException, RemoteException {
        JPythonMethods.plot(string, dataImpl, bl, d, d2, d3, null);
    }

    public static void plot(String string, DataImpl dataImpl, boolean bl, double d, double d2, double d3, ScalarMap[] scalarMapArray) throws VisADException, RemoteException {
        ConstantMap[] constantMapArray;
        BasicSSCell basicSSCell;
        if (dataImpl == null) {
            throw new VisADException("Data cannot be null");
        }
        if (string == null) {
            string = DEFAULT_NAME;
        }
        String string2 = string;
        Hashtable hashtable = frames;
        synchronized (hashtable) {
            basicSSCell = BasicSSCell.getSSCellByName(string2);
            if (basicSSCell == null) {
                basicSSCell = new FancySSCell(string2);
                basicSSCell.setDimension(1);
                basicSSCell.setPreferredSize(new Dimension(256, 256));
                constantMapArray = new JFrame("VisAD Display Plot (" + string2 + ")");
                frames.put(string2, constantMapArray);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                constantMapArray.setContentPane(jPanel);
                jPanel.add(basicSSCell);
                JButton jButton = new JButton("Mappings");
                JButton jButton2 = new JButton("Controls");
                JButton jButton3 = new JButton("Clear");
                JButton jButton4 = new JButton("Close");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.add(jButton);
                jPanel2.add(jButton2);
                jPanel2.add(jButton3);
                jPanel2.add(jButton4);
                jPanel.add(jPanel2);
                FancySSCell fancySSCell = (FancySSCell)basicSSCell;
                fancySSCell.setAutoShowControls(false);
                if (scalarMapArray != null) {
                    basicSSCell.setMaps(scalarMapArray);
                    fancySSCell.setAutoDetect(false);
                } else {
                    fancySSCell.setAutoDetect(!bl);
                }
                jButton.addActionListener(new ActionListener(fancySSCell){
                    private final /* synthetic */ FancySSCell val$fdisp;

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$fdisp.addMapDialog();
                    }
                    {
                        this.val$fdisp = fancySSCell;
                        this.constructor$0();
                    }

                    private final void constructor$0() {
                    }
                });
                jButton2.addActionListener(new ActionListener(fancySSCell){
                    private final /* synthetic */ FancySSCell val$fdisp;

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$fdisp.showWidgetFrame();
                    }
                    {
                        this.val$fdisp = fancySSCell;
                        this.constructor$0();
                    }

                    private final void constructor$0() {
                    }
                });
                jButton4.addActionListener(new ActionListener(fancySSCell, string2){
                    private final /* synthetic */ FancySSCell val$fdisp;
                    private final /* synthetic */ String val$name;

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            this.val$fdisp.smartClear();
                            JPythonMethods.clearplot(this.val$name);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    {
                        this.val$fdisp = fancySSCell;
                        this.val$name = string;
                        this.constructor$0();
                    }

                    private final void constructor$0() {
                    }
                });
                jButton3.addActionListener(new ActionListener(fancySSCell){
                    private final /* synthetic */ FancySSCell val$fdisp;

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            this.val$fdisp.smartClear();
                        }
                        catch (VisADException visADException) {
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    {
                        this.val$fdisp = fancySSCell;
                        this.constructor$0();
                    }

                    private final void constructor$0() {
                    }
                });
                constantMapArray.pack();
            } else {
                constantMapArray = (ConstantMap[])frames.get(string2);
            }
            constantMapArray.setVisible(true);
            constantMapArray.toFront();
        }
        constantMapArray = new ConstantMap[]{new ConstantMap(d, Display.Red), new ConstantMap(d2, Display.Green), new ConstantMap(d3, Display.Blue)};
        basicSSCell.addData(dataImpl, constantMapArray);
        if (bl) {
            ((FancySSCell)basicSSCell).addMapDialog();
        }
    }

    public static void clearplot() throws VisADException, RemoteException {
        JPythonMethods.clearplot(null);
    }

    public static void clearplot(String string) throws VisADException, RemoteException {
        BasicSSCell basicSSCell;
        if (string == null) {
            string = DEFAULT_NAME;
        }
        if ((basicSSCell = BasicSSCell.getSSCellByName(string)) != null) {
            JFrame jFrame = (JFrame)frames.get(string);
            basicSSCell.clearCell();
            basicSSCell.clearMaps();
            ((Component)jFrame).setVisible(false);
            jFrame.dispose();
            jFrame = null;
            basicSSCell.destroyCell();
            basicSSCell = null;
        }
    }

    public static void saveplot(DisplayImpl displayImpl, String string) throws VisADException, RemoteException, IOException {
        Util.captureDisplay(displayImpl, string);
    }

    public static void saveplot(String string) throws VisADException, RemoteException, IOException {
        JPythonMethods.saveplot(null, string);
    }

    public static void saveplot(String string, String string2) throws VisADException, RemoteException, IOException {
        if (string == null) {
            string = DEFAULT_NAME;
        }
        BasicSSCell basicSSCell = BasicSSCell.getSSCellByName(string);
        String string3 = string2;
        if (basicSSCell != null) {
            Runnable runnable = new Runnable(string3, basicSSCell){
                private final /* synthetic */ String val$fn;
                private final /* synthetic */ BasicSSCell val$sscell;

                public void run() {
                    try {
                        this.val$sscell.captureImage(new File(this.val$fn));
                    }
                    catch (Exception exception) {
                        System.out.println("Error saving plot = " + exception);
                    }
                }
                {
                    this.val$fn = string;
                    this.val$sscell = basicSSCell;
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public static Data abs(Data data) throws VisADException, RemoteException {
        return data.abs();
    }

    public static Data acos(Data data) throws VisADException, RemoteException {
        return data.acos();
    }

    public static Data acosDegrees(Data data) throws VisADException, RemoteException {
        return data.acosDegrees();
    }

    public static Data asin(Data data) throws VisADException, RemoteException {
        return data.asin();
    }

    public static Data asinDegrees(Data data) throws VisADException, RemoteException {
        return data.asinDegrees();
    }

    public static Data atan(Data data) throws VisADException, RemoteException {
        return data.atan();
    }

    public static Data atanDegrees(Data data) throws VisADException, RemoteException {
        return data.atanDegrees();
    }

    public static Data ceil(Data data) throws VisADException, RemoteException {
        return data.ceil();
    }

    public static Data cos(Data data) throws VisADException, RemoteException {
        return data.cos();
    }

    public static Data cosDegrees(Data data) throws VisADException, RemoteException {
        return data.cosDegrees();
    }

    public static Data exp(Data data) throws VisADException, RemoteException {
        return data.exp();
    }

    public static Data floor(Data data) throws VisADException, RemoteException {
        return data.floor();
    }

    public static Data log(Data data) throws VisADException, RemoteException {
        return data.log();
    }

    public static Data rint(Data data) throws VisADException, RemoteException {
        return data.rint();
    }

    public static Data round(Data data) throws VisADException, RemoteException {
        return data.round();
    }

    public static Data sin(Data data) throws VisADException, RemoteException {
        return data.sin();
    }

    public static Data sinDegrees(Data data) throws VisADException, RemoteException {
        return data.sinDegrees();
    }

    public static Data sqrt(Data data) throws VisADException, RemoteException {
        return data.sqrt();
    }

    public static Data tan(Data data) throws VisADException, RemoteException {
        return data.tan();
    }

    public static Data tanDegrees(Data data) throws VisADException, RemoteException {
        return data.tanDegrees();
    }

    public static Data max(Data data, Data data2) throws VisADException, RemoteException {
        return data.max(data2);
    }

    public static Data min(Data data, Data data2) throws VisADException, RemoteException {
        return data.min(data2);
    }

    public static Data atan2(Data data, Data data2) throws VisADException, RemoteException {
        return data.atan2(data2);
    }

    public static Data atan2Degrees(Data data, Data data2) throws VisADException, RemoteException {
        return data.atan2Degrees(data2);
    }

    public static Data max(Data data, double d) throws VisADException, RemoteException {
        return data.max(new Real(d));
    }

    public static Data min(Data data, double d) throws VisADException, RemoteException {
        return data.min(new Real(d));
    }

    public static Data atan2(Data data, double d) throws VisADException, RemoteException {
        return data.atan2(new Real(d));
    }

    public static Data atan2Degrees(Data data, double d) throws VisADException, RemoteException {
        return data.atan2Degrees(new Real(d));
    }

    public static Data max(double d, Data data) throws VisADException, RemoteException {
        return new Real(d).max(data);
    }

    public static Data min(double d, Data data) throws VisADException, RemoteException {
        return new Real(d).min(data);
    }

    public static Data atan2(double d, Data data) throws VisADException, RemoteException {
        return new Real(d).atan2(data);
    }

    public static Data atan2Degrees(double d, Data data) throws VisADException, RemoteException {
        return new Real(d).atan2Degrees(data);
    }

    public static FlatField fft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, true);
    }

    public static FlatField ifft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, false);
    }

    public static JamaMatrix matrixMultiply(FlatField flatField, FlatField flatField2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        JamaMatrix jamaMatrix2 = JamaMatrix.convertToMatrix(flatField2);
        return jamaMatrix.times(jamaMatrix2);
    }

    public static JamaMatrix solve(FlatField flatField, FlatField flatField2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        JamaMatrix jamaMatrix2 = JamaMatrix.convertToMatrix(flatField2);
        return jamaMatrix.solve(jamaMatrix2);
    }

    public static JamaMatrix inverse(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.inverse();
    }

    public static JamaMatrix transpose(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.transpose();
    }

    public static double det(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.det();
    }

    public static double norm1(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.norm1();
    }

    public static double norm2(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.norm2();
    }

    public static double normInf(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.normInf();
    }

    public static double normF(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.normF();
    }

    public static double rank(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.rank();
    }

    public static double cond(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.cond();
    }

    public static double trace(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.trace();
    }

    public static JamaCholeskyDecomposition chol(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.chol();
    }

    public static JamaEigenvalueDecomposition eig(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.eig();
    }

    public static JamaLUDecomposition lu(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.lu();
    }

    public static JamaQRDecomposition qr(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.qr();
    }

    public static JamaSingularValueDecomposition svd(FlatField flatField) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix jamaMatrix = JamaMatrix.convertToMatrix(flatField);
        return jamaMatrix.svd();
    }

    public static FlatField hist(Field field, Set set) throws VisADException, RemoteException {
        return Histogram.makeHistogram(field, set);
    }

    public static FlatField hist(Field field, int[] nArray) throws VisADException, RemoteException {
        if (nArray == null || nArray.length == 0) {
            throw new VisADException("bad ranges");
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = 64;
            ++n2;
        }
        return JPythonMethods.hist(field, nArray, nArray2);
    }

    public static FlatField hist(Field field, int[] nArray, int[] nArray2) throws VisADException, RemoteException {
        if (nArray == null || nArray.length == 0) {
            throw new VisADException("bad ranges");
        }
        if (nArray2 == null || nArray2.length != nArray.length) {
            throw new VisADException("bad sizes");
        }
        if (field == null) {
            throw new VisADException("bad field");
        }
        FunctionType functionType = (FunctionType)field.getType();
        RealType[] realTypeArray = functionType.getRealComponents();
        int n = realTypeArray.length;
        int n2 = nArray.length;
        RealType[] realTypeArray2 = new RealType[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] < 0 || nArray[n3] >= n) {
                throw new VisADException("range index out of range " + nArray[n3]);
            }
            realTypeArray2[n3] = realTypeArray[nArray[n3]];
            ++n3;
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray2);
        double[][] dArray = field.computeRanges(realTypeArray2);
        GriddedSet griddedSet = null;
        if (n2 == 1) {
            griddedSet = new Linear1DSet((MathType)realTupleType, dArray[0][0], dArray[0][1], nArray2[0]);
        } else if (n2 == 2) {
            griddedSet = new Linear2DSet((MathType)realTupleType, dArray[0][0], dArray[0][1], nArray2[0], dArray[1][0], dArray[1][1], nArray2[1]);
        } else if (n2 == 3) {
            griddedSet = new Linear3DSet((MathType)realTupleType, dArray[0][0], dArray[0][1], nArray2[0], dArray[1][0], dArray[1][1], nArray2[1], dArray[2][0], dArray[2][1], nArray2[2]);
        } else {
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            int n4 = 0;
            while (n4 < n2) {
                dArray2[n4] = dArray[n4][0];
                dArray3[n4] = dArray[n4][1];
                ++n4;
            }
            griddedSet = new LinearNDSet((MathType)realTupleType, dArray2, dArray3, nArray2);
        }
        return Histogram.makeHistogram(field, griddedSet);
    }

    public static FlatField field(float[] fArray) throws VisADException, RemoteException {
        return JPythonMethods.field("value", fArray);
    }

    public static FlatField field(String string, float[] fArray) throws VisADException, RemoteException {
        return JPythonMethods.field("domain", string, fArray);
    }

    public static FlatField field(String string, String string2, float[] fArray) throws VisADException, RemoteException {
        if (fArray == null || fArray.length == 0) {
            throw new VisADException("bad values");
        }
        RealType realType = RealType.getRealType(string);
        return JPythonMethods.field((Set)new Integer1DSet((MathType)realType, fArray.length), string2, fArray);
    }

    public static FlatField field(Set set, String string, float[] fArray) throws VisADException, RemoteException {
        Object object;
        if (fArray == null) {
            throw new VisADException("bad values");
        }
        if (set == null || set.getLength() < fArray.length) {
            throw new VisADException("bad set " + set);
        }
        if (string == null) {
            throw new VisADException("bad name");
        }
        MathType mathType = ((SetType)set.getType()).getDomain();
        if (mathType.getDimension() == 1) {
            mathType = mathType.getComponent(0);
        }
        RealType realType = RealType.getRealType(string);
        FunctionType functionType = new FunctionType(mathType, realType);
        FlatField flatField = new FlatField(functionType, set);
        int n = set.getLength();
        boolean bl = true;
        if (fArray.length < n) {
            object = new float[n];
            System.arraycopy(fArray, 0, object, 0, n);
            int n2 = fArray.length;
            while (n2 < n) {
                object[n2] = Float.NaN;
                ++n2;
            }
            fArray = object;
            bl = false;
        }
        object = new float[][]{fArray};
        flatField.setSamples((float[][])object, bl);
        return flatField;
    }

    public static FlatField field(float[][] fArray) throws VisADException, RemoteException {
        return JPythonMethods.field("value", fArray);
    }

    public static FlatField field(String string, float[][] fArray) throws VisADException, RemoteException {
        return JPythonMethods.field("ImageLine", "ImageElement", string, fArray);
    }

    public static FlatField field(String string, String string2, String string3, float[][] fArray) throws VisADException, RemoteException {
        int[] nArray = JPythonMethods.getValuesLengths(fArray);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        RealType realType = RealType.getRealType(string);
        RealType realType2 = RealType.getRealType(string2);
        RealTupleType realTupleType = new RealTupleType(realType, realType2);
        return JPythonMethods.field((Set)new Integer2DSet((MathType)realTupleType, n3, n), string3, fArray);
    }

    public static FlatField field(Set set, String string, float[][] fArray) throws VisADException, RemoteException {
        int n;
        int n2;
        int[] nArray = JPythonMethods.getValuesLengths(fArray);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        if (set == null || !(set instanceof GriddedSet) || set.getManifoldDimension() != 2) {
            throw new VisADException("bad set " + set);
        }
        int n6 = ((GriddedSet)set).getLength(0);
        int n7 = ((GriddedSet)set).getLength(1);
        if (n6 < n5 || n7 < n3) {
            throw new VisADException("bad set length " + n6 + " " + n7);
        }
        if (string == null) {
            throw new VisADException("bad name");
        }
        MathType mathType = ((SetType)set.getType()).getDomain();
        if (mathType.getDimension() == 1) {
            mathType = mathType.getComponent(0);
        }
        RealType realType = RealType.getRealType(string);
        FunctionType functionType = new FunctionType(mathType, realType);
        FlatField flatField = new FlatField(functionType, set);
        int n8 = n6 * n7;
        float[] fArray2 = new float[n8];
        int n9 = 0;
        while (n9 < n3) {
            n2 = n9 * n6;
            n = fArray[n9].length;
            if (n > 0) {
                System.arraycopy(fArray[n9], 0, fArray2, n2, n);
            }
            int n10 = n2 + n;
            while (n10 < n2 + n6) {
                fArray2[n10] = Float.NaN;
                ++n10;
            }
            ++n9;
        }
        n9 = n3;
        while (n9 < n7) {
            n = n2 = n9 * n6;
            while (n < n2 + n6) {
                fArray2[n] = Float.NaN;
                ++n;
            }
            ++n9;
        }
        float[][] fArray3 = new float[][]{fArray2};
        flatField.setSamples(fArray3, false);
        return flatField;
    }

    private static int[] getValuesLengths(float[][] fArray) throws VisADException {
        if (fArray == null) {
            throw new VisADException("bad values");
        }
        int n = fArray.length;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (fArray[n4] == null) {
                throw new VisADException("bad values");
            }
            int n5 = fArray[n4].length;
            if (n5 > n3) {
                n3 = n5;
            }
            if (n5 < n2) {
                n2 = n5;
            }
            ++n4;
        }
        if (n3 < n2) {
            n2 = 0;
        }
        return new int[]{n, n2, n3};
    }

    public static int getDomainDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainDimension(data);
    }

    public static int domainDimension(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getDimension();
    }

    public static int getRangeDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeDimension(data);
    }

    public static int rangeDimension(Data data) throws VisADException, RemoteException {
        int n = 1;
        if (data instanceof FlatField) {
            n = ((FlatField)data).getRangeDimension();
        }
        return n;
    }

    public static RealTupleType getDomainType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainType(data);
    }

    public static RealTupleType domainType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain();
    }

    public static MathType getRangeType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeType(data);
    }

    public static MathType rangeType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getRange();
    }

    public static String domainType(Data data, int n) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getComponent(n).toString();
    }

    public static String rangeType(Data data, int n) throws VisADException, RemoteException {
        MathType mathType = JPythonMethods.rangeType(data);
        int n2 = JPythonMethods.rangeDimension(data);
        String string = mathType.toString();
        if (n2 > 1) {
            string = ((TupleType)mathType).getComponent(n).toString();
        }
        return string;
    }

    public static Unit makeUnit(String string) throws NoSuchUnitException, ParseException {
        return Parser.parse(string);
    }

    public static Linear1DSet makeDomain(double d, double d2, int n) throws VisADException {
        return new Linear1DSet(d, d2, n);
    }

    public static Linear1DSet makeDomain(MathType mathType, double d, double d2, int n) throws VisADException {
        return new Linear1DSet(mathType, d, d2, n);
    }

    public static Linear2DSet makeDomain(double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        return new Linear2DSet(d, d2, n, d3, d4, n2);
    }

    public static Linear2DSet makeDomain(MathType mathType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        return new Linear2DSet(mathType, d, d2, n, d3, d4, n2);
    }

    public static Linear3DSet makeDomain(double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3) throws VisADException {
        return new Linear3DSet(d, d2, n, d3, d4, n2, d5, d6, n3);
    }

    public static Linear3DSet makeDomain(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3) throws VisADException {
        return new Linear3DSet(mathType, d, d2, n, d3, d4, n2, d5, d6, n3);
    }

    public static Set getDomainSet(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static Set getDomain(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static Field resample(Field field, Set set) throws VisADException, RemoteException {
        return field.resample(set, 0, 0);
    }

    public static double getValue(Real real) {
        return real.getValue();
    }

    public static double[][] getValues(Field field) throws VisADException, RemoteException {
        return field.getValues();
    }

    public static Field extract(Field field, MathType mathType) throws VisADException, RemoteException {
        return ((FieldImpl)field).extract(mathType);
    }

    public static Field extract(Field field, String string) throws VisADException, RemoteException {
        return ((FieldImpl)field).extract(string);
    }

    public static Field extract(Field field, int n) throws VisADException, RemoteException {
        return ((FieldImpl)field).extract(n);
    }

    public static Field domainFactor(Field field, RealType realType) throws VisADException, RemoteException {
        return ((FieldImpl)field).domainFactor(realType);
    }

    public static Field domainFactor(Field field, int n) throws VisADException, RemoteException {
        RealType realType = (RealType)((FunctionType)field.getType()).getDomain().getComponent(n);
        return ((FieldImpl)field).domainFactor(realType);
    }

    public static Data evaluate(Field field, Real real) throws VisADException, RemoteException {
        return field.evaluate(real);
    }

    public static Data evaluate(Field field, double d) throws VisADException, RemoteException {
        return field.evaluate(new Real(d));
    }

    public static MathType makeType(String string) throws VisADException, RemoteException {
        return MathType.stringToType(string);
    }

    public static RealType makeRealType(String string) {
        return RealType.getRealType(string);
    }

    public static RealType getRealType(String string) {
        return RealType.getRealType(string);
    }

    public static RealType makeRealType(String string, Unit unit) {
        return RealType.getRealType(string, unit);
    }

    public static RealType getRealType(String string, Unit unit) {
        return RealType.getRealType(string, unit);
    }

    public static MathType getType(Data data) throws VisADException, RemoteException {
        return data.getType();
    }

    public static void showAxesScales(DisplayImpl displayImpl, boolean bl) throws VisADException, RemoteException {
        displayImpl.getGraphicsModeControl().setScaleEnable(bl);
    }

    public static void setAxesScalesFont(ScalarMap[] scalarMapArray, Font font) throws VisADException, RemoteException {
        int n = 0;
        while (n < scalarMapArray.length) {
            AxisScale axisScale = scalarMapArray[n].getAxisScale();
            if (axisScale != null) {
                axisScale.setFont(font);
            }
            ++n;
        }
    }

    public static void dumpTypes(Data data) throws VisADException, RemoteException {
        MathType mathType = data.getType();
        DumpType.dumpMathType(mathType);
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - ");
        System.out.println("DataType analysis...");
        DumpType.dumpDataType(data);
    }

    public static PointDataAdapter getPointDataAdapter(String string) throws VisADException, RemoteException {
        return new PointDataAdapter(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

