/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import visad.VisADException;
import visad.python.RunJPython;
import visad.util.CodeEditor;
import visad.util.ExtensionFileFilter;

public class JPythonEditor
extends CodeEditor {
    private static final String PREPENDED_TEXT = "from visad.python.JPythonMethods import *";
    private static final Font MONO_FONT = new Font("Monospaced", 0, 11);
    protected RunJPython python = new RunJPython();
    protected boolean warnBeforeSave = true;
    protected boolean runSeparate = true;
    private JMenuItem runItem;

    public static String[] runCommand(String string) throws IOException, VisADException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        bufferedReader.close();
        if (process.exitValue() != 0) {
            throw new VisADException("exit value was non-zero");
        }
        return arrayList.toArray(new String[0]);
    }

    private String handleError(String string, String string2) {
        Container container;
        String string3;
        String string4;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("\t");
            while (n >= 0) {
                string4 = string4.substring(0, n) + "        " + string4.substring(n + 1);
                n = string4.indexOf("\t");
            }
            stringBuffer.append(string4 + "\n");
        }
        string4 = stringBuffer.toString();
        int n = string4.indexOf((string3 = string2 + "\", ") + "line ");
        if (n >= 0) {
            int n2 = string4.indexOf("\n", n += string3.length() + 5);
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string4.substring(n, n2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (--n3 >= 1) {
                this.highlightLine(n3);
                string4 = string4.substring(0, n) + n3 + string4.substring(n2);
            }
        }
        JDialog jDialog = (container = this.getRootPane().getParent()) instanceof Dialog ? new JDialog((Dialog)container, "JPython script error", true) : (container instanceof Frame ? new JDialog((Frame)container, "JPython script error", true) : new JDialog(null, "JPython script error", true));
        JLabel jLabel = new JLabel("An error in the script occurred:");
        jLabel.setAlignmentX(0.5f);
        JTextArea jTextArea = new JTextArea(string4, 16, 80);
        jTextArea.setEditable(false);
        jTextArea.setFont(MONO_FONT);
        jTextArea.setWrapStyleWord(true);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(this, jDialog){
            private final /* synthetic */ JPythonEditor this$0;
            private final /* synthetic */ JDialog val$dialog;

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.val$dialog).hide();
            }
            {
                this.val$dialog = jDialog;
                this.this$0 = jPythonEditor;
                this.constructor$0(jPythonEditor);
            }

            private final void constructor$0(JPythonEditor jPythonEditor) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(jTextArea);
        jPanel.add(jButton);
        jDialog.setContentPane(jPanel);
        jDialog.pack();
        jDialog.show();
        return string4;
    }

    public void exec(String string) throws VisADException {
        this.python.exec(string);
    }

    public void execfile(String string) throws VisADException {
        try {
            this.python.execfile(string);
        }
        catch (VisADException visADException) {
            String string2 = this.handleError(visADException.getMessage(), string);
            throw new VisADException(string2);
        }
    }

    public String getText() {
        return PREPENDED_TEXT + System.getProperty("line.separator") + super.getText();
    }

    public void setText(String string) {
        if (string.startsWith(PREPENDED_TEXT)) {
            string = string.substring(PREPENDED_TEXT.length()).trim();
        }
        super.setText(string);
    }

    public void setWarnBeforeSave(boolean bl) {
        this.warnBeforeSave = bl;
    }

    public void setRunSeparateProcess(boolean bl) {
        this.runSeparate = bl;
    }

    public void setRunItem(JMenuItem jMenuItem) {
        this.runItem = jMenuItem;
    }

    public void run() {
        if (this.hasChanged()) {
            int n;
            if (this.warnBeforeSave && (n = JOptionPane.showConfirmDialog(this, "A save is required before execution. Okay to save?", "VisAD JPython Editor", 0)) != 0) {
                return;
            }
            n = this.saveFile();
            if (n == 0) {
                return;
            }
        }
        Thread thread = new Thread(new Runnable(this){
            private final /* synthetic */ JPythonEditor this$0;

            public void run() {
                String string = this.this$0.getFilename();
                if (this.this$0.runSeparate) {
                    try {
                        String[] stringArray = JPythonEditor.runCommand("java visad.python.RunJPython " + string);
                    }
                    catch (IOException iOException) {
                    }
                    catch (VisADException visADException) {
                        String string2 = JPythonEditor.access$0(this.this$0, visADException.getMessage(), string);
                    }
                } else {
                    JPythonEditor.access$1(this.this$0).setEnabled(false);
                    JPythonEditor.access$1(this.this$0).setText("Running...");
                    try {
                        this.this$0.execfile(string);
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    JPythonEditor.access$1(this.this$0).setText("Run");
                    JPythonEditor.access$1(this.this$0).setEnabled(true);
                }
            }
            {
                this.this$0 = jPythonEditor;
                this.constructor$0(jPythonEditor);
            }

            private final void constructor$0(JPythonEditor jPythonEditor) {
            }
        });
        thread.start();
    }

    public void compile() throws VisADException {
        throw new VisADException("Not yet implemented!");
    }

    static /* synthetic */ String access$0(JPythonEditor jPythonEditor, String string, String string2) {
        return jPythonEditor.handleError(string, string2);
    }

    static /* synthetic */ JMenuItem access$1(JPythonEditor jPythonEditor) {
        return jPythonEditor.runItem;
    }

    public JPythonEditor() throws VisADException {
        this((String)null);
    }

    public JPythonEditor(String string) throws VisADException {
        super(string);
        this.fileChooser.addChoosableFileFilter(new ExtensionFileFilter("py", "JPython source code"));
    }
}

