/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa.spline;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.VisADSlider;

public class Spline {
    boolean toggle = true;
    Real nothing = new Real(-1000.0);
    boolean java2d = false;
    DataReference rlambda_ref;
    DataReference lambda_ref;
    DataReference wk_ref;
    DataReference noise_ref;
    DataReference spline_ref;
    DataReference spline_fieldRef;
    DataReference rlambda_fieldRef;
    DataReference true_fieldRef;
    DataReference gcv_fieldRef;
    int n_samples = 50;
    float[] domain_values;
    double[] range_values;
    double[] true_values;
    double[] rlambda_values;
    double[] noise;
    double[] noise_a;
    double[][] d_range = new double[1][];
    double[][] f_range = new double[1][];
    double[][] g_range = new double[1][];
    double[] spline_range;
    double[] values = new double[2];
    double val;
    double[] wkvalue = new double[1];
    double noise_fac;
    double last_noise_fac;
    double wk_value;
    int mode;
    FlatField rlambda_field;
    FlatField spline_field;
    FlatField gcv_field;
    FlatField true_field;
    Set domainSet;
    FunctionType f_type;
    DataReference[] range_refs;
    RealTuple[] tuples;
    Real[] reals;
    ConstantMap[][] cmaps;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        System.loadLibrary("Spline");
        Spline spline = new Spline("file");
    }

    public native void getspline_c(double[] var1, double[] var2, double var3, int var5, double[] var6);

    public Spline(String string) throws VisADException, RemoteException, IOException {
        this.rlambda_ref = new DataReferenceImpl("rlambda_ref");
        this.wk_ref = new DataReferenceImpl("wk_ref");
        this.lambda_ref = new DataReferenceImpl("lambda_ref");
        this.noise_ref = new DataReferenceImpl("noise_ref");
        this.spline_ref = new DataReferenceImpl("spline_ref");
        this.true_values = new double[this.n_samples];
        this.rlambda_values = new double[50];
        this.range_values = new double[this.n_samples];
        this.noise = new double[this.n_samples];
        this.domain_values = new float[this.n_samples];
        this.spline_range = new double[this.n_samples];
        this.range_refs = new DataReferenceImpl[this.n_samples];
        this.tuples = new RealTuple[this.n_samples];
        this.reals = new Real[this.n_samples];
        this.cmaps = new ConstantMap[this.n_samples][];
        double d = 0.0;
        this.last_noise_fac = this.noise_fac = 0.1;
        boolean bl = false;
        double d2 = 0.0;
        int n = 0;
        while (n < this.n_samples) {
            double d3;
            if (!bl) {
                double d4;
                double d5;
                double d6;
                while ((d6 = (d5 = 2.0 * Math.random() - 1.0) * d5 + (d4 = 2.0 * Math.random() - 1.0) * d4) >= 1.0 || d6 == 0.0) {
                }
                double d7 = Math.sqrt(-2.0 * Math.log(d6) / d6);
                d2 = d5 * d7;
                bl = true;
                d3 = d4 * d7;
            } else {
                bl = false;
                d3 = d2;
            }
            this.noise[n] = d3;
            this.true_values[n] = Math.cos(d * 3.1415926) * Math.exp(-3.0 * d);
            this.range_values[n] = this.true_values[n] + this.noise_fac * this.noise[n];
            d += 0.02;
            ++n;
        }
        n = 0;
        while (n < this.n_samples) {
            this.domain_values[n] = n;
            this.values[0] = this.domain_values[n];
            this.values[1] = this.range_values[n];
            this.tuples[n] = new RealTuple(RealTupleType.SpatialCartesian2DTuple, this.values);
            this.reals[n] = new Real(RealType.YAxis, this.values[1]);
            this.range_refs[n] = new DataReferenceImpl("rangeRef_" + n);
            this.range_refs[n].setData(this.reals[n]);
            ++n;
        }
        float[][] fArray = new float[1][this.n_samples];
        fArray[0] = this.domain_values;
        this.domainSet = new Gridded1DSet((MathType)RealType.XAxis, fArray, this.n_samples);
        this.f_type = new FunctionType(RealType.XAxis, RealType.YAxis);
        this.spline_field = new FlatField(this.f_type, this.domainSet);
        Linear1DSet linear1DSet = new Linear1DSet((MathType)RealType.XAxis, -10.0, 0.0, this.n_samples);
        this.rlambda_field = new FlatField(this.f_type, linear1DSet);
        this.gcv_field = new FlatField(this.f_type, this.domainSet);
        this.true_field = new FlatField(this.f_type, this.domainSet);
        double[][] dArray = new double[][]{this.true_values};
        this.true_field.setSamples(dArray);
        JFrame jFrame = new JFrame("Spline VisAD Application");
        jFrame.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Spline this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = spline;
                this.constructor$0(spline);
            }

            private final void constructor$0(Spline spline) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        SplinePanel splinePanel = new SplinePanel();
        jPanel.add(splinePanel);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(900, 900);
        ((Component)jFrame).setVisible(true);
    }

    class SplinePanel
    extends JPanel
    implements ActionListener {
        JPanel panel_a;
        JPanel panel_b;
        JPanel panel_c;
        JPanel panel_d;
        JPanel panel_e;
        JPanel panel_left;
        Border etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            double d;
            double d2;
            double d3;
            String string = actionEvent.getActionCommand();
            if (string.equals("fun0")) {
                try {
                    if (Spline.this.toggle) {
                        d3 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        d2 = 0.0;
                        int n3 = 0;
                        while (n3 < Spline.this.n_samples) {
                            Spline.this.true_values[n3] = Math.cos(d2 * 3.1415926) * Math.exp(-3.0 * d2);
                            Spline.this.range_values[n3] = Spline.this.true_values[n3] + d3 * Spline.this.noise[n3];
                            Spline.this.range_refs[n3].setData(new Real(RealType.YAxis, Spline.this.range_values[n3]));
                            d2 += 0.02;
                            ++n3;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        d = -10.0;
                        n2 = 0;
                        while (n2 < 50) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[n2] = 0.0;
                            Spline.this.val = Math.pow(10.0, d);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            n = 0;
                            while (n < Spline.this.n_samples) {
                                int n4 = n2;
                                Spline.this.rlambda_values[n4] = Spline.this.rlambda_values[n4] + (Spline.this.spline_range[n] - Spline.this.true_values[n]) * (Spline.this.spline_range[n] - Spline.this.true_values[n]);
                                ++n;
                            }
                            d += 0.2;
                            ++n2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("fun1")) {
                try {
                    if (Spline.this.toggle) {
                        d3 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        d2 = 0.0;
                        int n5 = 0;
                        while (n5 < Spline.this.n_samples) {
                            Spline.this.true_values[n5] = Math.sin(d2 * 3.1415926) * Math.exp(-3.0 * d2);
                            Spline.this.range_values[n5] = Spline.this.true_values[n5] + d3 * Spline.this.noise[n5];
                            Spline.this.range_refs[n5].setData(new Real(RealType.YAxis, Spline.this.range_values[n5]));
                            d2 += 0.02;
                            ++n5;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        d = -10.0;
                        n2 = 0;
                        while (n2 < 50) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[n2] = 0.0;
                            Spline.this.val = Math.pow(10.0, d);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            n = 0;
                            while (n < Spline.this.n_samples) {
                                int n6 = n2;
                                Spline.this.rlambda_values[n6] = Spline.this.rlambda_values[n6] + (Spline.this.spline_range[n] - Spline.this.true_values[n]) * (Spline.this.spline_range[n] - Spline.this.true_values[n]);
                                ++n;
                            }
                            d += 0.2;
                            ++n2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("fun2")) {
                try {
                    if (Spline.this.toggle) {
                        double d4 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        d2 = 0.0;
                        int n7 = 0;
                        while (n7 < Spline.this.n_samples) {
                            Spline.this.true_values[n7] = d2 * Math.sin(1.0 / (d2 + 1.0)) * Math.exp(-3.0 * d2);
                            Spline.this.range_values[n7] = Spline.this.true_values[n7] + d4 * Spline.this.noise[n7];
                            Spline.this.range_refs[n7].setData(new Real(RealType.YAxis, Spline.this.range_values[n7]));
                            d2 += 0.02;
                            ++n7;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        d = -10.0;
                        n2 = 0;
                        while (n2 < 50) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[n2] = 0.0;
                            Spline.this.val = Math.pow(10.0, d);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            n = 0;
                            while (n < Spline.this.n_samples) {
                                int n8 = n2;
                                Spline.this.rlambda_values[n8] = Spline.this.rlambda_values[n8] + (Spline.this.spline_range[n] - Spline.this.true_values[n]) * (Spline.this.spline_range[n] - Spline.this.true_values[n]);
                                ++n;
                            }
                            d += 0.2;
                            ++n2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("fun3")) {
                try {
                    if (Spline.this.toggle) {
                        double d5 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        d2 = 0.0;
                        int n9 = 0;
                        while (n9 < Spline.this.n_samples) {
                            Spline.this.true_values[n9] = 2.0 * d2 * d2 * Math.sin(d2 * 3.1415926);
                            Spline.this.range_values[n9] = Spline.this.true_values[n9] + d5 * Spline.this.noise[n9];
                            Spline.this.range_refs[n9].setData(new Real(RealType.YAxis, Spline.this.range_values[n9]));
                            d2 += 0.02;
                            ++n9;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        d = -10.0;
                        n2 = 0;
                        while (n2 < 50) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[n2] = 0.0;
                            Spline.this.val = Math.pow(10.0, d);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            n = 0;
                            while (n < Spline.this.n_samples) {
                                int n10 = n2;
                                Spline.this.rlambda_values[n10] = Spline.this.rlambda_values[n10] + (Spline.this.spline_range[n] - Spline.this.true_values[n]) * (Spline.this.spline_range[n] - Spline.this.true_values[n]);
                                ++n;
                            }
                            d += 0.2;
                            ++n2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("fun4")) {
                try {
                    if (Spline.this.toggle) {
                        double d6 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        d2 = 0.0;
                        int n11 = 0;
                        while (n11 < Spline.this.n_samples) {
                            Spline.this.true_values[n11] = Math.sin(d2 * 3.1415926) * Math.log(d2 + 1.0);
                            Spline.this.range_values[n11] = Spline.this.true_values[n11] + d6 * Spline.this.noise[n11];
                            Spline.this.range_refs[n11].setData(new Real(RealType.YAxis, Spline.this.range_values[n11]));
                            d2 += 0.02;
                            ++n11;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        d = -10.0;
                        n2 = 0;
                        while (n2 < 50) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[n2] = 0.0;
                            Spline.this.val = Math.pow(10.0, d);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            n = 0;
                            while (n < Spline.this.n_samples) {
                                int n12 = n2;
                                Spline.this.rlambda_values[n12] = Spline.this.rlambda_values[n12] + (Spline.this.spline_range[n] - Spline.this.true_values[n]) * (Spline.this.spline_range[n] - Spline.this.true_values[n]);
                                ++n;
                            }
                            d += 0.2;
                            ++n2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("toggle")) {
                try {
                    if (Spline.this.toggle) {
                        Spline.this.toggle = false;
                        Spline.this.true_fieldRef.setData(Spline.this.nothing);
                    } else {
                        Spline.this.toggle = true;
                        Spline.this.true_fieldRef.setData(Spline.this.true_field);
                    }
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("spline")) {
                try {
                    int n13 = 0;
                    while (n13 < Spline.this.n_samples) {
                        Spline.this.range_values[n13] = ((Real)Spline.this.range_refs[n13].getData()).getValue();
                        ++n13;
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("GCV")) {
                try {
                    int n14 = 0;
                    while (n14 < Spline.this.n_samples) {
                        Spline.this.range_values[n14] = ((Real)Spline.this.range_refs[n14].getData()).getValue();
                        ++n14;
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 2;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    System.out.print(Spline.this.wkvalue[0] + "\n");
                    Spline.this.wk_value = Spline.this.wkvalue[0];
                    Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.gcv_field.setSamples(Spline.this.f_range);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("nreset")) {
                try {
                    double d7 = ((Real)Spline.this.noise_ref.getData()).getValue();
                    boolean bl = false;
                    double d8 = 0.0;
                    int n15 = 0;
                    while (n15 < Spline.this.n_samples) {
                        double d9;
                        if (!bl) {
                            double d10;
                            double d11;
                            double d12;
                            while ((d12 = (d11 = 2.0 * Math.random() - 1.0) * d11 + (d10 = 2.0 * Math.random() - 1.0) * d10) >= 1.0 || d12 == 0.0) {
                            }
                            double d13 = Math.sqrt(-2.0 * Math.log(d12) / d12);
                            d8 = d11 * d13;
                            bl = true;
                            d9 = d10 * d13;
                        } else {
                            bl = false;
                            d9 = d8;
                        }
                        Spline.this.noise[n15] = d9;
                        Spline.this.range_values[n15] = Spline.this.true_values[n15] + d7 * Spline.this.noise[n15];
                        Spline.this.range_refs[n15].setData(new Real(RealType.YAxis, Spline.this.range_values[n15]));
                        ++n15;
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                    Spline.this.mode = 2;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    System.out.print(Spline.this.wkvalue[0] + "\n");
                    Spline.this.wk_value = Spline.this.wkvalue[0];
                    Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.gcv_field.setSamples(Spline.this.f_range);
                    double d14 = -10.0;
                    Spline.this.mode = 1;
                    int n16 = 0;
                    while (n16 < 50) {
                        Spline.this.rlambda_values[n16] = 0.0;
                        Spline.this.val = Math.pow(10.0, d14);
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        int n17 = 0;
                        while (n17 < Spline.this.n_samples) {
                            int n18 = n16;
                            Spline.this.rlambda_values[n18] = Spline.this.rlambda_values[n18] + (Spline.this.spline_range[n17] - Spline.this.true_values[n17]) * (Spline.this.spline_range[n17] - Spline.this.true_values[n17]);
                            ++n17;
                        }
                        d14 += 0.2;
                        ++n16;
                    }
                    Spline.this.g_range[0] = Spline.this.rlambda_values;
                    Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (string.equals("rlambda")) {
                try {
                    int n19 = 0;
                    while (n19 < Spline.this.n_samples) {
                        Spline.this.range_values[n19] = ((Real)Spline.this.range_refs[n19].getData()).getValue();
                        ++n19;
                    }
                    double d15 = -10.0;
                    int n20 = 0;
                    while (n20 < 50) {
                        Spline.this.rlambda_values[n20] = 0.0;
                        Spline.this.val = Math.pow(10.0, d15);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        int n21 = 0;
                        while (n21 < Spline.this.n_samples) {
                            int n22 = n20;
                            Spline.this.rlambda_values[n22] = Spline.this.rlambda_values[n22] + (Spline.this.spline_range[n21] - Spline.this.true_values[n21]) * (Spline.this.spline_range[n21] - Spline.this.true_values[n21]);
                            ++n21;
                        }
                        d15 += 0.2;
                        ++n20;
                    }
                    Spline.this.g_range[0] = Spline.this.rlambda_values;
                    Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Spline access$0(SplinePanel splinePanel) {
            return splinePanel.Spline.this;
        }

        SplinePanel() throws VisADException, RemoteException {
            int n;
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentY(0.0f);
            this.setAlignmentX(0.0f);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentY(0.0f);
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
            jPanel.add(new JLabel("Smoothing Spline"));
            jPanel.add(new JLabel("using VisAD  -  see:"));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("for more information about VisAD."));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("William Hibbard, Tom Rink"));
            jPanel.add(new JLabel("Paolo Antonelli and Giulia Panegrossi"));
            jPanel.add(new JLabel("Space Science and Engineering Center"));
            jPanel.add(new JLabel("University of Wisconsin - Madison"));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("Select different functions using the buttons"));
            jPanel.add(new JLabel("  "));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setAlignmentY(0.0f);
            jPanel2.setAlignmentX(0.0f);
            JButton jButton = new JButton("fun0");
            jButton.addActionListener(this);
            jButton.setActionCommand("fun0");
            jPanel2.add(jButton);
            JButton jButton2 = new JButton("fun1");
            jButton2.addActionListener(this);
            jButton2.setActionCommand("fun1");
            jPanel2.add(jButton2);
            JButton jButton3 = new JButton("fun2");
            jButton3.addActionListener(this);
            jButton3.setActionCommand("fun2");
            jPanel2.add(jButton3);
            JButton jButton4 = new JButton("fun3");
            jButton4.addActionListener(this);
            jButton4.setActionCommand("fun3");
            jPanel2.add(jButton4);
            JButton jButton5 = new JButton("fun4");
            jButton5.addActionListener(this);
            jButton5.setActionCommand("fun4");
            jPanel2.add(jButton5);
            jPanel.add(jPanel2);
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("fun0: cos(x)exp(-3x)    x in [0,1]"));
            jPanel.add(new JLabel("fun1: sin(x)exp(-3x)    x in [0,1]"));
            jPanel.add(new JLabel("fun2: xsin(1/(x+1))exp(-3x)   x in [0,1]"));
            jPanel.add(new JLabel("fun3: 2xxsin(x)          x in [0,1]"));
            jPanel.add(new JLabel("fun4: sin(x)log(x+1)   x in [0,1]"));
            jPanel.add(new JLabel("  "));
            JPanel jPanel3 = new JPanel();
            jPanel3.setName("Smoothing Spline Sliders");
            jPanel3.setFont(new Font("Dialog", 0, 12));
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setAlignmentY(0.0f);
            jPanel3.setAlignmentX(0.0f);
            jPanel.add(jPanel3);
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("The noise slider changes the value of sigma"));
            jPanel.add(new JLabel("  "));
            VisADSlider visADSlider = new VisADSlider(Spline.this.noise_ref, 0.0f, 0.5f, 0.1f, RealType.Generic, "noise");
            jPanel.add(visADSlider);
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("Manual tuning of the smoothing parameter"));
            jPanel.add(new JLabel("  "));
            VisADSlider visADSlider2 = new VisADSlider(Spline.this.lambda_ref, -10.0f, 0.0f, 0.5f, RealType.Generic, "lambda");
            jPanel.add(visADSlider2);
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("Top Display:"));
            jPanel.add(new JLabel("Blue Curve: True function"));
            jPanel.add(new JLabel("Red Dots: noisy observations"));
            jPanel.add(new JLabel("Green Curve: GCV solution"));
            jPanel.add(new JLabel("White Curve: Solution for a fixed value of lambda  "));
            jPanel.add(new JLabel("  "));
            jPanel.add(new JLabel("Bottom Display: "));
            jPanel.add(new JLabel("Green Curve: V(lambda)"));
            jPanel.add(new JLabel("Red Dot: value of lambda selected by GCV"));
            jPanel.add(new JLabel("  "));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setAlignmentY(0.0f);
            jPanel4.setAlignmentX(0.0f);
            this.add(jPanel4);
            DisplayImpl displayImpl = null;
            DisplayImpl displayImpl2 = null;
            if (!Spline.this.java2d) {
                try {
                    displayImpl = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                    displayImpl2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            if (Spline.this.java2d) {
                displayImpl = new DisplayImplJ2D("display1");
                displayImpl2 = new DisplayImplJ2D("display2");
            }
            GraphicsModeControl graphicsModeControl = displayImpl.getGraphicsModeControl();
            graphicsModeControl.setScaleEnable(true);
            GraphicsModeControl graphicsModeControl2 = displayImpl2.getGraphicsModeControl();
            graphicsModeControl2.setScaleEnable(true);
            this.panel_a = new JPanel();
            this.panel_a.setLayout(new BoxLayout(this.panel_a, 1));
            this.panel_a.setAlignmentY(0.0f);
            this.panel_a.setAlignmentX(0.0f);
            this.panel_a.add(displayImpl.getComponent());
            this.panel_a.setBorder(this.etchedBorder5);
            jPanel4.add(this.panel_a);
            this.panel_b = new JPanel();
            this.panel_b.setLayout(new BoxLayout(this.panel_b, 0));
            this.panel_b.setAlignmentY(0.0f);
            this.panel_b.setAlignmentX(0.0f);
            this.panel_d = new JPanel();
            this.panel_d.setLayout(new BoxLayout(this.panel_d, 0));
            this.panel_d.setAlignmentX(0.0f);
            JButton jButton6 = new JButton("spline");
            jButton6.addActionListener(this);
            jButton6.setActionCommand("spline");
            this.panel_d.add(jButton6);
            JButton jButton7 = new JButton("GCV");
            jButton7.addActionListener(this);
            jButton7.setActionCommand("GCV");
            this.panel_d.add(jButton7);
            JButton jButton8 = new JButton("reset noise");
            jButton8.addActionListener(this);
            jButton8.setActionCommand("nreset");
            this.panel_d.add(jButton8);
            JButton jButton9 = new JButton("R(lambda)");
            jButton9.addActionListener(this);
            jButton9.setActionCommand("rlambda");
            this.panel_d.add(jButton9);
            JButton jButton10 = new JButton("toggle");
            jButton10.addActionListener(this);
            jButton10.setActionCommand("toggle");
            this.panel_d.add(jButton10);
            this.panel_b.add(this.panel_d);
            this.panel_b.setBorder(this.etchedBorder5);
            jPanel4.add(this.panel_b);
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
            ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(4.0, Display.PointSize)};
            ConstantMap[] constantMapArray3 = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
            ConstantMap[] constantMapArray4 = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
            ConstantMap[] constantMapArray5 = new ConstantMap[5];
            constantMapArray5[0] = new ConstantMap(1.0, Display.Red);
            constantMapArray5[1] = new ConstantMap(0.0, Display.Green);
            constantMapArray5[2] = new ConstantMap(0.0, Display.Blue);
            constantMapArray5[3] = new ConstantMap(3.0, Display.PointSize);
            ScalarMap scalarMap = new ScalarMap(RealType.XAxis, Display.XAxis);
            scalarMap.setRange(0.0, Spline.this.n_samples - 1);
            ScalarMap scalarMap2 = new ScalarMap(RealType.YAxis, Display.YAxis);
            displayImpl.addMap(scalarMap);
            displayImpl.addMap(scalarMap2);
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            scalarMap.getScale(dArray, dArray2, dArray3);
            if (Spline.this.java2d) {
                n = 0;
                while (n < Spline.this.n_samples) {
                    double d = (double)Spline.this.domain_values[n] * dArray[0] + dArray[1];
                    constantMapArray5[4] = new ConstantMap(d, Display.XAxis);
                    displayImpl.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), Spline.this.range_refs[n], constantMapArray5);
                    ++n;
                }
            } else {
                n = 0;
                while (n < Spline.this.n_samples) {
                    double d = (double)Spline.this.domain_values[n] * dArray[0] + dArray[1];
                    constantMapArray5[4] = new ConstantMap(d, Display.XAxis);
                    displayImpl.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), Spline.this.range_refs[n], constantMapArray5);
                    ++n;
                }
            }
            ScalarMap scalarMap3 = new ScalarMap(RealType.XAxis, Display.XAxis);
            scalarMap3.setRange(-10.0, 0.0);
            ScalarMap scalarMap4 = new ScalarMap(RealType.YAxis, Display.YAxis);
            displayImpl2.addMap(scalarMap3);
            displayImpl2.addMap(scalarMap4);
            this.panel_e = new JPanel();
            this.panel_e.setLayout(new BoxLayout(this.panel_e, 1));
            this.panel_e.setAlignmentY(0.0f);
            this.panel_e.setAlignmentX(0.0f);
            this.panel_e.add(displayImpl2.getComponent());
            this.panel_e.setBorder(this.etchedBorder5);
            jPanel4.add(this.panel_e);
            Spline.this.spline_fieldRef = new DataReferenceImpl("spline_fieldRef");
            Spline.this.gcv_fieldRef = new DataReferenceImpl("gcv_fieldRef");
            Spline.this.true_fieldRef = new DataReferenceImpl("true_fieldRef");
            Spline.this.rlambda_fieldRef = new DataReferenceImpl("rlambda_fieldRef");
            Spline.this.rlambda_fieldRef.setData(Spline.this.rlambda_field);
            Spline.this.spline_fieldRef.setData(Spline.this.spline_field);
            Spline.this.gcv_fieldRef.setData(Spline.this.gcv_field);
            Spline.this.true_fieldRef.setData(Spline.this.true_field);
            displayImpl.addReference(Spline.this.spline_fieldRef);
            displayImpl.addReference(Spline.this.gcv_fieldRef, constantMapArray4);
            displayImpl.addReference(Spline.this.true_fieldRef, constantMapArray);
            displayImpl2.addReference(Spline.this.rlambda_fieldRef, constantMapArray3);
            displayImpl2.addReference(Spline.this.wk_ref, constantMapArray2);
            CellImpl cellImpl = new CellImpl(this){
                private final /* synthetic */ SplinePanel this$0;
                private final /* synthetic */ Spline this$1;

                public void doAction() throws VisADException, RemoteException {
                    int n = 0;
                    while (n < this.this$1.n_samples) {
                        this.this$1.range_values[n] = ((Real)this.this$1.range_refs[n].getData()).getValue();
                        ++n;
                    }
                    this.this$1.val = ((Real)this.this$1.lambda_ref.getData()).getValue();
                    this.this$1.val = Math.pow(10.0, this.this$1.val);
                    this.this$1.mode = 1;
                    this.this$1.getspline_c(this.this$1.range_values, this.this$1.spline_range, this.this$1.val, this.this$1.mode, this.this$1.wkvalue);
                    this.this$1.f_range[0] = this.this$1.spline_range;
                    this.this$1.spline_field.setSamples(this.this$1.f_range);
                }
                {
                    this.this$0 = splinePanel;
                    this.this$1 = SplinePanel.access$0(this.this$0);
                    this.constructor$0(splinePanel);
                }

                private final void constructor$0(SplinePanel splinePanel) {
                }
            };
            cellImpl.addReference(Spline.this.lambda_ref);
            CellImpl cellImpl2 = new CellImpl(this){
                double[] noise_a;
                private final /* synthetic */ SplinePanel this$0;
                private final /* synthetic */ Spline this$1;

                public void doAction() throws VisADException, RemoteException {
                    double d = ((Real)this.this$1.noise_ref.getData()).getValue();
                    int n = 0;
                    while (n < this.this$1.n_samples) {
                        this.this$1.range_values[n] = ((Real)this.this$1.range_refs[n].getData()).getValue();
                        this.noise_a[n] = this.this$1.last_noise_fac == 0.0 ? this.this$1.noise[n] : (this.this$1.range_values[n] - this.this$1.true_values[n]) / this.this$1.last_noise_fac;
                        this.this$1.range_values[n] = this.this$1.true_values[n] + d * this.noise_a[n];
                        this.this$1.range_refs[n].setData(new Real(RealType.YAxis, this.this$1.range_values[n]));
                        ++n;
                    }
                    this.this$1.val = ((Real)this.this$1.lambda_ref.getData()).getValue();
                    this.this$1.val = Math.pow(10.0, this.this$1.val);
                    this.this$1.mode = 1;
                    this.this$1.getspline_c(this.this$1.range_values, this.this$1.spline_range, this.this$1.val, this.this$1.mode, this.this$1.wkvalue);
                    this.this$1.f_range[0] = this.this$1.spline_range;
                    this.this$1.spline_field.setSamples(this.this$1.f_range);
                    this.this$1.mode = 2;
                    this.this$1.getspline_c(this.this$1.range_values, this.this$1.spline_range, this.this$1.val, this.this$1.mode, this.this$1.wkvalue);
                    System.out.print(this.this$1.wkvalue[0] + "\n");
                    this.this$1.f_range[0] = this.this$1.spline_range;
                    this.this$1.gcv_field.setSamples(this.this$1.f_range);
                    this.this$1.wk_value = this.this$1.wkvalue[0];
                    this.this$1.wk_ref.setData(new Real(RealType.XAxis, this.this$1.wkvalue[0]));
                    this.this$1.last_noise_fac = d;
                    double d2 = -10.0;
                    int n2 = 0;
                    while (n2 < 50) {
                        this.this$1.mode = 1;
                        this.this$1.rlambda_values[n2] = 0.0;
                        this.this$1.val = Math.pow(10.0, d2);
                        this.this$1.getspline_c(this.this$1.range_values, this.this$1.spline_range, this.this$1.val, this.this$1.mode, this.this$1.wkvalue);
                        int n3 = 0;
                        while (n3 < this.this$1.n_samples) {
                            int n4 = n2;
                            this.this$1.rlambda_values[n4] = this.this$1.rlambda_values[n4] + (this.this$1.spline_range[n3] - this.this$1.true_values[n3]) * (this.this$1.spline_range[n3] - this.this$1.true_values[n3]);
                            ++n3;
                        }
                        d2 += 0.2;
                        ++n2;
                    }
                    this.this$1.g_range[0] = this.this$1.rlambda_values;
                    this.this$1.rlambda_field.setSamples(this.this$1.g_range);
                }
                {
                    this.this$0 = splinePanel;
                    this.this$1 = SplinePanel.access$0(this.this$0);
                    this.noise_a = new double[this.this$1.n_samples];
                    this.constructor$0(splinePanel);
                }

                private final void constructor$0(SplinePanel splinePanel) {
                }
            };
            cellImpl2.addReference(Spline.this.noise_ref);
        }
    }
}

