/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.RangeSlider;
import visad.util.VisADSlider;

public class PCS
implements ActionListener,
ScalarMapListener,
DisplayListener {
    public static int WIDTH = 900;
    public static int HEIGHT = 600;
    int ntimes;
    int nbands;
    int npcs;
    int nchannels;
    int nlevels;
    Tuple file_data;
    FieldImpl time_series;
    FlatField eigen_vectors;
    FlatField means;
    FlatField pressures;
    RealType time;
    RealType band;
    RealType band1;
    RealType band2;
    RealType band3;
    RealType noise_band1;
    RealType noise_band2;
    RealType noise_band3;
    RealType latitude;
    RealType longitude;
    RealType levels;
    RealType temperature;
    RealType watervapor;
    RealType numpcs;
    RealType channels;
    RealType princ_comp;
    RealType band1_nu;
    RealType band2_nu;
    RealType band3_nu;
    RealType band1_mean;
    RealType band2_mean;
    RealType band3_mean;
    RealType band1_kur;
    RealType band2_kur;
    RealType band3_kur;
    RealType pressure;
    Linear1DSet time_set;
    Linear1DSet band_set;
    Linear2DSet eigen_set;
    Linear1DSet levels_set;
    Gridded1DSet band1_set;
    Gridded1DSet band2_set;
    Gridded1DSet band3_set;
    DataReferenceImpl time_ref;
    DataReferenceImpl num_eigen_ref;
    DataReferenceImpl b1_ref;
    DataReferenceImpl b1r_ref;
    DataReferenceImpl b1d_ref;
    DataReferenceImpl b2_ref;
    DataReferenceImpl b2r_ref;
    DataReferenceImpl b2d_ref;
    DataReferenceImpl b3_ref;
    DataReferenceImpl b3r_ref;
    DataReferenceImpl b3d_ref;
    DataReferenceImpl n1_ref;
    DataReferenceImpl n1r_ref;
    DataReferenceImpl n2_ref;
    DataReferenceImpl n2r_ref;
    DataReferenceImpl n3_ref;
    DataReferenceImpl n3r_ref;
    DataReferenceImpl ll_ref;
    DataReferenceImpl select_ll_ref;
    DataReferenceImpl map_ref;
    DataReferenceImpl temp_ref;
    DataReferenceImpl wv_ref;
    FunctionType b1_func;
    FunctionType b2_func;
    FunctionType b3_func;
    FunctionType n1_func;
    FunctionType n2_func;
    FunctionType n3_func;
    RealTupleType latlon;
    FunctionType latlon_func;
    FunctionType temp_profile;
    FunctionType wv_profile;
    float[][] eigen_values;
    float[][] mean_values;
    Gridded1DSet pressureSet;
    FlatField ll_field;
    RealTuple[] ll_select;
    FlatField[] tp;
    FlatField[] wvp;
    DisplayImpl displayb1;
    DisplayImpl displayb2;
    DisplayImpl displayb3;
    DisplayImpl displayll;
    Vector sMaps_b1;
    Vector cMaps_b1;
    Vector sMaps_b2;
    Vector cMaps_b2;
    Vector sMaps_b3;
    Vector cMaps_b3;
    int toggle;
    float band1_lo;
    float band1_hi;
    float band2_lo;
    float band2_hi;
    float band3_lo;
    float band3_hi;
    float[][] lls;
    RealTupleType scatter_range_b1;
    RealTupleType scatter_range_b2;
    RealTupleType scatter_range_b3;
    RealType scatter_index;
    FunctionType scatter_type_b1;
    FunctionType scatter_type_b2;
    FunctionType scatter_type_b3;
    final ScalarMap kur1_rgb;
    final ScalarMap kur2_rgb;
    final ScalarMap kur3_rgb;
    DataReferenceImpl zero_b1_ref;
    DataReferenceImpl zero_b2_ref;
    DataReferenceImpl zero_b3_ref;
    ScalarMap lonmap;
    ScalarMap latmap;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray.length < 1) {
            System.out.println("To run this program, type \"java visad.paoloa.PCS file.nc\"");
            System.out.println("where file.nc is a netCDF file containing GIFTS spectra and eigenvector");
            return;
        }
        PCS pCS = new PCS(stringArray[0]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("kurtosis")) {
            if (this.toggle == 0) {
                try {
                    this.displayb1.removeAllReferences();
                    this.displayb1.clearMaps();
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(0));
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(1));
                    this.displayb1.addMap(this.kur1_rgb);
                    this.displayb1.addReference(this.b1d_ref);
                    this.displayb2.removeAllReferences();
                    this.displayb2.clearMaps();
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(0));
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(1));
                    this.displayb2.addMap(this.kur2_rgb);
                    this.displayb2.addReference(this.b2d_ref);
                    this.displayb3.removeAllReferences();
                    this.displayb3.clearMaps();
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(0));
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(1));
                    this.displayb3.addMap(this.kur3_rgb);
                    this.displayb3.addReference(this.b3d_ref);
                }
                catch (VisADException visADException) {
                    System.out.println(visADException.getMessage());
                }
                catch (RemoteException remoteException) {
                    System.out.println(remoteException.getMessage());
                }
                this.toggle = 1;
            } else {
                try {
                    this.displayb1.removeAllReferences();
                    this.displayb1.clearMaps();
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(0));
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(1));
                    this.displayb1.addReference(this.b1_ref, (ConstantMap[])this.cMaps_b1.elementAt(0));
                    this.displayb1.addReference(this.b1r_ref, (ConstantMap[])this.cMaps_b1.elementAt(1));
                    this.displayb2.removeAllReferences();
                    this.displayb2.clearMaps();
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(0));
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(1));
                    this.displayb2.addReference(this.b2_ref, (ConstantMap[])this.cMaps_b2.elementAt(0));
                    this.displayb2.addReference(this.b2r_ref, (ConstantMap[])this.cMaps_b2.elementAt(1));
                    this.displayb3.removeAllReferences();
                    this.displayb3.clearMaps();
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(0));
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(1));
                    this.displayb3.addReference(this.b3_ref, (ConstantMap[])this.cMaps_b3.elementAt(0));
                    this.displayb3.addReference(this.b3r_ref, (ConstantMap[])this.cMaps_b3.elementAt(1));
                }
                catch (VisADException visADException) {
                    System.out.println(visADException.getMessage());
                }
                catch (RemoteException remoteException) {
                    System.out.println(remoteException.getMessage());
                }
                this.toggle = 0;
            }
        }
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) throws VisADException, RemoteException {
        ScalarMap scalarMap = scalarMapEvent.getScalarMap();
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
    }

    public void displayChanged(DisplayEvent displayEvent) throws VisADException, RemoteException {
        if (displayEvent.getId() == 4) {
            double[] dArray = new double[2];
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            double[] dArray4 = null;
            double d = 3.0;
            double d2 = 3.0;
            dArray4 = this.displayll.getDisplayRenderer().getCursor();
            this.lonmap.getScale(dArray, dArray2, dArray3);
            double d3 = (dArray4[0] - dArray[1]) / dArray[0];
            this.latmap.getScale(dArray, dArray2, dArray3);
            double d4 = (dArray4[1] - dArray[1]) / dArray[0];
            int n = 0;
            while (n < this.ntimes) {
                if ((double)this.lls[1][n] < d3 + d && (double)this.lls[1][n] > d3 - d && (double)this.lls[0][n] < d4 + d2 && (double)this.lls[0][n] > d4 - d2) {
                    this.time_ref.setData(new Real(this.time, (double)(n + 1)));
                    break;
                }
                ++n;
            }
        }
    }

    public PCS(String string) throws VisADException, RemoteException, IOException {
        Object object;
        DataImpl dataImpl;
        float f;
        Plain plain = new Plain();
        this.file_data = (Tuple)plain.open(string);
        plain = null;
        this.time_series = (FieldImpl)this.file_data.getComponent(0);
        this.eigen_vectors = (FlatField)this.file_data.getComponent(1);
        this.means = (FlatField)this.file_data.getComponent(2);
        this.pressures = (FlatField)this.file_data.getComponent(3);
        FunctionType functionType = (FunctionType)this.time_series.getType();
        FunctionType functionType2 = (FunctionType)this.eigen_vectors.getType();
        FunctionType functionType3 = (FunctionType)this.means.getType();
        FunctionType functionType4 = (FunctionType)this.pressures.getType();
        this.time = (RealType)functionType.getDomain().getComponent(0);
        TupleType tupleType = (TupleType)functionType.getRange();
        FunctionType functionType5 = (FunctionType)tupleType.getComponent(0);
        FunctionType functionType6 = (FunctionType)tupleType.getComponent(1);
        FunctionType functionType7 = (FunctionType)tupleType.getComponent(2);
        this.band = (RealType)functionType5.getDomain().getComponent(0);
        RealTupleType realTupleType = (RealTupleType)functionType5.getRange();
        this.band1 = (RealType)realTupleType.getComponent(0);
        this.band2 = (RealType)realTupleType.getComponent(1);
        this.band3 = (RealType)realTupleType.getComponent(2);
        this.noise_band1 = (RealType)realTupleType.getComponent(3);
        this.noise_band2 = (RealType)realTupleType.getComponent(4);
        this.noise_band3 = (RealType)realTupleType.getComponent(5);
        this.latlon = (RealTupleType)functionType6.getRange();
        this.latitude = (RealType)this.latlon.getComponent(0);
        this.longitude = (RealType)this.latlon.getComponent(1);
        this.levels = (RealType)functionType7.getDomain().getComponent(0);
        RealTupleType realTupleType2 = (RealTupleType)functionType7.getRange();
        this.temperature = (RealType)realTupleType2.getComponent(0);
        this.watervapor = (RealType)realTupleType2.getComponent(1);
        RealTupleType realTupleType3 = functionType2.getDomain();
        this.numpcs = (RealType)realTupleType3.getComponent(0);
        this.channels = (RealType)realTupleType3.getComponent(1);
        this.princ_comp = (RealType)functionType2.getRange();
        RealTupleType realTupleType4 = (RealTupleType)functionType3.getRange();
        this.band1_nu = (RealType)realTupleType4.getComponent(0);
        this.band2_nu = (RealType)realTupleType4.getComponent(1);
        this.band3_nu = (RealType)realTupleType4.getComponent(2);
        this.band1_mean = (RealType)realTupleType4.getComponent(3);
        this.band2_mean = (RealType)realTupleType4.getComponent(4);
        this.band3_mean = (RealType)realTupleType4.getComponent(5);
        this.band1_kur = (RealType)realTupleType4.getComponent(6);
        this.band2_kur = (RealType)realTupleType4.getComponent(7);
        this.band3_kur = (RealType)realTupleType4.getComponent(8);
        this.pressure = (RealType)functionType4.getRange();
        this.scatter_range_b1 = new RealTupleType(this.band, this.band1, this.band1_kur);
        this.scatter_range_b2 = new RealTupleType(this.band, this.band2, this.band2_kur);
        this.scatter_range_b3 = new RealTupleType(this.band, this.band3, this.band3_kur);
        this.scatter_index = new RealType("scatter_index");
        this.scatter_type_b1 = new FunctionType(this.scatter_index, this.scatter_range_b1);
        this.scatter_type_b2 = new FunctionType(this.scatter_index, this.scatter_range_b2);
        this.scatter_type_b3 = new FunctionType(this.scatter_index, this.scatter_range_b3);
        this.b1_func = new FunctionType(this.band, this.band1);
        this.b2_func = new FunctionType(this.band, this.band2);
        this.b3_func = new FunctionType(this.band, this.band3);
        this.n1_func = new FunctionType(this.band, this.noise_band1);
        this.n2_func = new FunctionType(this.band, this.noise_band2);
        this.n3_func = new FunctionType(this.band, this.noise_band3);
        this.latlon_func = new FunctionType(this.time, this.latlon);
        this.temp_profile = new FunctionType(this.pressure, this.temperature);
        this.wv_profile = new FunctionType(this.pressure, this.watervapor);
        Tuple tuple = (Tuple)this.time_series.getSample(0);
        this.time_set = (Linear1DSet)this.time_series.getDomainSet();
        this.band_set = (Linear1DSet)((Field)tuple.getComponent(0)).getDomainSet();
        this.eigen_set = (Linear2DSet)this.eigen_vectors.getDomainSet();
        this.levels_set = (Linear1DSet)((Field)tuple.getComponent(2)).getDomainSet();
        this.ntimes = this.time_set.getLength();
        this.nbands = this.band_set.getLength();
        int[] nArray = this.eigen_set.getLengths();
        this.npcs = nArray[0];
        this.nchannels = nArray[1];
        if (this.nchannels != 3 * this.nbands) {
            throw new VisADException("nchannels " + this.nchannels + " != 3 * " + this.nbands + " nbands");
        }
        this.nlevels = this.levels_set.getLength();
        float[][] fArray = new float[1][this.nbands];
        int n = 0;
        while (n < this.nbands) {
            fArray[0][n] = 0.0f;
            ++n;
        }
        FlatField flatField = new FlatField(this.b1_func, this.band_set);
        FlatField flatField2 = new FlatField(this.b2_func, this.band_set);
        FlatField flatField3 = new FlatField(this.b3_func, this.band_set);
        flatField.setSamples(fArray, false);
        flatField2.setSamples(fArray, false);
        flatField3.setSamples(fArray, false);
        double[][] dArray = this.means.getValues();
        double[][] dArray2 = new double[1][this.nbands];
        dArray2[0] = dArray[0];
        this.band1_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(dArray2), this.nbands);
        this.band1_lo = this.band1_set.getLowX();
        this.band1_hi = this.band1_set.getHiX();
        dArray2[0] = dArray[1];
        this.band2_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(dArray2), this.nbands);
        this.band2_lo = this.band2_set.getLowX();
        this.band2_hi = this.band2_set.getHiX();
        dArray2[0] = dArray[2];
        this.band3_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(dArray2), this.nbands);
        this.band3_lo = this.band3_set.getLowX();
        this.band3_hi = this.band3_set.getHiX();
        this.b1_ref = new DataReferenceImpl("b1_ref");
        this.b1r_ref = new DataReferenceImpl("b1r_ref");
        this.b1d_ref = new DataReferenceImpl("b1d_ref");
        this.b2_ref = new DataReferenceImpl("b2_ref");
        this.b2r_ref = new DataReferenceImpl("b2r_ref");
        this.b2d_ref = new DataReferenceImpl("b2d_ref");
        this.b3_ref = new DataReferenceImpl("b3_ref");
        this.b3r_ref = new DataReferenceImpl("b3r_ref");
        this.b3d_ref = new DataReferenceImpl("b3d_ref");
        this.n1_ref = new DataReferenceImpl("n1_ref");
        this.n1r_ref = new DataReferenceImpl("n1r_ref");
        this.n2_ref = new DataReferenceImpl("n2_ref");
        this.n2r_ref = new DataReferenceImpl("n2r_ref");
        this.n3_ref = new DataReferenceImpl("n3_ref");
        this.n3r_ref = new DataReferenceImpl("n3r_ref");
        this.ll_ref = new DataReferenceImpl("ll_ref");
        this.select_ll_ref = new DataReferenceImpl("select_ll_ref");
        this.map_ref = new DataReferenceImpl("map_ref");
        this.wv_ref = new DataReferenceImpl("wv_ref");
        this.temp_ref = new DataReferenceImpl("temp_ref");
        this.time_ref = new DataReferenceImpl("time_ref");
        this.num_eigen_ref = new DataReferenceImpl("num_eigen_ref");
        this.zero_b1_ref = new DataReferenceImpl("zero_b1_ref");
        this.zero_b2_ref = new DataReferenceImpl("zero_b2_ref");
        this.zero_b3_ref = new DataReferenceImpl("zero_b3_ref");
        this.zero_b1_ref.setData(flatField);
        this.zero_b2_ref.setData(flatField2);
        this.zero_b3_ref.setData(flatField3);
        this.toggle = 0;
        this.sMaps_b1 = new Vector();
        this.cMaps_b1 = new Vector();
        this.kur1_rgb = new ScalarMap(this.band1_kur, Display.RGB);
        this.displayb1 = new DisplayImplJ3D("displayb1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap = new ScalarMap(this.band, Display.XAxis);
        scalarMap.addScalarMapListener(this);
        this.sMaps_b1.addElement(scalarMap);
        this.displayb1.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(this.band1, Display.YAxis);
        this.sMaps_b1.addElement(scalarMap2);
        this.displayb1.addMap(scalarMap2);
        GraphicsModeControl graphicsModeControl = this.displayb1.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b1.addElement(constantMapArray);
        this.cMaps_b1.addElement(constantMapArray2);
        this.displayb1.setAlwaysAutoScale(true);
        this.displayb1.addReference(this.b1_ref, constantMapArray);
        this.displayb1.addReference(this.b1r_ref, constantMapArray2);
        this.sMaps_b2 = new Vector();
        this.cMaps_b2 = new Vector();
        this.kur2_rgb = new ScalarMap(this.band2_kur, Display.RGB);
        this.displayb2 = new DisplayImplJ3D("displayb2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap3 = new ScalarMap(this.band, Display.XAxis);
        this.sMaps_b2.addElement(scalarMap3);
        this.displayb2.addMap(scalarMap3);
        ScalarMap scalarMap4 = new ScalarMap(this.band2, Display.YAxis);
        this.sMaps_b2.addElement(scalarMap4);
        this.displayb2.addMap(scalarMap4);
        GraphicsModeControl graphicsModeControl2 = this.displayb2.getGraphicsModeControl();
        graphicsModeControl2.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b2.addElement(constantMapArray);
        this.cMaps_b2.addElement(constantMapArray2);
        this.displayb2.setAlwaysAutoScale(true);
        this.displayb2.addReference(this.b2_ref, constantMapArray);
        this.displayb2.addReference(this.b2r_ref, constantMapArray2);
        this.sMaps_b3 = new Vector();
        this.cMaps_b3 = new Vector();
        this.kur3_rgb = new ScalarMap(this.band3_kur, Display.RGB);
        this.displayb3 = new DisplayImplJ3D("displayb3", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap5 = new ScalarMap(this.band, Display.XAxis);
        this.sMaps_b3.addElement(scalarMap5);
        this.displayb3.addMap(scalarMap5);
        ScalarMap scalarMap6 = new ScalarMap(this.band3, Display.YAxis);
        this.sMaps_b3.addElement(scalarMap6);
        this.displayb3.addMap(scalarMap6);
        GraphicsModeControl graphicsModeControl3 = this.displayb3.getGraphicsModeControl();
        graphicsModeControl3.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b3.addElement(constantMapArray);
        this.cMaps_b3.addElement(constantMapArray2);
        this.displayb3.setAlwaysAutoScale(true);
        this.displayb3.addReference(this.b3_ref, constantMapArray);
        this.displayb3.addReference(this.b3r_ref, constantMapArray2);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("displayn1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap7 = new ScalarMap(this.band, Display.XAxis);
        displayImplJ3D.addMap(scalarMap7);
        displayImplJ3D.addMap(new ScalarMap(this.noise_band1, Display.YAxis));
        GraphicsModeControl graphicsModeControl4 = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        graphicsModeControl4.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayImplJ3D.addReference(this.n1_ref, constantMapArray);
        displayImplJ3D.addReference(this.n1r_ref, constantMapArray2);
        DisplayImplJ3D displayImplJ3D2 = new DisplayImplJ3D("displayn2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap8 = new ScalarMap(this.band, Display.XAxis);
        displayImplJ3D2.addMap(scalarMap8);
        displayImplJ3D2.addMap(new ScalarMap(this.noise_band2, Display.YAxis));
        GraphicsModeControl graphicsModeControl5 = ((DisplayImpl)displayImplJ3D2).getGraphicsModeControl();
        graphicsModeControl5.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayImplJ3D2.addReference(this.n2_ref, constantMapArray);
        displayImplJ3D2.addReference(this.n2r_ref, constantMapArray2);
        DisplayImplJ3D displayImplJ3D3 = new DisplayImplJ3D("displayn3", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap9 = new ScalarMap(this.band, Display.XAxis);
        displayImplJ3D3.addMap(scalarMap9);
        displayImplJ3D3.addMap(new ScalarMap(this.noise_band3, Display.YAxis));
        GraphicsModeControl graphicsModeControl6 = ((DisplayImpl)displayImplJ3D3).getGraphicsModeControl();
        graphicsModeControl6.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayImplJ3D3.addReference(this.n3_ref, constantMapArray);
        displayImplJ3D3.addReference(this.n3r_ref, constantMapArray2);
        this.displayll = new DisplayImplJ3D("displayll", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        this.displayll.addDisplayListener(this);
        this.lonmap = new ScalarMap(this.longitude, Display.XAxis);
        this.displayll.addMap(this.lonmap);
        this.latmap = new ScalarMap(this.latitude, Display.YAxis);
        this.displayll.addMap(this.latmap);
        GraphicsModeControl graphicsModeControl7 = this.displayll.getGraphicsModeControl();
        graphicsModeControl7.setScaleEnable(true);
        constantMapArray = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(5.0, Display.PointSize)};
        constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.5, Display.Green), new ConstantMap(0.5, Display.Blue), new ConstantMap(5.0, Display.PointSize)};
        this.displayll.addReference(this.select_ll_ref, constantMapArray);
        this.displayll.addReference(this.ll_ref, constantMapArray2);
        this.displayll.addReference(this.map_ref);
        DisplayImplJ3D displayImplJ3D4 = new DisplayImplJ3D("displayprof", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        displayImplJ3D4.addMap(new ScalarMap(this.temperature, Display.XAxis));
        displayImplJ3D4.addMap(new ScalarMap(this.watervapor, Display.XAxis));
        ScalarMap scalarMap10 = new ScalarMap(this.pressure, Display.YAxis);
        scalarMap10.setRange(1050.0, 0.0);
        displayImplJ3D4.addMap(scalarMap10);
        GraphicsModeControl graphicsModeControl8 = ((DisplayImpl)displayImplJ3D4).getGraphicsModeControl();
        graphicsModeControl8.setScaleEnable(true);
        ConstantMap[] constantMapArray3 = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(0.0, Display.Green)};
        ConstantMap[] constantMapArray4 = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(0.0, Display.Red)};
        displayImplJ3D4.addReference(this.wv_ref, constantMapArray4);
        displayImplJ3D4.addReference(this.temp_ref, constantMapArray3);
        JFrame jFrame = new JFrame("Principal Components");
        WindowAdapter windowAdapter = new WindowAdapter(this){
            private final /* synthetic */ PCS this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = pCS;
                this.constructor$0(pCS);
            }

            private final void constructor$0(PCS pCS) {
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ((Component)jFrame).setSize(WIDTH, HEIGHT);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - WIDTH / 2, dimension.height / 2 - HEIGHT / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("PCS Sliders");
        jPanel2.setFont(new Font("Dialog", 0, 12));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.time_ref.setData(new Real(this.time, 1.0));
        jPanel2.add(new VisADSlider("neigen", 0, this.npcs, 0, 1.0, this.num_eigen_ref, this.numpcs));
        JButton jButton = new JButton("kurtosis");
        jButton.addActionListener(this);
        jButton.setActionCommand("kurtosis");
        jPanel2.add(jButton);
        RangeSlider rangeSlider = new RangeSlider(this, scalarMap, scalarMap7, scalarMap3, scalarMap8, scalarMap5, scalarMap9, "band range", 0.0f, this.nbands){
            private final /* synthetic */ PCS this$0;
            private final /* synthetic */ ScalarMap val$bmapb1;
            private final /* synthetic */ ScalarMap val$bmapn1;
            private final /* synthetic */ ScalarMap val$bmapb2;
            private final /* synthetic */ ScalarMap val$bmapn2;
            private final /* synthetic */ ScalarMap val$bmapb3;
            private final /* synthetic */ ScalarMap val$bmapn3;

            public void valuesUpdated() {
                float f = (this.this$0.band1_hi - this.this$0.band1_lo) / (float)this.this$0.nbands;
                float f2 = (this.this$0.band2_hi - this.this$0.band2_lo) / (float)this.this$0.nbands;
                float f3 = (this.this$0.band3_hi - this.this$0.band3_lo) / (float)this.this$0.nbands;
                float[] fArray = this.getMinMaxValues();
                float f4 = fArray[0];
                float f5 = fArray[1];
                try {
                    float f6 = this.this$0.band1_lo + f * f4;
                    float f7 = this.this$0.band1_hi - f * ((float)this.this$0.nbands - f5);
                    this.val$bmapb1.setRange(f6, f7);
                    this.val$bmapn1.setRange(f6, f7);
                    f6 = this.this$0.band2_lo + f2 * f4;
                    f7 = this.this$0.band2_hi - f2 * ((float)this.this$0.nbands - f5);
                    this.val$bmapb2.setRange(f6, f7);
                    this.val$bmapn2.setRange(f6, f7);
                    f6 = this.this$0.band3_lo + f3 * f4;
                    f7 = this.this$0.band3_hi - f3 * ((float)this.this$0.nbands - f5);
                    this.val$bmapb3.setRange(f6, f7);
                    this.val$bmapn3.setRange(f6, f7);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            {
                this.val$bmapb1 = scalarMap;
                this.val$bmapn1 = scalarMap2;
                this.val$bmapb2 = scalarMap3;
                this.val$bmapn2 = scalarMap4;
                this.val$bmapb3 = scalarMap5;
                this.val$bmapn3 = scalarMap6;
                this.this$0 = pCS;
                this.constructor$0(pCS, string, f, f2);
            }

            private final void constructor$0(PCS pCS, String string, float f, float f2) {
            }
        };
        jPanel2.add(rangeSlider);
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("PCS Sliders");
        jPanel3.setFont(new Font("Dialog", 0, 12));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel3);
        JPanel jPanel4 = (JPanel)this.displayb1.getComponent();
        JPanel jPanel5 = (JPanel)this.displayb2.getComponent();
        JPanel jPanel6 = (JPanel)this.displayb3.getComponent();
        JPanel jPanel7 = (JPanel)this.displayll.getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        jPanel4.setBorder(compoundBorder);
        jPanel5.setBorder(compoundBorder);
        jPanel6.setBorder(compoundBorder);
        jPanel7.setBorder(compoundBorder);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setName("PCS Sliders");
        jPanel8.setFont(new Font("Dialog", 0, 12));
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setAlignmentY(0.0f);
        jPanel8.setAlignmentX(0.0f);
        jPanel.add(jPanel8);
        JPanel jPanel9 = (JPanel)displayImplJ3D.getComponent();
        JPanel jPanel10 = (JPanel)displayImplJ3D2.getComponent();
        JPanel jPanel11 = (JPanel)displayImplJ3D3.getComponent();
        JPanel jPanel12 = (JPanel)displayImplJ3D4.getComponent();
        jPanel9.setBorder(compoundBorder);
        jPanel10.setBorder(compoundBorder);
        jPanel11.setBorder(compoundBorder);
        jPanel12.setBorder(compoundBorder);
        jPanel8.add(jPanel9);
        jPanel8.add(jPanel10);
        jPanel8.add(jPanel11);
        jPanel8.add(jPanel12);
        float[][] fArray2 = this.means.getFloats(false);
        this.mean_values = new float[3][this.nbands];
        this.mean_values[0] = fArray2[3];
        this.mean_values[1] = fArray2[4];
        this.mean_values[2] = fArray2[5];
        fArray2 = this.eigen_vectors.getFloats(false);
        this.eigen_values = new float[this.npcs][this.nchannels];
        int n2 = 0;
        while (n2 < this.npcs) {
            double d = 0.0;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < this.nchannels) {
                this.eigen_values[n2][n3] = fArray2[0][n2 + this.npcs * n3];
                d2 += (double)this.npcs;
                d += (double)(this.eigen_values[n2][n3] * this.eigen_values[n2][n3]);
                ++n3;
            }
            f = (float)(1.0 / Math.sqrt(d));
            int n4 = 0;
            while (n4 < this.nchannels) {
                float[] fArray3 = this.eigen_values[n2];
                int n5 = n4++;
                fArray3[n5] = fArray3[n5] * f;
            }
            ++n2;
        }
        fArray2 = this.pressures.getFloats(false);
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)this.pressure, fArray2, this.nlevels);
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        f = 1.0f;
        float f6 = 1.0f;
        this.lls = new float[2][this.ntimes];
        this.ll_select = new RealTuple[this.ntimes];
        int n6 = 0;
        while (n6 < this.ntimes) {
            dataImpl = (Tuple)this.time_series.getSample(n6);
            FlatField flatField4 = (FlatField)dataImpl.getComponent(1);
            fArray2 = flatField4.getFloats(false);
            this.lls[0][n6] = fArray2[0][0];
            this.lls[1][n6] = fArray2[1][0];
            if (this.lls[0][n6] < f2) {
                f2 = this.lls[0][n6];
            }
            if (this.lls[0][n6] > f3) {
                f3 = this.lls[0][n6];
            }
            if (this.lls[1][n6] < f4) {
                f4 = this.lls[1][n6];
            }
            if (this.lls[1][n6] > f5) {
                f5 = this.lls[1][n6];
            }
            object = new double[]{fArray2[0][0], fArray2[1][0]};
            this.ll_select[n6] = new RealTuple(this.latlon, (double[])object);
            ++n6;
        }
        this.ll_field = new FlatField(this.latlon_func, new Integer1DSet((MathType)this.time, this.ntimes));
        this.ll_field.setSamples(this.lls);
        this.ll_ref.setData(this.ll_field);
        this.lonmap.setRange(f5, f4);
        this.latmap.setRange(f2, f3);
        BaseMapAdapter baseMapAdapter = new BaseMapAdapter("OUTLSUPW");
        if (baseMapAdapter.isEastPositive()) {
            baseMapAdapter.setEastPositive(false);
        }
        baseMapAdapter.setLatLonLimits(f2 - f, f3 + f, f4 - f6, f5 + f6);
        dataImpl = baseMapAdapter.getData();
        this.map_ref.setData(dataImpl);
        this.tp = new FlatField[this.ntimes];
        this.wvp = new FlatField[this.ntimes];
        int n7 = 0;
        while (n7 < this.ntimes) {
            object = (Tuple)this.time_series.getSample(n7);
            FlatField flatField5 = (FlatField)((Tuple)object).getComponent(2);
            fArray2 = flatField5.getFloats(false);
            float[][] fArray4 = new float[][]{fArray2[0]};
            this.tp[n7] = new FlatField(this.temp_profile, gridded1DSet);
            this.tp[n7].setSamples(fArray4, false);
            float[][] fArray5 = new float[][]{fArray2[1]};
            this.wvp[n7] = new FlatField(this.wv_profile, gridded1DSet);
            this.wvp[n7].setSamples(fArray5, false);
            ++n7;
        }
        CellImpl cellImpl = new CellImpl(this){
            private final /* synthetic */ PCS this$0;

            public void doAction() throws VisADException, RemoteException {
                Object object;
                int n;
                int n2 = (int)((Real)this.this$0.time_ref.getData()).getValue() - 1;
                int n3 = (int)((Real)this.this$0.num_eigen_ref.getData()).getValue();
                if (n2 < 0 || this.this$0.ntimes <= n2 || n3 < 0 || this.this$0.npcs < n3) {
                    System.out.println("time " + n2 + " or neigens " + n3 + " out of bounds");
                    return;
                }
                Tuple tuple = (Tuple)this.this$0.time_series.getSample(n2);
                FlatField flatField = (FlatField)tuple.getComponent(0);
                float[][] fArray = flatField.getFloats(false);
                float[] fArray2 = new float[this.this$0.nchannels];
                float[] fArray3 = new float[this.this$0.nchannels];
                float[] fArray4 = new float[this.this$0.nchannels];
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = n4 * this.this$0.nbands;
                    n = 0;
                    while (n < this.this$0.nbands) {
                        fArray2[n5 + n] = fArray[n4][n];
                        fArray3[n5 + n] = fArray[3 + n4][n];
                        fArray4[n5 + n] = this.this$0.mean_values[n4][n];
                        ++n;
                    }
                    ++n4;
                }
                float[] fArray5 = new float[n3];
                float[] fArray6 = new float[n3];
                n = 0;
                while (n < n3) {
                    double d = 0.0;
                    double d2 = 0.0;
                    object = this.this$0.eigen_values[n];
                    int n6 = 0;
                    while (n6 < this.this$0.nchannels) {
                        d += (double)(object[n6] * (fArray2[n6] - fArray4[n6]));
                        d2 += (double)(object[n6] * fArray3[n6]);
                        ++n6;
                    }
                    fArray5[n] = (float)d;
                    fArray6[n] = (float)d2;
                    ++n;
                }
                float[] fArray7 = new float[this.this$0.nchannels];
                float[] fArray8 = new float[this.this$0.nchannels];
                int n7 = 0;
                while (n7 < this.this$0.nchannels) {
                    float f = fArray4[n7];
                    float f2 = 0.0f;
                    int n8 = 0;
                    while (n8 < n3) {
                        f += fArray5[n8] * this.this$0.eigen_values[n8][n7];
                        f2 += fArray6[n8] * this.this$0.eigen_values[n8][n7];
                        ++n8;
                    }
                    fArray7[n7] = f;
                    fArray8[n7] = f2;
                    ++n7;
                }
                float[][] fArray9 = new float[6][this.this$0.nbands];
                int n9 = 0;
                while (n9 < 3) {
                    int n10 = n9 * this.this$0.nbands;
                    int n11 = 0;
                    while (n11 < this.this$0.nbands) {
                        fArray9[n9][n11] = fArray7[n10 + n11];
                        fArray9[3 + n9][n11] = fArray8[n10 + n11];
                        ++n11;
                    }
                    ++n9;
                }
                FlatField flatField2 = (FlatField)this.this$0.file_data.getComponent(2);
                double[][] dArray = flatField2.getValues();
                object = new float[][]{fArray[0]};
                FlatField flatField3 = new FlatField(this.this$0.b1_func, this.this$0.band1_set);
                flatField3.setSamples((float[][])object, false);
                this.this$0.b1_ref.setData(flatField3);
                object = new float[][]{fArray9[0]};
                FlatField flatField4 = new FlatField(this.this$0.b1_func, this.this$0.band1_set);
                flatField4.setSamples((float[][])object, false);
                this.this$0.b1r_ref.setData(flatField4);
                double[][] dArray2 = ((FlatField)flatField3.subtract(flatField4)).getValues();
                float[][] fArray10 = new float[3][];
                Set set = flatField3.getDomainSet();
                float[][] fArray11 = set.getSamples();
                fArray10[0] = fArray11[0];
                fArray10[1] = Set.doubleToFloat(dArray2)[0];
                fArray10[2] = Set.doubleToFloat(dArray)[6];
                Integer1DSet integer1DSet = new Integer1DSet((MathType)this.this$0.scatter_index, this.this$0.nbands);
                FlatField flatField5 = new FlatField(this.this$0.scatter_type_b1, integer1DSet);
                flatField5.setSamples(fArray10, false);
                this.this$0.b1d_ref.setData(flatField5);
                object = new float[][]{fArray[1]};
                FlatField flatField6 = new FlatField(this.this$0.b2_func, this.this$0.band2_set);
                flatField6.setSamples((float[][])object, false);
                this.this$0.b2_ref.setData(flatField6);
                object = new float[][]{fArray9[1]};
                FlatField flatField7 = new FlatField(this.this$0.b2_func, this.this$0.band2_set);
                flatField7.setSamples((float[][])object, false);
                this.this$0.b2r_ref.setData(flatField7);
                dArray2 = ((FlatField)flatField6.subtract(flatField7)).getValues();
                fArray10 = new float[3][];
                set = flatField6.getDomainSet();
                fArray11 = set.getSamples();
                fArray10[0] = fArray11[0];
                fArray10[1] = Set.doubleToFloat(dArray2)[0];
                fArray10[2] = Set.doubleToFloat(dArray)[7];
                integer1DSet = new Integer1DSet((MathType)this.this$0.scatter_index, this.this$0.nbands);
                flatField5 = new FlatField(this.this$0.scatter_type_b2, integer1DSet);
                flatField5.setSamples(fArray10, false);
                this.this$0.b2d_ref.setData(flatField5);
                object = new float[][]{fArray[2]};
                FlatField flatField8 = new FlatField(this.this$0.b3_func, this.this$0.band3_set);
                flatField8.setSamples((float[][])object, false);
                this.this$0.b3_ref.setData(flatField8);
                object = new float[][]{fArray9[2]};
                FlatField flatField9 = new FlatField(this.this$0.b3_func, this.this$0.band3_set);
                flatField9.setSamples((float[][])object, false);
                this.this$0.b3r_ref.setData(flatField9);
                dArray2 = ((FlatField)flatField8.subtract(flatField9)).getValues();
                fArray10 = new float[3][];
                set = flatField8.getDomainSet();
                fArray11 = set.getSamples();
                fArray10[0] = fArray11[0];
                fArray10[1] = Set.doubleToFloat(dArray2)[0];
                fArray10[2] = Set.doubleToFloat(dArray)[8];
                integer1DSet = new Integer1DSet((MathType)this.this$0.scatter_index, this.this$0.nbands);
                flatField5 = new FlatField(this.this$0.scatter_type_b3, integer1DSet);
                flatField5.setSamples(fArray10, false);
                this.this$0.b3d_ref.setData(flatField5);
                object = new float[][]{fArray[3]};
                FlatField flatField10 = new FlatField(this.this$0.n1_func, this.this$0.band1_set);
                flatField10.setSamples((float[][])object, false);
                this.this$0.n1_ref.setData(flatField10);
                object = new float[][]{fArray9[3]};
                FlatField flatField11 = new FlatField(this.this$0.n1_func, this.this$0.band1_set);
                flatField11.setSamples((float[][])object, false);
                this.this$0.n1r_ref.setData(flatField11);
                object = new float[][]{fArray[4]};
                FlatField flatField12 = new FlatField(this.this$0.n2_func, this.this$0.band2_set);
                flatField12.setSamples((float[][])object, false);
                this.this$0.n2_ref.setData(flatField12);
                object = new float[][]{fArray9[4]};
                FlatField flatField13 = new FlatField(this.this$0.n2_func, this.this$0.band2_set);
                flatField13.setSamples((float[][])object, false);
                this.this$0.n2r_ref.setData(flatField13);
                object = new float[][]{fArray[5]};
                FlatField flatField14 = new FlatField(this.this$0.n3_func, this.this$0.band3_set);
                flatField14.setSamples((float[][])object, false);
                this.this$0.n3_ref.setData(flatField14);
                object = new float[][]{fArray9[5]};
                FlatField flatField15 = new FlatField(this.this$0.n3_func, this.this$0.band3_set);
                flatField15.setSamples((float[][])object, false);
                this.this$0.n3r_ref.setData(flatField15);
                this.this$0.select_ll_ref.setData(this.this$0.ll_select[n2]);
                this.this$0.temp_ref.setData(this.this$0.tp[n2]);
                this.this$0.wv_ref.setData(this.this$0.wvp[n2]);
            }
            {
                this.this$0 = pCS;
                this.constructor$0(pCS);
            }

            private final void constructor$0(PCS pCS) {
            }
        };
        cellImpl.addReference(this.time_ref);
        cellImpl.addReference(this.num_eigen_ref);
        ((Component)jFrame).setVisible(true);
    }
}

