/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.LabeledColorWidget;

public class Nasti {
    int ntimes;
    int nlines;
    int nelements;
    int[] time_to_sample;
    int[][] sample_to_time;
    Field nasti;
    int spectrum_index;
    boolean java2d = false;
    RealType time;
    RealType wnum1;
    RealType atmosphericRadiance;
    RealType image_line;
    RealType image_element;
    float wnum_low;
    float wnum_hi;
    Linear2DSet image_set;
    RealTupleType image_domain;
    FunctionType image_type;
    FunctionType red_bar_type;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray.length < 1) {
            System.out.println("To run this program, type \"java visad.paoloa.Nasti file.nc\"");
            System.out.println("where file.nc is a netCDF file containing a NAST-I file.");
            return;
        }
        Nasti nasti = new Nasti(stringArray[0]);
    }

    public Nasti(String string) throws VisADException, RemoteException, IOException {
        Plain plain = new Plain();
        Tuple tuple = (Tuple)plain.open(string);
        plain = null;
        this.nasti = (Field)tuple.getComponent(2);
        FunctionType functionType = (FunctionType)this.nasti.getType();
        TupleType tupleType = (TupleType)functionType.getRange();
        int n = tupleType.getIndex("sceneMirrorAngle");
        this.time = (RealType)functionType.getDomain().getComponent(0);
        Gridded1DSet gridded1DSet = (Gridded1DSet)this.nasti.getDomainSet();
        float[][] fArray = gridded1DSet.getSamples();
        float[] fArray2 = fArray[0];
        this.ntimes = gridded1DSet.getLength();
        double[] dArray = new double[this.ntimes];
        int[] nArray = new int[this.ntimes];
        int[] nArray2 = new int[this.ntimes];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.ntimes) {
            dArray[n4] = ((Real)((Tuple)this.nasti.getSample(n4)).getComponent(n)).getValue();
            if (n4 <= 0 || dArray[n4] < dArray[n4 - 1]) {
                // empty if block
            }
            nArray2[n4] = ++n2;
            nArray[n4] = (int)Math.round((dArray[n4] + 45.0) / 7.5);
            if (nArray[n4] < 0) {
                System.out.println("negative element " + nArray[n4]);
                System.exit(0);
            }
            if (nArray[n4] > 12) {
                System.out.println("element > 12: " + nArray[n4]);
                System.exit(0);
            }
            if (nArray[n4] > n3) {
                n3 = nArray[n4];
            }
            ++n4;
        }
        if (n3 > 12) {
            System.out.println("max_element = " + n3 + " too large");
            System.exit(0);
        }
        this.nlines = n2 + 1;
        this.nelements = 13;
        System.out.println("nlines = " + this.nlines + " nelements = " + this.nelements);
        this.time_to_sample = new int[this.ntimes];
        this.sample_to_time = new int[this.nlines][this.nelements];
        n4 = 0;
        while (n4 < this.nlines) {
            int n5 = 0;
            while (n5 < this.nelements) {
                this.sample_to_time[n4][n5] = -1;
                ++n5;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.ntimes) {
            this.time_to_sample[n4] = nArray[n4] + this.nelements * nArray2[n4];
            this.sample_to_time[nArray2[n4]][nArray[n4]] = n4;
            ++n4;
        }
        this.spectrum_index = tupleType.getDimension() - 1;
        FunctionType functionType2 = (FunctionType)tupleType.getComponent(this.spectrum_index);
        this.wnum1 = (RealType)functionType2.getDomain().getComponent(0);
        this.atmosphericRadiance = (RealType)functionType2.getRange();
        this.red_bar_type = new FunctionType(this.atmosphericRadiance, this.wnum1);
        Field field = (Field)((Tuple)this.nasti.getSample(0)).getComponent(this.spectrum_index);
        Gridded1DSet gridded1DSet2 = (Gridded1DSet)field.getDomainSet();
        float[] fArray3 = gridded1DSet2.getLow();
        float[] fArray4 = gridded1DSet2.getHi();
        int n6 = gridded1DSet2.getLength();
        this.wnum_low = fArray3[0];
        this.wnum_hi = fArray4[0];
        this.image_set = new Linear2DSet(-48.75, 48.75, 13, -0.5, (double)this.nlines - 0.5, this.nlines);
        this.image_line = new RealType("image_line");
        this.image_element = new RealType("image_element");
        this.image_domain = new RealTupleType(this.image_element, this.image_line);
        this.image_type = new FunctionType(this.image_domain, this.atmosphericRadiance);
        JFrame jFrame = new JFrame("Nasti VisAD Application");
        jFrame.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Nasti this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = nasti;
                this.constructor$0(nasti);
            }

            private final void constructor$0(Nasti nasti) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        ChannelImage channelImage = new ChannelImage();
        ChannelImage channelImage2 = new ChannelImage();
        jPanel.add(channelImage);
        jPanel.add(channelImage2);
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(800, 900);
        ((Component)jFrame).setVisible(true);
    }

    class ChannelImage
    extends JPanel
    implements ActionListener,
    ItemListener,
    ScalarMapListener {
        double[][] radiances;
        FlatField image;
        DataReferenceImpl image_ref;
        DataReferenceImpl white_cursor_ref;
        DataReferenceImpl red_cursor_ref;
        DataReferenceImpl spectrum_ref;
        DataReferenceImpl red_bar_ref;
        ScalarMap radiance_map2;
        ScalarMap wnum_map;
        JPanel wpanel;
        JLabel wnum_label;
        JTextField wnum_field;
        JPanel zpanel;
        JCheckBox wnum_zoom;
        JButton recenter;
        JPanel dpanel1;
        JPanel dpanel2;
        float wnum_last;
        boolean wzoom;
        boolean skip_red = false;

        void do_image(float f) throws VisADException, RemoteException {
            int n = 0;
            while (n < Nasti.this.ntimes) {
                double d;
                Field field = (Field)((Tuple)Nasti.this.nasti.getSample(n)).getComponent(Nasti.this.spectrum_index);
                try {
                    d = ((Real)field.evaluate(new Real(Nasti.this.wnum1, (double)f))).getValue();
                }
                catch (VisADException visADException) {
                    d = Double.NaN;
                }
                this.radiances[0][Nasti.this.time_to_sample[n]] = d;
                ++n;
            }
            this.image.setSamples(this.radiances);
        }

        synchronized void do_red_bar(float f) throws VisADException, RemoteException {
            double[] dArray = this.radiance_map2.getRange();
            if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                float[][] fArray = new float[][]{{(float)dArray[0], (float)dArray[1]}};
                Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)Nasti.this.atmosphericRadiance, fArray, 2);
                FlatField flatField = new FlatField(Nasti.this.red_bar_type, gridded1DSet);
                float[][] fArray2 = new float[][]{{f, f}};
                flatField.setSamples(fArray2);
                this.red_bar_ref.setData(flatField);
            }
        }

        synchronized void do_wzoom() throws VisADException, RemoteException {
            if (this.wzoom) {
                this.wnum_map.setRange((double)this.wnum_last - 10.0, (double)this.wnum_last + 10.0);
            } else {
                this.wnum_map.setRange(Nasti.this.wnum_low, Nasti.this.wnum_hi);
            }
        }

        public void mapChanged(ScalarMapEvent scalarMapEvent) {
            if (this.radiance_map2.equals(scalarMapEvent.getScalarMap())) {
                try {
                    this.do_red_bar(this.wnum_last);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("wavenum")) {
                float f = Float.NaN;
                try {
                    f = Float.valueOf(this.wnum_field.getText()).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                }
                if (f == f) {
                    if (f < Nasti.this.wnum_low) {
                        f = Nasti.this.wnum_low;
                        this.wnum_field.setText(PlotText.shortString(Math.abs(f)));
                    }
                    if (f > Nasti.this.wnum_hi) {
                        f = Nasti.this.wnum_hi;
                        this.wnum_field.setText(PlotText.shortString(Math.abs(f)));
                    }
                    try {
                        this.do_image(f);
                        this.wnum_last = f;
                        this.do_red_bar(f);
                        this.do_wzoom();
                        this.skip_red = true;
                        Real real = new Real(Nasti.this.wnum1, (double)this.wnum_last);
                        this.red_cursor_ref.setData(real);
                    }
                    catch (VisADException visADException) {
                        this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                    }
                    catch (RemoteException remoteException) {
                        this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                    }
                } else {
                    this.wnum_field.setText(PlotText.shortString(Math.abs(this.wnum_last)));
                }
            }
            if (string.equals("recenter")) {
                try {
                    this.do_wzoom();
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl;
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (itemSelectable == this.wnum_zoom) {
                try {
                    this.wzoom = bl;
                    this.do_wzoom();
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Nasti access$0(ChannelImage channelImage) {
            return channelImage.Nasti.this;
        }

        ChannelImage() throws VisADException, RemoteException {
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentY(0.0f);
            this.setAlignmentX(0.0f);
            this.white_cursor_ref = new DataReferenceImpl("white_cursor_ref");
            this.red_cursor_ref = new DataReferenceImpl("red_cursor_ref");
            this.spectrum_ref = new DataReferenceImpl("spectrum_ref");
            this.red_bar_ref = new DataReferenceImpl("red_bar_ref");
            this.wpanel = new JPanel();
            this.wpanel.setLayout(new BoxLayout(this.wpanel, 0));
            this.wnum_label = new JLabel("wave number:");
            this.wnum_field = new JTextField("---");
            Dimension dimension = this.wnum_field.getMaximumSize();
            Dimension dimension2 = this.wnum_field.getPreferredSize();
            dimension.height = dimension2.height;
            this.wnum_field.setMaximumSize(dimension);
            this.wnum_field.addActionListener(this);
            this.wnum_field.setActionCommand("wavenum");
            this.wnum_field.setEnabled(true);
            this.wpanel.add(this.wnum_label);
            this.wpanel.add(this.wnum_field);
            this.wpanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(this.wpanel);
            this.wnum_last = (Nasti.this.wnum_low + Nasti.this.wnum_hi) / 2.0f;
            this.wnum_field.setText(PlotText.shortString(this.wnum_last));
            RealTuple realTuple = new RealTuple(new Real[]{new Real(Nasti.this.image_element, 0.0), new Real(Nasti.this.image_line, 0.0)});
            this.white_cursor_ref.setData(realTuple);
            this.image = new FlatField(Nasti.this.image_type, Nasti.this.image_set);
            this.radiances = new double[1][Nasti.this.nelements * Nasti.this.nlines];
            int n = 0;
            while (n < Nasti.this.nelements * Nasti.this.nlines) {
                this.radiances[0][n] = Double.NaN;
                ++n;
            }
            this.image_ref = new DataReferenceImpl("image_ref");
            this.image_ref.setData(this.image);
            Real real = new Real(Nasti.this.wnum1, (double)this.wnum_last);
            this.red_cursor_ref.setData(real);
            this.do_image(this.wnum_last);
            DisplayImpl displayImpl = null;
            if (!Nasti.this.java2d) {
                try {
                    displayImpl = new DisplayImplJ3D("image display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    Nasti.this.java2d = true;
                }
            }
            if (Nasti.this.java2d) {
                displayImpl = new DisplayImplJ2D("image display");
            }
            ScalarMap scalarMap = new ScalarMap(Nasti.this.image_line, Display.YAxis);
            displayImpl.addMap(scalarMap);
            scalarMap.setRange(12.5, -0.5);
            ScalarMap scalarMap2 = new ScalarMap(Nasti.this.image_element, Display.XAxis);
            displayImpl.addMap(scalarMap2);
            scalarMap2.setRange(-48.75, 48.75);
            ScalarMap scalarMap3 = new ScalarMap(Nasti.this.atmosphericRadiance, Display.RGB);
            displayImpl.addMap(scalarMap3);
            displayImpl.setAlwaysAutoScale(true);
            GraphicsModeControl graphicsModeControl = displayImpl.getGraphicsModeControl();
            displayImpl.addReference(this.image_ref);
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(4.0, Display.PointSize)};
            if (Nasti.this.java2d) {
                displayImpl.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), this.white_cursor_ref, constantMapArray);
            } else {
                displayImpl.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.white_cursor_ref, constantMapArray);
            }
            this.dpanel1 = new JPanel();
            this.dpanel1.setLayout(new BoxLayout(this.dpanel1, 0));
            this.dpanel1.add(displayImpl.getComponent());
            this.dpanel1.add(Box.createHorizontalStrut(0));
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.dpanel1.setBorder(compoundBorder);
            this.add(this.dpanel1);
            LabeledColorWidget labeledColorWidget = new LabeledColorWidget(scalarMap3);
            Dimension dimension3 = new Dimension(400, 200);
            labeledColorWidget.setMaximumSize(dimension3);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(labeledColorWidget);
            jPanel.setBorder(compoundBorder);
            this.add(jPanel);
            this.zpanel = new JPanel();
            this.zpanel.setLayout(new BoxLayout(this.zpanel, 0));
            this.wnum_zoom = new JCheckBox("wave number zoom", false);
            this.wnum_zoom.addItemListener(this);
            this.recenter = new JButton("Recenter");
            this.recenter.addActionListener(this);
            this.recenter.setActionCommand("recenter");
            this.zpanel.add(this.wnum_zoom);
            this.zpanel.add(this.recenter);
            this.add(this.zpanel);
            DisplayImpl displayImpl2 = null;
            displayImpl2 = Nasti.this.java2d ? new DisplayImplJ2D("spectrum display") : new DisplayImplJ3D("spectrum display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
            this.wnum_map = new ScalarMap(Nasti.this.wnum1, Display.XAxis);
            displayImpl2.addMap(this.wnum_map);
            this.radiance_map2 = new ScalarMap(Nasti.this.atmosphericRadiance, Display.YAxis);
            displayImpl2.addMap(this.radiance_map2);
            this.radiance_map2.addScalarMapListener(this);
            displayImpl.setAlwaysAutoScale(true);
            GraphicsModeControl graphicsModeControl2 = displayImpl2.getGraphicsModeControl();
            graphicsModeControl2.setScaleEnable(true);
            displayImpl2.addReference(this.spectrum_ref);
            ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green)};
            displayImpl2.addReference(this.red_bar_ref, constantMapArray2);
            ConstantMap[] constantMapArray3 = new ConstantMap[]{new ConstantMap(-1.0, Display.YAxis), new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(4.0, Display.PointSize)};
            if (Nasti.this.java2d) {
                displayImpl2.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), this.red_cursor_ref, constantMapArray3);
            } else {
                displayImpl2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.red_cursor_ref, constantMapArray3);
            }
            this.dpanel2 = new JPanel();
            this.dpanel2.setLayout(new BoxLayout(this.dpanel2, 0));
            this.dpanel2.add(displayImpl2.getComponent());
            this.dpanel2.add(Box.createHorizontalStrut(0));
            this.dpanel2.setBorder(compoundBorder);
            this.add(this.dpanel2);
            CellImpl cellImpl = new CellImpl(this){
                private final /* synthetic */ ChannelImage this$0;
                private final /* synthetic */ Nasti this$1;

                public void doAction() throws VisADException, RemoteException {
                    this.this$0.red_bar_ref.setData(null);
                    RealTuple realTuple = (RealTuple)this.this$0.white_cursor_ref.getData();
                    float f = (float)((Real)realTuple.getComponent(0)).getValue();
                    int n = (int)Math.round(((double)f + 45.0) / 7.5);
                    int n2 = (int)Math.round(((Real)realTuple.getComponent(1)).getValue());
                    int n3 = n2 >= 0 && n2 < this.this$1.nlines && n >= 0 && n < this.this$1.nelements ? this.this$1.sample_to_time[n2][n] : -1;
                    if (n3 >= 0) {
                        Field field = (Field)((Tuple)this.this$1.nasti.getSample(n3)).getComponent(this.this$1.spectrum_index);
                        this.this$0.spectrum_ref.setData(field);
                    } else {
                        this.this$0.spectrum_ref.setData(null);
                    }
                }
                {
                    this.this$0 = channelImage;
                    this.this$1 = ChannelImage.access$0(this.this$0);
                    this.constructor$0(channelImage);
                }

                private final void constructor$0(ChannelImage channelImage) {
                }
            };
            cellImpl.addReference(this.white_cursor_ref);
            CellImpl cellImpl2 = new CellImpl(this){
                private final /* synthetic */ ChannelImage this$0;
                private final /* synthetic */ Nasti this$1;

                public void doAction() throws VisADException, RemoteException {
                    if (this.this$0.skip_red) {
                        this.this$0.skip_red = false;
                        return;
                    }
                    Real real = (Real)this.this$0.red_cursor_ref.getData();
                    if (real == null) {
                        return;
                    }
                    float f = (float)real.getValue();
                    if (f < this.this$1.wnum_low) {
                        f = this.this$1.wnum_low;
                    }
                    if (f > this.this$1.wnum_hi) {
                        f = this.this$1.wnum_hi;
                    }
                    try {
                        this.this$0.do_image(f);
                        this.this$0.wnum_last = f;
                        this.this$0.do_red_bar(f);
                        this.this$0.wnum_field.setText(PlotText.shortString(Math.abs(f)));
                    }
                    catch (VisADException visADException) {
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                {
                    this.this$0 = channelImage;
                    this.this$1 = ChannelImage.access$0(this.this$0);
                    this.constructor$0(channelImage);
                }

                private final void constructor$0(ChannelImage channelImage) {
                }
            };
            cellImpl2.addReference(this.red_cursor_ref);
        }
    }
}

