/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.Delay;
import visad.util.VisADSlider;

public class GoesCollaboration {
    public static int WIDTH = 1200;
    public static int HEIGHT = 1000;
    RemoteServerImpl server_server;
    RemoteServer client_server;
    RealType nchan;
    RealType indx;
    RealType nl;
    RealType tbc;
    RealType tbc_d;
    RealType wfn;
    RealType pres;
    RealType temp;
    RealType mixr;
    RealType ozone;
    RealType pressure;
    RealType data_real;
    RealType diff;
    DataReference wfna_ref;
    DataReference tempa_ref;
    DataReference mixra_ref;
    DataReference ozonea_ref;
    DataReference presa_ref;
    DataReference diff_col_ref;
    DataReference diff_ref;
    DataReference zero_line_ref;
    DataReference smr_ref;
    DataReference real_tbc_ref;
    DataReference wfnb_ref;
    DataReference wfna_old_ref;
    DataReference gzen_ref;
    DataReference tskin_ref;
    DataReference in_dx_ref;

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        GoesCollaboration goesCollaboration = new GoesCollaboration(stringArray);
        if (goesCollaboration.client_server != null) {
            goesCollaboration.setupClient();
        } else if (goesCollaboration.server_server != null) {
            System.loadLibrary("GoesCollaboration");
            goesCollaboration.setupServer();
        } else {
            System.loadLibrary("GoesCollaboration");
            goesCollaboration.setupServer();
        }
    }

    void setupServer() throws VisADException, RemoteException {
        Linear1DSet linear1DSet = new Linear1DSet(1.0, 18.0, 18);
        Linear1DSet linear1DSet2 = new Linear1DSet(1.0, 19.0, 19);
        Linear1DSet linear1DSet3 = new Linear1DSet(1.0, 40.0, 40);
        Linear2DSet linear2DSet = new Linear2DSet(1.0, 40.0, 40, 1.0, 18.0, 18);
        this.nchan = new RealType("nchan", null, linear1DSet);
        this.indx = new RealType("indx", null, linear1DSet2);
        this.nl = new RealType("nl", null, linear1DSet3);
        this.tbc = new RealType("tbc", null, null);
        this.tbc_d = new RealType("tbc_d", null, null);
        this.wfn = new RealType("wfn", null, null);
        this.pres = new RealType("pres", null, null);
        this.temp = new RealType("temp", null, null);
        this.mixr = new RealType("mixr", null, null);
        this.ozone = new RealType("ozone", null, null);
        this.pressure = new RealType("pressure", null, null);
        this.data_real = new RealType("data_real", null, null);
        this.diff = new RealType("diff", null, null);
        RealTupleType realTupleType = new RealTupleType(this.nl, this.nchan, null, linear2DSet);
        FunctionType functionType = new FunctionType(this.indx, this.data_real);
        FunctionType functionType2 = new FunctionType(realTupleType, new RealTupleType(this.wfn, this.tbc));
        FunctionType functionType3 = new FunctionType(this.nchan, this.tbc_d);
        FunctionType functionType4 = new FunctionType(realTupleType, this.wfn);
        FunctionType functionType5 = new FunctionType(this.nl, this.temp);
        FunctionType functionType6 = new FunctionType(this.nl, this.mixr);
        FunctionType functionType7 = new FunctionType(this.nl, this.ozone);
        FunctionType functionType8 = new FunctionType(this.nl, this.pressure);
        FlatField flatField = new FlatField(functionType4);
        this.wfna_ref = new DataReferenceImpl("wfna");
        this.wfna_ref.setData(flatField);
        FlatField flatField2 = new FlatField(functionType5);
        this.tempa_ref = new DataReferenceImpl("tempa");
        this.tempa_ref.setData(flatField2);
        FlatField flatField3 = new FlatField(functionType6);
        this.mixra_ref = new DataReferenceImpl("mixra");
        this.mixra_ref.setData(flatField3);
        FlatField flatField4 = new FlatField(functionType7);
        this.ozonea_ref = new DataReferenceImpl("ozonea");
        this.ozonea_ref.setData(flatField4);
        FlatField flatField5 = new FlatField(functionType8);
        this.presa_ref = new DataReferenceImpl("presa");
        this.presa_ref.setData(flatField5);
        FlatField flatField6 = new FlatField(functionType4);
        this.diff_col_ref = new DataReferenceImpl("diff_col");
        this.diff_col_ref.setData(flatField6);
        FlatField flatField7 = new FlatField(functionType3);
        this.diff_ref = new DataReferenceImpl("diff");
        this.diff_ref.setData(flatField7);
        FlatField flatField8 = new FlatField(functionType3);
        this.zero_line_ref = new DataReferenceImpl("zero_line");
        this.zero_line_ref.setData(flatField8);
        Real real = new Real(this.tbc_d);
        this.smr_ref = new DataReferenceImpl("smr");
        this.smr_ref.setData(real);
        FlatField flatField9 = new FlatField(functionType);
        this.real_tbc_ref = new DataReferenceImpl("real_tbc");
        this.real_tbc_ref.setData(flatField9);
        FlatField flatField10 = new FlatField(functionType2);
        this.wfnb_ref = new DataReferenceImpl("wfnb");
        this.wfnb_ref.setData(flatField10);
        FlatField flatField11 = new FlatField(functionType4);
        this.wfna_old_ref = new DataReferenceImpl("wfna_old");
        this.wfna_old_ref.setData(flatField);
        this.gzen_ref = new DataReferenceImpl("gzen");
        this.tskin_ref = new DataReferenceImpl("tskin");
        this.in_dx_ref = new DataReferenceImpl("in_dx");
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("save_config");
        DisplayImpl[] displayImplArray = new DisplayImpl[4];
        this.setupDisplays(displayImplArray);
        if (this.server_server != null) {
            int n = 0;
            while (n < displayImplArray.length) {
                this.server_server.addDisplay(new RemoteDisplayImpl(displayImplArray[n]));
                ++n;
            }
        }
        this.setupUI(displayImplArray, this.in_dx_ref, dataReferenceImpl, this.gzen_ref, this.tskin_ref);
        double[][] dArray = flatField8.getValues();
        int n = 0;
        while (n < dArray[0].length) {
            dArray[0][n] = 0.0;
            ++n;
        }
        flatField8.setSamples(dArray);
        new Delay(1000);
        this.gzen_ref.incTick();
        dataReferenceImpl.incTick();
        new Delay(1000);
        real_tbcCell real_tbcCell2 = new real_tbcCell();
        real_tbcCell2.addReference(this.in_dx_ref);
        new Delay(500);
        wfnbCell wfnbCell2 = new wfnbCell();
        wfnbCell2.addReference(this.gzen_ref);
        wfnbCell2.addReference(this.tskin_ref);
        wfnbCell2.addReference(this.tempa_ref);
        wfnbCell2.addReference(this.mixra_ref);
        wfnbCell2.addReference(this.ozonea_ref);
        wfnbCell2.addReference(this.presa_ref);
        new Delay(500);
        wfnaCell wfnaCell2 = new wfnaCell();
        wfnaCell2.addReference(this.wfnb_ref);
        wfnaCell2.addReference(this.real_tbc_ref);
        new Delay(500);
        wfna_oldCell wfna_oldCell2 = new wfna_oldCell();
        wfna_oldCell2.addReference(dataReferenceImpl);
        new Delay(500);
        diff_colCell diff_colCell2 = new diff_colCell();
        diff_colCell2.addReference(this.wfna_ref);
        diff_colCell2.addReference(this.wfna_old_ref);
        new Delay(500);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.gzen_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.tskin_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.in_dx_ref), new RemoteDataReferenceImpl(dataReferenceImpl)};
            this.server_server.setDataReferences(remoteDataReferenceImplArray);
        }
        new Delay(1000);
        this.gzen_ref.incTick();
        dataReferenceImpl.incTick();
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] remoteDataReferenceArray = this.client_server.getDataReferences();
        if (remoteDataReferenceArray == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.gzen_ref = remoteDataReferenceArray[0];
        this.tskin_ref = remoteDataReferenceArray[1];
        this.in_dx_ref = remoteDataReferenceArray[2];
        RemoteDataReference remoteDataReference = remoteDataReferenceArray[3];
        DisplayImpl[] displayImplArray = new DisplayImpl[]{new DisplayImplJ3D(this.client_server.getDisplay("display1")), new DisplayImplJ3D(this.client_server.getDisplay("display2")), new DisplayImplJ3D(this.client_server.getDisplay("display3")), new DisplayImplJ3D(this.client_server.getDisplay("display4"))};
        this.setupUI(displayImplArray, this.in_dx_ref, remoteDataReference, this.gzen_ref, this.tskin_ref);
    }

    void setupDisplays(DisplayImpl[] displayImplArray) throws VisADException, RemoteException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1");
        ScalarMap scalarMap = new ScalarMap(this.nl, Display.YAxis);
        scalarMap.setRange(40.0, 1.0);
        displayImplJ3D.addMap(scalarMap);
        displayImplJ3D.addMap(new ScalarMap(this.nchan, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(this.wfn, Display.Green));
        displayImplJ3D.addMap(new ScalarMap(this.wfn, Display.ZAxis));
        displayImplJ3D.addMap(new ConstantMap(0.5, Display.Red));
        displayImplJ3D.addMap(new ConstantMap(0.5, Display.Blue));
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        displayImplJ3D.addReference(this.wfna_ref);
        DisplayImplJ3D displayImplJ3D2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap scalarMap2 = new ScalarMap(this.nl, Display.YAxis);
        scalarMap2.setRange(40.0, 1.0);
        displayImplJ3D2.addMap(scalarMap2);
        ScalarMap scalarMap3 = new ScalarMap(this.temp, Display.XAxis);
        displayImplJ3D2.addMap(scalarMap3);
        scalarMap3.setScaleColor(new float[]{1.0f, 0.0f, 0.0f});
        ScalarMap scalarMap4 = new ScalarMap(this.mixr, Display.XAxis);
        displayImplJ3D2.addMap(scalarMap4);
        scalarMap4.setScaleColor(new float[]{0.0f, 1.0f, 0.0f});
        ScalarMap scalarMap5 = new ScalarMap(this.ozone, Display.XAxis);
        displayImplJ3D2.addMap(scalarMap5);
        scalarMap5.setScaleColor(new float[]{0.0f, 0.0f, 1.0f});
        displayImplJ3D2.addMap(new ScalarMap(this.pressure, Display.XAxis));
        GraphicsModeControl graphicsModeControl2 = displayImplJ3D2.getGraphicsModeControl();
        graphicsModeControl2.setLineWidth(2.0f);
        graphicsModeControl2.setScaleEnable(true);
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] constantMapArray3 = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
        ConstantMap[] constantMapArray4 = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
        displayImplJ3D2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.tempa_ref, constantMapArray);
        displayImplJ3D2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.mixra_ref, constantMapArray2);
        displayImplJ3D2.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.ozonea_ref, constantMapArray3);
        displayImplJ3D2.addReference(this.presa_ref, constantMapArray4);
        DisplayImplJ3D displayImplJ3D3 = new DisplayImplJ3D("display3");
        ScalarMap scalarMap6 = new ScalarMap(this.nl, Display.YAxis);
        scalarMap6.setRange(40.0, 1.0);
        displayImplJ3D3.addMap(scalarMap6);
        displayImplJ3D3.addMap(new ScalarMap(this.nchan, Display.XAxis));
        displayImplJ3D3.addMap(new ScalarMap(this.wfn, Display.ZAxis));
        displayImplJ3D3.addMap(new ScalarMap(this.wfn, Display.Green));
        displayImplJ3D3.addMap(new ConstantMap(0.5, Display.Red));
        displayImplJ3D3.addMap(new ConstantMap(0.5, Display.Blue));
        GraphicsModeControl graphicsModeControl3 = displayImplJ3D3.getGraphicsModeControl();
        graphicsModeControl3.setScaleEnable(true);
        displayImplJ3D3.addReference(this.diff_col_ref);
        DisplayImplJ3D displayImplJ3D4 = new DisplayImplJ3D("display4", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        displayImplJ3D4.addMap(new ScalarMap(this.nchan, Display.XAxis));
        ScalarMap scalarMap7 = new ScalarMap(this.tbc_d, Display.YAxis);
        scalarMap7.setRange(-40.0, 40.0);
        displayImplJ3D4.addMap(scalarMap7);
        GraphicsModeControl graphicsModeControl4 = displayImplJ3D4.getGraphicsModeControl();
        graphicsModeControl4.setPointSize(5.0f);
        graphicsModeControl4.setLineWidth(2.0f);
        graphicsModeControl4.setScaleEnable(true);
        displayImplJ3D4.addReference(this.diff_ref);
        displayImplJ3D4.addReference(this.zero_line_ref);
        displayImplJ3D4.addReference(this.smr_ref);
        displayImplArray[0] = displayImplJ3D;
        displayImplArray[1] = displayImplJ3D2;
        displayImplArray[2] = displayImplJ3D3;
        displayImplArray[3] = displayImplJ3D4;
    }

    void setupUI(DisplayImpl[] displayImplArray, DataReference dataReference, DataReference dataReference2, DataReference dataReference3, DataReference dataReference4) throws VisADException, RemoteException {
        JFrame jFrame = new JFrame("GoesCollaboration");
        WindowAdapter windowAdapter = new WindowAdapter(this){
            private final /* synthetic */ GoesCollaboration this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = goesCollaboration;
                this.constructor$0(goesCollaboration);
            }

            private final void constructor$0(GoesCollaboration goesCollaboration) {
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ((Component)jFrame).setSize(WIDTH, HEIGHT);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - WIDTH / 2, dimension.height / 2 - HEIGHT / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2.add(new JLabel("Interactive GOES satellite sounding retrieval"));
        jPanel2.add(new JLabel("using VisAD  -  see:"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("for more information about VisAD."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Bill Hibbard, Paolo Antonelli and Bob Aune"));
        jPanel2.add(new JLabel("Space Science and Engineering Center"));
        jPanel2.add(new JLabel("University of Wisconsin - Madison"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Move index slider to retrieve a new model"));
        jPanel2.add(new JLabel("atmosphere."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Touch ref. conf. slider to save a new"));
        jPanel2.add(new JLabel("reference for weighting function difference."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Move zenith angle and skin T sliders to"));
        jPanel2.add(new JLabel("to modify atmosphere conditions."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Rotate scenes with left mouse button."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Redraw temperature, water vapor and ozone with"));
        jPanel2.add(new JLabel("right mouse button to modify model atmosphere."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("GoesCollaboration Sliders");
        jPanel3.setFont(new Font("Dialog", 0, 12));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel3.add(new VisADSlider("index", 1, 2234, 1, 1.0, dataReference, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("save as ref. conf.?", 0, 1000, 0, 1.0, dataReference2, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("zenith angle (deg)", 0, 65, 35, 1.0, dataReference3, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("skin T (K)", 250, 340, 300, 1.0, dataReference4, RealType.Generic));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setAlignmentY(0.0f);
        jPanel5.setAlignmentX(0.0f);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentY(0.0f);
        jPanel6.setAlignmentX(0.0f);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = (JPanel)displayImplArray[0].getComponent();
        JPanel jPanel8 = (JPanel)displayImplArray[1].getComponent();
        JPanel jPanel9 = (JPanel)displayImplArray[2].getComponent();
        JPanel jPanel10 = (JPanel)displayImplArray[3].getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        jPanel7.setBorder(compoundBorder);
        jPanel8.setBorder(compoundBorder);
        jPanel9.setBorder(compoundBorder);
        jPanel10.setBorder(compoundBorder);
        JLabel jLabel = new JLabel("weighting function");
        JLabel jLabel2 = new JLabel("vertical level (Y) vs channel (X)");
        JLabel jLabel3 = new JLabel("model atmosphere profile");
        JLabel jLabel4 = new JLabel("temperature (red), ozone (blue),");
        JLabel jLabel5 = new JLabel("water vapor (green), pressure (white)");
        JLabel jLabel6 = new JLabel("weighting function difference");
        JLabel jLabel7 = new JLabel("vertical level (Y) vs channel (X)");
        JLabel jLabel8 = new JLabel("brightness temperature errors");
        JLabel jLabel9 = new JLabel("with zero reference line and");
        JLabel jLabel10 = new JLabel("root mean square error (single point)");
        jPanel5.add(jPanel7);
        jPanel5.add(jLabel);
        jPanel5.add(jLabel2);
        jPanel5.add(jPanel8);
        jPanel5.add(jLabel3);
        jPanel5.add(jLabel4);
        jPanel5.add(jLabel5);
        jPanel6.add(jPanel9);
        jPanel6.add(jLabel6);
        jPanel6.add(jLabel7);
        jPanel6.add(jPanel10);
        jPanel6.add(jLabel8);
        jPanel6.add(jLabel9);
        jPanel6.add(jLabel10);
        ((Component)jFrame).setVisible(true);
    }

    private native void re_read_1_c(int var1, float[] var2);

    private native void goesrte_2_c(float var1, float var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8);

    private native void get_profil_c(float var1, int var2, float[] var3, float[] var4, float[] var5, float[] var6);

    public GoesCollaboration(String[] stringArray) throws VisADException, RemoteException {
        if (stringArray.length > 0) {
            String string = "//" + stringArray[0] + "/GoesCollaboration";
            try {
                this.client_server = (RemoteServer)Naming.lookup(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException notBoundException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException accessException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            File file = new File("data_obs_1.dat");
            File file2 = new File("goesrtcf");
            if (!file.exists() || !file2.exists()) {
                System.out.println("This program requires the data files \"data_obs_1.dat\"");
                System.out.println("and \"goesrtcf\", available at:");
                System.out.println("   ftp://www.ssec.wisc.edu/pub/visad-2.0/paoloa-files.tar.Z");
                System.exit(1);
            }
            if (!file2.exists()) {
                System.out.println("");
                System.exit(2);
            }
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///GoesCollaboration", this.server_server);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException accessException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    class real_tbcCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            int n = (int)((Real)GoesCollaboration.this.in_dx_ref.getData()).getValue();
            if (n < 1 || n > 2234) {
                return;
            }
            float[][] fArray = new float[1][19];
            GoesCollaboration.this.re_read_1_c(n, fArray[0]);
            ((FlatField)GoesCollaboration.this.real_tbc_ref.getData()).setSamples(fArray);
            float f = fArray[0][18];
            int n2 = 6;
            float[][] fArray2 = new float[1][40];
            float[][] fArray3 = new float[1][40];
            float[][] fArray4 = new float[1][40];
            float[][] fArray5 = new float[1][40];
            GoesCollaboration.this.get_profil_c(f, n2, fArray2[0], fArray3[0], fArray4[0], fArray5[0]);
            ((FlatField)GoesCollaboration.this.tempa_ref.getData()).setSamples(fArray2);
            ((FlatField)GoesCollaboration.this.mixra_ref.getData()).setSamples(fArray3);
            ((FlatField)GoesCollaboration.this.ozonea_ref.getData()).setSamples(fArray4);
            ((FlatField)GoesCollaboration.this.presa_ref.getData()).setSamples(fArray5);
        }

        real_tbcCell() {
        }
    }

    class wfnbCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            float f = (float)((Real)GoesCollaboration.this.gzen_ref.getData()).getValue();
            float f2 = (float)((Real)GoesCollaboration.this.tskin_ref.getData()).getValue();
            float[][] fArray = Set.doubleToFloat(((FlatField)GoesCollaboration.this.tempa_ref.getData()).getValues());
            float[][] fArray2 = Set.doubleToFloat(((FlatField)GoesCollaboration.this.mixra_ref.getData()).getValues());
            float[][] fArray3 = Set.doubleToFloat(((FlatField)GoesCollaboration.this.ozonea_ref.getData()).getValues());
            float[][] fArray4 = Set.doubleToFloat(((FlatField)GoesCollaboration.this.presa_ref.getData()).getValues());
            float[][] fArray5 = new float[2][720];
            GoesCollaboration.this.goesrte_2_c(f, f2, fArray[0], fArray2[0], fArray3[0], fArray4[0], fArray5[0], fArray5[1]);
            ((FlatField)GoesCollaboration.this.wfnb_ref.getData()).setSamples(fArray5);
        }

        wfnbCell() {
        }
    }

    class wfnaCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            float[][] fArray = new float[1][];
            float[][] fArray2 = Set.doubleToFloat(((FlatField)GoesCollaboration.this.wfnb_ref.getData()).getValues());
            fArray[0] = fArray2[0];
            ((FlatField)GoesCollaboration.this.wfna_ref.getData()).setSamples(fArray);
            float[][] fArray3 = Set.doubleToFloat(((FlatField)GoesCollaboration.this.real_tbc_ref.getData()).getValues());
            float[][] fArray4 = new float[1][18];
            float f = 0.0f;
            int n = 0;
            while (n < 18) {
                fArray4[0][n] = fArray2[1][40 * n] - fArray3[0][n];
                f += fArray4[0][n] * fArray4[0][n] / 18.0f;
                ++n;
            }
            ((FlatField)GoesCollaboration.this.diff_ref.getData()).setSamples(fArray4);
            GoesCollaboration.this.smr_ref.setData(new Real(GoesCollaboration.this.tbc_d, Math.sqrt(f)));
        }

        wfnaCell() {
        }
    }

    class wfna_oldCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            GoesCollaboration.this.wfna_old_ref.setData((FlatField)((FlatField)GoesCollaboration.this.wfna_ref.getData()).clone());
        }

        wfna_oldCell() {
        }
    }

    class diff_colCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            GoesCollaboration.this.diff_col_ref.setData(GoesCollaboration.this.wfna_ref.getData().subtract(GoesCollaboration.this.wfna_old_ref.getData()));
        }

        diff_colCell() {
        }
    }
}

