/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import visad.Data;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;
import visad.meteorology.SingleBandedImage;

public class SingleBandedImageImpl
extends FlatField
implements SingleBandedImage {
    private DateTime startTime;
    private String description;
    private Real minValue;
    private Real maxValue;

    public DateTime getStartTime() {
        return this.startTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Real getMinRangeValue() {
        return this.minValue;
    }

    public Real getMaxRangeValue() {
        return this.maxValue;
    }

    public boolean isNavigated() {
        return this.getDomainCoordinateSystem() instanceof NavigatedCoordinateSystem;
    }

    public void setSamples(float[][] fArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException, RemoteException {
        super.setSamples(fArray, errorEstimateArray, bl);
        this.setMaxMinValues();
    }

    public void setSamples(double[][] dArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException, RemoteException {
        super.setSamples(dArray, errorEstimateArray, bl);
        this.setMaxMinValues();
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException {
        return new SingleBandedImageImpl((FlatField)super.unary(n, mathType, n2, n3), this.startTime, this.description);
    }

    public Object clone() {
        SingleBandedImageImpl singleBandedImageImpl;
        try {
            singleBandedImageImpl = new SingleBandedImageImpl((FlatField)super.clone(), this.startTime, this.description);
        }
        catch (VisADException visADException) {
            throw new VisADError("SingleBandedImageImpl.clone(): VisADException occurred");
        }
        return singleBandedImageImpl;
    }

    private void setMaxMinValues() throws VisADException {
        Unit unit = null;
        RealType realType = RealType.Generic;
        ErrorEstimate errorEstimate = null;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        try {
            Set set = this.getRangeSets()[0];
            unit = this.getRangeUnits()[0][0];
            realType = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
            errorEstimate = this.getRangeErrors()[0];
            if (set instanceof SampledSet) {
                d = ((SampledSet)set).getLow()[0];
                d2 = ((SampledSet)set).getHi()[0];
            } else {
                double[] dArray = this.getValues(0);
                int n = 0;
                while (n < dArray.length) {
                    if (dArray[n] != Double.NaN) {
                        if (d == Double.MIN_VALUE) {
                            d = dArray[n];
                            d2 = dArray[n];
                        } else {
                            if (dArray[n] < d) {
                                d = dArray[n];
                            }
                            if (dArray[n] > d2) {
                                d2 = dArray[n];
                            }
                        }
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.minValue = new Real(realType, d, unit, errorEstimate);
        this.maxValue = new Real(realType, d2, unit, errorEstimate);
    }

    public SingleBandedImageImpl(FunctionType functionType, Set set, DateTime dateTime, String string) throws VisADException {
        this(new FlatField(functionType, set), dateTime, string);
    }

    public SingleBandedImageImpl(FlatField flatField, DateTime dateTime, String string) throws VisADException {
        super((FunctionType)flatField.getType(), flatField.getDomainSet());
        if (((FunctionType)this.getType()).getFlatRange().getNumberOfRealComponents() > 1) {
            throw new VisADException("SingleBandedImageImpl: Range must be a RealType or RealTupleType with one component");
        }
        try {
            if (!flatField.isMissing()) {
                this.setSamples(flatField.getValues());
                this.setRangeErrors(flatField.getRangeErrors());
                this.setMaxMinValues();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.startTime = dateTime;
        this.description = string;
    }
}

