/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;
import visad.georef.NavigatedField;
import visad.georef.TrivialNavigation;
import visad.meteorology.SingleBandedImageImpl;

public class NavigatedImage
extends SingleBandedImageImpl
implements NavigatedField {
    private NavigatedCoordinateSystem navigation;

    public NavigatedCoordinateSystem getNavigation() {
        return this.navigation;
    }

    private void vetDomain() throws VisADException {
        CoordinateSystem coordinateSystem = this.getDomainCoordinateSystem();
        if (coordinateSystem != null && !(coordinateSystem instanceof NavigatedCoordinateSystem)) {
            throw new VisADException("NavigatedImage: Domain CoordinateSystem must be a NavigatedCoordinateSystem");
        }
        if (coordinateSystem == null) {
            if (this.getDomainSet().getDimension() < 2 || !this.hasLatLon((RealTupleType)this.getDomainSet().getType())) {
                throw new VisADException("NavigatedImage: Domain set must have a Lat/Lon reference");
            }
            coordinateSystem = new TrivialNavigation(((FunctionType)this.getType()).getDomain());
        }
        this.navigation = (NavigatedCoordinateSystem)coordinateSystem;
    }

    private boolean hasLatLon(RealTupleType realTupleType) {
        return realTupleType.getIndex(RealType.Latitude) > -1 && realTupleType.getIndex(RealType.Longitude) > -1;
    }

    public boolean isNavigated() {
        return true;
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException {
        return new NavigatedImage((FlatField)super.unary(n, mathType, n2, n3), this.getStartTime(), this.getDescription());
    }

    public NavigatedImage(FunctionType functionType, Set set, DateTime dateTime, String string) throws VisADException {
        this(new FlatField(functionType, set), dateTime, string);
    }

    public NavigatedImage(FlatField flatField, DateTime dateTime, String string) throws VisADException {
        super(flatField, dateTime, string);
        this.vetDomain();
    }
}

