/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.TreeMap;
import visad.DateTime;
import visad.FunctionType;
import visad.RealType;
import visad.VisADException;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceImpl;
import visad.meteorology.SingleBandedImage;

public class ImageSequenceManager {
    private ImageSequence sequence = null;
    private TreeMap imageMap = new TreeMap();

    public static ImageSequence createImageSequence(SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        return new ImageSequenceImpl(singleBandedImageArray);
    }

    public ImageSequence addImageToSequence(SingleBandedImage singleBandedImage) throws VisADException, RemoteException {
        return this.addImagesToSequence(new SingleBandedImage[]{singleBandedImage});
    }

    public ImageSequence addImagesToSequence(SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        int n = 0;
        while (n < singleBandedImageArray.length) {
            this.imageMap.put(singleBandedImageArray[n].getStartTime(), singleBandedImageArray[n]);
            ++n;
        }
        this.makeNewSequence();
        return this.sequence;
    }

    public ImageSequence removeImageAtTime(DateTime dateTime) throws VisADException {
        if (dateTime == null) {
            throw new VisADException("Time can't be null");
        }
        try {
            this.imageMap.remove(dateTime);
            this.makeNewSequence();
        }
        catch (Exception exception) {
            throw new VisADException("Unable to remove image at " + dateTime + " from sequence");
        }
        return this.sequence;
    }

    public void clearSequence() {
        this.imageMap.clear();
        this.sequence = null;
    }

    public void setImageSequence(ImageSequence imageSequence) throws VisADException, RemoteException {
        if (imageSequence == null) {
            throw new VisADException("New sequence can't be null");
        }
        this.clearSequence();
        int n = imageSequence.getDomainSet().getLength();
        int n2 = 0;
        while (n2 < n) {
            SingleBandedImage singleBandedImage = (SingleBandedImage)imageSequence.getSample(n2);
            this.imageMap.put(singleBandedImage.getStartTime(), singleBandedImage);
            ++n2;
        }
        this.sequence = imageSequence;
    }

    public ImageSequence getImageSequence() {
        return this.sequence;
    }

    private void makeNewSequence() throws VisADException, RemoteException {
        if (this.imageMap.isEmpty()) {
            this.sequence = null;
        } else {
            Collection collection = this.imageMap.values();
            SingleBandedImage[] singleBandedImageArray = collection.toArray(new SingleBandedImage[collection.size()]);
            FunctionType functionType = (FunctionType)singleBandedImageArray[0].getType();
            FunctionType functionType2 = new FunctionType(RealType.Time, functionType);
            this.sequence = new ImageSequenceImpl(functionType2, singleBandedImageArray);
        }
    }

    public ImageSequenceManager() throws VisADException, RemoteException {
        this(new SingleBandedImage[0]);
    }

    public ImageSequenceManager(SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        int n = 0;
        while (n < singleBandedImageArray.length) {
            this.imageMap.put(singleBandedImageArray[n].getStartTime(), singleBandedImageArray[n]);
            ++n;
        }
        this.makeNewSequence();
    }
}

