/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import java.rmi.RemoteException;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.SampledSet;
import visad.SingletonSet;
import visad.VisADException;
import visad.meteorology.ImageSequence;
import visad.meteorology.SingleBandedImage;
import visad.util.DataUtility;

public class ImageSequenceImpl
extends FieldImpl
implements ImageSequence {
    private static SampledSet makeDomainSet(SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        if (singleBandedImageArray == null) {
            throw new VisADException("images can't be null");
        }
        DateTime[] dateTimeArray = new DateTime[singleBandedImageArray.length];
        int n = 0;
        while (n < singleBandedImageArray.length) {
            dateTimeArray[n] = singleBandedImageArray[n].getStartTime();
            ++n;
        }
        return dateTimeArray.length > 1 ? DateTime.makeTimeSet(dateTimeArray) : new SingletonSet(new RealTuple(new Real[]{dateTimeArray[0]}));
    }

    public DateTime[] getImageTimes() throws VisADException {
        DateTime[] dateTimeArray = null;
        dateTimeArray = this.getDomainSet().getLength() > 1 ? DateTime.timeSetToArray((Gridded1DDoubleSet)this.getDomainSet()) : new DateTime[]{new DateTime(((SingletonSet)this.getDomainSet()).getDoubles()[0][0])};
        return dateTimeArray == null ? new DateTime[]{} : dateTimeArray;
    }

    public int getImageCount() throws VisADException {
        return ((SampledSet)this.getDomainSet()).getLength();
    }

    public SingleBandedImage getImage(DateTime dateTime) throws VisADException, RemoteException {
        return (SingleBandedImage)this.evaluate(dateTime);
    }

    public SingleBandedImage getImage(int n) throws VisADException, RemoteException {
        return (SingleBandedImage)this.getSample(n);
    }

    private static FunctionType ensureFunctionType(FunctionType functionType) throws VisADException {
        if (functionType.getDomain().equals(DataUtility.ensureRealTupleType(RealType.Time)) && functionType.getRange() instanceof FunctionType && ((FunctionType)functionType.getRange()).getFlatRange().getDimension() == 1) {
            return functionType;
        }
        throw new VisADException("Not a valid ImageSequence type: " + functionType);
    }

    public ImageSequenceImpl(FunctionType functionType, SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        super(ImageSequenceImpl.ensureFunctionType(functionType), ImageSequenceImpl.makeDomainSet(singleBandedImageArray));
        FunctionType functionType2 = (FunctionType)functionType.getRange();
        int n = 0;
        while (n < singleBandedImageArray.length) {
            RealTuple realTuple = new RealTuple(new Real[]{singleBandedImageArray[n].getStartTime()});
            FunctionType functionType3 = (FunctionType)singleBandedImageArray[n].getType();
            SingleBandedImage singleBandedImage = functionType3.equals(functionType2) ? singleBandedImageArray[n] : (SingleBandedImage)singleBandedImageArray[n].changeMathType(functionType2);
            this.setSample(realTuple, (Data)singleBandedImage, false);
            ++n;
        }
    }

    public ImageSequenceImpl(SingleBandedImage[] singleBandedImageArray) throws VisADException, RemoteException {
        this(new FunctionType(RealType.Time, (FunctionType)singleBandedImageArray[0].getType()), singleBandedImageArray);
    }
}

