/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaSingularValueDecomposition
extends Tuple {
    private static final RealType SVS_row = RealType.getRealType("SV_S_row");
    private static final RealType SVS_column = RealType.getRealType("SV_S_column");
    private static final RealType SVS_value = RealType.getRealType("SV_S_value");
    private static final FunctionType SVSType = JamaSingularValueDecomposition.constructSFunction();
    private static final RealType SVV_row = RealType.getRealType("SV_V_row");
    private static final RealType SVV_column = RealType.getRealType("SV_V_column");
    private static final RealType SVV_value = RealType.getRealType("SV_V_value");
    private static final FunctionType SVVType = JamaSingularValueDecomposition.constructVFunction();
    private static final RealType SVU_row = RealType.getRealType("SV_H_row");
    private static final RealType SVU_column = RealType.getRealType("SV_H_column");
    private static final RealType SVU_value = RealType.getRealType("SV_H_value");
    private static final FunctionType SVUType = JamaSingularValueDecomposition.constructHFunction();
    private static final RealType singular_domain = RealType.getRealType("singular_domain");
    private static final RealType singular_value = RealType.getRealType("singular_value");
    private static final FunctionType singularType = JamaSingularValueDecomposition.constructSVFunction();
    private static final Class[] classes = JamaSingularValueDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaSingularValueDecomposition.constructMethods();
    private static final Method getU = methods[0];
    private static final Method getS = methods[1];
    private static final Method getV = methods[2];
    private static final Method getSingularValues = methods[3];
    private static final Method cond = methods[4];
    private static final Method norm2 = methods[4];
    private static final Method rank = methods[4];
    private static final Constructor matrixSVDecomposition = JamaSingularValueDecomposition.constructConstructor();
    private Object svd = ((JamaMatrix)this.getComponent(0)).getStash();

    private static FunctionType constructSFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(SVS_row, SVS_column);
            FunctionType functionType = new FunctionType(realTupleType, SVS_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructVFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(SVV_row, SVV_column);
            FunctionType functionType = new FunctionType(realTupleType, SVV_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructHFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(SVU_row, SVU_column);
            FunctionType functionType = new FunctionType(realTupleType, SVU_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructSVFunction() {
        try {
            FunctionType functionType = new FunctionType(singular_domain, singular_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[7];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classSingularValueDecomposition.getMethod("getU", classArray);
            methodArray[1] = classSingularValueDecomposition.getMethod("getS", classArray);
            methodArray[2] = classSingularValueDecomposition.getMethod("getV", classArray);
            methodArray[3] = classSingularValueDecomposition.getMethod("getSingularValues", classArray);
            methodArray[4] = classSingularValueDecomposition.getMethod("cond", classArray);
            methodArray[5] = classSingularValueDecomposition.getMethod("norm2", classArray);
            methodArray[6] = classSingularValueDecomposition.getMethod("rank", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] classArray = new Class[]{classMatrix};
            return classSingularValueDecomposition.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    private static Data[] makeDatums(Object object) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object2 = getU.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix = new JamaMatrix(object2, SVUType, null, null, null, null, null);
        jamaMatrix.setStash(object);
        Object object3 = getV.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix2 = new JamaMatrix(object3, SVVType, null, null, null, null, null);
        double[] dArray = (double[])getSingularValues.invoke(object, new Object[0]);
        FlatField flatField = new FlatField(singularType, new Integer1DSet(dArray.length));
        flatField.setSamples(new double[][]{dArray});
        return new Data[]{jamaMatrix, jamaMatrix2, flatField};
    }

    public Object getSVDecomposition() {
        return this.svd;
    }

    public JamaMatrix getU() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getV() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public JamaMatrix getS() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getS.invoke(this.svd, new Object[0]);
        return new JamaMatrix(object, SVSType, null, null, null, null, null);
    }

    public double[] getSingularValues() throws VisADException, RemoteException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField flatField = (FlatField)this.getComponent(2);
        double[][] dArray = flatField.getValues(false);
        return dArray[0];
    }

    public double cond() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)cond.invoke(this.svd, new Object[0]);
        return d;
    }

    public double norm2() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)norm2.invoke(this.svd, new Object[0]);
        return d;
    }

    public int rank() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classSingularValueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int n = (Integer)rank.invoke(this.svd, new Object[0]);
        return n;
    }

    public JamaSingularValueDecomposition(JamaMatrix jamaMatrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixSVDecomposition.newInstance(jamaMatrix.getMatrix()), false);
    }

    JamaSingularValueDecomposition(Object object, boolean bl) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaSingularValueDecomposition.makeDatums(object), bl);
    }
}

