/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaQRDecomposition
extends Tuple {
    private static final RealType QRQ_row = RealType.getRealType("QR_Q_row");
    private static final RealType QRQ_column = RealType.getRealType("QR_Q_column");
    private static final RealType QRQ_value = RealType.getRealType("QR_Q_value");
    private static final FunctionType QRQType = JamaQRDecomposition.constructQFunction();
    private static final RealType QRR_row = RealType.getRealType("QR_R_row");
    private static final RealType QRR_column = RealType.getRealType("QR_R_column");
    private static final RealType QRR_value = RealType.getRealType("QR_R_value");
    private static final FunctionType QRRType = JamaQRDecomposition.constructRFunction();
    private static final RealType QRH_row = RealType.getRealType("QR_H_row");
    private static final RealType QRH_column = RealType.getRealType("QR_H_column");
    private static final RealType QRH_value = RealType.getRealType("QR_H_value");
    private static final FunctionType QRHType = JamaQRDecomposition.constructHFunction();
    private static final Class[] classes = JamaQRDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaQRDecomposition.constructMethods();
    private static final Method getH = methods[0];
    private static final Method getQ = methods[1];
    private static final Method getR = methods[2];
    private static final Method isFullRank = methods[3];
    private static final Method solve = methods[4];
    private static final Constructor matrixQRDecomposition = JamaQRDecomposition.constructConstructor();
    private Object qrd = ((JamaMatrix)this.getComponent(0)).getStash();

    private static FunctionType constructQFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(QRQ_row, QRQ_column);
            FunctionType functionType = new FunctionType(realTupleType, QRQ_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructRFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(QRR_row, QRR_column);
            FunctionType functionType = new FunctionType(realTupleType, QRR_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructHFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(QRH_row, QRH_column);
            FunctionType functionType = new FunctionType(realTupleType, QRH_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[5];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classQRDecomposition.getMethod("getH", classArray);
            methodArray[1] = classQRDecomposition.getMethod("getQ", classArray);
            methodArray[2] = classQRDecomposition.getMethod("getR", classArray);
            methodArray[3] = classQRDecomposition.getMethod("isFullRank", classArray);
            classArray = new Class[]{classMatrix};
            methodArray[4] = classQRDecomposition.getMethod("solve", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] classArray = new Class[]{classMatrix};
            return classQRDecomposition.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    private static Data[] makeDatums(Object object) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object2 = getQ.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix = new JamaMatrix(object2, QRQType, null, null, null, null, null);
        jamaMatrix.setStash(object);
        Object object3 = getR.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix2 = new JamaMatrix(object3, QRQType, null, null, null, null, null);
        return new Data[]{jamaMatrix, jamaMatrix2};
    }

    public Object getQRDecomposition() {
        return this.qrd;
    }

    public JamaMatrix getQ() throws VisADException, RemoteException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getR() throws VisADException, RemoteException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public JamaMatrix getH() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getH.invoke(this.qrd, new Object[0]);
        return new JamaMatrix(object, QRHType, null, null, null, null, null);
    }

    public boolean isFullRank() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean bl = (Boolean)isFullRank.invoke(this.qrd, new Object[0]);
        return bl;
    }

    public JamaMatrix solve(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classQRDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = solve.invoke(this.qrd, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaQRDecomposition(JamaMatrix jamaMatrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixQRDecomposition.newInstance(jamaMatrix.getMatrix()), false);
    }

    JamaQRDecomposition(Object object, boolean bl) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaQRDecomposition.makeDatums(object), bl);
    }
}

