/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.matrix.JamaCholeskyDecomposition;
import visad.matrix.JamaEigenvalueDecomposition;
import visad.matrix.JamaLUDecomposition;
import visad.matrix.JamaQRDecomposition;
import visad.matrix.JamaSingularValueDecomposition;

public class JamaMatrix
extends FlatField {
    private static final RealType matrix_row = RealType.getRealType("matrix_row");
    private static final RealType matrix_column = RealType.getRealType("matrix_column");
    private static final RealType matrix_value = RealType.getRealType("matrix_value");
    private static final FunctionType matrixType = JamaMatrix.constructFunction();
    private static final Class[] classes = JamaMatrix.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaMatrix.constructMethods();
    private static final Method getColumnDimension = methods[0];
    private static final Method getRowDimension = methods[1];
    private static final Method getArray = methods[2];
    private static final Method get = methods[3];
    private static final Method getMatrix1 = methods[4];
    private static final Method getMatrix2 = methods[5];
    private static final Method getMatrix3 = methods[6];
    private static final Method getMatrix4 = methods[7];
    private static final Method set = methods[8];
    private static final Method setMatrix1 = methods[9];
    private static final Method setMatrix2 = methods[10];
    private static final Method setMatrix3 = methods[11];
    private static final Method setMatrix4 = methods[12];
    private static final Method transpose = methods[13];
    private static final Method norm1 = methods[14];
    private static final Method norm2 = methods[15];
    private static final Method normInf = methods[16];
    private static final Method normF = methods[17];
    private static final Method uminus = methods[18];
    private static final Method plus = methods[19];
    private static final Method plusEquals = methods[20];
    private static final Method minus = methods[21];
    private static final Method minusEquals = methods[22];
    private static final Method arrayTimes = methods[23];
    private static final Method arrayTimesEquals = methods[24];
    private static final Method arrayRightDivide = methods[25];
    private static final Method arrayRightDivideEquals = methods[26];
    private static final Method arrayLeftDivide = methods[27];
    private static final Method arrayLeftDivideEquals = methods[28];
    private static final Method times1 = methods[29];
    private static final Method timesEquals = methods[30];
    private static final Method times2 = methods[31];
    private static final Method solve = methods[32];
    private static final Method solveTranspose = methods[33];
    private static final Method inverse = methods[34];
    private static final Method det = methods[35];
    private static final Method rank = methods[36];
    private static final Method cond = methods[37];
    private static final Method trace = methods[38];
    private static final Method random = methods[39];
    private static final Method identity = methods[40];
    private static final Method print1 = methods[41];
    private static final Method print2 = methods[42];
    private static final Method print3 = methods[43];
    private static final Method print4 = methods[44];
    private static final Method read = methods[45];
    private static final Method chol = methods[46];
    private static final Method eig = methods[47];
    private static final Method lu = methods[48];
    private static final Method qr = methods[49];
    private static final Method svd = methods[50];
    private static final Constructor[] constructors = JamaMatrix.constructConstructors();
    private static final Constructor intintMatrix = constructors[0];
    private static final Constructor doubleMatrix = constructors[1];
    private Object matrix;
    private Object stash = null;
    private static /* synthetic */ Class array$I;
    private static /* synthetic */ Class class$Ljava$io$PrintWriter;
    private static /* synthetic */ Class class$Ljava$text$NumberFormat;
    private static /* synthetic */ Class class$Ljava$io$BufferedReader;
    private static /* synthetic */ Class array$$D;

    private static FunctionType constructFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(matrix_row, matrix_column);
            FunctionType functionType = new FunctionType(realTupleType, matrix_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Class constructMatrixClass() {
        try {
            Class<?> clazz = Class.forName("Jama.Matrix");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[51];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classMatrix.getMethod("getColumnDimension", classArray);
            methodArray[1] = classMatrix.getMethod("getRowDimension", classArray);
            methodArray[2] = classMatrix.getMethod("getArray", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            methodArray[3] = classMatrix.getMethod("get", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            methodArray[4] = classMatrix.getMethod("getMatrix", classArray);
            classArray = new Class[]{array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), array$I != null ? array$I : (array$I = JamaMatrix.class$("[I"))};
            methodArray[5] = classMatrix.getMethod("getMatrix", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE, array$I != null ? array$I : (array$I = JamaMatrix.class$("[I"))};
            methodArray[6] = classMatrix.getMethod("getMatrix", classArray);
            classArray = new Class[]{array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), Integer.TYPE, Integer.TYPE};
            methodArray[7] = classMatrix.getMethod("getMatrix", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE, Double.TYPE};
            methodArray[8] = classMatrix.getMethod("set", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, classMatrix};
            methodArray[9] = classMatrix.getMethod("setMatrix", classArray);
            classArray = new Class[]{array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), classMatrix};
            methodArray[10] = classMatrix.getMethod("setMatrix", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE, array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), classMatrix};
            methodArray[11] = classMatrix.getMethod("setMatrix", classArray);
            classArray = new Class[]{array$I != null ? array$I : (array$I = JamaMatrix.class$("[I")), Integer.TYPE, Integer.TYPE, classMatrix};
            methodArray[12] = classMatrix.getMethod("setMatrix", classArray);
            classArray = new Class[]{};
            methodArray[13] = classMatrix.getMethod("transpose", classArray);
            methodArray[14] = classMatrix.getMethod("norm1", classArray);
            methodArray[15] = classMatrix.getMethod("norm2", classArray);
            methodArray[16] = classMatrix.getMethod("normInf", classArray);
            methodArray[17] = classMatrix.getMethod("normF", classArray);
            methodArray[18] = classMatrix.getMethod("uminus", classArray);
            classArray = new Class[]{classMatrix};
            methodArray[19] = classMatrix.getMethod("plus", classArray);
            methodArray[20] = classMatrix.getMethod("plusEquals", classArray);
            methodArray[21] = classMatrix.getMethod("minus", classArray);
            methodArray[22] = classMatrix.getMethod("minusEquals", classArray);
            methodArray[23] = classMatrix.getMethod("arrayTimes", classArray);
            methodArray[24] = classMatrix.getMethod("arrayTimesEquals", classArray);
            methodArray[25] = classMatrix.getMethod("arrayRightDivide", classArray);
            methodArray[26] = classMatrix.getMethod("arrayRightDivideEquals", classArray);
            methodArray[27] = classMatrix.getMethod("arrayLeftDivide", classArray);
            methodArray[28] = classMatrix.getMethod("arrayLeftDivideEquals", classArray);
            classArray = new Class[]{Double.TYPE};
            methodArray[29] = classMatrix.getMethod("times", classArray);
            methodArray[30] = classMatrix.getMethod("timesEquals", classArray);
            classArray = new Class[]{classMatrix};
            methodArray[31] = classMatrix.getMethod("times", classArray);
            methodArray[32] = classMatrix.getMethod("solve", classArray);
            methodArray[33] = classMatrix.getMethod("solveTranspose", classArray);
            classArray = new Class[]{};
            methodArray[34] = classMatrix.getMethod("inverse", classArray);
            methodArray[35] = classMatrix.getMethod("det", classArray);
            methodArray[36] = classMatrix.getMethod("rank", classArray);
            methodArray[37] = classMatrix.getMethod("cond", classArray);
            methodArray[38] = classMatrix.getMethod("trace", classArray);
            classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            methodArray[39] = classMatrix.getMethod("random", classArray);
            methodArray[40] = classMatrix.getMethod("identity", classArray);
            methodArray[41] = classMatrix.getMethod("print", classArray);
            classArray = new Class[]{class$Ljava$io$PrintWriter != null ? class$Ljava$io$PrintWriter : (class$Ljava$io$PrintWriter = JamaMatrix.class$("java.io.PrintWriter")), Integer.TYPE, Integer.TYPE};
            methodArray[42] = classMatrix.getMethod("print", classArray);
            classArray = new Class[]{class$Ljava$text$NumberFormat != null ? class$Ljava$text$NumberFormat : (class$Ljava$text$NumberFormat = JamaMatrix.class$("java.text.NumberFormat")), Integer.TYPE};
            methodArray[43] = classMatrix.getMethod("print", classArray);
            classArray = new Class[]{class$Ljava$io$PrintWriter != null ? class$Ljava$io$PrintWriter : (class$Ljava$io$PrintWriter = JamaMatrix.class$("java.io.PrintWriter")), class$Ljava$text$NumberFormat != null ? class$Ljava$text$NumberFormat : (class$Ljava$text$NumberFormat = JamaMatrix.class$("java.text.NumberFormat")), Integer.TYPE};
            methodArray[44] = classMatrix.getMethod("print", classArray);
            classArray = new Class[]{class$Ljava$io$BufferedReader != null ? class$Ljava$io$BufferedReader : (class$Ljava$io$BufferedReader = JamaMatrix.class$("java.io.BufferedReader"))};
            methodArray[45] = classMatrix.getMethod("read", classArray);
            classArray = new Class[]{};
            methodArray[46] = classMatrix.getMethod("chol", classArray);
            methodArray[47] = classMatrix.getMethod("eig", classArray);
            methodArray[48] = classMatrix.getMethod("lu", classArray);
            methodArray[49] = classMatrix.getMethod("qr", classArray);
            methodArray[50] = classMatrix.getMethod("svd", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor[] constructConstructors() {
        Constructor[] constructorArray = new Constructor[2];
        try {
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            constructorArray[0] = classMatrix.getConstructor(classArray);
            classArray = new Class[]{array$$D != null ? array$$D : (array$$D = JamaMatrix.class$("[[D"))};
            constructorArray[1] = classMatrix.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return constructorArray;
    }

    public static JamaMatrix convertToMatrix(FlatField flatField) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object;
        CoordinateSystem[] coordinateSystemArray;
        Object object2;
        Object object3;
        float[][] fArray;
        int[] nArray;
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (flatField instanceof JamaMatrix) {
            return (JamaMatrix)flatField;
        }
        FunctionType functionType = (FunctionType)flatField.getType();
        Set set = flatField.getDomainSet();
        Gridded2DSet gridded2DSet = null;
        if (set instanceof Gridded2DSet) {
            gridded2DSet = (Gridded2DSet)set;
        } else if (set instanceof GriddedSet && set.getDimension() == 2) {
            nArray = ((GriddedSet)set).getLengths();
            fArray = set.getSamples(false);
            gridded2DSet = new Gridded2DSet(set.getType(), fArray, nArray[0], nArray[1], set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors());
        } else if (set instanceof Gridded1DSet) {
            nArray = ((Gridded1DSet)set).getLengths();
            fArray = set.getSamples(false);
            float[] fArray2 = new float[nArray[0]];
            int n = 0;
            while (n < nArray[0]) {
                fArray2[n] = 0.0f;
                ++n;
            }
            fArray = new float[][]{fArray[0], fArray2};
            object3 = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
            object2 = RealType.getRealType("dummy");
            RealTupleType realTupleType = new RealTupleType((RealType)object3, (RealType)object2);
            gridded2DSet = new Gridded2DSet((MathType)realTupleType, fArray, nArray[0], 1, null, null, null);
            functionType = new FunctionType(realTupleType, functionType.getRange());
        } else {
            return null;
        }
        nArray = gridded2DSet.getLengths();
        int n = nArray[0];
        int n2 = nArray[1];
        object3 = new double[n][n2];
        try {
            object2 = flatField.getValues(false);
        }
        catch (VisADException visADException) {
            return null;
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                object3[n3][n4] = object2[0][n2 * n3 + n4];
                ++n4;
            }
            ++n3;
        }
        CoordinateSystem coordinateSystem = null;
        try {
            coordinateSystemArray = flatField.getRangeCoordinateSystem();
            coordinateSystem = coordinateSystemArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        coordinateSystemArray = null;
        try {
            int n5 = ((TupleType)functionType.getRange()).getDimension();
            coordinateSystemArray = new CoordinateSystem[n5];
            int n6 = 0;
            while (n6 < n5) {
                object = flatField.getRangeCoordinateSystem(n6);
                coordinateSystemArray[n6] = object[0];
                ++n6;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set[] setArray = flatField.getRangeSets();
        Unit[] unitArray = null;
        try {
            object = flatField.getRangeUnits();
            if (object != null) {
                int n7 = ((Unit[][])object).length;
                int n8 = 0;
                while (n8 < n7) {
                    unitArray[n8] = object[n8][0];
                    ++n8;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = doubleMatrix.newInstance(object3);
        return new JamaMatrix(object, functionType, gridded2DSet, coordinateSystem, coordinateSystemArray, setArray, unitArray);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        double[][] dArray = new double[][]{{3.0, 4.0, 5.0}, {10.0, 18.0, 6.0}, {2.0, -1.0, 0.0}};
        double[][] dArray2 = new double[][]{{6.0, 4.0, 2.0}, {-4.0, -3.0, -2.0}, {1.0, 1.0, 1.0}};
        try {
            System.out.println("get = " + get);
            System.out.println("getMatrix2 = " + getMatrix2);
            JamaMatrix jamaMatrix = new JamaMatrix(dArray);
            JamaMatrix jamaMatrix2 = new JamaMatrix(dArray2);
            JamaMatrix jamaMatrix3 = JamaMatrix.convertToMatrix((FlatField)jamaMatrix.add(jamaMatrix2));
            JamaMatrix jamaMatrix4 = jamaMatrix.plus(jamaMatrix2);
            System.out.println("m1.get(1, 1) = " + jamaMatrix.get(1, 1));
            System.out.println("m1:");
            jamaMatrix.print(1, 0);
            System.out.println("m2:");
            jamaMatrix2.print(1, 0);
            System.out.println("m3 = m1 + m2 (VisAD):");
            jamaMatrix3.print(1, 0);
            System.out.println("m4 = m1 + m2 (JAMA):");
            jamaMatrix4.print(1, 0);
            System.out.println("m4 = " + jamaMatrix4);
            JamaSingularValueDecomposition jamaSingularValueDecomposition = jamaMatrix4.svd();
            System.out.println("m4 svd U:");
            jamaSingularValueDecomposition.getU().print(1, 0);
            System.out.println("m4 svd S:");
            jamaSingularValueDecomposition.getS().print(1, 0);
            System.out.println("m4 svd V:");
            jamaSingularValueDecomposition.getV().print(1, 0);
            JamaQRDecomposition jamaQRDecomposition = jamaMatrix4.qr();
            System.out.println("m4 qr Q:");
            jamaQRDecomposition.getQ().print(1, 0);
            System.out.println("m4 qr R:");
            jamaQRDecomposition.getR().print(1, 0);
            JamaLUDecomposition jamaLUDecomposition = jamaMatrix4.lu();
            System.out.println("m4 lu L:");
            jamaLUDecomposition.getL().print(1, 0);
            System.out.println("m4 lu U:");
            jamaLUDecomposition.getU().print(1, 0);
            JamaEigenvalueDecomposition jamaEigenvalueDecomposition = jamaMatrix4.eig();
            System.out.println("m4 eig D:");
            jamaEigenvalueDecomposition.getD().print(1, 0);
            System.out.println("m4 eig V:");
            jamaEigenvalueDecomposition.getV().print(1, 0);
            JamaCholeskyDecomposition jamaCholeskyDecomposition = jamaMatrix4.chol();
            System.out.println("m4 chol L:");
            jamaCholeskyDecomposition.getL().print(1, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Integer2DSet getDomainSet(Object object) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (!classMatrix.isInstance(object)) {
            throw new VisADException("matrix must be an instance of Jama.Matrix");
        }
        int n = (Integer)getRowDimension.invoke(object, new Object[0]);
        int n2 = (Integer)getColumnDimension.invoke(object, new Object[0]);
        return new Integer2DSet(n, n2);
    }

    void setStash(Object object) {
        this.stash = object;
    }

    Object getStash() {
        return this.stash;
    }

    public Object getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Object object) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        if (!classMatrix.isInstance(object)) {
            throw new VisADException("matrix must be an instance of Jama.Matrix");
        }
        int n = (Integer)getRowDimension.invoke(object, new Object[0]);
        int n2 = (Integer)getColumnDimension.invoke(object, new Object[0]);
        double[][] dArray = (double[][])getArray.invoke(object, new Object[0]);
        double[][] dArray2 = new double[1][n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray2[0][n2 * n3 + n4] = dArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        try {
            this.setSamples(dArray2, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.matrix = object;
    }

    public void setMatrix(double[][] dArray) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this.setMatrix(doubleMatrix.newInstance(new Object[]{dArray}));
    }

    public int getRowDimension() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int n = (Integer)getRowDimension.invoke(this.matrix, new Object[0]);
        return n;
    }

    public int getColumnDimension() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int n = (Integer)getColumnDimension.invoke(this.matrix, new Object[0]);
        return n;
    }

    public double get(int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)get.invoke(this.matrix, new Integer(n), new Integer(n2));
        return d;
    }

    public JamaMatrix getMatrix(int n, int n2, int n3, int n4) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getMatrix1.invoke(this.matrix, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
        return new JamaMatrix(object);
    }

    public JamaMatrix getMatrix(int[] nArray, int[] nArray2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getMatrix2.invoke(this.matrix, nArray, nArray2);
        return new JamaMatrix(object);
    }

    public JamaMatrix getMatrix(int n, int n2, int[] nArray) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getMatrix1.invoke(this.matrix, new Integer(n), new Integer(n2), nArray);
        return new JamaMatrix(object);
    }

    public JamaMatrix getMatrix(int[] nArray, int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getMatrix1.invoke(this.matrix, nArray, new Integer(n), new Integer(n2));
        return new JamaMatrix(object);
    }

    public void set(int n, int n2, double d) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        set.invoke(this.matrix, new Integer(n), new Integer(n2), new Double(d));
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int n, int n2, int n3, int n4, JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix1.invoke(this.matrix, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int[] nArray, int[] nArray2, JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix2.invoke(this.matrix, nArray, nArray2, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int[] nArray, int n, int n2, JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix3.invoke(this.matrix, nArray, new Integer(n), new Integer(n2), jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
    }

    public void setMatrix(int n, int n2, int[] nArray, JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        setMatrix4.invoke(this.matrix, new Integer(n), new Integer(n2), nArray, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
    }

    public JamaMatrix transpose() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = transpose.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(object);
    }

    public double norm1() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)norm1.invoke(this.matrix, new Object[0]);
        return d;
    }

    public double norm2() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)norm2.invoke(this.matrix, new Object[0]);
        return d;
    }

    public double normInf() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)normInf.invoke(this.matrix, new Object[0]);
        return d;
    }

    public double normF() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)normF.invoke(this.matrix, new Object[0]);
        return d;
    }

    public JamaMatrix uminus() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = uminus.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(object);
    }

    public JamaMatrix plus(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = plus.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix plusEquals(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        plusEquals.invoke(this.matrix, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix minus(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = minus.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix minusEquals(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        minusEquals.invoke(this.matrix, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayTimes(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = arrayTimes.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix arrayTimesEquals(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayTimesEquals.invoke(this.matrix, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayRightDivide(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = arrayRightDivide.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix arrayRightDivideEquals(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayRightDivideEquals.invoke(this.matrix, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix arrayLeftDivide(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = arrayLeftDivide.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix arrayLeftDivideEquals(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        arrayLeftDivideEquals.invoke(this.matrix, jamaMatrix.getMatrix());
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix times(double d) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = times1.invoke(this.matrix, new Double(d));
        return new JamaMatrix(object);
    }

    public JamaMatrix timesEquals(double d) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        timesEquals.invoke(this.matrix, new Double(d));
        this.setMatrix(this.matrix);
        return this;
    }

    public JamaMatrix times(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = times2.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix solve(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = solve.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix solveTranspose(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = solveTranspose.invoke(this.matrix, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaMatrix inverse() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = inverse.invoke(this.matrix, new Object[0]);
        return new JamaMatrix(object);
    }

    public double det() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)det.invoke(this.matrix, new Object[0]);
        return d;
    }

    public int rank() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int n = (Integer)rank.invoke(this.matrix, new Object[0]);
        return n;
    }

    public double cond() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)cond.invoke(this.matrix, new Object[0]);
        return d;
    }

    public double trace() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)trace.invoke(this.matrix, new Object[0]);
        return d;
    }

    public static JamaMatrix random(int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = random.invoke(null, new Integer(n), new Integer(n2));
        return new JamaMatrix(object);
    }

    public static JamaMatrix identity(int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = identity.invoke(null, new Integer(n), new Integer(n2));
        return new JamaMatrix(object);
    }

    public void print(int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print1.invoke(this.matrix, new Integer(n), new Integer(n2));
    }

    public void print(PrintWriter printWriter, int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print2.invoke(this.matrix, printWriter, new Integer(n), new Integer(n2));
    }

    public void print(NumberFormat numberFormat, int n) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print3.invoke(this.matrix, numberFormat, new Integer(n));
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        print4.invoke(this.matrix, printWriter, numberFormat, new Integer(n));
    }

    public static JamaMatrix read(BufferedReader bufferedReader) throws IOException, VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = read.invoke(null, bufferedReader);
        return new JamaMatrix(object);
    }

    public JamaCholeskyDecomposition chol() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = chol.invoke(this.matrix, new Object[0]);
        return new JamaCholeskyDecomposition(object, false);
    }

    public JamaEigenvalueDecomposition eig() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = eig.invoke(this.matrix, new Object[0]);
        return new JamaEigenvalueDecomposition(object, false);
    }

    public JamaLUDecomposition lu() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = lu.invoke(this.matrix, new Object[0]);
        return new JamaLUDecomposition(object, false);
    }

    public JamaQRDecomposition qr() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = qr.invoke(this.matrix, new Object[0]);
        return new JamaQRDecomposition(object, false);
    }

    public JamaSingularValueDecomposition svd() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classMatrix == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = svd.invoke(this.matrix, new Object[0]);
        return new JamaSingularValueDecomposition(object, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JamaMatrix(int n, int n2) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(intintMatrix.newInstance(new Integer(n), new Integer(n2)), null, null, null, null, null, null);
    }

    public JamaMatrix(double[][] dArray) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(doubleMatrix.newInstance(new Object[]{dArray}), null, null, null, null, null, null);
    }

    public JamaMatrix(Object object) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(object, null, null, null, null, null, null);
    }

    public JamaMatrix(Object object, FunctionType functionType, Gridded2DSet gridded2DSet) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(object, functionType, gridded2DSet, null, null, null, null);
    }

    public JamaMatrix(Object object, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(object, null, null, coordinateSystem, coordinateSystemArray, setArray, unitArray);
    }

    public JamaMatrix(Object object, FunctionType functionType, Gridded2DSet gridded2DSet, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(functionType == null ? matrixType : functionType, gridded2DSet == null ? JamaMatrix.getDomainSet(object) : gridded2DSet, coordinateSystem, coordinateSystemArray, setArray, unitArray);
        if (functionType != null && !matrixType.equalsExceptName(functionType)) {
            throw new VisADException("JamaMatrix: MathType must be of the form ((x, y) -> z)");
        }
        this.setMatrix(object);
    }
}

