/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaLUDecomposition
extends Tuple {
    private static final RealType LUL_row = RealType.getRealType("LU_L_row");
    private static final RealType LUL_column = RealType.getRealType("LU_L_column");
    private static final RealType LUL_value = RealType.getRealType("LU_L_value");
    private static final FunctionType LULType = JamaLUDecomposition.constructLFunction();
    private static final RealType LUU_row = RealType.getRealType("LU_U_row");
    private static final RealType LUU_column = RealType.getRealType("LU_U_column");
    private static final RealType LUU_value = RealType.getRealType("LU_U_value");
    private static final FunctionType LUUType = JamaLUDecomposition.constructUFunction();
    private static final RealType pivot_domain = RealType.getRealType("pivot_domain");
    private static final RealType pivot_value = RealType.getRealType("pivot_value");
    private static final FunctionType pivotType = JamaLUDecomposition.constructPFunction();
    private static final Class[] classes = JamaLUDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaLUDecomposition.constructMethods();
    private static final Method getL = methods[0];
    private static final Method getU = methods[1];
    private static final Method getPivot = methods[2];
    private static final Method getDoublePivot = methods[3];
    private static final Method det = methods[4];
    private static final Method isNonsingular = methods[5];
    private static final Method solve = methods[6];
    private static final Constructor matrixLUDecomposition = JamaLUDecomposition.constructConstructor();
    private Object lud = ((JamaMatrix)this.getComponent(0)).getStash();

    private static FunctionType constructLFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(LUL_row, LUL_column);
            FunctionType functionType = new FunctionType(realTupleType, LUL_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructUFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(LUU_row, LUU_column);
            FunctionType functionType = new FunctionType(realTupleType, LUU_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructPFunction() {
        try {
            FunctionType functionType = new FunctionType(pivot_domain, pivot_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[7];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classLUDecomposition.getMethod("getL", classArray);
            methodArray[1] = classLUDecomposition.getMethod("getU", classArray);
            methodArray[2] = classLUDecomposition.getMethod("getPivot", classArray);
            methodArray[3] = classLUDecomposition.getMethod("getDoublePivot", classArray);
            methodArray[4] = classLUDecomposition.getMethod("det", classArray);
            methodArray[5] = classLUDecomposition.getMethod("isNonsingular", classArray);
            classArray = new Class[]{classMatrix};
            methodArray[6] = classLUDecomposition.getMethod("solve", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] classArray = new Class[]{classMatrix};
            return classLUDecomposition.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    private static Data[] makeDatums(Object object) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object2 = getL.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix = new JamaMatrix(object2, LULType, null, null, null, null, null);
        jamaMatrix.setStash(object);
        Object object3 = getU.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix2 = new JamaMatrix(object3, LUUType, null, null, null, null, null);
        double[] dArray = (double[])getDoublePivot.invoke(object, new Object[0]);
        FlatField flatField = new FlatField(pivotType, new Integer1DSet(dArray.length));
        flatField.setSamples(new double[][]{dArray});
        return new Data[]{jamaMatrix, jamaMatrix2, flatField};
    }

    public Object getLUDecomposition() {
        return this.lud;
    }

    public JamaMatrix getL() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getU() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public double det() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double d = (Double)det.invoke(this.lud, new Object[0]);
        return d;
    }

    public double[] getDoublePivot() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField flatField = (FlatField)this.getComponent(2);
        double[][] dArray = flatField.getValues(false);
        return dArray[0];
    }

    public int[] getPivot() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int[] nArray = (int[])getPivot.invoke(this.lud, new Object[0]);
        return nArray;
    }

    public boolean isNonsingular() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean bl = (Boolean)isNonsingular.invoke(this.lud, new Object[0]);
        return bl;
    }

    public JamaMatrix solve(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = solve.invoke(this.lud, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaLUDecomposition(JamaMatrix jamaMatrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixLUDecomposition.newInstance(jamaMatrix.getMatrix()), false);
    }

    JamaLUDecomposition(Object object, boolean bl) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaLUDecomposition.makeDatums(object), bl);
    }
}

