/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaEigenvalueDecomposition
extends Tuple {
    private static final RealType eigenV_row = RealType.getRealType("eigenV_row");
    private static final RealType eigenV_column = RealType.getRealType("eigenV_column");
    private static final RealType eigenV_value = RealType.getRealType("eigenV_value");
    private static final FunctionType eigenVType = JamaEigenvalueDecomposition.constructEVFunction();
    private static final RealType eigen_domain = RealType.getRealType("eigen_domain");
    private static final RealType eigen_real = RealType.getRealType("eigen_real");
    private static final RealType eigen_imaginary = RealType.getRealType("eigen_imaginary");
    private static final FunctionType eigenRType = JamaEigenvalueDecomposition.constructERFunction();
    private static final FunctionType eigenIType = JamaEigenvalueDecomposition.constructEIFunction();
    private static final Class[] classes = JamaEigenvalueDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaEigenvalueDecomposition.constructMethods();
    private static final Method getD = methods[0];
    private static final Method getV = methods[1];
    private static final Method getImagEigenvalues = methods[2];
    private static final Method getRealEigenvalues = methods[3];
    private static final Constructor matrixEigenvalueDecomposition = JamaEigenvalueDecomposition.constructConstructor();
    private Object ed = ((JamaMatrix)this.getComponent(0)).getStash();

    private static FunctionType constructEVFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(eigenV_row, eigenV_column);
            FunctionType functionType = new FunctionType(realTupleType, eigenV_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructERFunction() {
        try {
            FunctionType functionType = new FunctionType(eigen_domain, eigen_real);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructEIFunction() {
        try {
            FunctionType functionType = new FunctionType(eigen_domain, eigen_imaginary);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[4];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classEigenvalueDecomposition.getMethod("getD", classArray);
            methodArray[1] = classEigenvalueDecomposition.getMethod("getV", classArray);
            methodArray[2] = classEigenvalueDecomposition.getMethod("getImagEigenvalues", classArray);
            methodArray[3] = classEigenvalueDecomposition.getMethod("getRealEigenvalues", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] classArray = new Class[]{classMatrix};
            return classEigenvalueDecomposition.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    private static Data[] makeDatums(Object object) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object2 = getV.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix = new JamaMatrix(object2, eigenVType, null, null, null, null, null);
        jamaMatrix.setStash(object);
        double[] dArray = (double[])getRealEigenvalues.invoke(object, new Object[0]);
        FlatField flatField = new FlatField(eigenRType, new Integer1DSet(dArray.length));
        flatField.setSamples(new double[][]{dArray});
        double[] dArray2 = (double[])getImagEigenvalues.invoke(object, new Object[0]);
        FlatField flatField2 = new FlatField(eigenIType, new Integer1DSet(dArray2.length));
        flatField2.setSamples(new double[][]{dArray2});
        return new Data[]{jamaMatrix, flatField, flatField2};
    }

    public Object getEigenvalueDecomposition() {
        return this.ed;
    }

    public JamaMatrix getV() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getD() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = getD.invoke(this.ed, new Object[0]);
        return new JamaMatrix(object);
    }

    public double[] getRealEigenvalues() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField flatField = (FlatField)this.getComponent(1);
        double[][] dArray = flatField.getValues(false);
        return dArray[0];
    }

    public double[] getImagEigenvalues() throws VisADException, RemoteException {
        if (classEigenvalueDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField flatField = (FlatField)this.getComponent(2);
        double[][] dArray = flatField.getValues(false);
        return dArray[0];
    }

    public JamaEigenvalueDecomposition(JamaMatrix jamaMatrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixEigenvalueDecomposition.newInstance(jamaMatrix.getMatrix()), false);
    }

    JamaEigenvalueDecomposition(Object object, boolean bl) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaEigenvalueDecomposition.makeDatums(object), bl);
    }
}

