/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaCholeskyDecomposition
extends Tuple {
    private static final RealType cholesky_row = RealType.getRealType("choleskyL_row");
    private static final RealType cholesky_column = RealType.getRealType("choleskyL_column");
    private static final RealType cholesky_value = RealType.getRealType("choleskyL_value");
    private static final FunctionType choleskyLType = JamaCholeskyDecomposition.constructFunction();
    private static final Class[] classes = JamaCholeskyDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private static final Method[] methods = JamaCholeskyDecomposition.constructMethods();
    private static final Method getL = methods[0];
    private static final Method isSPD = methods[1];
    private static final Method solve = methods[2];
    private static final Constructor matrixCholeskyDecomposition = JamaCholeskyDecomposition.constructConstructor();
    private Object cd = ((JamaMatrix)this.getComponent(0)).getStash();

    private static FunctionType constructFunction() {
        try {
            RealTupleType realTupleType = new RealTupleType(cholesky_row, cholesky_column);
            FunctionType functionType = new FunctionType(realTupleType, cholesky_value);
            return functionType;
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] classArray = new Class[6];
        try {
            classArray[0] = Class.forName("Jama.Matrix");
            classArray[1] = Class.forName("Jama.CholeskyDecomposition");
            classArray[2] = Class.forName("Jama.EigenvalueDecomposition");
            classArray[3] = Class.forName("Jama.LUDecomposition");
            classArray[4] = Class.forName("Jama.QRDecomposition");
            classArray[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return classArray;
    }

    private static Method[] constructMethods() {
        Method[] methodArray = new Method[3];
        try {
            Class[] classArray = new Class[]{};
            methodArray[0] = classCholeskyDecomposition.getMethod("getL", classArray);
            methodArray[1] = classCholeskyDecomposition.getMethod("isSPD", classArray);
            classArray = new Class[]{classMatrix};
            methodArray[2] = classCholeskyDecomposition.getMethod("solve", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return methodArray;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] classArray = new Class[]{classMatrix};
            return classCholeskyDecomposition.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
    }

    private static Data[] makeDatums(Object object) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object2 = getL.invoke(object, new Object[0]);
        JamaMatrix jamaMatrix = new JamaMatrix(object2, choleskyLType, null, null, null, null, null);
        jamaMatrix.setStash(object);
        return new Data[]{jamaMatrix};
    }

    public Object getCholeskyDecomposition() {
        return this.cd;
    }

    public JamaMatrix getL() throws VisADException, RemoteException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public boolean isSPD() throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean bl = (Boolean)isSPD.invoke(this.cd, new Object[0]);
        return bl;
    }

    public JamaMatrix solve(JamaMatrix jamaMatrix) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classCholeskyDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object object = solve.invoke(this.cd, jamaMatrix.getMatrix());
        return new JamaMatrix(object);
    }

    public JamaCholeskyDecomposition(JamaMatrix jamaMatrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixCholeskyDecomposition.newInstance(jamaMatrix.getMatrix()), false);
    }

    JamaCholeskyDecomposition(Object object, boolean bl) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaCholeskyDecomposition.makeDatums(object), bl);
    }
}

