/*
 * Decompiled with CFR 0.152.
 */
package visad.math;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.TypeException;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Histogram {
    public static FlatField makeHistogram(Data[] dataArray) {
        FlatField flatField = null;
        try {
            if (dataArray == null || dataArray.length != 2) {
                throw new VisADException("bad arguments");
            }
            if (!(dataArray[0] instanceof Field)) {
                throw new VisADException("first argument must be a Field");
            }
            if (!(dataArray[1] instanceof Set)) {
                throw new VisADException("second argument must be a Set");
            }
            flatField = Histogram.makeHistogram((Field)dataArray[0], (Set)dataArray[1]);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (flatField == null) {
            System.out.println("result == null");
        }
        return flatField;
    }

    public static FlatField makeHistogram(Field field, Set set) throws VisADException, RemoteException {
        int n;
        FunctionType functionType = (FunctionType)field.getType();
        RealType[] realTypeArray = functionType.getRealComponents();
        RealTupleType realTupleType = ((SetType)set.getType()).getDomain();
        RealType[] realTypeArray2 = realTupleType.getRealComponents();
        RealType realType = RealType.getRealType("count");
        FunctionType functionType2 = new FunctionType(realTupleType, realType);
        int n2 = realTypeArray2.length;
        float[][] fArray = field.getFloats(false);
        float[][] fArray2 = new float[n2][];
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < realTypeArray.length) {
                if (realTypeArray2[n3].equals(realTypeArray[n])) {
                    fArray2[n3] = fArray[n];
                    break;
                }
                ++n;
            }
            if (fArray2[n3] == null) {
                throw new TypeException("set component " + realTypeArray2[n3] + " does not occur in " + functionType);
            }
            ++n3;
        }
        int[] nArray = set.valueToIndex(fArray2);
        n = set.getLength();
        float[][] fArray3 = new float[1][n];
        int n4 = 0;
        while (n4 < n) {
            fArray3[0][n4] = 0.0f;
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] >= 0) {
                float[] fArray4 = fArray3[0];
                int n5 = nArray[n4];
                fArray4[n5] = fArray4[n5] + 1.0f;
            }
            ++n4;
        }
        FlatField flatField = new FlatField(functionType2, set);
        flatField.setSamples(fArray3, false);
        return flatField;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        int n = 64;
        RealType realType = new RealType("X");
        RealType realType2 = new RealType("Y");
        RealType realType3 = new RealType("A");
        RealType realType4 = new RealType("B");
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, n, n);
        RealType[] realTypeArray2 = new RealType[]{realType3, realType4};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        FlatField flatField = new FlatField(functionType, integer2DSet);
        int n2 = integer2DSet.getLength();
        int n3 = n2 * n2 / 16;
        float[][] fArray = new float[2][n2];
        int n4 = 0;
        while (n4 < n2) {
            fArray[0][n4] = n4;
            fArray[1][n4] = (float)((double)(n4 * n4 + n3) * Math.random());
            ++n4;
        }
        flatField.setSamples(fArray, false);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType2, 0.5 * (double)n, (double)n2 - 0.5 * (double)n, n2 / n, 0.5 * (double)n * (double)n2, (double)(n2 * n2 + n3) - 0.5 * (double)n * (double)n2, n2 / n);
        FlatField flatField2 = Histogram.makeHistogram(flatField, linear2DSet);
        RealType realType5 = RealType.getRealType("count");
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1");
        displayImplJ3D.addMap(new ScalarMap(realType3, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(realType4, Display.YAxis));
        if (stringArray.length == 0) {
            displayImplJ3D.addMap(new ScalarMap(realType5, Display.ZAxis));
        }
        displayImplJ3D.addMap(new ScalarMap(realType5, Display.RGB));
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        graphicsModeControl.setCurvedSize(1);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("hist_ref");
        dataReferenceImpl.setData(flatField2);
        displayImplJ3D.addReference(dataReferenceImpl);
        JFrame jFrame = new JFrame("VisAD HSV Color Coordinates");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.getContentPane().add(displayImplJ3D.getComponent());
        int n5 = 500;
        int n6 = 600;
        ((Component)jFrame).setSize(n5, n6);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n5 / 2, dimension.height / 2 - n6 / 2);
        ((Component)jFrame).setVisible(true);
    }
}

