/*
 * Decompiled with CFR 0.152.
 */
package visad.math;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DoubleSet;
import visad.Field;
import visad.FieldException;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.MathType;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class FFT {
    public static FlatField forwardFT(Data[] dataArray) {
        FlatField flatField = null;
        try {
            flatField = FFT.fourierTransform((Field)dataArray[0], true);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (flatField == null) {
            System.out.println("result == null");
        }
        return flatField;
    }

    public static FlatField backwardFT(Data[] dataArray) {
        FlatField flatField = null;
        try {
            flatField = FFT.fourierTransform((Field)dataArray[0], false);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (flatField == null) {
            System.out.println("result == null");
        }
        return flatField;
    }

    public static FlatField fourierTransform(Field field, boolean bl) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, bl, null, null, null, null, null);
    }

    public static FlatField fourierTransform(Field field, boolean bl, FunctionType functionType, GriddedSet griddedSet, CoordinateSystem coordinateSystem, Set[] setArray, Unit[] unitArray) throws VisADException, RemoteException {
        int n;
        Object object;
        Object object2;
        if (field == null) {
            return null;
        }
        FunctionType functionType2 = (FunctionType)field.getType();
        RealTupleType realTupleType = functionType2.getDomain();
        int n2 = realTupleType.getDimension();
        MathType mathType = functionType2.getRange();
        RealType[] realTypeArray = null;
        int n3 = 0;
        if (mathType instanceof RealType) {
            realTypeArray = new RealType[]{(RealType)mathType};
            n3 = 1;
        } else if (mathType instanceof RealTupleType) {
            realTypeArray = ((RealTupleType)mathType).getRealComponents();
            n3 = realTypeArray.length;
        } else {
            throw new FieldException("bad range type " + mathType);
        }
        if (n2 != 1 && n2 != 2) {
            throw new FieldException("bad domain dimension " + realTupleType);
        }
        if (n3 != 1 && n3 != 2) {
            throw new FieldException("bad range dimension " + mathType);
        }
        if (unitArray == null || unitArray.length == 0) {
            unitArray = new Unit[]{null, null};
        } else if (unitArray.length == 1) {
            unitArray = new Unit[]{unitArray[0], null};
        }
        if (functionType == null) {
            object2 = new RealType[2];
            if (n3 == 2) {
                if (bl) {
                    object = realTypeArray[0].getName() + "_FT";
                    object2[0] = RealType.getRealType((String)object, unitArray[0], null);
                    object = realTypeArray[1].getName() + "_FT";
                    object2[1] = RealType.getRealType((String)object, unitArray[1], null);
                } else {
                    object = realTypeArray[0].getName();
                    if (((String)object).endsWith("_FT")) {
                        object = ((String)object).substring(0, ((String)object).length() - 3);
                    } else if (((String)object).endsWith("_FT_real")) {
                        object = ((String)object).substring(0, ((String)object).length() - 8);
                    } else if (((String)object).endsWith("_RFT_real")) {
                        object = ((String)object).substring(0, ((String)object).length() - 9);
                    }
                    object2[0] = RealType.getRealType((String)object, unitArray[0], null);
                    object = realTypeArray[1].getName();
                    if (((String)object).endsWith("_FT")) {
                        object = ((String)object).substring(0, ((String)object).length() - 3);
                    } else if (((String)object).endsWith("_FT_imag")) {
                        object = ((String)object).substring(0, ((String)object).length() - 8) + "_imag";
                    } else if (((String)object).endsWith("_RFT_imag")) {
                        object = ((String)object).substring(0, ((String)object).length() - 9) + "_imag";
                    }
                    object2[1] = RealType.getRealType((String)object, unitArray[1], null);
                }
            } else if (bl) {
                object = realTypeArray[0].getName() + "_FT";
                object2[0] = RealType.getRealType((String)object + "_real", unitArray[0], null);
                object2[1] = RealType.getRealType((String)object + "_imag", unitArray[1], null);
            } else {
                object = realTypeArray[0].getName() + "_RFT";
                object2[0] = RealType.getRealType((String)object + "_real", unitArray[0], null);
                object2[1] = RealType.getRealType((String)object + "_imag", unitArray[1], null);
            }
            object = new RealTupleType((RealType[])object2, coordinateSystem, null);
            functionType = new FunctionType(realTupleType, (MathType)object);
        } else {
            object2 = functionType.getDomain();
            if (((TupleType)object2).getDimension() != n2) {
                throw new FieldException("bad domain dimension " + object2);
            }
            object = functionType.getRange();
            if (!(object instanceof RealTupleType) || ((RealTupleType)object).getDimension() != 2) {
                throw new FieldException("bad range type " + object);
            }
        }
        object2 = field.getDomainSet();
        if (!(object2 instanceof GriddedSet)) {
            throw new FieldException("field domain set must be Gridded2DSet " + object2);
        }
        object = ((GriddedSet)object2).getLengths();
        if (griddedSet == null) {
            griddedSet = (GriddedSet)object2;
        } else {
            if (griddedSet.getDimension() != n2) {
                throw new FieldException("domain_set bad dimension " + griddedSet);
            }
            int[] nArray = griddedSet.getLengths();
            int n4 = 0;
            while (n4 < n2) {
                if (object[n4] != nArray[n4]) {
                    throw new FieldException("domain_set size must match field domain set " + griddedSet + "\n" + object2);
                }
                ++n4;
            }
        }
        boolean bl2 = true;
        if (field instanceof FlatField) {
            bl2 = false;
            Set[] setArray2 = ((FlatField)field).getRangeSets();
            n = 0;
            while (n < setArray2.length) {
                if (setArray2[n] instanceof DoubleSet) {
                    bl2 = true;
                }
                ++n;
            }
        }
        boolean bl3 = false;
        if (setArray != null) {
            if (setArray.length != 2) {
                throw new FieldException("bad range_sets length" + setArray.length);
            }
            n = 0;
            while (n < 2) {
                if (setArray[n] instanceof DoubleSet) {
                    bl3 = true;
                }
                ++n;
            }
        }
        bl2 = bl2 && bl3;
        FlatField flatField = new FlatField(functionType, griddedSet, coordinateSystem, null, setArray, unitArray);
        if (bl2) {
            double[][] dArray = field.getValues(false);
            if (dArray.length == 1) {
                int n5 = dArray[0].length;
                double[][] dArray2 = new double[2][n5];
                System.arraycopy(dArray[0], 0, dArray2[0], 0, n5);
                int n6 = 0;
                while (n6 < n5) {
                    dArray2[1][n6] = 0.0;
                    ++n6;
                }
                dArray = dArray2;
            }
            dArray = n2 == 1 ? FFT.FT1D(dArray, bl) : FFT.FT2D((int)object[0], (int)object[1], dArray, bl);
            flatField.setSamples(dArray, false);
        } else {
            float[][] fArray = field.getFloats(false);
            if (fArray.length == 1) {
                int n7 = fArray[0].length;
                float[][] fArray2 = new float[2][n7];
                System.arraycopy(fArray[0], 0, fArray2[0], 0, n7);
                int n8 = 0;
                while (n8 < n7) {
                    fArray2[1][n8] = 0.0f;
                    ++n8;
                }
                fArray = fArray2;
            }
            fArray = n2 == 1 ? FFT.FT1D(fArray, bl) : FFT.FT2D((int)object[0], (int)object[1], fArray, bl);
            flatField.setSamples(fArray, false);
        }
        return flatField;
    }

    public static float[][] FT2D(int n, int n2, float[][] fArray, boolean bl) throws VisADException {
        int n3;
        if (fArray == null) {
            return null;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n4 = fArray[0].length;
        if (n * n2 != n4) {
            throw new FieldException(n + " * " + n2 + " must equal " + n4);
        }
        float[][] fArray2 = new float[2][n4];
        float[][] fArray3 = new float[2][n];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n;
            n3 = 0;
            while (n3 < n) {
                fArray3[0][n3] = fArray[0][n6 + n3];
                fArray3[1][n3] = fArray[1][n6 + n3];
                ++n3;
            }
            fArray3 = FFT.FT1D(fArray3, bl);
            n3 = 0;
            while (n3 < n) {
                fArray2[0][n6 + n3] = fArray3[0][n3];
                fArray2[1][n6 + n3] = fArray3[1][n3];
                ++n3;
            }
            ++n5;
        }
        float[][] fArray4 = new float[2][n4];
        float[][] fArray5 = new float[2][n2];
        n3 = 0;
        while (n3 < n) {
            int n7 = n3;
            int n8 = 0;
            while (n8 < n2) {
                fArray5[0][n8] = fArray2[0][n7 + n8 * n];
                fArray5[1][n8] = fArray2[1][n7 + n8 * n];
                ++n8;
            }
            fArray5 = FFT.FT1D(fArray5, bl);
            n8 = 0;
            while (n8 < n2) {
                fArray4[0][n7 + n8 * n] = fArray5[0][n8];
                fArray4[1][n7 + n8 * n] = fArray5[1][n8];
                ++n8;
            }
            ++n3;
        }
        return fArray4;
    }

    public static double[][] FT2D(int n, int n2, double[][] dArray, boolean bl) throws VisADException {
        int n3;
        if (dArray == null) {
            return null;
        }
        if (dArray.length != 2 || dArray[0].length != dArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n4 = dArray[0].length;
        if (n * n2 != n4) {
            throw new FieldException(n + " * " + n2 + " must equal " + n4);
        }
        double[][] dArray2 = new double[2][n4];
        double[][] dArray3 = new double[2][n];
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n;
            n3 = 0;
            while (n3 < n) {
                dArray3[0][n3] = dArray[0][n6 + n3];
                dArray3[1][n3] = dArray[1][n6 + n3];
                ++n3;
            }
            dArray3 = FFT.FT1D(dArray3, bl);
            n3 = 0;
            while (n3 < n) {
                dArray2[0][n6 + n3] = dArray3[0][n3];
                dArray2[1][n6 + n3] = dArray3[1][n3];
                ++n3;
            }
            ++n5;
        }
        double[][] dArray4 = new double[2][n4];
        double[][] dArray5 = new double[2][n2];
        n3 = 0;
        while (n3 < n) {
            int n7 = n3;
            int n8 = 0;
            while (n8 < n2) {
                dArray5[0][n8] = dArray2[0][n7 + n8 * n];
                dArray5[1][n8] = dArray2[1][n7 + n8 * n];
                ++n8;
            }
            dArray5 = FFT.FT1D(dArray5, bl);
            n8 = 0;
            while (n8 < n2) {
                dArray4[0][n7 + n8 * n] = dArray5[0][n8];
                dArray4[1][n7 + n8 * n] = dArray5[1][n8];
                ++n8;
            }
            ++n3;
        }
        return dArray4;
    }

    public static float[][] FT1D(float[][] fArray, boolean bl) throws VisADException {
        if (fArray == null) {
            return null;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = fArray[0].length;
        int n2 = 1;
        boolean bl2 = true;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            bl2 = false;
        }
        if (bl2) {
            return FFT.FFT1D(fArray, bl);
        }
        float[][] fArray2 = new float[2][n];
        float f = (float)(Math.PI * -2 / (double)n);
        if (!bl) {
            f = -f;
        }
        int n3 = 0;
        while (n3 < n) {
            fArray2[0][n3] = (float)Math.cos((float)n3 * f);
            fArray2[1][n3] = (float)Math.sin((float)n3 * f);
            ++n3;
        }
        float[][] fArray3 = new float[2][n];
        int n4 = 0;
        while (n4 < n) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n4 * n5 % n;
                f2 += fArray[0][n5] * fArray2[0][n6] - fArray[1][n5] * fArray2[1][n6];
                f3 += fArray[0][n5] * fArray2[1][n6] + fArray[1][n5] * fArray2[0][n6];
                ++n5;
            }
            fArray3[0][n4] = f2;
            fArray3[1][n4] = f3;
            ++n4;
        }
        if (!bl) {
            n4 = 0;
            while (n4 < n) {
                float[] fArray4 = fArray3[0];
                int n7 = n4;
                fArray4[n7] = fArray4[n7] / (float)n;
                float[] fArray5 = fArray3[1];
                int n8 = n4++;
                fArray5[n8] = fArray5[n8] / (float)n;
            }
        }
        return fArray3;
    }

    public static float[][] FFT1D(float[][] fArray, boolean bl) throws VisADException {
        if (fArray == null) {
            return null;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = fArray[0].length;
        int n2 = 1;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            throw new FieldException("x length must be power of 2");
        }
        n2 = n / 2;
        float[][] fArray2 = new float[2][n2];
        float f = (float)(Math.PI * -2 / (double)n);
        if (!bl) {
            f = -f;
        }
        int n3 = 0;
        while (n3 < n2) {
            fArray2[0][n3] = (float)Math.cos((float)n3 * f);
            fArray2[1][n3] = (float)Math.sin((float)n3 * f);
            ++n3;
        }
        float[][] fArray3 = FFT.FFT1D(fArray, fArray2);
        if (!bl) {
            int n4 = 0;
            while (n4 < n) {
                float[] fArray4 = fArray3[0];
                int n5 = n4;
                fArray4[n5] = fArray4[n5] / (float)n;
                float[] fArray5 = fArray3[1];
                int n6 = n4++;
                fArray5[n6] = fArray5[n6] / (float)n;
            }
        }
        return fArray3;
    }

    private static float[][] FFT1D(float[][] fArray, float[][] fArray2) {
        int n = fArray[0].length;
        int n2 = n / 2;
        int n3 = 0;
        int n4 = 0;
        if (n == 1) {
            float[][] fArray3 = new float[][]{{fArray[0][0]}, {fArray[1][0]}};
            return fArray3;
        }
        int n5 = fArray2[0].length / n2;
        float[][] fArray4 = new float[2][n2];
        float[][] fArray5 = new float[2][n2];
        n3 = 0;
        while (n3 < n / 2) {
            int n6 = 2 * n3;
            fArray4[0][n3] = fArray[0][n6];
            fArray4[1][n3] = fArray[1][n6];
            fArray5[0][n3] = fArray[0][n6 + 1];
            fArray5[1][n3] = fArray[1][n6 + 1];
            ++n3;
        }
        fArray4 = FFT.FFT1D(fArray4, fArray2);
        fArray5 = FFT.FFT1D(fArray5, fArray2);
        float[][] fArray6 = new float[2][n];
        n3 = 0;
        while (n3 < n2) {
            fArray6[0][n3] = fArray4[0][n3];
            fArray6[1][n3] = fArray4[1][n3];
            float f = fArray5[0][n3] * fArray2[0][n4] - fArray5[1][n3] * fArray2[1][n4];
            float f2 = fArray5[0][n3] * fArray2[1][n4] + fArray5[1][n3] * fArray2[0][n4];
            fArray5[0][n3] = f;
            fArray5[1][n3] = f2;
            float[] fArray7 = fArray6[0];
            int n7 = n3;
            fArray7[n7] = fArray7[n7] + fArray5[0][n3];
            float[] fArray8 = fArray6[1];
            int n8 = n3;
            fArray8[n8] = fArray8[n8] + fArray5[1][n3];
            fArray6[0][n3 + n2] = fArray4[0][n3] - fArray5[0][n3];
            fArray6[1][n3 + n2] = fArray4[1][n3] - fArray5[1][n3];
            n4 += n5;
            ++n3;
        }
        return fArray6;
    }

    public static double[][] FT1D(double[][] dArray, boolean bl) throws VisADException {
        if (dArray == null) {
            return null;
        }
        if (dArray.length != 2 || dArray[0].length != dArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = dArray[0].length;
        int n2 = 1;
        boolean bl2 = true;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            bl2 = false;
        }
        if (bl2) {
            return FFT.FFT1D(dArray, bl);
        }
        double[][] dArray2 = new double[2][n];
        double d = Math.PI * -2 / (double)n;
        if (!bl) {
            d = -d;
        }
        int n3 = 0;
        while (n3 < n) {
            dArray2[0][n3] = Math.cos((double)n3 * d);
            dArray2[1][n3] = Math.sin((double)n3 * d);
            ++n3;
        }
        double[][] dArray3 = new double[2][n];
        int n4 = 0;
        while (n4 < n) {
            double d2 = 0.0;
            double d3 = 0.0;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n4 * n5 % n;
                d2 += dArray[0][n5] * dArray2[0][n6] - dArray[1][n5] * dArray2[1][n6];
                d3 += dArray[0][n5] * dArray2[1][n6] + dArray[1][n5] * dArray2[0][n6];
                ++n5;
            }
            dArray3[0][n4] = d2;
            dArray3[1][n4] = d3;
            ++n4;
        }
        if (!bl) {
            n4 = 0;
            while (n4 < n) {
                double[] dArray4 = dArray3[0];
                int n7 = n4;
                dArray4[n7] = dArray4[n7] / (double)n;
                double[] dArray5 = dArray3[1];
                int n8 = n4++;
                dArray5[n8] = dArray5[n8] / (double)n;
            }
        }
        return dArray3;
    }

    public static double[][] FFT1D(double[][] dArray, boolean bl) throws VisADException {
        if (dArray == null) {
            return null;
        }
        if (dArray.length != 2 || dArray[0].length != dArray[1].length) {
            throw new FieldException("bad x lengths");
        }
        int n = dArray[0].length;
        int n2 = 1;
        while (n2 < n) {
            if ((n2 *= 2) <= n) continue;
            throw new FieldException("x length must be power of 2");
        }
        n2 = n / 2;
        double[][] dArray2 = new double[2][n2];
        double d = Math.PI * -2 / (double)n;
        if (!bl) {
            d = -d;
        }
        int n3 = 0;
        while (n3 < n2) {
            dArray2[0][n3] = Math.cos((double)n3 * d);
            dArray2[1][n3] = Math.sin((double)n3 * d);
            ++n3;
        }
        double[][] dArray3 = FFT.FFT1D(dArray, dArray2);
        if (!bl) {
            int n4 = 0;
            while (n4 < n) {
                double[] dArray4 = dArray3[0];
                int n5 = n4;
                dArray4[n5] = dArray4[n5] / (double)n;
                double[] dArray5 = dArray3[1];
                int n6 = n4++;
                dArray5[n6] = dArray5[n6] / (double)n;
            }
        }
        return dArray3;
    }

    private static double[][] FFT1D(double[][] dArray, double[][] dArray2) {
        int n = dArray[0].length;
        int n2 = n / 2;
        int n3 = 0;
        int n4 = 0;
        if (n == 1) {
            double[][] dArray3 = new double[][]{{dArray[0][0]}, {dArray[1][0]}};
            return dArray3;
        }
        int n5 = dArray2[0].length / n2;
        double[][] dArray4 = new double[2][n2];
        double[][] dArray5 = new double[2][n2];
        n3 = 0;
        while (n3 < n2) {
            int n6 = 2 * n3;
            dArray4[0][n3] = dArray[0][n6];
            dArray4[1][n3] = dArray[1][n6];
            dArray5[0][n3] = dArray[0][n6 + 1];
            dArray5[1][n3] = dArray[1][n6 + 1];
            ++n3;
        }
        dArray4 = FFT.FFT1D(dArray4, dArray2);
        dArray5 = FFT.FFT1D(dArray5, dArray2);
        double[][] dArray6 = new double[2][n];
        n3 = 0;
        while (n3 < n2) {
            dArray6[0][n3] = dArray4[0][n3];
            dArray6[1][n3] = dArray4[1][n3];
            double d = dArray5[0][n3] * dArray2[0][n4] - dArray5[1][n3] * dArray2[1][n4];
            double d2 = dArray5[0][n3] * dArray2[1][n4] + dArray5[1][n3] * dArray2[0][n4];
            dArray5[0][n3] = d;
            dArray5[1][n3] = d2;
            double[] dArray7 = dArray6[0];
            int n7 = n3;
            dArray7[n7] = dArray7[n7] + dArray5[0][n3];
            double[] dArray8 = dArray6[1];
            int n8 = n3;
            dArray8[n8] = dArray8[n8] + dArray5[1][n3];
            dArray6[0][n3 + n2] = dArray4[0][n3] - dArray5[0][n3];
            dArray6[1][n3 + n2] = dArray4[1][n3] - dArray5[1][n3];
            n4 += n5;
            ++n3;
        }
        return dArray6;
    }

    public static void main(String[] stringArray) throws VisADException {
        int n;
        int n2;
        int n3;
        int n4 = 16;
        int n5 = 1;
        int n6 = 1;
        boolean bl = false;
        if (stringArray.length > 0) {
            n4 = Integer.valueOf(stringArray[0]);
        }
        if (stringArray.length > 1) {
            n5 = Integer.valueOf(stringArray[0]);
            n6 = Integer.valueOf(stringArray[1]);
            n4 = n5 * n6;
            bl = true;
        }
        float[][] fArray = new float[2][n4];
        System.out.println("  initial values");
        if (bl) {
            n3 = 0;
            n2 = 0;
            while (n2 < n6) {
                n = 0;
                while (n < n5) {
                    fArray[0][n3] = (float)(Math.sin(Math.PI * 2 * (double)n / (double)n5) * Math.sin(Math.PI * 2 * (double)n2 / (double)n6));
                    fArray[1][n3] = 0.0f;
                    System.out.println("x[" + n + "][" + n2 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                    ++n3;
                    ++n;
                }
                ++n2;
            }
        } else {
            n3 = 0;
            while (n3 < n4) {
                fArray[0][n3] = (float)Math.sin(Math.PI * 2 * (double)n3 / (double)n4);
                fArray[1][n3] = 0.0f;
                System.out.println("x[" + n3 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                ++n3;
            }
        }
        fArray = bl ? FFT.FT2D(n5, n6, fArray, true) : FFT.FT1D(fArray, true);
        System.out.println("\n  fft");
        if (bl) {
            n3 = 0;
            n2 = 0;
            while (n2 < n6) {
                n = 0;
                while (n < n5) {
                    System.out.println("x[" + n + "][" + n2 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                    ++n3;
                    ++n;
                }
                ++n2;
            }
        } else {
            n3 = 0;
            while (n3 < n4) {
                System.out.println("x[" + n3 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                ++n3;
            }
        }
        fArray = bl ? FFT.FT2D(n5, n6, fArray, false) : FFT.FT1D(fArray, false);
        System.out.println("\n  back fft");
        if (bl) {
            n3 = 0;
            n2 = 0;
            while (n2 < n6) {
                n = 0;
                while (n < n5) {
                    System.out.println("x[" + n + "][" + n2 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                    ++n3;
                    ++n;
                }
                ++n2;
            }
        } else {
            n3 = 0;
            while (n3 < n4) {
                System.out.println("x[" + n3 + "] = " + PlotText.shortString(fArray[0][n3]) + " " + PlotText.shortString(fArray[1][n3]));
                ++n3;
            }
        }
    }
}

