/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.ProjectionControl;
import visad.RealType;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.UnionSet;
import visad.ValueControl;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.jmet.NCEPPanel;
import visad.jmet.NetcdfGrids;
import visad.util.ClientServer;

public class ShowNCEPModel
extends JFrame
implements ActionListener,
ChangeListener,
DisplayListener {
    private BaseMapAdapter baseMap;
    private ColorControl ccmap;
    private float[][] colorTable;
    private Container cf;
    private JSlider speedSlider;
    private JLabel speedSliderLabel;
    private int speedValue;
    private int frameValue;
    private int maxFrames;
    private JButton start_stop;
    private JButton snapButton;
    private JButton forward;
    private JButton backward;
    private JButton mapColor;
    private boolean isLooping;
    private ContourControl ci;
    private ProjectionControl pc;
    private AnimationControl ca;
    private double[] pcMatrix;
    private GraphicsModeControl gmc;
    private LocalDisplay display;
    private NetcdfGrids ng;
    private JPanel vdisplay;
    private RealType x;
    private RealType y;
    private RealType level;
    private RealType time_type;
    private RealType pres;
    private RealType Values;
    private RealType SfcValues;
    private boolean firstFile;
    private boolean gotSfcGrids;
    private boolean gotAloftGrids;
    private JLabel statLabel;
    private String cmd;
    private NCEPPanel[] ncp;
    private JTabbedPane tabby;
    private FieldImpl mapField;
    private ValueControl mapControl;
    private DataReference mapRef;
    private RealType enableMap;
    private ScalarMap mapMap;
    private ScalarMap xAxis;
    private ScalarMap yAxis;
    private JCheckBox showMap;
    private String directory;
    private String MapFile;
    private boolean isServer = false;
    private boolean isClient = false;
    private String clientHost = null;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        block19: {
            var1_1 = 1;
            var2_2 = false;
            var3_3 = false;
            var4_4 = null;
            var5_5 = null;
            if (var0 == null || var0.length <= 0) break block19;
            var6_6 = false;
            var7_8 = false;
            var8_9 = 0;
            while (var8_9 < var0.length) {
                block21: {
                    block20: {
                        if (var0[var8_9].charAt(0) != '-' || var0[var8_9].length() <= 1) break block20;
                        switch (var0[var8_9].charAt(1)) {
                            case 'c': {
                                if (var2_2) {
                                    System.out.println("Cannot specify both '-c' and '-s'");
                                    var6_6 = true;
                                }
                                var3_3 = true;
                                if (var0[var8_9].length() > 2) {
                                    var5_5 = var0[var8_9].substring(2).trim();
                                    break;
                                }
                                break block21;
                            }
                            case 's': {
                                if (var3_3) {
                                    System.out.println("Cannot specify both '-c' and '-s'");
                                    var6_6 = true;
                                }
                                var2_2 = true;
                                break;
                            }
                            default: {
                                System.out.println("Unknown argument \"" + var0[var8_9] + "\"");
                                var6_6 = true;
                            }
                        }
                        break block21;
                    }
                    var9_10 = false;
                    if (var7_8) ** GOTO lbl-1000
                    try {
                        var1_1 = Integer.parseInt(var0[var8_9]);
                        var9_10 = true;
                    }
                    catch (NumberFormatException var10_11) {
                        // empty catch block
                    }
                    if (var9_10) {
                        if (var1_1 >= 1 && var1_1 <= 9) {
                            var7_8 = true;
                        } else {
                            System.out.println("invalid number of tabs (1-9) = " + var1_1);
                            var6_6 = true;
                        }
                    } else if (var4_4 == null) {
                        var4_4 = var0[var8_9];
                    } else {
                        System.out.println("Ignoring extra argument \"" + var0[var8_9] + "\"");
                    }
                }
                ++var8_9;
            }
            if (var6_6) {
                System.out.println("Usage: ShowNCEPModel [-c|-s] # [fileName]");
                System.out.println("Usage: ShowNCEPModel [-chostname|-s] # [fileName]");
                System.exit(1);
            }
        }
        try {
            new ShowNCEPModel(var1_1, var2_2, var3_3, var5_5, var4_4);
        }
        catch (Exception var6_7) {
            var6_7.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private DisplayImpl buildData(int n) throws RemoteException, VisADException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1");
        displayImplJ3D.addDisplayListener(this);
        this.pc = ((DisplayImpl)displayImplJ3D).getProjectionControl();
        this.pcMatrix = this.pc.getMatrix();
        this.pcMatrix[0] = 0.95;
        this.pcMatrix[5] = 0.95;
        this.pcMatrix[10] = 0.95;
        this.pc.setMatrix(this.pcMatrix);
        this.x = new RealType("x");
        this.y = new RealType("y");
        this.level = new RealType("level");
        this.time_type = RealType.Time;
        this.pres = new RealType("pres");
        this.gmc = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        this.gmc.setProjectionPolicy(0);
        this.xAxis = new ScalarMap(this.x, Display.XAxis);
        this.yAxis = new ScalarMap(this.y, Display.YAxis);
        displayImplJ3D.addMap(this.xAxis);
        displayImplJ3D.addMap(this.yAxis);
        ScalarMap scalarMap = new ScalarMap(this.pres, Display.ZAxis);
        scalarMap.setRange(1020.0, 10.0);
        displayImplJ3D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(this.time_type, Display.Animation);
        displayImplJ3D.addMap(scalarMap2);
        this.ca = (AnimationControl)((Object)scalarMap2.getControl());
        this.ca.setOn(false);
        this.statLabel = new JLabel("Please choose a data file...");
        this.statLabel.setForeground(Color.black);
        this.tabby = new JTabbedPane();
        this.ncp = new NCEPPanel[n + 1];
        this.ncp[0] = new NCEPPanel(false, displayImplJ3D, this.statLabel, this.tabby, "Single-level Data");
        int n2 = 1;
        while (n2 < this.ncp.length) {
            this.ncp[n2] = new NCEPPanel(true, displayImplJ3D, this.statLabel, this.tabby, "Data Aloft");
            ++n2;
        }
        this.enableMap = new RealType("enableMap");
        this.mapMap = new ScalarMap(this.enableMap, Display.SelectValue);
        displayImplJ3D.addMap(this.mapMap);
        ScalarMap scalarMap3 = new ScalarMap(this.enableMap, Display.RGB);
        displayImplJ3D.addMap(scalarMap3);
        this.ccmap = (ColorControl)scalarMap3.getControl();
        this.colorTable = new float[3][256];
        int n3 = 0;
        while (n3 < 256) {
            this.colorTable[0][n3] = 0.6f;
            this.colorTable[1][n3] = 0.0f;
            this.colorTable[2][n3] = 0.6f;
            ++n3;
        }
        this.ccmap.setTable(this.colorTable);
        return displayImplJ3D;
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open File");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("menuFile");
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("menuQuit");
        jMenu.add(jMenuItem2);
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Map");
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("North America", true);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setActionCommand("menuNA");
        jMenu2.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("World", false);
        jRadioButtonMenuItem2.addActionListener(this);
        jRadioButtonMenuItem2.setActionCommand("menuWorld");
        jMenu2.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    private Component buildMapControls() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.5f);
        jPanel.add(this.mapColor);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.showMap);
        return jPanel;
    }

    private Component buildSpeedControl() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel.setAlignmentY(0.5f);
        this.speedSlider = new JSlider(0, 1, 20, 10);
        this.speedSlider.setMaximumSize(this.speedSlider.getPreferredSize());
        this.speedSlider.setAlignmentX(0.5f);
        this.speedSlider.addChangeListener(this);
        this.speedValue = 3;
        jPanel.add(new JLabel("Speed"));
        jPanel.add(this.speedSlider);
        return jPanel;
    }

    private Component buildAnimationControls() {
        this.backward = new JButton(" < ");
        this.backward.setAlignmentX(0.5f);
        this.backward.setMaximumSize(this.backward.getMaximumSize());
        this.backward.setMinimumSize(this.backward.getMaximumSize());
        this.backward.setPreferredSize(this.backward.getMaximumSize());
        this.backward.addActionListener(this);
        this.backward.setActionCommand("backward");
        this.start_stop = new JButton("Animate");
        this.start_stop.setAlignmentX(0.5f);
        this.start_stop.setMaximumSize(this.start_stop.getMaximumSize());
        this.start_stop.setMinimumSize(this.start_stop.getMaximumSize());
        this.start_stop.setPreferredSize(this.start_stop.getMaximumSize());
        this.start_stop.addActionListener(this);
        this.start_stop.setActionCommand("start_stop");
        this.isLooping = false;
        this.forward = new JButton(" > ");
        this.forward.setAlignmentX(0.5f);
        this.forward.setMaximumSize(this.forward.getMaximumSize());
        this.forward.setMinimumSize(this.forward.getMaximumSize());
        this.forward.setPreferredSize(this.forward.getMaximumSize());
        this.forward.addActionListener(this);
        this.forward.setActionCommand("forward");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.5f);
        jPanel.add(this.backward);
        jPanel.add(this.start_stop);
        jPanel.add(this.forward);
        jPanel.add(this.buildSpeedControl());
        return jPanel;
    }

    private Component buildControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.5f);
        jPanel.setAlignmentY(0.0f);
        jPanel.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        jPanel.setMinimumSize(new Dimension(300, 400));
        jPanel.setPreferredSize(new Dimension(300, 400));
        this.mapColor = new JButton("Map Color");
        this.mapColor.addActionListener(this);
        this.mapColor.setActionCommand("mapColor");
        this.mapColor.setBackground(new Color(154, 0, 154));
        this.showMap = new JCheckBox("Make map visible");
        this.showMap.setAlignmentX(0.5f);
        this.showMap.addActionListener(this);
        this.showMap.setActionCommand("showmap");
        this.showMap.setSelected(true);
        this.snapButton = new JButton("Snap!");
        this.snapButton.setAlignmentX(0.5f);
        this.snapButton.setMaximumSize(this.snapButton.getMaximumSize());
        this.snapButton.setMinimumSize(this.snapButton.getMaximumSize());
        this.snapButton.setPreferredSize(this.snapButton.getMaximumSize());
        this.snapButton.addActionListener(this);
        this.snapButton.setActionCommand("snapButton");
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.snapButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.buildMapControls());
        jPanel.add(this.buildAnimationControls());
        int n = 0;
        while (n < this.ncp.length) {
            this.tabby.addTab("Data", this.ncp[n]);
            ++n;
        }
        jPanel.add(Box.createRigidArea(new Dimension(10, 30)));
        jPanel.add(this.tabby);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.statLabel.setAlignmentX(0.5f);
        jPanel.add(this.statLabel);
        return jPanel;
    }

    private void buildUI() {
        this.buildMenuBar();
        this.vdisplay = (JPanel)this.display.getComponent();
        this.vdisplay.setPreferredSize(new Dimension(700, 700));
        this.vdisplay.setAlignmentX(0.0f);
        this.vdisplay.setAlignmentY(0.0f);
        this.cf = this.getContentPane();
        this.cf.setLayout(new BoxLayout(this.cf, 0));
        if (!this.isClient) {
            this.cf.add(this.buildControlPanel());
        }
        this.cf.add(this.vdisplay);
        ((Component)this).setSize(1024, 768);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.cmd = actionEvent.getActionCommand();
        if (this.cmd.equals("menuFile")) {
            try {
                this.setLooping(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            FileDialog fileDialog = new FileDialog(this);
            fileDialog.setDirectory(this.directory);
            fileDialog.setMode(0);
            ((Component)fileDialog).setVisible(true);
            this.getNewFile(fileDialog.getDirectory(), fileDialog.getFile());
        } else if (this.cmd.equals("menuQuit")) {
            System.exit(0);
        } else if (this.cmd.equals("menuNA")) {
            this.MapFile = "../data/mcidas/OUTLUSAM";
            this.doBaseMap();
        } else if (this.cmd.equals("menuWorld")) {
            this.MapFile = "../data/mcidas/OUTLSUPW";
            this.doBaseMap();
        } else if (this.cmd.startsWith("Param:")) {
            System.out.println("not implemented");
        } else if (this.cmd.equals("start_stop")) {
            try {
                this.setLooping(!this.isLooping);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        } else if (this.cmd.equals("backward")) {
            try {
                this.ca.setDirection(false);
                this.ca.takeStep();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.cmd.equals("forward")) {
            try {
                this.ca.setDirection(true);
                this.ca.takeStep();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.cmd.equals("snapButton")) {
            try {
                this.pc.setMatrix(this.pcMatrix);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        } else if (this.cmd.equals("mapColor")) {
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, "Choose contour color", Color.white);
            if (color != null) {
                this.mapColor.setBackground(color);
                try {
                    int n = 0;
                    while (n < 256) {
                        this.colorTable[0][n] = (float)color.getRed() / 255.0f;
                        this.colorTable[1][n] = (float)color.getGreen() / 255.0f;
                        this.colorTable[2][n] = (float)color.getBlue() / 255.0f;
                        ++n;
                    }
                    this.ccmap.setTable(this.colorTable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (this.cmd.equals("showmap")) {
            try {
                if (this.showMap.isSelected()) {
                    this.mapControl.setValue(0.0);
                } else {
                    this.mapControl.setValue(1.0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void displayChanged(DisplayEvent displayEvent) {
        if (displayEvent.getId() == 2) {
            this.statLabel.setText("Display Frame done...");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Object object = changeEvent.getSource();
        if (object.equals(this.speedSlider) && (n = this.speedSlider.getValue()) != this.speedValue) {
            this.speedValue = n;
            try {
                this.ca.setStep(50 * (21 - this.speedValue));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    void getNewFile(String string, String string2) {
        if (string2 == null || string == null) {
            return;
        }
        try {
            File file = new File(string, string2);
            this.ng = new NetcdfGrids(file);
            this.setTitle("Show NCEP Model Data from " + string2);
            this.ng.setRealTypes(this.x, this.y, this.level, this.time_type, this.pres);
            Dimension dimension = this.ng.getDimension();
            this.xAxis.setRange(0.0, dimension.width - 1);
            this.yAxis.setRange(0.0, dimension.height - 1);
            double d = this.ng.getAspect();
            d *= (double)dimension.width / (double)dimension.height;
            if (d >= 1.0) {
                this.pcMatrix[0] = 0.95;
                this.pcMatrix[5] = 0.95 / d;
            } else {
                this.pcMatrix[0] = 0.95 * d;
                this.pcMatrix[5] = 0.95;
            }
            this.pc.setMatrix(this.pcMatrix);
            int n = 0;
            while (n < this.ncp.length) {
                this.ncp[n].setNetcdfGrid(this.ng);
                ++n;
            }
            this.maxFrames = this.ng.getNumberOfTimes() - 1;
            Vector vector = this.ng.get3dVariables();
            this.ncp[0].setParams(vector);
            Vector vector2 = this.ng.get4dVariables();
            int n2 = 1;
            while (n2 < this.ncp.length) {
                this.ncp[n2].setParams(vector2);
                ++n2;
            }
            this.statLabel.setText("Rendering base map...");
            this.doBaseMap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void doBaseMap() {
        if (this.ng == null) {
            return;
        }
        try {
            this.baseMap = new BaseMapAdapter(this.MapFile);
            this.baseMap.setDomainSet(this.ng.getDomainSet());
            UnionSet unionSet = this.baseMap.getData();
            FunctionType functionType = new FunctionType(this.enableMap, unionSet.getType());
            Integer1DSet integer1DSet = new Integer1DSet((MathType)this.enableMap, 2);
            this.mapField = new FieldImpl(functionType, integer1DSet);
            this.mapField.setSample(0, (Data)unionSet);
            this.mapControl = (ValueControl)((Object)this.mapMap.getControl());
            if (this.mapRef != null) {
                this.display.removeReference(this.mapRef);
            }
            this.mapRef = new DataReferenceImpl("mapData");
            this.mapRef.setData(this.mapField);
            ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
            this.display.addReference(this.mapRef, constantMapArray);
            this.mapControl.setValue(0.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void setLooping(boolean bl) throws RemoteException, VisADException {
        this.ca.setOn(bl);
        this.start_stop.setText(bl ? "Stop" : "Animate");
        this.isLooping = bl;
    }

    public ShowNCEPModel(int n) throws RemoteException, VisADException {
        this(n, false, false, null, null);
    }

    public ShowNCEPModel(int n, boolean bl, boolean bl2) throws RemoteException, VisADException {
        this(n, bl, bl2, null, null);
    }

    public ShowNCEPModel(int n, String string) throws RemoteException, VisADException {
        this(n, false, false, null, string);
    }

    public ShowNCEPModel(int n, boolean bl, boolean bl2, String string, String string2) throws RemoteException, VisADException {
        super("Show NCEP Model Data");
        this.isServer = bl;
        this.isClient = bl2;
        this.clientHost = string;
        if (this.clientHost == null) {
            this.clientHost = "localhost";
        }
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ ShowNCEPModel this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = showNCEPModel;
                this.constructor$0(showNCEPModel);
            }

            private final void constructor$0(ShowNCEPModel showNCEPModel) {
            }
        });
        this.frameValue = 0;
        this.maxFrames = -1;
        this.firstFile = true;
        this.gotSfcGrids = false;
        this.gotAloftGrids = false;
        this.directory = ".";
        this.ng = null;
        this.MapFile = "../data/mcidas/OUTLUSAM";
        String string3 = this.getClass().getName();
        if (!this.isClient) {
            DisplayImpl displayImpl = this.buildData(n);
            if (this.isServer) {
                RemoteServerImpl remoteServerImpl = ClientServer.startServer(string3);
                remoteServerImpl.addDisplay(new RemoteDisplayImpl(displayImpl));
            }
            this.display = displayImpl;
        } else {
            RemoteServer remoteServer = ClientServer.connectToServer(this.clientHost, string3);
            LocalDisplay[] localDisplayArray = ClientServer.getClientDisplays(remoteServer);
            this.display = localDisplayArray[0];
        }
        this.buildUI();
        if (string2 != null) {
            try {
                this.setLooping(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getNewFile(".", string2);
        }
    }
}

