/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Dimension;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import ucar.netcdf.Attribute;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Tuple;
import visad.Unit;
import visad.data.units.Parser;
import visad.jmet.GRIBCoordinateSystem;

public class NetcdfGrids {
    File filename;
    NetcdfFile nc = null;
    double[] pressureLevels;
    double[] valtime;
    double[][] times;
    Set time_set;
    int[] timeIndex;
    DateTime[] validDateTime;
    int num_levels;
    int num_records;
    int xval;
    int yval;
    RealType x;
    RealType y;
    RealType level;
    RealType time_type;
    RealType pres;
    RealTupleType grid_domain;
    Integer2DSet dom_set;
    CoordinateSystem gridCoord;
    int gridNumber;
    int gridTypeCode;

    public void setRealTypes(RealType realType, RealType realType2, RealType realType3, RealType realType4, RealType realType5) {
        this.x = realType;
        this.y = realType2;
        this.level = realType3;
        this.time_type = realType4;
        this.pres = realType5;
        try {
            Variable variable = this.nc.get("Nx");
            if (variable == null) {
                variable = this.nc.get("Ni");
            }
            int[] nArray = new int[]{0};
            this.xval = variable.getInt(nArray);
            variable = this.nc.get("Ny");
            if (variable == null) {
                variable = this.nc.get("Nj");
            }
            this.yval = variable.getInt(nArray);
            System.out.println("x,y dimensions = " + this.xval + " " + this.yval);
            RealType[] realTypeArray = new RealType[]{realType, realType2};
            if (GRIBCoordinateSystem.isGridNumberKnown(this.gridNumber)) {
                this.gridCoord = new GRIBCoordinateSystem(this.gridNumber);
            } else if (this.gridTypeCode == 0) {
                int[] nArray2 = new int[]{0};
                variable = this.nc.get("Ni");
                int n = variable.getInt(nArray2);
                variable = this.nc.get("Nj");
                int n2 = variable.getInt(nArray2);
                variable = this.nc.get("La1");
                double d = variable.getDouble(nArray2);
                variable = this.nc.get("Lo1");
                double d2 = variable.getDouble(nArray2);
                variable = this.nc.get("La2");
                double d3 = variable.getDouble(nArray2);
                variable = this.nc.get("Lo2");
                double d4 = variable.getDouble(nArray2);
                variable = this.nc.get("Di");
                double d5 = variable.getDouble(nArray2);
                variable = this.nc.get("Dj");
                double d6 = variable.getDouble(nArray2);
                this.gridCoord = new GRIBCoordinateSystem(0, n, n2, d, d2, d3, d4, d5, d6);
            }
            this.grid_domain = new RealTupleType(realTypeArray, this.gridCoord, null);
            this.dom_set = new Integer2DSet((MathType)this.grid_domain, this.xval, this.yval);
            this.time_set = new Gridded1DDoubleSet((MathType)realType4, this.times, this.num_records);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized Vector get4dVariables() {
        Vector<String> vector = new Vector<String>();
        VariableIterator variableIterator = this.nc.iterator();
        int n = this.nc.size();
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableIterator.next();
            DimensionIterator dimensionIterator = variable.getDimensionIterator();
            int n3 = variable.getRank();
            if (n3 == 4) {
                int[] nArray = variable.getLengths();
                String[] stringArray = new String[n3];
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n8 < n3) {
                    stringArray[n8] = dimensionIterator.next().getName().trim();
                    if (stringArray[n8] == "x" || stringArray[n8] == "lon") {
                        n4 = n8;
                    }
                    if (stringArray[n8] == "y" || stringArray[n8] == "lat") {
                        n5 = n8;
                    }
                    if (stringArray[n8] == "level") {
                        n6 = n8;
                    }
                    if (stringArray[n8] == "record") {
                        n7 = n8;
                    }
                    ++n8;
                }
                if (n4 != -1 && n5 != -1 && n6 != -1 && n7 != -1) {
                    vector.addElement(variable.getName());
                    vector.addElement(variable.getAttribute("long_name").getStringValue());
                    vector.addElement(variable.getAttribute("units").getStringValue());
                }
            }
            ++n2;
        }
        return vector;
    }

    public synchronized Vector get3dVariables() {
        Vector<String> vector = new Vector<String>();
        VariableIterator variableIterator = this.nc.iterator();
        int n = this.nc.size();
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableIterator.next();
            DimensionIterator dimensionIterator = variable.getDimensionIterator();
            int n3 = variable.getRank();
            if (n3 == 3) {
                int[] nArray = variable.getLengths();
                String[] stringArray = new String[n3];
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = 0;
                while (n7 < n3) {
                    stringArray[n7] = dimensionIterator.next().getName().trim();
                    if (stringArray[n7] == "x" || stringArray[n7] == "lon") {
                        n4 = n7;
                    }
                    if (stringArray[n7] == "y" || stringArray[n7] == "lat") {
                        n5 = n7;
                    }
                    if (stringArray[n7] == "record") {
                        n6 = n7;
                    }
                    ++n7;
                }
                if (n4 != -1 && n5 != -1 && n6 != -1) {
                    vector.addElement(variable.getName());
                    vector.addElement(variable.getAttribute("long_name").getStringValue());
                    Attribute attribute = variable.getAttribute("units");
                    if (attribute != null) {
                        vector.addElement(attribute.getStringValue());
                    } else {
                        vector.addElement("null");
                    }
                }
            }
            ++n2;
        }
        return vector;
    }

    public synchronized String[][] getVariableNames() {
        VariableIterator variableIterator = this.nc.iterator();
        int n = this.nc.size();
        String[][] stringArray = new String[3][n];
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableIterator.next();
            stringArray[0][n2] = variable.getName();
            stringArray[1][n2] = variable.getAttribute("long_name").getStringValue();
            stringArray[2][n2] = variable.getAttribute("units").getStringValue();
            ++n2;
        }
        return stringArray;
    }

    public double getAspect() {
        if (this.gridCoord != null) {
            return ((GRIBCoordinateSystem)this.gridCoord).getAspectRatio();
        }
        return 1.0;
    }

    public int getNumberOfLevels() {
        return this.num_levels;
    }

    public double[] getPressureLevels() {
        return this.pressureLevels;
    }

    public int getNumberOfTimes() {
        return this.num_records;
    }

    public Dimension getDimension() {
        return new Dimension(this.xval, this.yval);
    }

    public Integer2DSet getDomainSet() {
        return this.dom_set;
    }

    public synchronized Tuple[] getGrids(String string, RealType realType, double[][] dArray) {
        Variable variable = this.nc.get(string);
        if (variable == null) {
            System.out.println("could not find " + variable + " in netCDF file");
            System.exit(1);
        }
        Attribute attribute = variable.getAttribute("long_name");
        Attribute attribute2 = variable.getAttribute("units");
        Attribute attribute3 = variable.getAttribute("_FillValue");
        double d = attribute3.getNumericValue().doubleValue();
        DimensionIterator dimensionIterator = variable.getDimensionIterator();
        int n = variable.getRank();
        int[] nArray = variable.getLengths();
        String[] stringArray = new String[n];
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n) {
            stringArray[n6] = dimensionIterator.next().getName().trim();
            if (stringArray[n6] == "x" || stringArray[n6] == "lon") {
                n2 = n6;
            }
            if (stringArray[n6] == "y" || stringArray[n6] == "lat") {
                n3 = n6;
            }
            if (stringArray[n6] == "level") {
                n4 = n6;
            }
            if (stringArray[n6] == "record") {
                n5 = n6;
            }
            ++n6;
        }
        if (n2 == -1 || n3 == -1) {
            System.out.println("one or more x-y dimensions missing");
            System.exit(1);
        }
        int[] nArray2 = new int[n];
        Tuple[] tupleArray = null;
        try {
            FunctionType functionType = new FunctionType(this.grid_domain, realType);
            FunctionType functionType2 = new FunctionType(this.time_type, functionType);
            tupleArray = new Tuple[this.num_levels];
            int n7 = nArray[n2] * nArray[n3];
            double[][] dArray2 = new double[1][n7];
            Data[] dataArray = new Data[2];
            if (n4 != -1 && n5 != -1) {
                int n8 = 0;
                while (n8 < this.num_levels) {
                    nArray2[n4] = n8;
                    dArray[n8][0] = Double.MAX_VALUE;
                    dArray[n8][1] = -1.7976931348623157E308;
                    FieldImpl fieldImpl = new FieldImpl(functionType2, this.time_set);
                    int n9 = 0;
                    while (n9 < this.num_records) {
                        nArray2[n5] = this.timeIndex[n9];
                        int n10 = 0;
                        while (n10 < nArray[n3]) {
                            nArray2[n3] = n10;
                            int n11 = 0;
                            while (n11 < nArray[n2]) {
                                nArray2[n2] = n11;
                                double d2 = variable.getDouble(nArray2);
                                if (d2 == d) {
                                    d2 = Double.NaN;
                                } else {
                                    if (d2 < dArray[n8][0]) {
                                        dArray[n8][0] = d2;
                                    }
                                    if (d2 > dArray[n8][1]) {
                                        dArray[n8][1] = d2;
                                    }
                                }
                                dArray2[0][n10 * nArray[n2] + n11] = d2;
                                ++n11;
                            }
                            ++n10;
                        }
                        FlatField flatField = new FlatField(functionType, this.dom_set);
                        flatField.setSamples(dArray2, false);
                        fieldImpl.setSample(n9, (Data)flatField);
                        ++n9;
                    }
                    dataArray[0] = new Real(this.pres, this.pressureLevels[n8]);
                    dataArray[1] = fieldImpl;
                    tupleArray[n8] = new Tuple(dataArray);
                    ++n8;
                }
            } else if (n5 != -1) {
                dArray[0][0] = Double.MAX_VALUE;
                dArray[0][1] = -1.7976931348623157E308;
                FieldImpl fieldImpl = new FieldImpl(functionType2, this.time_set);
                int n12 = 0;
                while (n12 < this.num_records) {
                    nArray2[n5] = this.timeIndex[n12];
                    int n13 = 0;
                    while (n13 < nArray[n3]) {
                        nArray2[n3] = n13;
                        int n14 = 0;
                        while (n14 < nArray[n2]) {
                            nArray2[n2] = n14;
                            double d3 = variable.getDouble(nArray2);
                            if (d3 == d) {
                                d3 = Double.NaN;
                            } else {
                                if (d3 < dArray[0][0]) {
                                    dArray[0][0] = d3;
                                }
                                if (d3 > dArray[0][1]) {
                                    dArray[0][1] = d3;
                                }
                            }
                            dArray2[0][n13 * nArray[n2] + n14] = d3;
                            ++n14;
                        }
                        ++n13;
                    }
                    FlatField flatField = new FlatField(functionType, this.dom_set);
                    flatField.setSamples(dArray2, false);
                    fieldImpl.setSample(n12, (Data)flatField);
                    ++n12;
                }
                dataArray[0] = new Real(this.pres, 1020.0);
                dataArray[1] = fieldImpl;
                tupleArray[0] = new Tuple(dataArray);
            } else {
                int n15 = 0;
                while (n15 < nArray[n3]) {
                    nArray2[n3] = n15;
                    int n16 = 0;
                    while (n16 < nArray[n2]) {
                        nArray2[n2] = n16;
                        double d4 = variable.getDouble(nArray2);
                        if (d4 == d) {
                            d4 = Double.NaN;
                        } else {
                            if (d4 < dArray[0][0]) {
                                dArray[0][0] = d4;
                            }
                            if (d4 > dArray[0][1]) {
                                dArray[0][1] = d4;
                            }
                        }
                        dArray2[0][n15 * nArray[n2] + n16] = d4;
                        ++n16;
                    }
                    ++n15;
                }
                FlatField flatField = new FlatField(functionType, this.dom_set);
                flatField.setSamples(dArray2, false);
                dataArray[0] = new Real(this.pres, 1020.0);
                dataArray[1] = flatField;
                tupleArray[0] = new Tuple(dataArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return tupleArray;
    }

    public static void main(String[] stringArray) {
        try {
            NetcdfGrids netcdfGrids = new NetcdfGrids("97032712_eta.nc");
            RealType realType = new RealType("x");
            RealType realType2 = new RealType("y");
            RealType realType3 = new RealType("level");
            RealType realType4 = RealType.Time;
            RealType realType5 = new RealType("pres");
            RealType realType6 = new RealType("Z");
            int n = netcdfGrids.getNumberOfLevels();
            double[][] dArray = new double[n][2];
            netcdfGrids.setRealTypes(realType, realType2, realType3, realType4, realType5);
            Tuple[] tupleArray = netcdfGrids.getGrids("Z", realType6, dArray);
            System.out.println("range = " + dArray[0][0] + " - " + dArray[0][1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized Tuple[][] getGridsWithTime(String string, RealType realType, double[][] dArray) {
        Variable variable = this.nc.get(string);
        if (variable == null) {
            System.out.println("could not find " + variable + " in netCDF file");
            System.exit(1);
        }
        Attribute attribute = variable.getAttribute("long_name");
        Attribute attribute2 = variable.getAttribute("units");
        Attribute attribute3 = variable.getAttribute("_FillValue");
        DimensionIterator dimensionIterator = variable.getDimensionIterator();
        int n = variable.getRank();
        int[] nArray = variable.getLengths();
        String[] stringArray = new String[n];
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n) {
            stringArray[n6] = dimensionIterator.next().getName().trim();
            if (stringArray[n6] == "x") {
                n2 = n6;
            }
            if (stringArray[n6] == "y") {
                n3 = n6;
            }
            if (stringArray[n6] == "level") {
                n4 = n6;
            }
            if (stringArray[n6] == "record") {
                n5 = n6;
            }
            ++n6;
        }
        if (n2 == -1 || n3 == -1) {
            System.out.println("one or more x-y dimensions missing");
            System.exit(1);
        }
        int[] nArray2 = new int[n];
        Tuple[][] tupleArray = null;
        try {
            RealType[] realTypeArray = new RealType[]{this.x, this.y};
            this.gridCoord = new GRIBCoordinateSystem(this.gridNumber);
            RealTupleType realTupleType = new RealTupleType(realTypeArray, this.gridCoord, null);
            this.dom_set = new Integer2DSet((MathType)realTupleType, nArray[n2], nArray[n3]);
            FunctionType functionType = new FunctionType(realTupleType, realType);
            tupleArray = new Tuple[this.num_levels][this.num_records];
            int n7 = nArray[n2] * nArray[n3];
            double[][] dArray2 = new double[1][n7];
            Data[] dataArray = new Data[2];
            if (n4 != -1 && n5 != -1) {
                int n8 = 0;
                while (n8 < this.num_levels) {
                    nArray2[n4] = n8;
                    int n9 = 0;
                    while (n9 < this.num_records) {
                        nArray2[n5] = this.timeIndex[n9];
                        int n10 = 0;
                        while (n10 < nArray[n3]) {
                            nArray2[n3] = n10;
                            int n11 = 0;
                            while (n11 < nArray[n2]) {
                                nArray2[n2] = n11;
                                dArray2[0][n10 * nArray[n2] + n11] = variable.getDouble(nArray2);
                                ++n11;
                            }
                            ++n10;
                        }
                        FlatField flatField = new FlatField(functionType, this.dom_set);
                        flatField.setSamples(dArray2, false);
                        dataArray[0] = new Real(this.pres, this.pressureLevels[n8]);
                        dataArray[1] = flatField;
                        tupleArray[n8][n9] = new Tuple(dataArray);
                        ++n9;
                    }
                    ++n8;
                }
            } else if (n5 != -1) {
                int n12 = 0;
                while (n12 < this.num_records) {
                    nArray2[n5] = this.timeIndex[n12];
                    int n13 = 0;
                    while (n13 < nArray[n3]) {
                        nArray2[n3] = n13;
                        int n14 = 0;
                        while (n14 < nArray[n2]) {
                            nArray2[n2] = n14;
                            dArray2[0][n13 * nArray[n2] + n14] = variable.getDouble(nArray2);
                            ++n14;
                        }
                        ++n13;
                    }
                    FlatField flatField = new FlatField(functionType, this.dom_set);
                    flatField.setSamples(dArray2, false);
                    dataArray[0] = new Real(this.pres, 1020.0);
                    dataArray[1] = flatField;
                    tupleArray[0][n12] = new Tuple(dataArray);
                    ++n12;
                }
            } else {
                int n15;
                int n16 = 0;
                while (n16 < nArray[n3]) {
                    nArray2[n3] = n16;
                    n15 = 0;
                    while (n15 < nArray[n2]) {
                        nArray2[n2] = n15;
                        dArray2[0][n16 * nArray[n2] + n15] = variable.getDouble(nArray2);
                        ++n15;
                    }
                    ++n16;
                }
                FlatField flatField = new FlatField(functionType, this.dom_set);
                flatField.setSamples(dArray2, false);
                dataArray[0] = new Real(this.pres, 1020.0);
                dataArray[1] = flatField;
                n15 = 0;
                while (n15 < this.num_records) {
                    tupleArray[0][n15] = new Tuple(dataArray);
                    ++n15;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return tupleArray;
    }

    public NetcdfGrids(String string) {
        this(new File(string));
    }

    public NetcdfGrids(File file) {
        this.filename = file;
        this.dom_set = null;
        this.gridCoord = null;
        try {
            Object object;
            Object object2;
            this.nc = new NetcdfFile(file, true);
            Object var2_2 = null;
            Object var3_4 = null;
            int[] nArray = new int[1];
            Variable variable = this.nc.get("level");
            if (variable != null) {
                object2 = variable.getLengths();
                this.num_levels = object2[0];
                this.pressureLevels = new double[this.num_levels];
                int n = 0;
                while (n < this.num_levels) {
                    nArray[0] = n;
                    this.pressureLevels[n] = variable.getDouble(nArray);
                    ++n;
                }
            } else {
                this.num_levels = 1;
                this.pressureLevels = new double[this.num_levels];
                this.pressureLevels[0] = 1020.0;
            }
            this.num_records = this.nc.getDimensions().get("record").getLength();
            object2 = this.nc.get("valtime");
            this.valtime = new double[this.num_records];
            this.validDateTime = new DateTime[this.num_records];
            this.timeIndex = new int[this.num_records];
            this.times = new double[1][this.num_records];
            TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
            if (object2 != null) {
                object = Parser.parse(((Variable)object2).getAttribute("units").getStringValue());
                int[] nArray2 = ((Variable)object2).getLengths();
                int n = 0;
                while (n < this.num_records) {
                    nArray[0] = n;
                    this.valtime[n] = ((Variable)object2).getDouble(nArray);
                    treeMap.put(new Double(this.valtime[n]), new Integer(n));
                    this.validDateTime[n] = new DateTime(new Real(RealType.Time, this.valtime[n], (Unit)object));
                    ++n;
                }
                Iterator iterator = treeMap.keySet().iterator();
                int n2 = 0;
                while (n2 < this.num_records) {
                    Double d = (Double)iterator.next();
                    Integer n3 = (Integer)treeMap.get(d);
                    this.timeIndex[n2] = n3;
                    this.times[0][n2] = this.validDateTime[this.timeIndex[n2]].getValue();
                    ++n2;
                }
            } else {
                System.out.println("cannot find valtime-s...using linear steps");
                this.valtime = null;
                int n = 0;
                while (n < this.num_records) {
                    this.timeIndex[n] = n;
                    this.times[0][n] = n;
                    ++n;
                }
            }
            variable = this.nc.get("grid_number");
            object = new int[variable.getRank()];
            int n = 0;
            while (n < ((Object)object).length) {
                object[n] = false;
                ++n;
            }
            this.gridNumber = variable.getInt((int[])object);
            System.out.println("grid number = " + this.gridNumber);
            variable = this.nc.get("grid_type_code");
            nArray[0] = 0;
            this.gridTypeCode = variable.getInt(nArray);
            System.out.println("grid type code = " + this.gridTypeCode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

