/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.ColorControl;
import visad.ContourControl;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.ValueControl;
import visad.jmet.NetcdfGrids;

public class NCEPPanel
extends JPanel
implements ActionListener,
ChangeListener {
    static int instance = 0;
    private int myInstance;
    private JSlider levelSlider;
    private JSlider speedSlider;
    private JTextField intervalText;
    private JLabel levelSliderLabel;
    private JLabel intervalUnits;
    private int levelValue;
    private double intervalValue;
    private JComboBox paramBox;
    private DataReference ref;
    private ContourControl ci;
    private RealType Values;
    private Tuple[] tup;
    private NetcdfGrids ncg = null;
    private JLabel statLabel;
    private JTabbedPane tabby;
    private JButton butColor;
    private float[][] colorTable;
    private String paramName;
    private JCheckBox showHide;
    private DisplayImpl di;
    private ValueControl control;
    private ColorControl ccon;
    private Color nc;
    private ScalarMap map;
    private RealType enable;
    private FieldImpl field;
    private String valueName;
    private String enableName;
    private String dataName;
    private ScalarMap valueMap;
    private ScalarMap valueColorMap;
    private boolean isAloft;
    private int ndx;
    private Vector paramInfo;
    private double[] pressureLevels;
    private double[][] range;
    private double cbeg;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JLabel jLabel = new JLabel("The status label");
        NCEPPanel nCEPPanel = new NCEPPanel(true, null, jLabel, null, "Title");
        Container container = jFrame.getContentPane();
        container.add(nCEPPanel);
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        ((Component)jFrame).setSize(600, 600);
        ((Component)jFrame).setVisible(true);
    }

    private static synchronized int getNextInstance() {
        return instance++;
    }

    public void setNetcdfGrid(NetcdfGrids netcdfGrids) {
        try {
            if (this.ref != null && this.di != null) {
                this.di.removeReference(this.ref);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ncg = netcdfGrids;
        if (this.isAloft) {
            this.pressureLevels = this.ncg.getPressureLevels();
            int n = this.ncg.getNumberOfLevels();
            this.range = new double[n][2];
            this.levelSlider.setMinimum(0);
            this.levelSlider.setMaximum(n - 1);
            this.levelSlider.setValue(0);
            this.levelValue = 0;
            this.intervalValue = 60.0;
            this.intervalText.setText("Enter value");
        }
        if (this.tabby != null) {
            this.tabby.setTitleAt(this.myInstance, "Data");
            this.tabby.setBackgroundAt(this.myInstance, this.nc);
        }
    }

    public void setParams(Vector vector) {
        this.paramInfo = vector;
        this.paramBox.removeAllItems();
        this.paramBox.addItem("-- none --");
        int n = 0;
        while (n < this.paramInfo.size()) {
            String string = (String)this.paramInfo.elementAt(n + 1);
            this.paramBox.addItem(string);
            n += 3;
        }
        this.revalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block22: {
            String string = actionEvent.getActionCommand();
            if (string.equals("paramBox")) {
                this.paramName = (String)this.paramBox.getSelectedItem();
                this.ndx = this.paramBox.getSelectedIndex();
                if (this.paramName != null && this.ndx > 0) {
                    this.paramName = (String)this.paramInfo.elementAt((this.ndx - 1) * 3);
                    Thread thread = new Thread(this){
                        private final /* synthetic */ NCEPPanel this$0;

                        public void run() {
                            try {
                                NCEPPanel.access$0(this.this$0).setText("Reading data...please wait!");
                                NCEPPanel.access$6(this.this$0, NCEPPanel.access$5(this.this$0).getGrids(NCEPPanel.access$2(this.this$0), NCEPPanel.access$3(this.this$0), NCEPPanel.access$4(this.this$0)));
                                NCEPPanel.access$0(this.this$0).setText("Done reading data...");
                                NCEPPanel.access$7(this.this$0).disableAction();
                                FunctionType functionType = new FunctionType(NCEPPanel.access$8(this.this$0), NCEPPanel.access$1(this.this$0)[NCEPPanel.access$9(this.this$0)].getType());
                                Integer1DSet integer1DSet = new Integer1DSet((MathType)NCEPPanel.access$8(this.this$0), 2);
                                NCEPPanel.access$11(this.this$0, new FieldImpl(functionType, integer1DSet));
                                NCEPPanel.access$10(this.this$0).setSample(0, (Data)NCEPPanel.access$1(this.this$0)[NCEPPanel.access$9(this.this$0)]);
                                if (NCEPPanel.access$12(this.this$0) != null) {
                                    NCEPPanel.access$7(this.this$0).removeReference(NCEPPanel.access$12(this.this$0));
                                }
                                NCEPPanel.access$15(this.this$0, (ValueControl)((Object)NCEPPanel.access$14(this.this$0).getControl()));
                                NCEPPanel.access$17(this.this$0, new DataReferenceImpl(NCEPPanel.access$16(this.this$0)));
                                NCEPPanel.access$18(this.this$0).setRange(NCEPPanel.access$4(this.this$0)[NCEPPanel.access$9(this.this$0)][0], NCEPPanel.access$4(this.this$0)[NCEPPanel.access$9(this.this$0)][1]);
                                if (NCEPPanel.access$19(this.this$0)) {
                                    NCEPPanel.access$22(this.this$0).setText((String)NCEPPanel.access$21(this.this$0).elementAt((NCEPPanel.access$20(this.this$0) - 1) * 3 + 2));
                                    this.this$0.setContInterval(NCEPPanel.access$4(this.this$0)[NCEPPanel.access$9(this.this$0)]);
                                }
                                NCEPPanel.access$12(this.this$0).setData(NCEPPanel.access$10(this.this$0));
                                NCEPPanel.access$7(this.this$0).addReference(NCEPPanel.access$12(this.this$0));
                                NCEPPanel.access$7(this.this$0).enableAction();
                                NCEPPanel.access$0(this.this$0).setText("Rendering display...please wait!");
                                if (NCEPPanel.access$23(this.this$0) != null) {
                                    NCEPPanel.access$23(this.this$0).setTitleAt(NCEPPanel.access$24(this.this$0), NCEPPanel.access$2(this.this$0));
                                    NCEPPanel.access$23(this.this$0).setBackgroundAt(NCEPPanel.access$24(this.this$0), NCEPPanel.access$25(this.this$0));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        {
                            this.this$0 = nCEPPanel;
                            this.constructor$0(nCEPPanel);
                        }

                        private final void constructor$0(NCEPPanel nCEPPanel) {
                        }
                    };
                    thread.start();
                }
            } else if (string.equals("showbutton")) {
                try {
                    if (this.showHide.isSelected()) {
                        this.control.setValue(0.0);
                        break block22;
                    }
                    this.control.setValue(1.0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("intervaltext")) {
                try {
                    String string2 = this.intervalText.getText();
                    this.intervalValue = Double.valueOf(string2);
                    if (this.ci != null & this.ref != null) {
                        this.ci.setContourInterval((float)this.intervalValue, (float)this.range[this.levelValue][0], (float)this.range[this.levelValue][1], (float)this.cbeg);
                    }
                    this.statLabel.setText("Rendering display...please wait!");
                }
                catch (NumberFormatException numberFormatException) {
                    this.statLabel.setText("Invalid number...try again!");
                    this.getToolkit().beep();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("butColor")) {
                JColorChooser jColorChooser = new JColorChooser();
                this.nc = JColorChooser.showDialog(this, "Choose contour color", Color.white);
                if (this.nc != null) {
                    this.butColor.setBackground(this.nc);
                    if (this.tabby != null) {
                        this.tabby.setBackgroundAt(this.myInstance, this.nc);
                    }
                    try {
                        int n = 0;
                        while (n < 256) {
                            if (this.isAloft) {
                                this.colorTable[0][n] = (float)this.nc.getRed() / 255.0f;
                                this.colorTable[1][n] = (float)this.nc.getGreen() / 255.0f;
                                this.colorTable[2][n] = (float)this.nc.getBlue() / 255.0f;
                            } else {
                                this.colorTable[0][n] = (float)this.nc.getRed() / 255.0f * (float)n / 255.0f;
                                this.colorTable[1][n] = (float)this.nc.getGreen() / 255.0f * (float)n / 255.0f;
                                this.colorTable[2][n] = (float)this.nc.getBlue() / 255.0f * (float)n / 255.0f;
                            }
                            ++n;
                        }
                        this.ccon.setTable(this.colorTable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.levelSlider) && this.ncg != null) {
            int n = this.levelSlider.getValue();
            if (n != this.levelValue) {
                this.levelSliderLabel.setText("Pressure level = " + this.pressureLevels[n]);
            }
            if (n != this.levelValue & !this.levelSlider.getValueIsAdjusting()) {
                this.levelValue = n;
                if (this.ref != null) {
                    try {
                        this.di.disableAction();
                        this.valueMap.setRange(this.range[this.levelValue][0], this.range[this.levelValue][1]);
                        this.setContInterval(this.range[this.levelValue]);
                        this.field.setSample(0, (Data)this.tup[this.levelValue]);
                        this.di.enableAction();
                        this.statLabel.setText("Rendering display...please wait!");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    void setContInterval(double[] dArray) {
        double d = (dArray[1] - dArray[0]) * 0.11;
        long l = (long)(Math.log(d) / Math.log(10.0));
        if (d < 1.0) {
            --l;
        }
        double d2 = Math.pow(10.0, l);
        d = Math.floor(d / d2) * d2;
        this.cbeg = Math.floor(dArray[0] / d) * d;
        try {
            this.ci.setContourInterval((float)d, (float)dArray[0], (float)dArray[1], (float)this.cbeg);
            this.intervalText.setText(d + " ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ JLabel access$0(NCEPPanel nCEPPanel) {
        return nCEPPanel.statLabel;
    }

    static /* synthetic */ Tuple[] access$1(NCEPPanel nCEPPanel) {
        return nCEPPanel.tup;
    }

    static /* synthetic */ String access$2(NCEPPanel nCEPPanel) {
        return nCEPPanel.paramName;
    }

    static /* synthetic */ RealType access$3(NCEPPanel nCEPPanel) {
        return nCEPPanel.Values;
    }

    static /* synthetic */ double[][] access$4(NCEPPanel nCEPPanel) {
        return nCEPPanel.range;
    }

    static /* synthetic */ NetcdfGrids access$5(NCEPPanel nCEPPanel) {
        return nCEPPanel.ncg;
    }

    static /* synthetic */ void access$6(NCEPPanel nCEPPanel, Tuple[] tupleArray) {
        nCEPPanel.tup = tupleArray;
    }

    static /* synthetic */ DisplayImpl access$7(NCEPPanel nCEPPanel) {
        return nCEPPanel.di;
    }

    static /* synthetic */ RealType access$8(NCEPPanel nCEPPanel) {
        return nCEPPanel.enable;
    }

    static /* synthetic */ int access$9(NCEPPanel nCEPPanel) {
        return nCEPPanel.levelValue;
    }

    static /* synthetic */ FieldImpl access$10(NCEPPanel nCEPPanel) {
        return nCEPPanel.field;
    }

    static /* synthetic */ void access$11(NCEPPanel nCEPPanel, FieldImpl fieldImpl) {
        nCEPPanel.field = fieldImpl;
    }

    static /* synthetic */ DataReference access$12(NCEPPanel nCEPPanel) {
        return nCEPPanel.ref;
    }

    static /* synthetic */ ValueControl access$13(NCEPPanel nCEPPanel) {
        return nCEPPanel.control;
    }

    static /* synthetic */ ScalarMap access$14(NCEPPanel nCEPPanel) {
        return nCEPPanel.map;
    }

    static /* synthetic */ void access$15(NCEPPanel nCEPPanel, ValueControl valueControl) {
        nCEPPanel.control = valueControl;
    }

    static /* synthetic */ String access$16(NCEPPanel nCEPPanel) {
        return nCEPPanel.dataName;
    }

    static /* synthetic */ void access$17(NCEPPanel nCEPPanel, DataReference dataReference) {
        nCEPPanel.ref = dataReference;
    }

    static /* synthetic */ ScalarMap access$18(NCEPPanel nCEPPanel) {
        return nCEPPanel.valueMap;
    }

    static /* synthetic */ boolean access$19(NCEPPanel nCEPPanel) {
        return nCEPPanel.isAloft;
    }

    static /* synthetic */ int access$20(NCEPPanel nCEPPanel) {
        return nCEPPanel.ndx;
    }

    static /* synthetic */ Vector access$21(NCEPPanel nCEPPanel) {
        return nCEPPanel.paramInfo;
    }

    static /* synthetic */ JLabel access$22(NCEPPanel nCEPPanel) {
        return nCEPPanel.intervalUnits;
    }

    static /* synthetic */ JTabbedPane access$23(NCEPPanel nCEPPanel) {
        return nCEPPanel.tabby;
    }

    static /* synthetic */ int access$24(NCEPPanel nCEPPanel) {
        return nCEPPanel.myInstance;
    }

    static /* synthetic */ Color access$25(NCEPPanel nCEPPanel) {
        return nCEPPanel.nc;
    }

    public NCEPPanel(boolean bl, DisplayImpl displayImpl, JLabel jLabel, JTabbedPane jTabbedPane, String string) {
        JComponent jComponent;
        this.di = displayImpl;
        this.statLabel = jLabel;
        this.isAloft = bl;
        this.tabby = jTabbedPane;
        this.myInstance = NCEPPanel.getNextInstance();
        this.valueName = "Value" + (this.myInstance + 1);
        this.enableName = "enable" + (this.myInstance + 1);
        this.dataName = "data" + (this.myInstance + 1);
        this.range = new double[1][2];
        this.range[0][0] = -20000.0;
        this.cbeg = 0.0;
        this.range[0][1] = 20000.0;
        this.colorTable = new float[3][256];
        if (displayImpl != null) {
            try {
                int n;
                this.Values = new RealType(this.valueName);
                this.nc = Color.white;
                if (bl) {
                    this.valueMap = new ScalarMap(this.Values, Display.IsoContour);
                    this.valueColorMap = new ScalarMap(this.Values, Display.RGB);
                    displayImpl.addMap(this.valueMap);
                    displayImpl.addMap(this.valueColorMap);
                    this.ci = (ContourControl)this.valueMap.getControl();
                    this.ci.setContourInterval(30.0f, 0.0f, 20000.0f, 60.0f);
                    this.ci.enableLabels(true);
                    n = 0;
                    while (n < 256) {
                        this.colorTable[0][n] = 1.0f;
                        this.colorTable[1][n] = 1.0f;
                        this.colorTable[2][n] = 1.0f;
                        ++n;
                    }
                    this.ccon = (ColorControl)this.valueColorMap.getControl();
                    this.ccon.setTable(this.colorTable);
                } else {
                    this.valueMap = new ScalarMap(this.Values, Display.RGB);
                    displayImpl.addMap(this.valueMap);
                    n = 0;
                    while (n < 256) {
                        this.colorTable[0][n] = (float)n / 255.0f;
                        this.colorTable[1][n] = (float)n / 255.0f;
                        this.colorTable[2][n] = (float)n / 255.0f;
                        ++n;
                    }
                    this.ccon = (ColorControl)this.valueMap.getControl();
                    this.ccon.setTable(this.colorTable);
                }
                this.enable = new RealType(this.enableName);
                this.map = new ScalarMap(this.enable, Display.SelectValue);
                displayImpl.addMap(this.map);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.black), string, 2, 3);
        titledBorder.setTitleColor(Color.black);
        this.setBorder(titledBorder);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.levelValue = 0;
        if (bl) {
            this.levelSliderLabel = new JLabel("Pressure level = 1000", 0);
            this.levelSliderLabel.setAlignmentX(0.5f);
            this.levelSlider = new JSlider(0, 0, 100, 0);
            this.levelSlider.setMaximumSize(new Dimension(200, 50));
            this.levelSlider.setAlignmentX(0.5f);
            this.levelSlider.addChangeListener(this);
            this.add(this.levelSliderLabel);
            this.add(this.levelSlider);
            this.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        String[] stringArray = new String[]{"Choose a data file first"};
        this.paramBox = new JComboBox<String>(stringArray);
        this.paramBox.setMaximumSize(new Dimension(250, 50));
        this.paramBox.setAlignmentX(0.5f);
        this.paramBox.addActionListener(this);
        this.paramBox.setActionCommand("paramBox");
        JLabel jLabel2 = new JLabel("Selected parameter:");
        jLabel2.setAlignmentX(1.0f);
        this.add(jLabel2);
        this.add(this.paramBox);
        this.intervalValue = 60.0;
        if (bl) {
            this.add(Box.createRigidArea(new Dimension(10, 10)));
            jComponent = new JLabel("Contour interval:");
            jComponent.setAlignmentX(1.0f);
            this.add(jComponent);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.5f);
            this.intervalText = new JTextField("Enter value", 8);
            this.intervalText.setMaximumSize(this.intervalText.getPreferredSize());
            this.intervalText.setActionCommand("intervaltext");
            this.intervalText.addActionListener(this);
            this.intervalUnits = new JLabel("<units>");
            jPanel.add(this.intervalText);
            jPanel.add(this.intervalUnits);
            this.add(jPanel);
        }
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        jComponent.setAlignmentX(0.5f);
        this.butColor = new JButton("Color");
        this.butColor.addActionListener(this);
        this.butColor.setActionCommand("butColor");
        this.butColor.setBackground(this.nc);
        jComponent.add(this.butColor);
        this.showHide = new JCheckBox("Make visible");
        this.showHide.addActionListener(this);
        this.showHide.setActionCommand("showbutton");
        this.showHide.setSelected(true);
        jComponent.add(Box.createRigidArea(new Dimension(20, 10)));
        jComponent.add(this.showHide);
        this.add(jComponent);
    }
}

